# Hospital Care - HMS: Technical Information & Sale Details

---

## 1. Source Code Availability

**Question:** Is it possible to sell the complete source code of the project (backend + frontend)?

**Answer:** Yes, the complete source code is available for licensing, including:
- Full backend source code (PHP/CodeIgniter)
- Complete frontend source code (PHP views with AdminLTE framework)
- Database schema and SQL files
- All modules and integrations
- Mobile app source code (Flutter-based patient and doctor apps)

*Note: Source code is provided under license (Single Use or Reseller License), not as an ownership transfer.*

---

## 2. Licensing Options

**Question:** What licensing options do you offer (exclusive sale, non-exclusive sale, or transfer with certain limitations)?

**Answer:** We offer the following licensing options:
- **Single Use License:** License for use and modification of the source code for a single deployment/project. The license allows you to use, modify, and customize the code for your own use, but does not include ownership transfer or resale rights.
- **Reseller License:** License that allows you to resell the product to end clients. This license includes the right to distribute and sell the system to multiple clients while maintaining the original licensing structure.

*Note: Ownership transfer is not included in our licensing model. All licenses are usage-based licenses. Specific licensing terms and pricing to be discussed separately.*

---

## 3. Technologies and Stack

### Backend
- **Language:** PHP (version >= 5.3.7, compatible with PHP 7.x and 8.x)
- **Framework:** CodeIgniter 3.x (MVC architecture)
- **Architecture:** Modular monolith structure using HMVC (Hierarchical Model-View-Controller) pattern via MX (Modular Extensions)
- **Authentication & Authorization:** Ion Auth library with role-based access control (RBAC)
- **User Roles:** Admin, SuperAdmin, Doctor, Nurse, Accountant, Receptionist, Pharmacist, Laboratorist, Patient
- **Logging:** Built-in CodeIgniter logging system
- **Auditing:** User activity logs and system audit trails

### Frontend
- **Framework:** AdminLTE 3.x (Bootstrap-based admin dashboard template)
- **JavaScript Libraries:**
  - jQuery
  - Chart.js 3.9.1 (for dashboards and analytics)
  - DataTables (server-side and client-side)
  - Various jQuery plugins (date pickers, file uploads, etc.)
- **CSS Framework:** Bootstrap 4/5
- **Icons:** Font Awesome 6.0.0
- **Build Tools:** No separate build process (traditional PHP application)
- **Design System:** AdminLTE component library with custom hospital-themed styling

### Database
- **Database System:** MySQL/MariaDB
- **Driver:** MySQLi
- **Character Set:** UTF-8 (utf8_general_ci)
- **Schema:** Complete database schema included (democa_hmz_v2.sql)
- **Backup:** SQL dump files provided for database backup and recovery

### Mobile Applications
- **Framework:** Flutter
- **Apps Included:**
  - Patient Mobile App
  - Doctor Mobile App
- **Integration:** RESTful API integration with backend

---

## 4. Documentation and Deployment

### Available Documentation
- **Module Documentation:** README files for specific modules (e.g., Dashboard module)
- **Product Description:** HTML documentation file included
- **Code Comments:** Extensive inline code comments
- **Database Schema:** SQL dump file with complete schema
- **API Documentation:** API endpoints documented in code (REST API available)

### Deployment Instructions
- **Server Requirements:**
  - PHP >= 5.3.7 (recommended: PHP 7.4+ or 8.x)
  - MySQL/MariaDB 5.7+
  - Apache/Nginx web server with mod_rewrite
  - Composer (for dependency management)
- **Deployment Method:** Traditional LAMP/LEMP stack deployment
- **Docker:** No Docker configuration files included (can be added as custom service)
- **Configuration Files:** 
  - Database configuration: `application/config/database.php`
  - Application configuration: `application/config/config.php`
  - Environment-based configuration support

---

## 5. Technical Support

**Question:** Possibility of further technical support or consultations (by agreement).

**Answer:** Yes, technical support and consultation services are available:
- Post-deal technical support (terms to be agreed upon)
- Code customization assistance
- Integration support
- Deployment assistance
- Training and documentation
- Bug fixes and updates (terms negotiable)

*Note: Support terms, duration, and pricing to be discussed separately.*

---

## 6. Detailed Technical Information

### Frontend Details

**Question:** Which language/framework is the frontend built with?

**Answer:**
- **Primary:** PHP with CodeIgniter views (server-side rendering)
- **UI Framework:** AdminLTE 3.x (Bootstrap-based)
- **JavaScript:** jQuery with various plugins
- **Charts:** Chart.js for analytics and dashboards
- **No separate frontend framework:** This is a traditional server-side rendered application, not a SPA (Single Page Application)

**Question:** Is there a design system/components, build setup (Vite/Webpack), and deployment guide?

**Answer:**
- **Design System:** AdminLTE component library with custom hospital-themed components
- **Build Setup:** No modern build tools (Vite/Webpack) - traditional PHP application
- **Assets:** Static assets (CSS, JS, images) organized in `common/` and `adminlte/` directories
- **Deployment Guide:** Basic deployment instructions available; detailed guide can be provided

### Backend Details

**Question:** Which language and framework is the backend implemented in?

**Answer:**
- **Language:** PHP (>= 5.3.7)
- **Framework:** CodeIgniter 3.x
- **Architecture:** HMVC (Hierarchical MVC) using Modular Extensions (MX)

**Question:** Are there any architectural specifics (monolith/microservices), RBAC/roles, logging, auditing?

**Answer:**
- **Architecture:** Modular monolith (HMVC pattern)
- **RBAC:** Yes, comprehensive role-based access control using Ion Auth library
  - Roles: Admin, SuperAdmin, Doctor, Nurse, Accountant, Receptionist, Pharmacist, Laboratorist, Patient
  - Permission-based access to modules and features
  - Hospital-specific data isolation
- **Logging:** CodeIgniter logging system with configurable log levels
- **Auditing:** User activity logs, system audit trails, login attempts tracking

### Database Details

**Question:** Which database is used?

**Answer:**
- **Database:** MySQL/MariaDB
- **Driver:** MySQLi
- **Character Set:** UTF-8

**Question:** Are there schema migrations, backups, and recovery instructions?

**Answer:**
- **Migrations:** No migration system included. Database schema is provided as a complete SQL dump file.
- **Schema:** Complete SQL dump file included (`democa_hmz_v2.sql`)
- **Backups:** SQL dump can be used for backup and recovery
- **Recovery Instructions:** Standard MySQL backup/restore procedures apply

### Integrations and API Readiness

**Question:** Was the project designed with integrations in mind?

**Answer:** Yes, the system is designed with integration capabilities:

**Existing Integrations:**
1. **Payment Gateways:**
   - Stripe (integrated)
   - PayPal (integrated via Omnipay)
   - Paystack (integrated)
   - PayU (integrated)
   - Custom payment gateway module

2. **SMS Integration:**
   - Twilio SDK (integrated)
   - SMS gateway module with template system
   - Auto-SMS functionality for appointments, reminders, etc.

3. **Email Integration:**
   - Email module with SMTP configuration
   - Auto-email templates
   - Manual email sending capabilities

4. **Telemedicine:**
   - Jitsi Meet integration for video consultations

5. **Document Generation:**
   - mPDF for PDF generation
   - PHPWord for document creation

**Question:** Is there a REST API / GraphQL? Is documentation available (Swagger/OpenAPI)?

**Answer:**
- **REST API:** Yes, RESTful API module available (`application/modules/api/`)
- **API Endpoints:** Multiple endpoints for:
  - Authentication
  - Patient management
  - Appointment management
  - Prescription management
  - Lab reports
  - Profile management
  - Donor/blood bank
  - And more
- **API Documentation:** Endpoints documented in code; formal Swagger/OpenAPI documentation not included but can be generated
- **GraphQL:** No GraphQL implementation

**Question:** Is it possible to expose or extend the API for external systems and mobile applications?

**Answer:** Yes, the API is designed for extensibility:
- API module is modular and can be extended
- Mobile apps (Flutter) already integrate with the API
- New endpoints can be added following existing patterns
- Authentication system supports API token-based access

### Deployment and Support

**Question:** Is Docker / docker-compose or any other deployment guide available?

**Answer:**
- **Docker:** No Docker configuration files included in the current codebase
- **Deployment:** Traditional LAMP/LEMP stack deployment
- **Deployment Guide:** Basic instructions available; detailed guide can be provided
- **Docker Support:** Can be added as a custom service (additional development required)

**Question:** Is post-deal technical support or consultation possible (by agreement)?

**Answer:** Yes, available options include:
- Post-deal technical support (terms negotiable)
- Code customization and extension
- Integration assistance
- Deployment support
- Training sessions
- Documentation updates
- Bug fixes and maintenance

---

## 7. Deal Format

**Question:** Is the sale of the full source code possible (backend + frontend + database models)?

**Answer:** Yes, the complete package includes:
- ✅ Full backend source code (PHP/CodeIgniter)
- ✅ Complete frontend source code (PHP views, AdminLTE, assets)
- ✅ Database schema and SQL files
- ✅ All modules (60+ modules)
- ✅ Mobile app source code (Flutter)
- ✅ Third-party libraries and dependencies
- ✅ Configuration files
- ✅ Documentation files

**Question:** License options: exclusive / non-exclusive / with limitations.

**Answer:** We offer two licensing options:
- **Single Use License:** License for use and modification of the source code for a single deployment/project. Includes full source code access, modification rights, and deployment rights for one project.
- **Reseller License:** License that allows reselling the product to end clients. Includes all rights from Single Use License plus the right to distribute and sell to multiple clients.

*Note: Ownership transfer is not available. All licenses are usage-based licenses that grant usage and modification rights but do not transfer ownership of the intellectual property.*

*Specific terms and pricing to be discussed.*

**Question:** Pricing and delivery timeline.

**Answer:** 
- **Pricing:** To be discussed
- **Delivery Timeline:** Upon agreement, source code delivery can be arranged within 
- **Delivery Format:** 
  - Complete source code repository
  - Database schema files
  - Documentation
  - Deployment instructions

---

## 8. System Modules Overview

The system includes 60+ modules covering:

### Core Modules
- Patient Management
- Doctor Management
- Appointment Scheduling
- Prescription Management
- Laboratory Management
- Radiology Management
- Pharmacy & Inventory
- Financial Management
- Bed Management
- Emergency Management
- Case Management
- Diagnosis Management

### Advanced Features
- AI Medical Image Analysis
- AI Patient Overview
- AI Treatment Plan Generator
- Advanced Dashboards (Executive, Clinical, Financial, Operational)
- Telemedicine (Jitsi Meet)
- Blood Bank & Donor Management
- Payroll & Attendance
- Meeting Management
- Notice Board
- File Management
- Multi-language Support

### Integration Modules
- Payment Gateways (Stripe, PayPal, Paystack, PayU)
- SMS Gateway (Twilio)
- Email System
- API Module
- Import/Export

---

## 9. Additional Information

### System Capabilities
- **Multi-Hospital Support:** Yes, supports single or multi-hospital SaaS deployment
- **Multi-Language:** Yes, language files included (English, Arabic, Spanish, French, and more)
- **Responsive Design:** Yes, mobile-responsive interface
- **Real-time Features:** Auto-refreshing dashboards, real-time notifications
- **Security:** CSRF protection, SQL injection prevention, role-based access control
- **Scalability:** Modular architecture allows for easy extension

### Code Quality
- Well-structured modular codebase
- HMVC pattern for better organization
- Extensive code comments
- Separation of concerns
- Reusable components

---

## Contact Information

For further discussions regarding:
- Pricing details
- Licensing terms
- Technical support packages
- Customization requirements
- Delivery timeline
- Payment terms

Please contact us to schedule a discussion (correspondence, call, or video conference as per your convenience).

---

**Note:** This document provides technical information based on the current codebase. Specific business terms, pricing, and licensing details are to be discussed separately.
