<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Supplier extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->module('sms');
        $this->load->model('supplier_model');
        $this->load->model('purchase/purchase_model');
        $this->load->model('finance/finance_model');
        $this->load->model('bank/bank_model');
        $this->load->module('pgateway');
        if (!$this->ion_auth->in_group(array('admin', 'Accountant'))) {
            redirect('home/permission');
        }
    }

    public function index() {

        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('supplier', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addNewView() {
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_new');
        $this->load->view('home/footer'); // just the header file
    }

    function getSupplier() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['suppliers'] = $this->supplier_model->getSupplierBysearch($search); //done
            } else {
                $data['suppliers'] = $this->supplier_model->getSupplierjason(); //done
            }
        } else {
            if (!empty($search)) {
                $data['suppliers'] = $this->supplier_model->getSupplierByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['suppliers'] = $this->supplier_model->getSupplierByLimit($limit, $start); //done
            }
        }
        $options5 = '';
        foreach ($data['suppliers'] as $supplier) {

            if ($this->ion_auth->in_group(array('admin'))) {
                $options1 = ' <a type="button" class="btn btn-xs editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $supplier->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
            }
            $option7 = '<img  src="' . $supplier->img_url . '" width="80px;">';
            if ($this->ion_auth->in_group(array('admin'))) {
                $options5 = '<a class="btn btn-xs delete_button" title="' . lang('delete') . '" href="supplier/delete?id=' . $supplier->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i> ' . lang('delete') . '</a>';
            }
            $options9 = '<a class="btn btn-xs btn-primary" title="' . lang('payment_details') . '" href="supplier/purchaseDetailsBySupplier?id=' . $supplier->id . '"><i class="fa fa-info"></i> ' . lang('payment_details') . '</a>';

            $options6 = ' <a type="button" class="btn btn-xs detailsbutton inffo" title="' . lang('info') . '" data-toggle = "modal" data-id="' . $supplier->id . '"><i class="fa fa-eye"> </i> ' . lang('info') . '</a>';

            if ($this->ion_auth->in_group(array('admin'))) {
                $info[] = array(
                    $option7,
                    $supplier->id,
                    $supplier->name,
                    $supplier->phone,
                    $supplier->email,
                    $supplier->address,
                    $supplier->company,
                    $options1 . ' ' . $options6 . ' ' . $options5 . ' ' . $options9,
                );
            }
            if ($this->ion_auth->in_group(array('Supplier'))) {
                $info[] = array(
                    $option7,
                    $supplier->name,
                    $supplier->designation,
                    $supplier->phone,
                    $supplier->email,
                    $options6,
                );
            }
        }

        if (!empty($data['suppliers'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('supplier')->num_rows(),
                "recordsFiltered" => $this->db->get('supplier')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function addNew() {

        if ($this->ion_auth->in_group(array('Supplier'))) {
            redirect('home/permission');
        }

        $id = $this->input->post('id');
        $redirect = $this->input->get('redirect');
        $name = $this->input->post('name');
        $password = 'passCA12345';



        $address = $this->input->post('address');
        $phone = $this->input->post('phone');
        $company = $this->input->post('company');
        $email = $this->input->post('email');
        if ((empty($id))) {
            $add_date = date('d-m-y');
            $registration_time = time();
        } else {
            $add_date = $this->supplier_model->getSupplierById($id)->add_date;
        }

        if (empty($email)) {
            $email = $name . 'example.com';
        }

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

        //  if (empty($id)) {
        //      $this->form_validation->set_rules('password', 'Password', 'trim|min_length[5]|max_length[100]|xss_clean');
        //  }

        $this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[2]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('email', 'Email', 'trim|min_length[2]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('address', 'Address', 'trim|required|min_length[2]|max_length[500]|xss_clean');
        $this->form_validation->set_rules('phone', 'Phone', 'trim|required|min_length[2]|max_length[50]|xss_clean');
        $this->form_validation->set_rules('company', 'Company', 'trim|required|min_length[2]|max_length[100]|xss_clean');


        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                $this->session->set_flashdata('feedback', 'Validation Error !');
                redirect("supplier/editSupplier?id=$id");
            } else {
                $data = array();
                $data['setval'] = 'setval';

                $this->load->view('home/dashboard'); // just the header file
                $this->load->view('add_new', $data);
                $this->load->view('home/footer'); // just the header file
            }
        } else {
            $file_name = $_FILES['img_url']['name'];

            $file_name_pieces = explode('_', $file_name);
            $new_file_name = '';
            $count = 1;
            foreach ($file_name_pieces as $piece) {
                if ($count !== 1) {
                    $piece = ucfirst($piece);
                }

                $new_file_name .= $piece;
                $count++;
            }
            $config = array(
                'file_name' => $new_file_name,
                'upload_path' => "./uploads/",
                'allowed_types' => "gif|jpg|png|jpeg|pdf",
                'overwrite' => False,
                'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                'max_height' => "1768",
                'max_width' => "2024"
            );

            $this->load->library('Upload', $config);
            $this->upload->initialize($config);
            if (!empty($file_name)) {
                if ($this->upload->do_upload('img_url')) {
                    $path = $this->upload->data();
                    $img_url = "uploads/" . $path['file_name'];
                    $data = array();
                    $data = array(
                        'img_url' => $img_url,
                        'name' => $name,
                        'email' => $email,
                        'address' => $address,
                        'phone' => $phone,
                        'company' => $company,
                        'add_date' => $add_date,
                    );
                }
            } else {
                $data = array(
                    'name' => $name,
                    'email' => $email,
                    'address' => $address,
                    'phone' => $phone,
                    'company' => $company,
                    'add_date' => $add_date,
                );
            }

            $username = $this->input->post('name');

            if (empty($id)) {     // Adding New Supplier
                if ($this->ion_auth->email_check($email)) {
                    $this->session->set_flashdata('feedback', 'This Email Address Is Already Registered');
                    redirect('supplier/addNewView');
                } else {
                    $dfg = 9;
                    $this->ion_auth->register($username, $password, $email, $dfg);
                    $ion_user_id = $this->db->get_where('users', array('email' => $email))->row()->id;
                    $this->supplier_model->insertSupplier($data);
                    $supplier_user_id = $this->db->get_where('supplier', array('email' => $email))->row()->id;
                    $id_info = array('ion_user_id' => $ion_user_id);
                    $this->supplier_model->updateSupplier($supplier_user_id, $id_info);


                    $this->session->set_flashdata('feedback', 'Added');
                }
                $send_email = $this->db->get_where('autoEmailTemplate', array('id =' => 2))->row();
                $send_sms = $this->db->get_where('autoSmsTemplate', array('id =' => 3))->row();
                $setings11 = $this->settings_model->getSettings();
                if ($send_sms->status == 'Active') {
                    $send_user = $this->db->get_where('supplier', array('email =' => $email))->row();
                    $data1 = array(
                        'name' => $send_user->name,
                        'companyname' => $setings11->system_vendor
                    );
                    $message = $this->parser->parse_string($send_sms->message, $data1);
                    $data3[] = array($send_user->phone => $message);
                    $this->sms->sendSms($send_user->phone, $message, $data3);
                }
                if ($send_email->status == 'Active') {
                    $send_user = $this->db->get_where('supplier', array('email =' => $email))->row();
                    $data2 = array(
                        'name' => $send_user->name,
                        'companyname' => $setings11->system_vendor
                    );
                    $message = $this->parser->parse_string($send_email->message, $data2);
                    $emailSettings = $this->db->get_where('email_settings', array('id =' => 1))->row();
                    $this->email->from($emailSettings->admin_email);
                    $this->email->to($send_user->email);
                    $this->email->subject('Registration Successful');
                    $this->email->message($message);
                    $this->email->send();
                }
                //    }
            } else { // Updating Supplier
                $ion_user_id = $this->db->get_where('supplier', array('id' => $id))->row()->ion_user_id;
                if (empty($password)) {
                    $password = $this->db->get_where('users', array('id' => $ion_user_id))->row()->password;
                } else {
                    $password = $this->ion_auth_model->hash_password($password);
                }
                $this->supplier_model->updateIonUser($username, $email, $password, $ion_user_id);
                $this->supplier_model->updateSupplier($id, $data);
                $this->session->set_flashdata('feedback', 'Updated');
            }
            // Loading View
            if (!empty($redirect)) {
                redirect('finance/addPaymentView');
            } else {
                redirect('supplier');
            }
        }
    }

    function searchSupplierByJason() {
        $search = $this->input->get('id');
        $data['suppliers'] = $this->supplier_model->searchSupplier($search);
        echo json_encode($data);
    }

    function editSupplier() {
        $data = array();
        $id = $this->input->get('id');
        $data['supplier'] = $this->supplier_model->getSupplierById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_new', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function editSupplierByJason() {
        $id = $this->input->get('id');
        $data['supplier'] = $this->supplier_model->getSupplierById($id);
        echo json_encode($data);
    }

    function getSupplierByJason() {
        $id = $this->input->get('id');
        $data['supplier'] = $this->supplier_model->getSupplierById($id);
        echo json_encode($data);
    }

    function delete() {
        $data = array();
        $id = $this->input->get('id');
        $user_data = $this->db->get_where('supplier', array('id' => $id))->row();
        $path = $user_data->img_url;


        if (!empty($path) && $path != 'uploads/male1.jpg') {
            unlink($path);
        }
        $ion_user_id = $user_data->ion_user_id;
        $this->db->where('id', $ion_user_id);
        $this->db->delete('users');
        $this->supplier_model->delete($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        redirect('supplier');
    }

    public function purchaseDetailsBySupplier() {
        $supplierid = $this->input->get('id');
        $data['supplierdetails'] = $this->supplier_model->getSupplierById($supplierid);
        $purchasedetails = $this->purchase_model->getBatchBySupplierId($supplierid);
        $purchasearray = array();
        $paymentdonearray = array();
        if (!empty($purchasedetails)) {
            foreach ($purchasedetails as $purchase) {
                $purchasearray[] = $purchase->p_price * $purchase->quantity;
            }
            $data['total'] = array_sum($purchasearray);
        } else {
            $data['total'] = 0;
        }
        $paymentdone = $this->supplier_model->getSupplierPaymentBySupplierId($supplierid);
        if (!empty($paymentdone)) {
            foreach ($paymentdone as $paymentdo) {
                $paymentdonearray[] = $paymentdo->paidamount;
            }
            $data['paid'] = array_sum($paymentdonearray);
        } else {
            $data['paid'] = 0;
        }

        $data['due'] = $data['total'] - $data['paid'];
        $data['settings'] = $this->settings_model->getSettings();
        $data['gateway'] = $this->db->get_where('pgateway', array('gateway' => $data['settings']->payment_gateway))->row();

        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('purchasedetailsbysupplier', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function getPurchaseFromSupplier() {
        $supplierid = $this->input->post('id');
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['batches'] = $this->purchase_model->getPurchaseBySearchBySupplier($supplierid, $search); //done
            } else {
                $data['batches'] = $this->purchase_model->getPurchaseBySupplier($supplierid); //done
            }
        } else {
            if (!empty($search)) {
                $data['batches'] = $this->purchase_model->getPurchaseByLimitBySearchBySupplier($supplierid, $limit, $start, $search); //done
            } else {
                $data['batches'] = $this->purchase_model->getPurchaseByLimitBySupplier($supplierid, $limit, $start); //done
                //print_r($data);
                // die();
            }
        }

        $options5 = '';
        $count = 0;
        foreach ($data['batches'] as $batch) {

            if ($this->ion_auth->in_group(array('admin'))) {
                $options4 = '<a class="btn btn-xs btn-primary" title="' . lang('view_payment') . '" href="supplier/purchaseDetails?id=' . $batch->id . '"><i class="fa fa-info"></i> ' . lang('view_payment') . '</a>';
                $options5 = '<a class="btn btn-xs delete_button" title="' . lang('delete') . '" href="supplier/deleteBatch?id=' . $batch->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i> ' . lang('delete') . '</a>';
                $options1 = ' <a type="button" class="btn btn-xs editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $batch->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
                $options2 = ' <a type="button" class="btn btn-xs btn-primary viewpurchase" title="' . lang('purchase_info') . '" data-toggle = "modal" data-id="' . $batch->id . '"><i class="fa fa-eye"> </i> ' . lang('purchase_info') . '</a>';
                $options3 = ' <a type="button" class="btn btn-xs btn-default addpayment" title="' . lang('add_payment') . '" data-toggle = "modal" data-id="' . $batch->id . '"><i class="fa fa-plus"> </i> ' . lang('add_payment') . '</a>';
            }

            $grandtotal = $batch->p_price * $batch->quantity;
            $paymentbatchwise11 = $this->supplier_model->getPaymentByBatchId($batch->id);
            $paymentarray = array();
            if (!empty($paymentbatchwise11)) {
                foreach ($paymentbatchwise11 as $payment) {
                    $paymentarray[] = $payment->paidamount;
                }
                $paidamount = array_sum($paymentarray);
            } else {
                $paidamount = 0;
            }


            $duebalance = $grandtotal - $paidamount;

            if ($duebalance > 0) {
                $optiondue = '<div class="btn-info "style="background: #B2204B;">' . lang('pending') . '</div>';
            } else {
                $optiondue = '<div class="btn-info">' . lang('paid') . '</div>';
            }

            $settings = $this->settings_model->getSettings();

            if ($this->ion_auth->in_group(array('admin'))) {
                $info[] = array(
                    $batch->add_date,
                    $batch->medname,
                    $batch->batchid,
                    $batch->p_price,
                    $batch->quantity,
                    $settings->currency . '' . $grandtotal,
                    $settings->currency . '' . $paidamount,
                    $settings->currency . '' . $duebalance,
                    $optiondue,
                    $options1 . ' ' . $options2 . ' ' . $options3 . ' ' . $options4 . ' ' . $options5,
                );
                $count = $count + 1;
            }
        }

        if (!empty($count)) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $count,
                "recordsFiltered" => $count,
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function purchaseinfoBysupplier() {
        $batchid = $this->input->get('id');
        $settings = $this->settings_model->getSettings();
        $purchaseinfo = $this->purchase_model->getPurchaseById($batchid);
        $data['option'] = '<tr><td>' . lang('date') . '</td><td>' . $purchaseinfo->add_date . '</td></tr>' . '<tr><td>' . lang('batch_no') . '</td><td>' . $purchaseinfo->batchid . '</td></tr>' . '<tr><td>' . lang('med_name') . '</td><td>' . $purchaseinfo->medname . '</td></tr>' .
                '<tr><td>' . lang('medicine_category') . '</td><td>' . $purchaseinfo->medcategory . '</td></tr>' . '<tr><td>' . lang('expire_date') . '</td><td>' . $purchaseinfo->e_date . '</td></tr>'
                . '<tr><td>' . lang('quantity') . '</td><td>' . $purchaseinfo->quantity . '</td></tr>' . '<tr><td>' . lang('p_price') . '</td><td>' . $settings->currency . $purchaseinfo->p_price . '</td></tr>'
                . '<tr><td>' . lang('payable') . '</td><td>' . $settings->currency . $purchaseinfo->p_price * $purchaseinfo->quantity . '</td></tr>';

        echo json_encode($data);
    }

    public function addNewPayment() {
        $refno = $this->input->post('refno');
        $amount = $this->input->post('amount');
        $date = $this->input->post('date');

        $id = $this->input->post('id');
        if (!empty($date)) {
            $datefinalstamp = strtotime($date);
            $datefinal = $date;
        } else {
            $datefinal = date('d-m-Y', time());
            $datefinalstamp = time();
        }

        $type = $this->input->post('ptype');
        $notes = $this->input->post('notes');

        if ($type == 'bank') {
            $bank = $this->input->post('bankname');
            $cheque_no = $this->input->post('cheque_no');
            $this->form_validation->set_rules('bankname', 'Bank', 'trim|required|xss_clean');
            $this->form_validation->set_rules('cheque_no', 'Cheque no', 'trim|required|xss_clean');
        }
        $supplierid = $this->input->post('supplierid');
        $batchid = $this->input->post('batchid');
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

// Validating Course Field
        $this->form_validation->set_rules('refno', 'Reference No', 'trim|min_length[1]|max_length[100]|xss_clean');
// Validating Student Field
        $this->form_validation->set_rules('amount', 'Amount', 'trim|min_length[1]|max_length[100]|xss_clean');
// Validating Student Field
// Validating Discount Field

        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $data['setval'] = 'setval';
            $data['settings'] = $this->settings_model->getSettings();
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('add_new_supplier_payment', $data);
            $this->load->view('home/footer'); // just the header file
        } else {
            $gateway = $this->db->get('settings')->row()->payment_gateway;
            $datainsertsupplierpayment = array(
                'batchid' => $batchid,
                'supplierid' => $supplierid,
                'paidamount' => $amount,
                'adddate' => $datefinal,
                'adddatestamp' => $datefinalstamp,
                'notes' => $notes,
                'paidby' => $type,
                'refno' => $refno
            );
            $datainsertsupplierpayment['transactionid'] = $transactionid;
            if ($type == 'bank') {

                $datainsertsupplierpayment['transactionid'] = $cheque_no;
                $datainsertsupplierpayment['bank'] = $bank;
                $bankname = $this->bank_model->getBankById($bank);
                $datainsertsupplierpayment['bankname'] = $bankname->name;
                if (empty($id)) {
                    $this->supplier_model->insertSupplierPayment($datainsertsupplierpayment);
                    $this->session->set_flashdata('feedback', 'Added');
                    redirect("supplier/purchaseDetailsBySupplier?id=" . $supplierid);
                } else {
                    $this->supplier_model->updateSupplierPayment($datainsertsupplierpayment, $id);
                    $this->session->set_flashdata('feedback', 'Updated');
                    redirect("supplier/purchaseDetails?id=" . $supplierid);
                }
            }

            if ($type == 'cash') {
                if (empty($id)) {
                    $this->supplier_model->insertSupplierPayment($datainsertsupplierpayment);
                    $this->session->set_flashdata('feedback', 'Added');
                    redirect("supplier/purchaseDetailsBySupplier?id=" . $supplierid);
                } else {
                    $this->supplier_model->updateSupplierPayment($datainsertsupplierpayment, $id);
                    $this->session->set_flashdata('feedback', 'Updated');
                    redirect("supplier/purchaseDetails?id=" . $batchid);
                }
            }
        }
    }

    public function purchaseDetails() {
        $batchid = $this->input->get('id');
        $data['batchid'] = $batchid;
        $data['purchaseinfo'] = $this->purchase_model->getPurchaseById($batchid);
        $data['supplierdetails'] = $this->supplier_model->getSupplierById($data['purchaseinfo']->supplierid);
        $data['settings'] = $this->settings_model->getSettings();
        $data['gateway'] = $this->db->get_where('pgateway', array('gateway' => $data['settings']->payment_gateway))->row();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('paymentlist', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function getSupplierPayment() {
        $supplierid = $this->input->post('supplierid');
        $batchid = $this->input->post('batchid');

        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['supplierpayment'] = $this->supplier_model->getSupplierPaymentBySearch($supplierid, $batchid, $search); //done
            } else {
                $data['supplierpayment'] = $this->supplier_model->getSupplierPayment($supplierid, $batchid); //done
            }
        } else {
            if (!empty($search)) {
                $data['supplierpayment'] = $this->supplier_model->getSupplierPaymentByLimitBySearch($supplierid, $batchid, $limit, $start, $search); //done
            } else {
                $data['supplierpayment'] = $this->supplier_model->getSupplierPaymentByLimit($supplierid, $batchid, $limit, $start); //done
                //print_r($data);
                // die();
            }
        }

        $options5 = '';
        $count = 0;
        foreach ($data['supplierpayment'] as $supplierpayments) {


            $options5 = '<a class="btn btn-xs delete_button" title="' . lang('delete') . '" href="supplier/deleteSupplierPayment?id=' . $supplierpayments->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i> ' . lang('delete') . '</a>';
            $options1 = ' <a type="button" class="btn btn-xs editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $supplierpayments->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';



            $settings = $this->settings_model->getSettings();

            if ($supplierpayments->paidby == 'cash') {
                $info[] = array(
                    $supplierpayments->adddate,
                    $supplierpayments->refno,
                    $settings->currency . $supplierpayments->paidamount,
                    $supplierpayments->notes,
                    $supplierpayments->paidby,
                    $supplierpayments->bankname,
                    $supplierpayments->transactionid,
                    $options1 . ' ' . $options5,
                        //  $options2
                );
                $count = $count + 1;
            } else {
                $info[] = array(
                    $supplierpayments->adddate,
                    $supplierpayments->refno,
                    $settings->currency . $supplierpayments->paidamount,
                    $supplierpayments->notes,
                    $supplierpayments->paidby,
                    $supplierpayments->bankname,
                    $supplierpayments->transactionid,
                    $options5,
                );
                $count = $count + 1;
            }
        }
        if (!empty($count)) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $count,
                "recordsFiltered" => $count,
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function editSupplierPaymentByJason() {
        $id = $this->input->get('id');
        $data['response'] = $this->supplier_model->getSupplierPaymentById($id);
        echo json_encode($data);
    }

    public function deleteSupplierPayment() {

        $id = $this->input->get('id');
        $supplierpayment = $this->supplier_model->getSupplierPaymentById($id);
        $this->supplier_model->deleteSupplierPayment($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        redirect("supplier/purchaseDetails?id=" . $supplierpayment->batchid);
    }

    public function deleteBatch() {
        $batchid = $this->input->get('id');
        $purchaselist = $this->purchase_model->getPurchaseById($batchid);
        $supplierpayment = $this->supplier_model->getPaymentByBatchId($batchid);

        foreach ($supplierpayment as $supplierpayments) {
            $deleteall[] = $this->supplier_model->deleteSupplierPayment($supplierpayments->id);
        }
        $this->purchase_model->delete($batchid);
        redirect("supplier/purchaseDetailsBySupplier?id=" . $purchaselist->supplierid);
    }

}

/* End of file supplier.php */
    /* Location: ./application/modules/supplier/controllers/supplier.php */
    