<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

use Twilio\Rest\Client;

class Sms extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('sms_model');
        $this->load->model('supplier/supplier_model');
        $this->load->model('accountant/accountant_model');
    }

    public function index() {
        $data = array();
        $id = $this->ion_auth->get_user_id();
        $data['settings'] = $this->settings_model->getSettings();
        $data['sgateways'] = $this->sms_model->getSmsSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('sgateway', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    public function sendView() {
        $data = array();
        $id = $this->ion_auth->get_user_id();
        $type = 'sms';
        $data['templates'] = $this->sms_model->getManualTemplate($type);
        $data['shortcode'] = $this->sms_model->getTag();
        $data['sms'] = $this->sms_model->getSmsSettingsById($id);
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('sendview', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    public function settings() {
        $data = array();
        $id = $this->input->get('id');
        $data['settings1'] = $this->sms_model->getSmsSettingsById($id);
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('settings', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    public function addNewSettings() {

        $id = $this->input->post('id');


        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

        if ($id == 1) {
            $username = $this->input->post('username');
            $password = $this->input->post('password');
            $api_id = $this->input->post('api_id');
           
            $this->form_validation->set_rules('username', 'Username', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            // Validating Password Field
            if (!empty($password)) {
                $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            }
            // Validating Email Field
            $this->form_validation->set_rules('api_id', 'Api Id', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            if ($this->form_validation->run() == false) {
                $data = array();
                $data['settings1'] = $this->sms_model->getSmsSettingsById($id);
                $data['settings'] = $this->settings_model->getSettings();
                $this->load->view('home/dashboard', $data); // just the header file
                $this->load->view('settings', $data);
                $this->load->view('home/footer'); // just the footer file
            } else {
                $data = array();
                $data = array(
                    'username' => $username,
                    'password' => $password,
                    'api_id' => $api_id,
                    'user' => $this->ion_auth->get_user_id()
                );
                $this->sms_model->updateSmsSettings($id, $data);
                $this->session->set_flashdata('feedback', 'Updated');
            }
        } if ($id == 2) {
            $authkey = $this->input->post('authkey');
            $sender = $this->input->post('sender');
            $this->form_validation->set_rules('authkey', 'Auth Key', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            // Validating Password Field
            $this->form_validation->set_rules('sender', 'Sender', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            // Validating Email Field
            if ($this->form_validation->run() == false) {
                $data = array();
                $data['settings1'] = $this->sms_model->getSmsSettingsById($id);
                $data['settings'] = $this->settings_model->getSettings();
                $this->load->view('home/dashboard', $data); // just the header file
                $this->load->view('settings', $data);
                $this->load->view('home/footer'); // just the footer file
            } else {
                $data = array();
                $data = array(
                    'sender' => $sender,
                    'authkey' => $authkey,
                    'user' => $this->ion_auth->get_user_id()
                );
                $this->sms_model->updateSmsSettings($id, $data);
                $this->session->set_flashdata('feedback', 'Updated');
            }
        } if ($id == 3) {

            $sid = $this->input->post('sid');
            $token = $this->input->post('token');
            $twilio_number = $this->input->post('twilio_number');
            $this->form_validation->set_rules('twilio_number', 'Twilio Number', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            // Validating Password Field
            $this->form_validation->set_rules('sid', 'SID', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            // Validating Email Field
            $this->form_validation->set_rules('token', 'Token', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            if ($this->form_validation->run() == false) {
                $data = array();
                $data['settings1'] = $this->sms_model->getSmsSettingsById($id);
                $data['settings'] = $this->settings_model->getSettings();
                $this->load->view('home/dashboard', $data); // just the header file
                $this->load->view('settings', $data);
                $this->load->view('home/footer'); // just the footer file
            } else {
                $data = array();
                $data = array(
                    'sid' => $sid,
                    'token' => $token,
                    'twilio_number' => $twilio_number,
                    'user' => $this->ion_auth->get_user_id()
                );
                $this->sms_model->updateSmsSettings($id, $data);
                $this->session->set_flashdata('feedback', 'Updated');
            }
        }
        redirect('sms/settings?id=' . $id);
    }

    function sendSms($to, $message, $data) {
  
        $sms_gateway = $this->settings_model->getSettings()->sms_gateway;
        if (!empty($sms_gateway)) {
            $smsSettings = $this->sms_model->getSmsSettingsByGatewayName($sms_gateway);
            
        } else {

            $this->session->set_flashdata('feedback', lang('gateway_not_selected'));
            redirect('sms/sendView');
        }
        $j = sizeof($data);
      
        foreach ($data as $key => $value) {
            foreach ($value as $key2 => $value2) {




                if ($smsSettings->name == 'Clickatell') {
                    $username = $smsSettings->username;
                    $password = $smsSettings->password;
                    $api_id = $smsSettings->api_id;

                    file_get_contents('https://platform.clickatell.com/messages/http/send?apiKey=' . $api_id . '&to=' . $key2 . '&content=' . $value2);           // file_get_contents('https://platform.clickatell.com/messages/http/send?apiKey='.$api_id.'&to='.$to.'&content='.$message1);           // file_get_contents('https://api.clickatell.com/http/sendmsg?user=' . $username . '&password=' . $password . '&api_id=' . $api_id . '&to=' . $to . '&text=' . $message1);
                }
                if ($smsSettings->name == 'Twilio') {
                    $sid = $smsSettings->sid;
                    $token = $smsSettings->token;
                    $sendername = $smsSettings->twilio_number;
                    $client = new Client($sid, $token);
                    $client->messages->create(
                            $key2, // Text this number
                            array(
                        'from' => $sendername, // From a valid Twilio number
                        'body' => $value2
                            )
                    );



                }
                if ($smsSettings->name == 'MSG91') {
                    $authkey = $smsSettings->authkey;
                    $sender = $smsSettings->sender;
                    file_get_contents('http://api.msg91.com/api/sendhttp.php?route=4&sender=' . $sender . '&mobiles=' . $key2 . '&authkey=' . $authkey . '&message=' . $value2 . '&country=0');           // file_get_contents('https://platform.clickatell.com/messages/http/send?apiKey='.$api_id.'&to='.$to.'&content='.$message1);           // file_get_contents('https://api.clickatell.com/http/sendmsg?user=' . $username . '&password=' . $password . '&api_id=' . $api_id . '&to=' . $to . '&text=' . $message1);
                }
            }
        }
    }

    function send() {
        $userId = $this->ion_auth->get_user_id();
        $is_v_v = $this->input->post('radio');
        $settings = $this->settings_model->getSettings();
        if ($is_v_v == 'allstaff') {
            $employees = $this->accountant_model->getAccountant();

            foreach ($employees as $employee) {
                $to[] = $employee->phone;
                $message = $this->input->post('message');
                $name = explode(' ', $employee->name);
                if (!isset($name[1])) {
                    $name[1] = null;
                }
                $data1 = array(
                    'firstname' => $name[0],
                    'lastname' => $name[1],
                    'name' => $employee->name,
                    'phone' => $employee->phone,
                    'email' => $employee->email,
                    'address' => $employee->address,
                    'companyname' => $settings->system_vendor
                );
                $messageprint = $this->parser->parse_string($message, $data1);
                $data2[] = array($employee->phone => $messageprint);
            }

            $recipient = 'All Staff';
        }

        if ($is_v_v == 'single_staff') {
            $employee = $this->input->post('staff');
            $employee_detail = $this->accountant_model->getAccountantById($employee);
            $single_employee_phone = $employee_detail->phone;
            $message = $this->input->post('message');
            $name = array();
            $name = explode(' ', $employee_detail->name);
            if (!isset($name[1])) {
                $name[1] = null;
            }
            $data1 = array();
            $data1 = array(
                'firstname' => $name[0],
                'lastname' => $name[1],
                'name' => $employee_detail->name,
                'phone' => $employee_detail->phone,
                'email' => $employee_detail->email,
                'address' => $employee_detail->address,
                'companyname' => $settings->system_vendor
            );
            $messageprint = $this->parser->parse_string($message, $data1);
            $data2[] = array($employee_detail->phone => $messageprint);
            $recipient = 'Employee Id: ' . $employee_detail->id . '<br> Employee Name: ' . $employee_detail->name . '<br> Employee Phone: ' . $employee_detail->phone;
        }
        if ($is_v_v == 'allsupplier') {
            $suppliers = $this->supplier_model->getSupplier();
            foreach ($suppliers as $supplier) {
                $to[] = $supplier->phone;
                $message = $this->input->post('message');
                $name = explode(' ', $supplier->name);
                if (!isset($name[1])) {
                    $name[1] = null;
                }
                $data1 = array(
                    'firstname' => $name[0],
                    'lastname' => $name[1],
                    'name' => $supplier->name,
                    'phone' => $supplier->phone,
                    'email' => $supplier->email,
                    'address' => $supplier->address,
                    'companyname' => $settings->system_vendor
                );
                $messageprint = $this->parser->parse_string($message, $data1);
                $data2[] = array($supplier->phone => $messageprint);
            }
            $recipient = 'All Supplier';
        }

        if ($is_v_v == 'single_supplier') {
            $supplier = $this->input->post('supplier');
            $supplier_detail = $this->supplier_model->getSupplierById($supplier);
            $single_supplier_sms = $supplier_detail->phone;
            $message = $this->input->post('message');
            $name = array();
            $name = explode(' ', $supplier_detail->name);
            if (!isset($name[1])) {
                $name[1] = null;
            }
            $data1 = array();
            $data1 = array(
                'firstname' => $name[0],
                'lastname' => $name[1],
                'name' => $supplier_detail->name,
                'phone' => $supplier_detail->phone,
                'email' => $supplier_detail->email,
                'address' => $supplier_detail->address,
                'companyname' => $settings->system_vendor
            );
            $messageprint = $this->parser->parse_string($message, $data1);
            $data2[] = array($supplier_detail->phone => $messageprint);


            $recipient = 'Supplier Id: ' . $supplier_detail->id . '<br> Supplier Name: ' . $supplier_detail->name . '<br> Supplier Phone: ' . $supplier_detail->phone;
        }
        if (!empty($single_employee_phone)) {
            $to1 = $single_employee_phone;
        } else {
            if (!empty($to)) {
                $to1 = implode(',', $to);
            }
        }
        if (!empty($single_supplier_sms)) {
            $to1 = $single_supplier_sms;
        } else {
            if (!empty($to)) {

                $to1 = implode(',', $to);
            }
        }

        if (!empty($to1)) {
            $message = $this->input->post('message');
            $message1 = urlencode($message);
            $this->sendSms($to1, $message1, $data2);
            //$this->sendSms($to, $message1);
            $data = array();
            $date = time();
            $data = array(
                'message' => $message,
                'date' => $date,
                'recipient' => $recipient,
                'user' => $userId
            );
            $this->sms_model->insertSms($data);
            $this->session->set_flashdata('feedback', 'Message Sent');
        } else {
            $this->session->set_flashdata('feedback', 'Not Sent');
        }
        redirect('sms/sendView');
    }

    function sendSmsDuringEmployeeRegistration($employee) {


        $employee_detail = $this->employee_model->getEmployeeById($employee);

        $recipient_p = 'Employee Id: ' . $employee_detail->id . '<br> Employee Name: ' . $employee_detail->name . '<br> Employee Phone: ' . $employee_detail->phone;

        if (!empty($employee)) {
            $to = $employee_detail->phone;
            $message = 'Employee Registration' . $employee_detail->name . 'is successfully registerred';
            $message1 = urlencode($message);
            $this->sendSms($to, $message1);
            $data_p = array();
            $date = time();
            $data_p = array(
                'message' => $message,
                'date' => $date,
                'recipient' => $recipient_p,
                'user' => $this->ion_auth->get_user_id()
            );
            $this->sms_model->insertSms($data_p);
        }
    }

    function sent() {
        if ($this->ion_auth->in_group(array('admin'))) {
            $data['sents'] = $this->sms_model->getSms();
        } else {
            $current_user_id = $this->ion_auth->user()->row()->id;
            $data['sents'] = $this->sms_model->getSmsByUser($current_user_id);
        }
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data);
        $this->load->view('sms', $data);
        $this->load->view('home/footer');
    }

    function delete() {
        $id = $this->input->get('id');
        $this->sms_model->delete($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        redirect('sms/sent');
    }

    function smsTemplate() {
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data);
        $this->load->view('addSmsTemplate');
        $this->load->view('home/footer');
    }

    function editAutoSmsTemplate() {
        $id = $this->input->get('id');
        $data['autotemplatename'] = $this->sms_model->getAutoSmsTemplatebyId($id);
        $type = $data['autotemplatename']->type;
        $data['autotag'] = $this->sms_model->getShortCodebyType($type);
        echo json_encode($data);
    }

    function getAutoTemplateList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['cases'] = $this->sms_model->getAutoTemplateBySearch($search);
            } else {
                $data['cases'] = $this->sms_model->getAutoTemplate();
            }
        } else {
            if (!empty($search)) {
                $data['cases'] = $this->sms_model->getAutoTemplateByLimitBySearch($limit, $start, $search);
            } else {
                $data['cases'] = $this->sms_model->getAutoTemplateByLimit($limit, $start);
            }
        }
        $i = 0;
        $count = 0;
        foreach ($data['cases'] as $case) {
            $i = $i + 1;
            if ($this->ion_auth->in_group(array('admin'))) {

                $options1 = ' <a type="button" class="btn btn-success btn-xs btn_width editbutton1" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $case->id . '"><i class="fa fa-edit"> </i></a>';
            }
            $info[] = array(
                '<i class="fa fa-check-circle"></i> '.$case->name,
                $case->message,
                $case->status,
                $options1
            );
            $count = $count + 1;
        }

        if (!empty($data['cases'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $count,
                "recordsFiltered" => $count,
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function addNewAutoTemplate() {
        $message = $this->input->post('message');
        $name = $this->input->post('category');
        $status = $this->input->post('status');
        $id = $this->input->post('id');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        $this->form_validation->set_rules('message', 'Message', 'trim|xss_clean|required');
        if ($this->form_validation->run() == FALSE) {

            $data['settings'] = $this->settings_model->getSettings();
            $data['shortcode'] = $this->sms_model->getTag();
            $this->load->view('home/dashboard', $data);
            $this->load->view('addSmsTemplate');
            $this->load->view('home/footer');
        } else {
            $data = array();
            $data = array(
                'name' => $name,
                'message' => $message,
                'status' => $status,
            );

            $this->sms_model->updateAutoTemplate($data, $id);
            $this->session->set_flashdata('feedback', 'Updated');

            redirect('sms/smsTemplate');
        }
    }

    function getSmsList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['cases'] = $this->sms_model->getSmsBySearch($search);
            } else {
                $data['cases'] = $this->sms_model->getSms();
            }
        } else {
            if (!empty($search)) {
                $data['cases'] = $this->sms_model->getSmsByLimitBySearch($limit, $start, $search);
            } else {
                $data['cases'] = $this->sms_model->getSmsByLimit($limit, $start);
            }
        }
        $i = 0;
        foreach ($data['cases'] as $case) {
            $i = $i + 1;
            if ($this->ion_auth->in_group(array('admin'))) {

                $options2 = '<a class="btn btn-info btn-xs btn_width delete_button" title="' . lang('delete') . '" href="sms/delete?id=' . $case->id . '&redirect=sms" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i></a>';
            }


            $info[] = array(
                $i,
                $case->date,
                $case->message,
                $case->recipient,
                $options2
            );
        }

        if (!empty($data['cases'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('sms')->num_rows(),
                "recordsFiltered" => $this->db->get('sms')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function smsmanualTemplate() {
        $data['settings'] = $this->settings_model->getSettings();
        $data['shortcode'] = $this->sms_model->getTag();
        $this->load->view('home/dashboard', $data);
        $this->load->view('smstemplate', $data);
        $this->load->view('home/footer', $data);
    }

    public function smsNewTemplate() {
        $data['settings'] = $this->settings_model->getSettings();
        $data['shortcode'] = $this->sms_model->getTag();
        $this->load->view('home/dashboard', $data);
        $this->load->view('addtemplate', $data);
        $this->load->view('home/footer', $data);
    }

    public function addNewTemplate() {
        $message = $this->input->post('message');
        $name = $this->input->post('name');
        $type = $this->input->post('type');
        $id = $this->input->post('id');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
// Validating 
        $this->form_validation->set_rules('message', 'Message', 'trim|xss_clean|required');

// Validating 
        $this->form_validation->set_rules('name', 'Name', 'trim|xss_clean|required');
        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                $data = array();
                $data['settings'] = $this->settings_model->getSettings();
                $data['templatename'] = $this->sms_model->getTemplateById($id, $type);
                $data['shortcode'] = $this->sms_model->getTag();
                $this->load->view('home/dashboard', $data); // just the header file
                $this->load->view('addtemplate', $data);
                $this->load->view('home/footer', $data); // just the footer file
            } else {
                $data = array();
                $data['setval'] = 'setval';
                $data['settings'] = $this->settings_model->getSettings();
                $data['shortcode'] = $this->sms_model->getTag();
                $this->load->view('home/dashboard', $data); // just the header file
                $this->load->view('addtemplate', $data);
                $this->load->view('home/footer', $data); // just the footer file
            }
        } else {
            $data = array();
            $data = array(
                'name' => $name,
                'message' => $message,
                'type' => $type
            );
            if (empty($id)) {
                $this->sms_model->addTemplate($data);
                $this->session->set_flashdata('feedback', 'Added');
            } else {
                $this->sms_model->updateTemplate($data, $id);
                $this->session->set_flashdata('feedback', 'Updated');
            }
            redirect('sms/sendView');
        }
    }

    function getTemplateList() {
        $type = $this->input->post('type');
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['cases'] = $this->sms_model->getTemplateBySearch($search, $type);
            } else {
                $data['cases'] = $this->sms_model->getManualTemplate($type);
            }
        } else {
            if (!empty($search)) {
                $data['cases'] = $this->sms_model->getTemplateByLimitBySearch($limit, $start, $search, $type);
            } else {
                $data['cases'] = $this->sms_model->getTemplateByLimit($limit, $start, $type);
            }
        }
        $i = 0;
        $count = 0;
        foreach ($data['cases'] as $case) {
            $i = $i + 1;
            if ($this->ion_auth->in_group(array('admin'))) {

                $options1 = ' <a type="button" class="btn btn-success btn-xs btn_width editbutton1" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $case->id . '"><i class="fa fa-edit"> </i></a>';
                $options2 = '<a class="btn btn-danger btn-xs btn_width" title="' . lang('delete') . '" href="sms/deleteManualTemplate?id=' . $case->id . '&redirect=sms/smsTemplate" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i></a>';
            }
            $info[] = array(
                $i,
                $case->name,
                $case->message,
                ' ' . $options1 . ' ' . $options2
            );
            $count = $count + 1;
        }

        if (!empty($data['cases'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $count,
                "recordsFiltered" => $count,
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function editTemplate() {
        $id = $this->input->get('id');
        $type = $this->input->get('type');
        $data['settings'] = $this->settings_model->getSettings();
        $data['templatename'] = $this->sms_model->getTemplateById($id, $type);

        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('addtemplate', $data);
        $this->load->view('home/footer', $data); // just the footer file
    }

    public function editSmsTemplate() {
        $id = $this->input->get('id');
        $type = $this->input->get('type');

        $data['templatename'] = $this->sms_model->getTemplateById($id, $type);

        echo json_encode($data);
    }

    public function deleteManualTemplate() {
        $id = $this->input->get('id');
        $this->sms_model->deleteTemplate($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        redirect('sms/smsmanualTemplate');
    }

    public function getTemplateinfo() {
        $searchTerm = $this->input->post('searchTerm');
        $type = 'sms';
        $response = $this->sms_model->gettemplates($searchTerm, $type);

        echo json_encode($response);
    }

    public function getTemplateText() {
        $id = $this->input->get('id');
        $type = $this->input->get('type');
        $data['user'] = $this->sms_model->getTemplateById($id, $type);
        echo json_encode($data);
    }

}

/* End of file profile.php */
/* Location: ./application/modules/profile/controllers/profile.php */
