<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Status extends MX_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->helper('url');
        $this->load->library('Ion_auth');
        $this->load->module('finance');
        $this->load->model('client/client_model');
        $this->load->model('finance/finance_model');
        //$this->load->model('student/student_model');
        $this->load->model('pgateway/pgateway_model');
        $this->load->library('session');
    }

    public function index() {
        $status = $this->input->post('status');
        if (empty($status)) {
            redirect('payu');
        }

        $firstname = $this->input->post('firstname');
        $amount = $this->input->post('amount');
        $txnid = $this->input->post('txnid');
        $posted_hash = $this->input->post('hash');
        $key = $this->input->post('key');
        $productinfo = $this->input->post('productinfo');

        $email = $this->input->post('email');

        $payumoney = $this->pgateway_model->getPaymentGatewaySettingsById('Pay U Money');

        $salt = $payumoney->salt; //  Your salt
        $add = $this->input->post('additionalCharges');
        If (isset($add)) {
            $additionalCharges = $this->input->post('additionalCharges');
            $retHashSeq = $additionalCharges . '|' . $salt . '|' . $status . '|||||||||||' . $email . '|' . $firstname . '|' . $productinfo . '|' . $amount . '|' . $txnid . '|' . $key;
        } else {

            $retHashSeq = $salt . '|' . $status . '|||||||||||' . $email . '|' . $firstname . '|' . $productinfo . '|' . $amount . '|' . $txnid . '|' . $key;
        }
        $data['hash'] = hash("sha512", $retHashSeq);
        $data['amount'] = $amount;
        $data['txnid'] = $txnid;
        $data['posted_hash'] = $posted_hash;
        $data['status'] = $status;

        $client_info = $this->customer_model->getcustomerByEmail($email);
        $client_id = $client_info->id;


        if ($status == 'success') {

            $data = array();
            $data = array('customer' => $client_id,
                'date' => time(),
                'payment_id' => $productinfo,
                'deposited_amount' => $amount,
                'deposit_type' => 'Card',
                'gateway' => 'Pay U Money',
                'user' => $this->ion_auth->get_user_id()
            );
            $this->finance_model->insertDeposit($data);

            $this->session->set_flashdata('feedback', 'Payment Completed Successfully');

            if ($this->ion_auth->in_group(array('Customer'))) {
                redirect('customer/myPaymentHistory');
            } else {
                redirect('finance/customerPaymentHistory?customer=' . $client_id);
            }
            //  $this->load->view('success', $data);
        } else {
            $this->session->set_flashdata('feedback', 'Payment Failed!');
            redirect('finance/customerPaymentHistory?customer=' . $client_id);
        }
    }

    public function index1() {
        $status = $this->input->post('status');
        if (empty($status)) {
            redirect('payu');
        }

        $firstname = $this->input->post('firstname');
        $amount = $this->input->post('amount');
        $txnid = $this->input->post('txnid');
        $posted_hash = $this->input->post('hash');
        $key = $this->input->post('key');
        $productinfo = $this->input->post('productinfo');
        $productexplode = explode('-', $productinfo);
        $paymentdetails = $this->finance_model->getPaymentById($productexplode[0]);
        if ($paymentdetails->client != 'Walking Customer') {
            $clientdetails = $this->client_model->getClientById($paymentdetails->client);
        } else {
            $clientdetails = 'Walking Customer';
        }
        $email = $this->input->post('email');
        $payumoney = $this->pgateway_model->getGatewayById('3');
        $amountactual = $amount;
        $salt = $payumoney->salt; //  Your salt
        $add = $this->input->post('additionalCharges');
        If (isset($add)) {
            $additionalCharges = $this->input->post('additionalCharges');
            $retHashSeq = $additionalCharges . '|' . $salt . '|' . $status . '|||||||||||' . $email . '|' . $firstname . '|' . $productinfo . '|' . $amount . '|' . $txnid . '|' . $key;
        } else {

            $retHashSeq = $salt . '|' . $status . '|||||||||||' . $email . '|' . $firstname . '|' . $productinfo . '|' . $amount . '|' . $txnid . '|' . $key;
        }
        $data['hash'] = hash("sha512", $retHashSeq);
        $data['amount'] = $amount;
        $data['txnid'] = $txnid;
        $data['posted_hash'] = $posted_hash;
        $data['status'] = $status;


        if ($status == 'success') {
            // $date = time();
            $transaction_id = $txnid;
            $paid_by = 'PayU Money';
            $transaction = array(
                'client_id' => $paymentdetails->client,
                'paid_amount' => $amount,
                'date' => strtotime(date('d-m-Y')),
                'date_string' => date('d-m-Y'),
                'transaction_id' => $transaction_id,
                'paid_by' => $paid_by,
                'paidtype' => 'card',
                'invoice' => $paymentdetails->id
            );
            $this->finance_model->addTransaction($transaction);
            if ($paymentdetails->client != 'Walking Customer') {
                $data6 = array(
                    'clientid' => $paymentdetails->client,
                    'amount' => $amount
                );
                $this->finance->sendingSmsEmail($data6);
            }

            $this->session->set_flashdata('feedback', 'Payment Completed Successfully');


            redirect("finance/invoice?id=" . $paymentdetails->id);
        } else {
            $this->session->set_flashdata('feedback', 'Payment Failed!');
            redirect("finance/invoice?id=" . $paymentdetails->id);
            /* if ($productexplode[2] == 0) {
              redirect('finance/addPaymentView');
              } else {
              redirect("student/details?student_id=" . $productexplode[1]);
              } */
        }
    }

    public function index2() {
        $status = $this->input->post('status');
        if (empty($status)) {
            redirect('payu');
        }

        $firstname = $this->input->post('firstname');
        $amount = $this->input->post('amount');
        $txnid = $this->input->post('txnid');
        $posted_hash = $this->input->post('hash');
        $key = $this->input->post('key');
        $productinfo = $this->input->post('productinfo');
        $productexplode = explode('-', $productinfo);
        $paymentdetails = $this->finance_model->getPaymentById($productexplode[0]);



        $email = $this->input->post('email');
        $payumoney = $this->pgateway_model->getGatewayById('3');
        $amountactual = $amount;
        $salt = $payumoney->salt; //  Your salt
        $add = $this->input->post('additionalCharges');
        If (isset($add)) {
            $additionalCharges = $this->input->post('additionalCharges');
            $retHashSeq = $additionalCharges . '|' . $salt . '|' . $status . '|||||||||||' . $email . '|' . $firstname . '|' . $productinfo . '|' . $amount . '|' . $txnid . '|' . $key;
        } else {

            $retHashSeq = $salt . '|' . $status . '|||||||||||' . $email . '|' . $firstname . '|' . $productinfo . '|' . $amount . '|' . $txnid . '|' . $key;
        }
        $data['hash'] = hash("sha512", $retHashSeq);
        $data['amount'] = $amount;
        $data['txnid'] = $txnid;
        $data['posted_hash'] = $posted_hash;
        $data['status'] = $status;


        if ($status == 'success') {
            // $date = time();
            $transaction_id = $txnid;
            $paid_by = 'PayU Money';
            $transaction = array(
                'client_id' => $paymentdetails->client,
                'paid_amount' => $amount,
                'date' => strtotime(date('d-m-Y')),
                'date_string' => date('d-m-Y'),
                'transaction_id' => $transaction_id,
                'paid_by' => $paid_by,
                'paidtype' => 'card',
                'invoice' => $paymentdetails->id
            );
            $this->finance_model->addTransaction($transaction);


            $this->session->set_flashdata('feedback', 'Payment Completed Successfully');


            redirect('finance/paymentDetailsByClient?id=' . $paymentdetails->client);
        } else {
            $this->session->set_flashdata('feedback', 'Payment Failed!');
            redirect('finance/paymentDetailsByClient?id=' . $paymentdetails->client);
            /* if ($productexplode[2] == 0) {
              redirect('finance/addPaymentView');
              } else {
              redirect("student/details?student_id=" . $productexplode[1]);
              } */
        }
    }

}
