<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Order_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertOrder($data) {
       $query= $this->db->insert('orderphar', $data);
       return $query;
    }

    function getOrder() {
        $query = $this->db->get('orderphar');
        return $query->result();
    }

    function searchOrder($search) {
        $this->db->like('name', $search);
        $query = $this->db->get('orderphar');
        return $query;
    }

    function getOrderById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('orderphar');
        return $query->row();
    }

    function updateOrder($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('orderphar', $data);
    }

    function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete('orderphar');
    }

    function deletePurchaseAndPaymaneByOrderId($id) {
        $this->db->where('orderphar', $id);
        $query = $this->db->get('purchase')->result();

        foreach ($query as $purchase) {
            $this->db->where('purchase_id', $purchase->id);
            $this->db->delete('payment');
        }

        $this->db->where('order', $id);
        $this->db->delete('purchase');
    }

    function updateIonUser($username, $email, $password, $ion_user_id) {
        $uptade_ion_user = array(
            'username' => $username,
            'email' => $email,
            'password' => $password
        );
        $this->db->where('id', $ion_user_id);
        $this->db->update('users', $uptade_ion_user);
    }
     function getOrderjason() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('orderphar');
        return $query->result();
    }

    function getOrderBySearch($search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('medcompany', $search);
        $this->db->or_like('ordermaker', $search);
        $this->db->or_like('supplierid', $search);
        $query = $this->db->get('orderphar');
        return $query->result();
    }

    function getOrderByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('orderphar');
        return $query->result();
    }

    function getOrderByLimitBySearch($limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');

         $this->db->like('medcompany', $search);
        $this->db->or_like('ordermaker', $search);
        $this->db->or_like('supplierid', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('orderphar');
        return $query->result();
    }


}
