<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Order extends MX_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('order_model');
        $this->load->model('supplier/supplier_model');
        $this->load->model('medicine/medicine_model');
        $this->load->model('email/email_model');
        if (!$this->ion_auth->in_group(array('admin', 'Accountant'))) {
            redirect('home/permission');
        }
    }

    public function index() {

        $data['medcat'] = $this->medicine_model->getMedicineCategory();
        $data['medcats'] = $this->medicine_model->getMedicineCategory();
        $data['supplier'] = $this->supplier_model->getSupplier();
        $data['suppliers'] = $this->supplier_model->getSupplier();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('order', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addNewView() {
        $data['medcat'] = $this->medicine_model->getMedicineCategory();
        $data['supplier'] = $this->supplier_model->getSupplier();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_new', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function catgoryMed() {

        $catidseparates1 = $this->input->get('id');
        $catidseparates = explode(',', $catidseparates1);
        $med_id = $this->input->get('med_id');
        $catmed_ids = explode(',', $med_id);




        $data = array();
        $data2 = array();

        $i = 0;
        foreach ($catidseparates as $catidseparate) {

            $catname = $this->medicine_model->getMedicineCategoryById($catidseparate);

            $medicineNames = $this->medicine_model->getMedicineByCategory($catname->category);
            foreach ($medicineNames as $medicineName) {
                if (in_array($medicineName->id, $catmed_ids)) {
                    $data[] = '<option data-cat_name="' . $medicineName->category . '" data-iid="' . $medicineName->company . '" data-id="' . $medicineName->name . '"data-cat_id="' . $medicineName->id . '"value="' . $medicineName->id . '" selected >' . $medicineName->name . '</option>';
                    $data2[$i] = $medicineName->id;
                    $i = $i + 1;
                } else {
                    $data[] = '<option data-cat_name="' . $medicineName->category . '" data-iid="' . $medicineName->company . '" data-id="' . $medicineName->name . '"data-cat_id="' . $medicineName->id . '"value="' . $medicineName->id . '">' . $medicineName->name . '</option>';
                }
            }
        }
        array_unique($data);
        $data1['user1'] = implode(' ', $data);
        $data1['user'] = $data2;
        $data = NULL;
        echo json_encode($data1);
    }

    public function categoryMedquan() {

        $medicine1 = $this->input->get('id');
        $medicines = explode(',', $medicine1);


        $data = '';
        foreach ($medicines as $medicine) {
            $medname = $this->medicine_model->getMedicineById($medicine);
            $data.= '
                      <div class="form-group col-md-12">
                      <div class="col-md-3"></div>
                        <div class="form-group row last"><label class="control-label col-md-3">' . $medname->name . '<br>(' . $medname->company . ')</label>
                        
                            <div id="">
                                <div class="input-group input-small">
                                    <td><input type="number"class="" maxlength="5" name="med' . $medname->id . '"></td>                                  
                                </div>                           
                        </div>
               </div>
               </div>
                    ';
        }


        echo json_encode($data);
    }

    function getOrder() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['orders'] = $this->order_model->getOrderBysearch($search); //done
            } else {
                $data['orders'] = $this->order_model->getOrderjason(); //done
            }
        } else {
            if (!empty($search)) {
                $data['orders'] = $this->order_model->getOrderByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['orders'] = $this->order_model->getOrderByLimit($limit, $start); //done
            }
        }
        foreach ($data['orders'] as $order) {

            if ($this->ion_auth->in_group(array('admin','Accountant'))) {
                $options1 = ' <a type="button" class="btn editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $order->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
            }
            $options2 = '<a class="btn detailsbutton" title="' . lang('info') . '" style="color: #fff;" href="order/orderDetails?id=' . $order->id . '"><i class="fa fa-info"></i> ' . lang('info') . '</a>';

            if ($this->ion_auth->in_group(array('admin','Accountant'))) {
                $options5 = '<a class="btn delete_button" title="' . lang('delete') . '" href="order/delete?id=' . $order->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i> ' . lang('delete') . '</a>';
            }

            $options6 = ' <a type="button" class="btn detailsbutton inffo" title="' . lang('info') . '" data-toggle = "modal" data-id="' . $order->id . '"><i class="fa fa-info"> </i> ' . lang('info') . '</a>';

            if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {


                $medid = explode(',', $order->medname);
                $medcompany = explode(',', $order->medcompany);
                $i = 0;
                $orderTable = '';
                foreach ($medid as $medid) {
                    $medquan = explode(',', $order->medquantity);
                     $mednameac = explode(',', $order->mednameac);
                      $medordercompany = explode(',', $order->medcompany);
                    $medname = $this->medicine_model->getMedicineById($medid);
                    if ($medquan[$i] == '') {
                        $medquanupdate = '<label class="control-label"> 0 </label>';
                        $medname11=$mednameac[$i];
                         $medcompany11=$medordercompany[$i];
                    } else {
                        $medquanupdate = '<label class="control-label">' . $medquan[$i] . '</label>';
                         $medname11=$mednameac[$i];
                         $medcompany11=$medordercompany[$i];
                    }
                    $orderTable.=' <div class="form-group">
                     
                        <div class="form-group row last"><label class="control-label">' . $medname11 . '(' . $medcompany11 . ')&emsp;</label> ' . $medquanupdate
                            . ' </div>
               </div>';
                    $i = $i + 1;
                }

                $info[] = array(
                    $order->id,
                    $order->supplierid,
                    $order->ordermaker,
                    $order->add_date,
                    $orderTable,
                     $options5,
                );
            }
        }

        if (!empty($data['orders'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('orderphar')->num_rows(),
                "recordsFiltered" => $this->db->get('orderphar')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function addNew() {

        if (!$this->ion_auth->in_group(array('admin', 'Accountant'))) {
            redirect('home/permission');
        }


        $add_date = date('d-m-y');
        $registration_time = time();
        $ordermaker = $this->input->post('ordermaker');
        $supplier1 = $this->input->post('supplier1');
        $messageorder = $this->input->post('messageorder');
        $med = $_POST['med'];

        $i = 0;
        foreach ($med as $med) {
            $medname = 'med' . $med;

            $medquan[$i] = $this->input->post($medname);
            $medcom[$i] =$this->medicine_model->getMedicineById($med)->company;
             $medname112[$i] =$this->medicine_model->getMedicineById($med)->name;
            $i = $i + 1;
        }
        $medquandatabase = implode(',', $medquan);
        $medcomdatabase = implode(',', $medcom);
         $mednamedatabase = implode(',', $medname112);
        $med1 = $_POST['med'];
        $meddatabase = implode(',', $med1);
        $medcat1 = $_POST['medcat'];
        $medcatdatabase = implode(',', $medcat1);

        $data = array(
            'medname' => $meddatabase,
            'mednameac'=>$mednamedatabase,
            'medcompany' => $medcomdatabase,
            'medquantity' => $medquandatabase,
            'add_date' => $add_date,
            'registrationtime' => $registration_time,
            'supplierid' => $supplier1,
            'ordermaker' => $ordermaker,
            'medcat' => $medcatdatabase,
            'message' => $messageorder
        );
        $query = $this->order_model->insertOrder($data);
        if ($query) {
            $j = 0;
            $supplerEmail = $this->supplier_model->getSupplierById($supplier1)->email;
            $emailSettings = $this->email_model->getEmailSettings();
            $recentids = $this->db->select_max('id')
                            ->get('orderphar')
                            ->row()->id;

            $subject = 'New Medicine order' . ' ' . '(order no: ' . $recentids . ' )';
            if (!empty($messageorder)) {
                $message = $messageorder . '<br><br>';
            }
            $message.='<table style="border: 1px solid black; border-collapse: collapse;"> <thead>
                            <tr>
                             
                                <th style="border: 1px solid black;">' . lang('name') . '</th>
                                <th style="border: 1px solid black;">' . lang('company') . '</th>
                                 <th style="border: 1px solid black;">' . lang('quantity') . '</th>
                                
                            </tr>
                        </thead>';
            $recentid = $this->order_model->getOrderById($recentids);
            $recentnames = explode(',', $recentid->medname);
            $recentquan = explode(',', $recentid->medquantity);
            foreach ($recentnames as $recentname) {
                $meddetails = $this->medicine_model->getCategoryNameBYMedicineID($recentname);
                if (!empty($recentquan[$j])) {
                    $message.='<tr> <td style="border: 1px solid black;">' . $meddetails->name . '</td>
                                <td style="border: 1px solid black;">' . $meddetails->company . '</td>
                                 <td style="border: 1px solid black;">' . $recentquan[$j] . '</td>'
                            . '</tr>';
                    $j = $j + 1;
                }
            }
            $message.='</table>';

            $this->email->from($emailSettings->admin_email);
            $this->email->to($supplerEmail);
            $this->email->subject($subject);
            $this->email->message($message);
            $this->email->send();
        }
        redirect('order');
        $this->session->set_flashdata('feedback', 'Added & and Email Send to supplier');
    }

    function searchOrderByJason() {
        $search = $this->input->get('id');
        $data['orders'] = $this->order_model->searchOrder($search);
        echo json_encode($data);
    }

    function editOrder() {
        $data = array();
        $id = $this->input->get('id');
        $data['order'] = $this->order_model->getOrderById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_new', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function editOrderByJason() {
        $id = $this->input->get('id');
        $data['order'] = $this->order_model->getOrderById($id);
        echo json_encode($data);
    }

    function getOrderByJason() {
        $id = $this->input->get('id');
        $data['order'] = $this->order_model->getOrderById($id);
        echo json_encode($data);
    }

    function delete() {
        $data = array();
        $id = $this->input->get('id');
        $this->order_model->delete($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        redirect('order');
    }

}

/* End of file order.php */
/* Location: ./application/modules/order/controllers/order.php */
