<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Medicine_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertMedicine($data) {
        $this->db->insert('medicine', $data);
    }

    function getMedicine() {
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('medicine');
        return $query->result();
    }
    
    function totalMedicineNumber() {
        $medicines = $this->db->get('medicine')->result();
        $medicine_number = 0;
        foreach ($medicines as $medicine) {
            $medicine_number = $medicine_number + 1;
        }
        
        return $medicine_number;
    }

    function getLatestMedicine() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function getCategoryNameBYMedicineID($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('medicine');
        return $query->row();
    }

    function getCategoryIDByName($id) {
        $this->db->where('category', $id);
        $query = $this->db->get('medicine_category');
        return $query->row();
    }

    function getCategoryId($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('medicine_category');
        return $query->row();
    }

    function getMedicineByPageNumber($page_number) {
        $data_range_1 = 50 * $page_number;
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('medicine', 50, $data_range_1);
        return $query->result();
    }

    function getMedicineByStockAlert() {
        $this->db->where('quantity <=', 20);
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function getMedicineByExpireAlert() {
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function getMedicineByStockAlertByPageNumber($page_number) {
        $data_range_1 = 50 * $page_number;
        $this->db->where('quantity <=', 20);
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('medicine', 50, $data_range_1);
        return $query->result();
    }

    function getMedicineById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('medicine');
        return $query->row();
    }

    function getMedicineByKeyByStockAlert($page_number, $key) {
        $data_range_1 = 50 * $page_number;

        $this->db->where('quantity <=', 20);
        $this->db->or_like('name', $key);
        $this->db->or_like('company', $key);



        $this->db->order_by('id', 'asc');
        $query = $this->db->get('medicine', 50, $data_range_1);
        return $query->result();
    }

    function getMedicineByKey($page_number, $key) {
        $data_range_1 = 50 * $page_number;
        $this->db->like('name', $key);
        $this->db->or_like('company', $key);
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('medicine', 50, $data_range_1);
        return $query->result();
    }

    function getMedicineByKeyForPos($key) {
        $this->db->like('name', $key);
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function updateMedicine($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('medicine', $data);
    }

    function insertMedicineCategory($data) {

        $this->db->insert('medicine_category', $data);
    }

    function getMedicineCategory() {
        $query = $this->db->get('medicine_category');
        return $query->result();
    }

    function getMedicineCategoryById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('medicine_category');
        return $query->row();
    }

    function getMedicineByCategory($cat) {
        $this->db->where('category', $cat);
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function totalStockPrice() {
        $query = $this->db->get('medicine')->result();
        $stock_price = array();
        foreach ($query as $medicine) {
            $stock_price[] = $medicine->price * $medicine->quantity;
        }

        if (!empty($stock_price)) {
            return array_sum($stock_price);
        } else {
            return 0;
        }
    }

    function updateMedicineCategory($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('medicine_category', $data);
    }

    function deleteMedicine($id) {
        $this->db->where('id', $id);
        $this->db->delete('medicine');
    }

    function deleteMedicineCategory($id) {
        $this->db->where('id', $id);
        $this->db->delete('medicine_category');
    }

//new
    function getMedicinejason() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function getMedicineBySearch($search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('company', $search);
        $this->db->or_like('name', $search);
        $this->db->or_like('generic', $search);
        //    $this->db->or_like('generic', $search);
        // $this->db->or_like('company', $search);
        $this->db->or_like('effects', $search);
        $this->db->or_like('category', $search);
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function getMedicineByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function getMedicineByLimitBySearch($limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');

        // $this->db->like('company', $search);
        $this->db->or_like('name', $search);
        $this->db->or_like('generic', $search);
        //  $this->db->or_like('generic', $search);
        $this->db->or_like('company', $search);
        $this->db->or_like('effects', $search);
        $this->db->or_like('category', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function getMedicinecatjason() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('medicine_category');
        return $query->result();
    }

    function getMedicinecatBySearch($search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('description', $search);

        $this->db->or_like('category', $search);
        $query = $this->db->get('medicine_category');
        return $query->result();
    }

    function getMedicinecatByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('medicine_category');
        return $query->result();
    }

    function getMedicinecatByLimitBySearch($limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');

        $this->db->like('description', $search);

        $this->db->or_like('category', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('medicine_category');
        return $query->result();
    }

    function getMedicineexpirejason() {
        $this->db->order_by('id', 'desc');
        $this->db->where('e_datetimestamp <', time());
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getMedicineexpireBySearch($search) {
        $this->db->order_by('id', 'desc');
        $this->db->where('e_datetimestamp <', time());
        $this->db->like('batchid', $search);
        $this->db->or_like('medname', $search);
        $this->db->or_like('e_date', $search);
        $this->db->or_like('medcategory', $search);
       
        $this->db->or_like('suppliername', $search);
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getMedicineexpireByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->where('e_datetimestamp <', time());
        $this->db->limit($limit, $start);

        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getMedicineexpireByLimitBySearch($limit, $start, $search) {

        $this->db->like('id', $search);
        $this->db->where('e_datetimestamp <', time());
        $this->db->order_by('id', 'desc');
        $this->db->or_like('batchid', $search);
        $this->db->or_like('medname', $search);
        $this->db->or_like('e_date', $search);
        $this->db->or_like('medcategory', $search);
        $this->db->or_like('suppliername', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

//alert
    function getMedicineexpirealertjason() {

        $this->db->order_by('id', 'desc');
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getMedicineexpirealertBySearch($search) {

        $this->db->order_by('id', 'desc');
        $this->db->like('batchid', $search);
        $this->db->or_like('medname', $search);
        $this->db->or_like('e_date', $search);
        $this->db->or_like('medcategory', $search);
        $this->db->or_like('suppliername', $search);
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getMedicineexpirealertByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getMedicineexpirealertByLimitBySearch($limit, $start, $search) {

        // $this->db->like('id', $search);
        $this->db->order_by('id', 'desc');
        //$this->db->order_by('id', 'desc');
        $this->db->like('batchid', $search);
        $this->db->or_like('medname', $search);
        $this->db->or_like('e_date', $search);
        $this->db->or_like('medcategory', $search);
        $this->db->or_like('suppliername', $search);
        // $query = $this->db->get('batchmedicine');
        //  return $query->result();

        $this->db->limit($limit, $start);
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    //stock alert
    function getMedicinestockalertjason() {

        $this->db->order_by('id', 'desc');
        $this->db->where('quantity <=', 20);
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function getMedicinestockalertBySearch($search) {

        $this->db->order_by('id', 'desc');
        $this->db->where('quantity <=', 20);
        $this->db->like('company', $search);
        $this->db->or_like('name', $search);
        $this->db->or_like('generic', $search);
        $this->db->or_like('effects', $search);
        $this->db->or_like('category', $search);
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function getMedicinestockalertByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->where('quantity <=', 20);
        $this->db->limit($limit, $start);
        $query = $this->db->get('medicine');
        return $query->result();
    }

    function getMedicinestockalertByLimitBySearch($limit, $start, $search) {

        $this->db->like('id', $search);
        $this->db->order_by('id', 'desc');
        $this->db->where('quantity <=', 20);
        $this->db->like('company', $search);
        $this->db->or_like('name', $search);
        $this->db->or_like('generic', $search);
        $this->db->or_like('effects', $search);
        $this->db->or_like('category', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('medicine');
        return $query->result();
    }
    function currentStockOutNumberOfMedicine() {
        $query_medicine = $this->db->get('medicine')->result();
        $i = 0;
        foreach ($query_medicine as $q_medicine) {
            $purchaselist = $this->db->get_where('batchmedicine', array('mednameid' => $q_medicine->id))->result();
            $purchasequan = 0;
            foreach ($purchaselist as $purchase) {
                if ($purchase->e_datetimestamp > time()) {
                    $purchasequan = $purchasequan + $purchase->quantity;
                }
            }
            $quantitytrack = array();
            $j = 0;
            $paymentlist2 = $this->db->get('payment')->result();
            foreach ($paymentlist2 as $paymentlist3) {
                $category_name9 = $paymentlist3->category_name;
                $category_name10 = explode(',', $category_name9);
                foreach ($category_name10 as $category_name11) {
                    $category_name12 = explode('*', $category_name11);
                    if ($category_name12[4] == $q_medicine->id) {
                        $quantitytrack[$j] = $category_name12[2];
                        $j = $j + 1;
                    }
                }
                $j = $j + 1;
            }
            $totalbatch = array_sum($quantitytrack);
            $purchasequan3 = $purchasequan - $totalbatch;
            if ($purchasequan3 == 0) {
                $i = $i + 1;
            }
        }
        return $i;
    }
}
