<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Medicine extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('medicine_model');
        $this->load->model('purchase/purchase_model');
        $this->load->model('supplier/supplier_model');
        $this->load->model('finance/finance_model');

        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        if (!$this->ion_auth->in_group(array('admin', 'Accountant', 'Pharmacist', 'Doctor'))) {
            redirect('home/permission');
        }
    }

    public function index() {

        $data['medicines'] = $this->medicine_model->getMedicine();
        $data['categories'] = $this->medicine_model->getMedicineCategory();

        $data['settings'] = $this->settings_model->getSettings();

        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('medicine', $data);
        $this->load->view('home/footer', $data); // just the header file
    }

    public function medicineByPageNumber() {
        $page_number = $this->input->get('page_number');
        if (empty($page_number)) {
            $page_number = 0;
        }
        $data['medicines'] = $this->medicine_model->getMedicineByPageNumber($page_number);
        $data['categories'] = $this->medicine_model->getMedicineCategory();
        $data['pagee_number'] = $page_number;
        $data['p_n'] = $page_number;
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('medicine', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function medicineStockAlert() {

        $data['categories'] = $this->medicine_model->getMedicineCategory();

        $data['settings'] = $this->settings_model->getSettings();
        $data['alert'] = 'Alert Stock';
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('medicine_stock_alert', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function medicineExpireAlert() {

        $data['categories'] = $this->medicine_model->getMedicineCategory();
        $data['supplierupdate'] = $this->supplier_model->getSupplier();

        $data['settings'] = $this->settings_model->getSettings();
        $data['alert'] = 'Expire Alert';
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('medicine_expire_alert', $data);
        $this->load->view('home/footer', $data); // just the header file
    }

    public function medicineExpire() {

        $data['settings'] = $this->settings_model->getSettings();
        $data['supplierupdate'] = $this->supplier_model->getSupplier();
        $data['alert'] = 'Expire Alert';
        $data['categories'] = $this->medicine_model->getMedicineCategory();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('medicine_expire', $data);
        $this->load->view('home/footer', $data); // just the header file
    }

    public function medicineStockAlertByPageNumber() {
        $page_number = $this->input->get('page_number');
        if (empty($page_number)) {
            $page_number = 0;
        }
        $data['p_n'] = $page_number;
        $data['medicines'] = $this->medicine_model->getMedicineByStockAlert($page_number);
        $data['categories'] = $this->medicine_model->getMedicineCategory();
        $data['pagee_number'] = $page_number;
        $data['alert'] = 'Alert Stock';
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('medicine_stock_alert', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function searchMedicine() {
        $page_number = $this->input->get('page_number');
        if (empty($page_number)) {
            $page_number = 0;
        }
        $data['p_n'] = $page_number;
        $key = $this->input->get('key');
        $data['medicines'] = $this->medicine_model->getMedicineByKey($page_number, $key);
        $data['categories'] = $this->medicine_model->getMedicineCategory();
        $data['settings'] = $this->settings_model->getSettings();
        $data['pagee_number'] = $page_number;
        $data['key'] = $key;
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('medicine', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function searchMedicineInAlertStock() {
        $page_number = $this->input->get('page_number');
        if (empty($page_number)) {
            $page_number = 0;
        }
        $data['p_n'] = $page_number;
        $key = $this->input->get('key');
        $data['medicines'] = $this->medicine_model->getMedicineByKeyByStockAlert($page_number, $key);
        $data['categories'] = $this->medicine_model->getMedicineCategory();
        $data['settings'] = $this->settings_model->getSettings();
        $data['pagee_number'] = $page_number;
        $data['key'] = $key;
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('medicine_stock_alert', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function stockReport() {
        $data['medicines'] = $this->medicine_model->getMedicine();

        foreach ($data['medicines'] as $medicine) {
            $quantity = $this->currentStockByMedicine($medicine->id);
            if ($quantity > 0) {
                $stock[] = $quantity;
                $value[] = $quantity * $medicine->s_price;
            }
        }

        if (!empty($stock)) {
            $data['total_stock'] = array_sum($stock);
        } else {
            $data['total_stock'] = 0;
        }

        if (!empty($value)) {
            $data['total_value'] = array_sum($value);
        } else {
            $data['total_value'] = 0;
        }

        $data['categories'] = $this->medicine_model->getMedicineCategory();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('stock_report', $data);
        $this->load->view('home/footer', $data); // just the header file
    }

    public function addMedicineView() {
        $data = array();
        $data['settings'] = $this->settings_model->getSettings();
        $data['categories'] = $this->medicine_model->getMedicineCategory();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_new_medicine_view', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addNewMedicine() {
        $id = $this->input->post('id');
        $name = $this->input->post('name');
        $category = $this->input->post('category');
        $box = $this->input->post('box');
        $s_price = $this->input->post('s_price');
        $generic = $this->input->post('generic');
        $company = $this->input->post('company');
        $effects = $this->input->post('effects');






        if ((empty($id))) {
            $add_date = date('m/d/y');
        } else {
            $add_date = $this->db->get_where('medicine', array('id' => $id))->row()->add_date;
        }

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating Name Field
        $this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[2]|max_length[100]|xss_clean');
        // Validating Category Field
        $this->form_validation->set_rules('category', 'Category', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Purchase Price Field
        // Validating Store Box Field
        $this->form_validation->set_rules('box', 'Store Box', 'trim|min_length[1]|max_length[100]|xss_clean');
        // Validating Selling Price Field
        $this->form_validation->set_rules('s_price', 'Selling Price', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Quantity Field
        // Validating Generic Name Field
        $this->form_validation->set_rules('generic', 'Generic Name', 'trim|required|min_length[2]|max_length[100]|xss_clean');
        // Validating Company Name Field
        $this->form_validation->set_rules('company', 'Company', 'trim|min_length[1]|max_length[100]|xss_clean');
        // Validating Effects Field
        $this->form_validation->set_rules('effects', 'Effects', 'trim|min_length[1]|max_length[500]|xss_clean');
        // Validating Expire Date Field


        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $data['categories'] = $this->medicine_model->getMedicineCategory();
            $data['settings'] = $this->settings_model->getSettings();
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('add_new_medicine_view', $data);
            $this->load->view('home/footer'); // just the header file
        } else {
            $catename = $this->medicine_model->getCategoryId($category);
            $data = array();
            $data = array('name' => $name,
                'category' => $catename->category,
                'categoryid' => $category,
                'box' => $box,
                's_price' => $s_price,
                'generic' => $generic,
                'company' => $company,
                'effects' => $effects,
                'add_date' => $add_date,
            );
            if (empty($id)) {
                $this->medicine_model->insertMedicine($data);
                $this->session->set_flashdata('feedback', 'Added');
            } else {
                $this->medicine_model->updateMedicine($id, $data);
                $this->session->set_flashdata('feedback', 'Updated');
            }
            redirect('medicine');
        }
    }

    function editMedicine() {
        $data = array();
        $data['categories'] = $this->medicine_model->getMedicineCategory();
        $id = $this->input->get('id');
        $data['medicine'] = $this->medicine_model->getMedicineById($id);
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_new_medicine_view', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function load() {
        $id = $this->input->post('id');
        $qty = $this->input->post('qty');
        $previous_qty = $this->db->get_where('medicine', array('id' => $id))->row()->quantity;
        $new_qty = $previous_qty + $qty;
        if ($new_qty < 0) {
            $new_qty = 0;
        }
        $data = array();
        $data = array('quantity' => $new_qty);
        $this->medicine_model->updateMedicine($id, $data);
        $this->session->set_flashdata('feedback', 'Medicine Loaded');
        redirect('medicine');
    }

    function editMedicineByJason() {
        $id = $this->input->get('id');
        $data['medicine'] = $this->medicine_model->getMedicineById($id);
        echo json_encode($data);
    }

    function delete() {
        $id = $this->input->get('id');
        $this->medicine_model->deleteMedicine($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        redirect('medicine');
    }

    public function medicineCategory() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $data['categories'] = $this->medicine_model->getMedicineCategory();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('medicine_category', $data);
        $this->load->view('home/footer', $data); // just the header file
    }

    public function addCategoryView() {
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_new_category_view');
        $this->load->view('home/footer'); // just the header file
    }

    public function addNewCategory() {
        $id = $this->input->post('id');
        $category = $this->input->post('category');
        $description = $this->input->post('description');

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating Category Name Field
        $this->form_validation->set_rules('category', 'Category', 'trim|required|min_length[2]|max_length[100]|xss_clean');
        // Validating Description Field
        $this->form_validation->set_rules('description', 'Description', 'trim|required|min_length[5]|max_length[100]|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $data['settings'] = $this->settings_model->getSettings();
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('add_new_category_view');
            $this->load->view('home/footer'); // just the header file
        } else {
            $data = array();
            $data = array('category' => $category,
                'description' => $description
            );
            if (empty($id)) {
                $this->medicine_model->insertMedicineCategory($data);
                $this->session->set_flashdata('feedback', 'Added');
            } else {
                $this->medicine_model->updateMedicineCategory($id, $data);
                $this->session->set_flashdata('feedback', 'Updated');
            }
            redirect('medicine/medicineCategory');
        }
    }

    function edit_category() {
        $data = array();
        $id = $this->input->get('id');
        $data['medicine'] = $this->medicine_model->getMedicineCategoryById($id);
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_new_category_view', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function editMedicineCategoryByJason() {
        $id = $this->input->get('id');
        $data['medicinecategory'] = $this->medicine_model->getMedicineCategoryById($id);
        echo json_encode($data);
    }

    function deleteMedicineCategory() {
        $id = $this->input->get('id');
        $this->medicine_model->deleteMedicineCategory($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        redirect('medicine/medicineCategory');
    }

    // new med functrions serverside

    function getMedicine() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['medicines'] = $this->medicine_model->getMedicineBysearch($search); //done
            } else {
                $data['medicines'] = $this->medicine_model->getMedicinejason(); //done
            }
        } else {
            if (!empty($search)) {
                $data['medicines'] = $this->medicine_model->getMedicineByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['medicines'] = $this->medicine_model->getMedicineByLimit($limit, $start); //done
            }
        }
        $i = 1;
        $data3 = $this->settings_model->getSettings();
        foreach ($data['medicines'] as $medicine) {
            $stock = '';
            if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                $options1 = ' <a type="button" class="btn btn-xs editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $medicine->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
            }
            $options3 = ' <a type="button" class="btn btn-xs detailsbutton" title="' . lang('details') . '" data-toggle = "modal" data-id="' . $medicine->id . '"data-name="' . $medicine->name . '"><i class="fa fa-info"> </i> ' . lang('details') . '</a>';
            if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                $options5 = '<a class="btn btn-xs delete_button" title="' . lang('delete') . '" href="medicine/delete?id=' . $medicine->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash-o"></i> ' . lang('delete') . '</a>';
            }

            $stock = $this->currentStockByMedicine($medicine->id);

            if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                $info[] = array(
                    $i,
                    $medicine->name,
                    $medicine->category,
                    $medicine->box,
                    $medicine->s_price,
                    $stock,
                    $medicine->generic,
                    $medicine->company,
                    $medicine->effects,
                    $options1 . ' ' . $options3 . ' ' . $options5,
                );
            }
            $i = $i + 1;
        }

        if (!empty($data['medicines'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('medicine')->num_rows(),
                "recordsFiltered" => $this->db->get('medicine')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getStockReport() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['medicines'] = $this->medicine_model->getMedicineBysearch($search); //done
            } else {
                $data['medicines'] = $this->medicine_model->getMedicinejason(); //done
            }
        } else {
            if (!empty($search)) {
                $data['medicines'] = $this->medicine_model->getMedicineByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['medicines'] = $this->medicine_model->getMedicineByLimit($limit, $start); //done
            }
        }
        $i = 1;
        $data3 = $this->settings_model->getSettings();
        foreach ($data['medicines'] as $medicine) {
            $stock = '';
            $stock = $this->currentStockByMedicine($medicine->id);
            if ($stock > 0) {
                if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                    $options1 = ' <a type="button" class="btn-xs editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $medicine->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
                }
                $options3 = ' <a type="button" class="btn-xs detailsbutton" title="' . lang('details') . '" data-toggle = "modal" data-id="' . $medicine->id . '"data-name="' . $medicine->name . '"><i class="fa fa-info"> </i> ' . lang('details') . '</a>';
                if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                    $options5 = '<a class="btn-xs delete_button" title="' . lang('delete') . '" href="medicine/delete?id=' . $medicine->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash-o"></i> ' . lang('delete') . '</a>';
                }




                if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                    $info[] = array(
                        $medicine->name,
                        $stock,
                        $this->currency . $medicine->s_price,
                        $this->currency . $stock * $medicine->s_price
                    );
                }
                $i = $i + 1;
            }
        }

        if (!empty($data['medicines'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('medicine')->num_rows(),
                "recordsFiltered" => $this->db->get('medicine')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getMedicinecategorybyjason() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['medicines'] = $this->medicine_model->getMedicinecatBysearch($search); //done
            } else {
                $data['medicines'] = $this->medicine_model->getMedicinecatjason(); //done
            }
        } else {
            if (!empty($search)) {
                $data['medicines'] = $this->medicine_model->getMedicinecatByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['medicines'] = $this->medicine_model->getMedicinecatByLimit($limit, $start); //done
            }
        }
        $i = 1;
        foreach ($data['medicines'] as $medicine) {
            if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                $options1 = ' <a type="button" class="btn-xs editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $medicine->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
            }

            if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                $options5 = '<a class="btn-xs delete_button" title="' . lang('delete') . '" href="medicine/deleteMedicineCategory?id=' . $medicine->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash-o"></i> ' . lang('delete') . '</a>';
            }


            if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                $info[] = array(
                    $i,
                    $medicine->category,
                    $medicine->description,
                    $options1 . ' ' . $options5,
                );
            }
            $i = $i + 1;
        }

        if (!empty($data['medicines'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('medicine_category')->num_rows(),
                "recordsFiltered" => $this->db->get('medicine_category')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getMedicineexpire() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['medicines'] = $this->medicine_model->getMedicineexpireBysearch($search); //done
            } else {
                $data['medicines'] = $this->medicine_model->getMedicineexpirejason(); //done
            }
        } else {
            if (!empty($search)) {
                $data['medicines'] = $this->medicine_model->getMedicineexpireByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['medicines'] = $this->medicine_model->getMedicineexpireByLimit($limit, $start); //done
            }
        }
        $i = 1;
        $data3 = $this->settings_model->getSettings();
        foreach ($data['medicines'] as $medicine) {
            $stock = '';
            $quantitytrack = array();
            $j = 0;
            $paymentlist2 = $this->finance_model->getPayment();

            foreach ($paymentlist2 as $paymentlist3) {
                $category_name9 = $paymentlist3->category_name;
                $category_name10 = explode(',', $category_name9);
                foreach ($category_name10 as $category_name11) {
                    $category_name12 = explode('*', $category_name11);
                    if ($category_name12[0] == $medicine->id) {
                        $quantitytrack[$j] = $category_name12[2];
                        $j = $j + 1;
                    }
                }
                $j = $j + 1;
            }

            $totalbatch = array_sum($quantitytrack);


            $purchasequan3 = $medicine->quantity - $totalbatch;

            if ($purchasequan3 <= 0) {
                $stock1 = '<p class="os">Stock Out</p>';
            } else {
                $stock1 = $purchasequan3;
            }
            if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                $stock = $this->medicine_model->getMedicineById($medicine->mednameid);
                $info[] = array(
                    $i,
                    $medicine->medname,
                    $medicine->batchid,
                    $medicine->e_date,
                );
            }
            $i = $i + 1;
        }

        if (!empty($data['medicines'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->where('e_datetimestamp <', time())->get('batchmedicine')->num_rows(),
                "recordsFiltered" => $this->db->where('e_datetimestamp <', time())->get('batchmedicine')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                //"draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getMedicineexpirealert() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        $settings11 = $this->settings_model->getSettings()->expire;
        if (empty($settings11)) {
            $settings11 = 5;
        } else {
            $settings11 = $settings11;
        }
        $currenttime = time() + $settings11 * 24 * 60 * 60;
        if ($limit == -1) {
            if (!empty($search)) {
                $data['medicines'] = $this->medicine_model->getMedicineexpirealertBysearch($search); //done
            } else {
                $data['medicines'] = $this->medicine_model->getMedicineexpirealertjason(); //done
            }
        } else {
            if (!empty($search)) {
                $data['medicines'] = $this->medicine_model->getMedicineexpirealertByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['medicines'] = $this->medicine_model->getMedicineexpirealertByLimit($limit, $start); //done
            }
        }
        $i = 1;
        $data3 = $this->settings_model->getSettings();
        $count = 0;
        foreach ($data['medicines'] as $medicine) {
            $stock = '';


            $quantitytrack = array();
            $j = 0;
            $paymentlist2 = $this->finance_model->getPayment();


            foreach ($paymentlist2 as $paymentlist3) {
                $category_name9 = $paymentlist3->category_name;
                $category_name10 = explode(',', $category_name9);
                foreach ($category_name10 as $category_name11) {
                    $category_name12 = explode('*', $category_name11);
                    if ($category_name12[0] == $medicine->id) {
                        $quantitytrack[$j] = $category_name12[2];
                        $j = $j + 1;
                    }
                }
                $j = $j + 1;
            }

            $totalbatch = array_sum($quantitytrack);



            $purchasequan3 = $medicine->quantity - $totalbatch;


            if ($purchasequan3 <= 0) {
                $stock1 = '<p class="os">Stock Out</p>';
            } else {
                $stock1 = $purchasequan3;
            }
            if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                if ($medicine->e_datetimestamp - ($currenttime) <= 0 && $medicine->e_datetimestamp >= time()) {
                    $stock = $this->medicine_model->getMedicineById($medicine->mednameid);
                    $info[] = array(
                        $i,
                        $medicine->medname,
                        $medicine->batchid,
                        $medicine->e_date,
                    );
                    $count = $count + 1;
                } else {
                    $info1[] = array();
                }
            }
            $i = $i + 1;
        }

        if (!empty($info)) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $count,
                "recordsFiltered" => $count,
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function currentStockByMedicine($id) {
        $purchasequan = 0;
        $purchaselist = $this->purchase_model->getPurchaseByMed($id);
        foreach ($purchaselist as $purchase) {
            if ($purchase->e_datetimestamp > time()) {
                $purchasequan = $purchasequan + $purchase->quantity;
            }
        }
        $quantitytrack = array();
        $j = 0;
        $paymentlist2 = $this->finance_model->getPayment();
        foreach ($paymentlist2 as $paymentlist3) {
            $category_name9 = $paymentlist3->category_name;
            $category_name10 = explode(',', $category_name9);
            foreach ($category_name10 as $category_name11) {
                $category_name12 = explode('*', $category_name11);
                if ($category_name12[4] == $id) {
                    $quantitytrack[$j] = $category_name12[2];
                    $j = $j + 1;
                }
            }
            $j = $j + 1;
        }
        $totalbatch = array_sum($quantitytrack);
        $purchasequan3 = $purchasequan - $totalbatch;

        if ($purchasequan3 <= 0) {
            return 0;
        } else {
            return $purchasequan3;
        }
    }

    function currentStockOutNumberOfMedicine() {
        $query_medicine = $this->db->get('medicine')->result();
        $i = 0;
        foreach ($query_medicine as $q_medicine) {
            $purchaselist = $this->db->get_where('batchmedicine', array('mednameid' => $q_medicine->id))->result();
            $purchasequan = 0;
            foreach ($purchaselist as $purchase) {
                if ($purchase->e_datetimestamp > time()) {
                    $purchasequan = $purchasequan + $purchase->quantity;
                }
            }
            $quantitytrack = array();
            $j = 0;
            $paymentlist2 = $this->db->get('payment')->result();
            foreach ($paymentlist2 as $paymentlist3) {
                $category_name9 = $paymentlist3->category_name;
                $category_name10 = explode(',', $category_name9);
                foreach ($category_name10 as $category_name11) {
                    $category_name12 = explode('*', $category_name11);
                    if ($category_name12[4] == $q_medicine->id) {
                        $quantitytrack[$j] = $category_name12[2];
                        $j = $j + 1;
                    }
                }
                $j = $j + 1;
            }
            $totalbatch = array_sum($quantitytrack);
            $purchasequan3 = $purchasequan - $totalbatch;
            if ($purchasequan3 == 0) {
                $i = $i + 1;
            }
        }
        return $i;
    }

    function getMedicinestockalert() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['medicines'] = $this->medicine_model->getMedicineBysearch($search); //done
            } else {
                $data['medicines'] = $this->medicine_model->getMedicinejason(); //done
            }
        } else {
            if (!empty($search)) {
                $data['medicines'] = $this->medicine_model->getMedicineByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['medicines'] = $this->medicine_model->getMedicineByLimit($limit, $start); //done
            }
        }
        $i = 1;
        $data3 = $this->settings_model->getSettings();
        $cou = 0;
        foreach ($data['medicines'] as $medicine) {
            $stock = '';
            $purchasequan3 = $this->currentStockByMedicine($medicine->id);
            if ($purchasequan3 <= 0) {
                $stock = 0;
            } else {
                $stock = $purchasequan3;
            }

            if ($stock <= $this->stock_limit) {
                if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                    $settings11 = $this->settings_model->getSettings();
                    if ($purchasequan3 <= $settings11->stock) {
                        $info[] = array(
                            $i,
                            $medicine->name,
                            $stock,
                        );
                        $cou = $cou + 1;
                    }
                }
                $i = $i + 1;
            }
        }

        if ($cou != 0) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $cou,
                "recordsFiltered" => $cou,
                "data" => $info
            );
        } else {
            $output = array(
                //"draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function getavailableMedicine() {
        $id = $_POST['iid'];
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['medicines'] = $this->purchase_model->getBatchMedBysearch($id, $search); //done
            } else {
                $data['medicines'] = $this->purchase_model->getBatchjason($id); //done
            }
        } else {
            if (!empty($search)) {
                $data['medicines'] = $this->purchase_model->getBatchMedByLimitBySearch($limit, $start, $search, $id); //done
            } else {
                $data['medicines'] = $this->purchase_model->getBatchMedicineByLimit($id, $limit, $start); //done
            }
        }
        $i = 0;
        foreach ($data['medicines'] as $medicine) {
            $payments = $this->finance_model->getPayment();
            $quantity = array();
            foreach ($payments as $payment) {
                $category_name = $payment->category_name;
                $category_name1 = explode(',', $category_name);
                foreach ($category_name1 as $category_name2) {
                    $category_name3 = explode('*', $category_name2);
                    if ($category_name3[0] == $medicine->id) {
                        $quantity[] = $category_name3[2];
                    }
                }
            }

            $quantitysum = array_sum($quantity);
            $currentstock = $medicine->quantity - $quantitysum;
            if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                $j = 0;
                if ($currentstock > 0) {
                    $info[] = array(
                        $medicine->batchid,
                        $medicine->quantity,
                        $quantitysum,
                        $currentstock,
                        $medicine->e_date,
                    );
                    $i = $i + 1;
                } else {
                    $j = $j + 1;
                }
            }
        }
        if ($i > 0) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $i,
                "recordsFiltered" => $i,
                "data" => $info
            );
        } else {
            $output = array(
                "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function getunavailableMedicine() {
        $id = $_POST['iid'];
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['medicines'] = $this->purchase_model->getBatchMedexBysearch($id, $search); //done
            } else {
                $data['medicines'] = $this->purchase_model->getBatchexjason($id); //done
            }
        } else {
            if (!empty($search)) {
                $data['medicines'] = $this->purchase_model->getBatchMedexByLimitBySearch($limit, $start, $search, $id); //done
            } else {
                $data['medicines'] = $this->purchase_model->getBatchMedicineexByLimit($id, $limit, $start); //done
                //print_r($data);
                // die();
            }
        }
        $i = 0;
        foreach ($data['medicines'] as $medicine) {
            $payments = $this->finance_model->getPayment();
            $quantity = array();

            foreach ($payments as $payment) {
                $category_name = $payment->category_name;
                $category_name1 = explode(',', $category_name);
                foreach ($category_name1 as $category_name2) {
                    $category_name3 = explode('*', $category_name2);
                    if ($category_name3[0] == $medicine->id) {
                        $quantity[] = $category_name3[2];
                    }
                }
            }

            $quantitysum = array_sum($quantity);
            $currentstock = $medicine->quantity - $quantitysum;
            if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                $j = 0;
                if ($currentstock == 0 || $medicine->e_datetimestamp < time()) {
                    $info[] = array(
                        $medicine->batchid,
                        $medicine->quantity,
                        $quantitysum,
                        $currentstock,
                        $medicine->e_date,
                    );
                    $i = $i + 1;
                } else {
                    $j = $j + 1;
                }
            }
        }
        if ($i > 0) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $i,
                "recordsFiltered" => $i,
                "data" => $info
            );
        } else {
            $output = array(
                "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function getexpirealertbyBatchwise() {
        $start = $this->input->get('start');
        $end = $this->input->get('end');
        $startstamp = strtotime($start);
        $endstamp = strtotime($end);
        $query = $this->purchase_model->getPurchase();
        $jsonevents = array();

        foreach ($query as $entry) {


            $info = lang('med') . ': ' . $entry->medname . '<br>' . lang('batch') . ': ' . $entry->batchid;
            $color = '#009988';
            $jsonevents[] = array(
                'id' => $entry->id,
                'title' => $info,
                'start' => date('Y-m-d H:i:s', $entry->e_datetimestamp),
                'end' => date('Y-m-d H:i:s', $entry->e_datetimestamp + ((24 * 60 * 60) - 1)),
                'color' => $color,
            );
        }

        echo json_encode($jsonevents);
    }

}

/* End of file medicine.php */
/* Location: ./application/modules/medicine/controllers/medicine.php */
