<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Home extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('medicine/medicine_model');
        $this->load->model('finance/finance_model');
        $this->load->model('home_model');
        // $this->load->module('medicine');
    }

    public function index() {
        $data = array();
        $data['medicines'] = $this->medicine_model->getMedicine();
        $data['latest_medicines'] = $this->medicine_model->getLatestMedicine(); 
        $data['settings'] = $this->settings_model->getSettings();
        $data['payments'] = $this->finance_model->getPayment();
        $data['expenses'] = $this->finance_model->getExpense();
        $data['today_sales_amount'] = $this->finance_model->todaySalesAmount();
        $data['today_expenses_amount'] = $this->finance_model->todayExpensesAmount();
        $data['total_stock_price'] = $this->medicine_model->totalStockPrice();
        $data['sum'] = $this->home_model->getSum('gross_total', 'payment');
        
        
        
        $data['this_month']['payment'] = $this->finance_model->thisMonthPayment();
        $data['this_month']['expense'] = $this->finance_model->thisMonthExpense();

        $data['this_day']['payment'] = $this->finance_model->thisDayPayment();
        $data['this_day']['expense'] = $this->finance_model->thisDayExpense();

        $data['this_year']['payment'] = $this->finance_model->thisYearPayment();
        $data['this_year']['expense'] = $this->finance_model->thisYearExpense();
        
        
        $data['this_year']['payment_per_month'] = $this->finance_model->getPaymentPerMonthThisYear();
        
        
        $data['this_year']['expense_per_month'] = $this->finance_model->getExpensePerMonthThisYear();
        
        
        
        
        
        $this->load->view('dashboard', $data); // just the header file
        $this->load->view('home', $data);
        $this->load->view('footer');
    }

    public function permission() {
        $this->load->view('permission');
    }

}

/* End of file home.php */
/* Location: ./application/controllers/home.php */
