<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Finance_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertPayment($data) {
        $this->db->insert('payment', $data);
    }

    function getPayment() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('payment');
        return $query->result();
    }

    function getPaymentById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('payment');
        return $query->row();
    }

    function getPaymentByKey($page_number, $key) {
        $data_range_1 = 50 * $page_number;
        $this->db->like('id', $key);
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('payment', 50, $data_range_1);
        return $query->result();
    }

    function getPaymentByPageNumber($page_number) {
        $data_range_1 = 50 * $page_number;
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('payment', 50, $data_range_1);
        return $query->result();
    }

    function updatePayment($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('payment', $data);
    }

    function deletePayment($id) {
        $this->db->where('id', $id);
        $this->db->delete('payment');
    }

    function insertExpense($data) {
        $this->db->insert('expense', $data);
    }

    function getExpense() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('expense');
        return $query->result();
    }

    function getExpenseById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('expense');
        return $query->row();
    }

    function updateExpense($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('expense', $data);
    }

    function insertExpenseCategory($data) {
        $this->db->insert('expense_category', $data);
    }

    function getExpenseCategory() {
        $query = $this->db->get('expense_category');
        return $query->result();
    }

    function getExpenseCategoryById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('expense_category');
        return $query->row();
    }

    function updateExpenseCategory($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('expense_category', $data);
    }

    function deleteExpense($id) {
        $this->db->where('id', $id);
        $this->db->delete('expense');
    }

    function deleteExpenseCategory($id) {
        $this->db->where('id', $id);
        $this->db->delete('expense_category');
    }

    function getDiscountType() {
        $query = $this->db->get('settings');
        return $query->row()->discount;
    }

    function getPaymentByDate($date_from, $date_to) {
        $this->db->select('*');
        $this->db->from('payment');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $query = $this->db->get();
        return $query->result();
    }

    function getExpenseByDate($date_from, $date_to) {
        $this->db->select('*');
        $this->db->from('expense');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $query = $this->db->get();
        return $query->result();
    }

    function amountReceived($id, $data) {
        $this->db->where('id', $id);
        $query = $this->db->update('payment', $data);
    }

    function todaySalesAmount() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $hour = 0;
        $today = strtotime($hour . ':00:00');
        $today_last = strtotime($hour . ':00:00') + 24 * 60 * 60;
        $data['settings'] = $this->settings_model->getSettings();
        $data['payments'] = $this->getPaymentByDate($today, $today_last);

        foreach ($data['payments'] as $sales) {
            $sales_amount[] = $sales->gross_total;
        }
        if (!empty($sales_amount)) {
            return array_sum($sales_amount);
        } else {
            return 0;
        }
    }

    function todayExpensesAmount() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $hour = 0;
        $today = strtotime($hour . ':00:00');
        $today_last = strtotime($hour . ':00:00') + 24 * 60 * 60;
        $data['payments'] = $this->getExpenseByDate($today, $today_last);

        foreach ($data['payments'] as $expenses) {
            $expenses_amount[] = $expenses->amount;
        }
        if (!empty($expenses_amount)) {
            return array_sum($expenses_amount);
        } else {
            return 0;
        }
    }
    
    
    
    function thisMonthPayment() {
        $query = $this->db->get('payment')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('m/Y', time()) == date('m/Y', $q->date)) {
                $total[] = $q->gross_total;
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisMonthExpense() {
        $query = $this->db->get('expense')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('m/Y', time()) == date('m/Y', $q->date)) {
                $total[] = $q->amount;
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }
    
    
    
    function thisDayPayment() {
        $query = $this->db->get('payment')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('d/m/Y', time()) == date('d/m/Y', $q->date)) {
                $total[] = $q->gross_total;
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisDayExpense() {
        $query = $this->db->get('expense')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('d/m/Y', time()) == date('d/m/Y', $q->date)) {
                $total[] = $q->amount;
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }
    
    
    function thisYearPayment() {
        $query = $this->db->get('payment')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('Y', time()) == date('Y', $q->date)) {
                $total[] = $q->gross_total;
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisYearExpense() {
        $query = $this->db->get('expense')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('Y', time()) == date('Y', $q->date)) {
                $total[] = $q->amount;
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }
    
    
    
    
    
     function getPaymentPerMonthThisYear() {
        $query = $this->db->get('payment')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('Y', time()) == date('Y', $q->date)) {
                if (date('m', $q->date) == '01') {
                    $total['january'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '02') {
                    $total['february'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '03') {
                    $total['march'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '04') {
                    $total['april'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '05') {
                    $total['may'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '06') {
                    $total['june'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '07') {
                    $total['july'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '08') {
                    $total['august'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '09') {
                    $total['september'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '10') {
                    $total['october'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '11') {
                    $total['november'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '12') {
                    $total['december'][] = $q->gross_total;
                }
            }
        }
        
        
        if(!empty($total['january'])){
            $total['january'] = array_sum($total['january']);
        }else{
            $total['january'] = 0;
        }
        if(!empty($total['february'])){
            $total['february'] = array_sum($total['february']);
        }else{
            $total['february'] = 0;
        }
        if(!empty($total['march'])){
            $total['march'] = array_sum($total['march']);
        }else{
            $total['march'] = 0;
        }
        if(!empty($total['april'])){
            $total['april'] = array_sum($total['april']);
        }else{
            $total['april'] = 0;
        }
        if(!empty($total['may'])){
            $total['may'] = array_sum($total['may']);
        }else{
            $total['may'] = 0;
        }
        if(!empty($total['june'])){
            $total['june'] = array_sum($total['june']);
        }else{
            $total['june'] = 0;
        }
        if(!empty($total['july'])){
            $total['july'] = array_sum($total['july']);
        }else{
            $total['july'] = 0;
        }
        if(!empty($total['august'])){
            $total['august'] = array_sum($total['august']);
        }else{
            $total['august'] = 0;
        }
        if(!empty($total['september'])){
            $total['september'] = array_sum($total['september']);
        }else{
            $total['september'] = 0;
        }
        if(!empty($total['october'])){
            $total['october'] = array_sum($total['october']);
        }else{
            $total['october'] = 0;
        }
        if(!empty($total['november'])){
            $total['november'] = array_sum($total['november']);
        }else{
            $total['november'] = 0;
        }
        if(!empty($total['december'])){
            $total['december'] = array_sum($total['december']);
        }else{
            $total['december'] = 0;
        }
        
        return $total;
    }
    
    function getExpensePerMonthThisYear() {
        $query = $this->db->get('expense')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('Y', time()) == date('Y', $q->date)) {
                if (date('m', $q->date) == '01') {
                    $total['january'][] = $q->amount;
                }
                if (date('m', $q->date) == '02') {
                    $total['february'][] = $q->amount;
                }
                if (date('m', $q->date) == '03') {
                    $total['march'][] = $q->amount;
                }
                if (date('m', $q->date) == '04') {
                    $total['april'][] = $q->amount;
                }
                if (date('m', $q->date) == '05') {
                    $total['may'][] = $q->amount;
                }
                if (date('m', $q->date) == '06') {
                    $total['june'][] = $q->amount;
                }
                if (date('m', $q->date) == '07') {
                    $total['july'][] = $q->amount;
                }
                if (date('m', $q->date) == '08') {
                    $total['august'][] = $q->amount;
                }
                if (date('m', $q->date) == '09') {
                    $total['september'][] = $q->amount;
                }
                if (date('m', $q->date) == '10') {
                    $total['october'][] = $q->amount;
                }
                if (date('m', $q->date) == '11') {
                    $total['november'][] = $q->amount;
                }
                if (date('m', $q->date) == '12') {
                    $total['december'][] = $q->amount;
                }
            }
        }
        
        
        if(!empty($total['january'])){
            $total['january'] = array_sum($total['january']);
        }else{
            $total['january'] = 0;
        }
        if(!empty($total['february'])){
            $total['february'] = array_sum($total['february']);
        }else{
            $total['february'] = 0;
        }
        if(!empty($total['march'])){
            $total['march'] = array_sum($total['march']);
        }else{
            $total['march'] = 0;
        }
        if(!empty($total['april'])){
            $total['april'] = array_sum($total['april']);
        }else{
            $total['april'] = 0;
        }
        if(!empty($total['may'])){
            $total['may'] = array_sum($total['may']);
        }else{
            $total['may'] = 0;
        }
        if(!empty($total['june'])){
            $total['june'] = array_sum($total['june']);
        }else{
            $total['june'] = 0;
        }
        if(!empty($total['july'])){
            $total['july'] = array_sum($total['july']);
        }else{
            $total['july'] = 0;
        }
        if(!empty($total['august'])){
            $total['august'] = array_sum($total['august']);
        }else{
            $total['august'] = 0;
        }
        if(!empty($total['september'])){
            $total['september'] = array_sum($total['september']);
        }else{
            $total['september'] = 0;
        }
        if(!empty($total['october'])){
            $total['october'] = array_sum($total['october']);
        }else{
            $total['october'] = 0;
        }
        if(!empty($total['november'])){
            $total['november'] = array_sum($total['november']);
        }else{
            $total['november'] = 0;
        }
        if(!empty($total['december'])){
            $total['december'] = array_sum($total['december']);
        }else{
            $total['december'] = 0;
        }
        
        return $total;
    }
    
    
    

    //new
    function getFinancejason() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('expense');
        return $query->result();
    }

    function getFinanceBysearch($search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('category', $search);
        $this->db->or_like('amount', $search);
        $this->db->or_like('datestring', $search);
        $query = $this->db->get('expense');
        return $query->result();
    }

    function getFinanceByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('expense');
        return $query->result();
    }

    function getFinanceByLimitBySearch($limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');

        $this->db->like('category', $search);
        $this->db->or_like('amount', $search);
        $this->db->or_like('datestring', $search);
        $this->db->limit($limit, $start);
        $query = $this->db->get('expense');
        return $query->result();
    }

//new
    function getPaymentjason() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('payment');
        return $query->result();
    }

    function getPaymentBysearch($search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('id', $search);
         $this->db->or_like('date_string', $search);
        $this->db->or_like('gross_total', $search);

        $query = $this->db->get('payment');
        return $query->result();
    }

    function getPaymentByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('payment');
        return $query->result();
    }

    function getPaymentByLimitBySearch($limit, $start, $search) {


        $this->db->order_by('id', 'desc');

        $this->db->like('id', $search);
        $this->db->or_like('date_string', $search);
        $this->db->or_like('gross_total', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('payment');
        return $query->result();
    }

    function getMedicineNameByAvailablity($searchTerm) {
        if (!empty($searchTerm)) {
            $this->db->select('*');
            $this->db->where("name like '%" . $searchTerm . "%' ");
            $fetched_records = $this->db->get('medicine');
            $query = $fetched_records->result();
        } else {
            $this->db->select('*');
            $this->db->limit(10);
            $fetched_records = $this->db->get('medicine');
            $query = $fetched_records->result();
        }

        return $query;
    }

    function getPaymentByDateBySearch($date_from, $date_to, $search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('id', $search);
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);

        $query = $this->db->get('payment');
        return $query->result();
    }

    function getPaymentByDateByLimit($date_from, $date_to, $limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $this->db->limit($limit, $start);
        $query = $this->db->get('payment');
        return $query->result();
    }

    function getPaymentByDateByLimitBySearch($date_from, $date_to, $limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);



        $this->db->limit($limit, $start);
        $query = $this->db->get('payment');
        return $query->result();
    }

    function getExpenseByDateBySearch($date_from, $date_to, $search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('id', $search);
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);

        $query = $this->db->get('expense');
        return $query->result();
    }

    function getExpenseByDateByLimit($date_from, $date_to, $limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $this->db->limit($limit, $start);
        $query = $this->db->get('expense');
        return $query->result();
    }

    function getExpenseByDateByLimitBySearch($date_from, $date_to, $limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);



        $this->db->limit($limit, $start);
        $query = $this->db->get('expense');
        return $query->result();
    }

    function addTransaction($data) {
        $this->db->insert('client_payment', $data);
    }

    function getClientPaymentByPaymentId($id) {
        $this->db->order_by('id', 'asc');
        $this->db->where('invoice', $id);
        $query = $this->db->get('client_payment');
        return $query->result();
    }

    function updateTransaction($id, $data) {
        $this->db->where('id', $id);
        return $this->db->update('client_payment', $data);
    }

    function getDueBalanceByPaymentId($id) {
        $this->db->where('id', $id);
        $payment = $this->db->get('payment')->row();
    }

    function getPaymentByClientId($client_id) {
        $this->db->where('client', $client_id);
        $query = $this->db->get('payment');
        return $query->result();
    }

    function getPaymentByClientIdBydate($client, $datefrom, $dateto) {
        $clientpayments = $this->getClientPaymentByIdBydate($client, $datefrom, $dateto);
        if (!empty($clientpayments)) {
            foreach ($clientpayments as $clientpayment) {
                if (!empty($clientpayment->paid_amount)) {
                    $invoiceid[] = $clientpayment->invoice;
                }
            }
        }
        if (!empty($invoiceid)) {
            foreach ($invoiceid as $invoiceid) {
                $this->db->where('id', $invoiceid);
                $query[] = $this->db->get('payment')->row();
            }
        } else {
            $query = array();
        }
        return $query;
    }

    function getClientPaymentById($client_id) {
        $this->db->order_by('id', 'asc');
        $this->db->where('client_id', $client_id);
        $query = $this->db->get('client_payment');
        return $query->result();
    }

    function getDepositedAmountByInvoiceId($id) {
        $this->db->where('invoice', $id);
        $query = $this->db->get('client_payment')->result();

        foreach ($query as $row) {
            $deposited_amount[] = $row->paid_amount;
            $deposited_amount[] = $row->othersdeposit;
        }

        if (!empty($deposited_amount)) {
            $deposited_amount = array_sum($deposited_amount);
        } else {
            $deposited_amount = 0;
        }

        return $deposited_amount;
    }

    function getClientPaymentByIdBydate($client_id, $datefrom, $dateto) {
        $this->db->order_by('id', 'asc');
        $this->db->where('client_id', $client_id);
        $this->db->where('date_string>=', $datefrom);
        $this->db->where('date_string<=', $dateto);
        $query = $this->db->get('client_payment');
        return $query->result();
    }

    function deleteTransaction($id) {
        $this->db->where('id', $id);
        $this->db->delete('client_payment');
    }

}
