<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Client_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertClient($data) {
        $this->db->insert('client', $data);
    }

    function getClient() {
        $query = $this->db->get('client');
        return $query->result();
    }

    function searchClient($search) {
        $this->db->like('name', $search);
        $query = $this->db->get('client');
        return $query;
    }

    function getClientById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('client');
        return $query->row();
    }

    function deleteSaleAndPaymentByClientId($id) {
        $this->db->where('client_id', $id);
        $query = $this->db->get('sale')->result();

        foreach ($query as $sale) {
            $this->db->where('sale_id', $sale->id);
            $this->db->delete('payment');
        }

        $this->db->where('client_id', $id);
        $this->db->delete('sale');
    }

    function updateClient($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('client', $data);
    }

    function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete('client');
    }

    function updateIonUser($username, $email, $password, $ion_user_id) {
        $uptade_ion_user = array(
            'username' => $username,
            'email' => $email,
            'password' => $password
        );
        $this->db->where('id', $ion_user_id);
        $this->db->update('users', $uptade_ion_user);
    }
    
  
     function getClientBySearch($search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('id', $search);
     $this->db->or_like('name', $search);
        $this->db->or_like('phone', $search);
        $this->db->or_like('address', $search);
        $this->db->or_like('email', $search);
        $query = $this->db->get('client');
        return $query->result();
    }

    function getClientByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('client');
        return $query->result();
    }

    function getClientByLimitBySearch($limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');

        $this->db->or_like('name', $search);
        $this->db->or_like('phone', $search);
        $this->db->or_like('address', $search);
        $this->db->or_like('email', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('client');
        return $query->result();
    }

}
