<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Client extends MX_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('client_model');
        $this->load->module('sms');
        if (!$this->ion_auth->in_group(array('admin', 'Accountant'))) {
            redirect('home/permission');
        }
    }

    public function index() {

        $data['clients'] = $this->client_model->getClient();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('client', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addNewView() {
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_new');
        $this->load->view('home/footer'); // just the header file
    }

    public function addNew() {

        $id = $this->input->post('id');
        $name = $this->input->post('name');
        $password = 'passCA12345';
        $email = $this->input->post('email');
        if (empty($email)) {
            $email = 'client' . rand(0, 10000) . 'example.com';
        }
        $address = $this->input->post('address');
        $phone = $this->input->post('phone');
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

        // Validating Name Field
        $this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[5]|max_length[100]|xss_clean');
        // Validating Password Field
        //   if (empty($id)) {
        //       $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[5]|max_length[100]|xss_clean');
        //   }
        // Validating Email Field
        $this->form_validation->set_rules('email', 'Email', 'trim|min_length[5]|max_length[100]|xss_clean');
        // Validating Address Field   
        $this->form_validation->set_rules('address', 'Address', 'trim|min_length[5]|max_length[500]|xss_clean');
        // Validating Phone Field           
        $this->form_validation->set_rules('phone', 'Phone', 'trim|min_length[5]|max_length[50]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                redirect("client/editClient?id=$id");
            } else {
                $data['settings'] = $this->settings_model->getSettings();
                $this->load->view('home/dashboard', $data); // just the header file
                $this->load->view('add_new');
                $this->load->view('home/footer'); // just the header file
            }
        } else {
            $file_name = $_FILES['img_url']['name'];
            $file_name_pieces = explode('_', $file_name);
            $new_file_name = '';
            $count = 1;
            foreach ($file_name_pieces as $piece) {
                if ($count !== 1) {
                    $piece = ucfirst($piece);
                }

                $new_file_name .= $piece;
                $count++;
            }
            $config = array(
                'file_name' => $new_file_name,
                'upload_path' => "./uploads/",
                'allowed_types' => "gif|jpg|png|jpeg|pdf",
                'overwrite' => False,
                'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                'max_height' => "1768",
                'max_width' => "2024"
            );

            $this->load->library('Upload', $config);
            $this->upload->initialize($config);

            if ($this->upload->do_upload('img_url')) {
                $path = $this->upload->data();
                $img_url = "uploads/" . $path['file_name'];
                $data = array();
                $data = array(
                    'img_url' => $img_url,
                    'name' => $name,
                    'email' => $email,
                    'address' => $address,
                    'phone' => $phone
                );
            } else {
                $data = array();
                $data = array(
                    'name' => $name,
                    'email' => $email,
                    'address' => $address,
                    'phone' => $phone
                );
            }

            $username = $this->input->post('name');

            if (empty($id)) {     // Adding New Client
                if ($this->ion_auth->email_check($email)) {
                    $this->session->set_flashdata('feedback', 'This Email Address Is Already Registered');
                    redirect('client/addNewView');
                } else {
                    $dfg = 3;
                    $this->ion_auth->register($username, $password, $email, $dfg);
                    $user_id = $this->db->insert_id();
                    $ion_user_id = $this->db->get_where('users_groups', array('id' => $user_id))->row()->user_id;
                    $this->client_model->insertClient($data);
                    $client_user_id = $this->db->insert_id();
                    $id_info = array('ion_user_id' => $ion_user_id);
                    $this->client_model->updateClient($client_user_id, $id_info);
                    $this->session->set_flashdata('feedback', 'Added');
                }
                $send_email = $this->db->get_where('autoEmailTemplate', array('id =' => 1))->row();
                $send_sms = $this->db->get_where('autoSmsTemplate', array('id =' => 1))->row();
                $setings11 = $this->settings_model->getSettings();
                if ($send_sms->status == 'Active') {
                    $send_user = $this->db->get_where('client', array('email =' => $email))->row();
                    $data1 = array(
                        'name' => $send_user->name,
                        'companyname' => $setings11->system_vendor
                    );
                    $message = $this->parser->parse_string($send_sms->message, $data1);
                    $data3[] = array($send_user->phone => $message);
                    $this->sms->sendSms($send_user->phone, $message, $data3);
                }
                if ($send_email->status == 'Active') {
                    $send_user = $this->db->get_where('client', array('email =' => $email))->row();
                    $data2 = array(
                        'name' => $send_user->name,
                        'companyname' => $setings11->system_vendor
                    );
                    $message = $this->parser->parse_string($send_email->message, $data2);
                    $emailSettings = $this->db->get_where('email_settings', array('id =' => 1))->row();
                    // $this->load->library('Email');

                    $this->email->from($emailSettings->admin_email);
                    $this->email->to($email);
                    $this->email->subject('Registration Successful');
                    $this->email->message($message);
                    $this->email->send();
                }
            } else { // Updating Client
                $ion_user_id = $this->db->get_where('client', array('id' => $id))->row()->ion_user_id;
                if (empty($password)) {
                    $password = $this->db->get_where('users', array('id' => $ion_user_id))->row()->password;
                } else {
                    $password = $this->ion_auth_model->hash_password($password);
                }
                $this->client_model->updateIonUser($username, $email, $password, $ion_user_id);
                $this->client_model->updateClient($id, $data);
                $this->session->set_flashdata('feedback', 'Updated');
            }
            // Loading View
            redirect('client');
        }
    }

    function getClient() {
        $data['clients'] = $this->client_model->getClient();
        $this->load->view('client', $data);
    }

    function searchClientByJason() {
        $search = $this->input->get('id');
        $data['clients'] = $this->client_model->searchClient($search);
        echo json_encode($data);
    }

    function editClient() {
        $data = array();
        $id = $this->input->get('id');
        $data['client'] = $this->client_model->getClientById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_new', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function editClientByJason() {
        $id = $this->input->get('id');
        $data['client'] = $this->client_model->getClientById($id);
        echo json_encode($data);
    }

    function delete() {
        $data = array();
        $id = $this->input->get('id');
        $user_data = $this->db->get_where('client', array('id' => $id))->row();
        $path = $user_data->img_url;

        if (!empty($path)) {
            unlink($path);
        }
        $ion_user_id = $user_data->ion_user_id;
        $this->db->where('id', $ion_user_id);
        $this->db->delete('users');
        $this->client_model->delete($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        redirect('client');
    }

    public function getClientList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['client'] = $this->client_model->getClientBySearch($search); //done
            } else {
                $data['client'] = $this->client_model->getClient(); //done
            }
        } else {
            if (!empty($search)) {
                $data['client'] = $this->client_model->getClientByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['client'] = $this->client_model->getClientByLimit($limit, $start); //done
            }
        }
        foreach ($data['client'] as $clients) {

            if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                $options1 = ' <a type="button" class="btn btn-xs editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $clients->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
                $option3 = '<a class="btn btn-xs detailsbutton" title="' . lang('view_payment') . '" href="finance/paymentDetailsByClient?id=' . $clients->id . '"><i class="fa fa-money-bill-alt"></i> ' . lang('view_payment') . '</a>';
            }


            if ($this->ion_auth->in_group(array('admin'))) {
                $options5 = '<a class="btn btn-xs delete_button" title="' . lang('delete') . '" href="client/delete?id=' . $clients->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i> ' . lang('delete') . '</a>';
            }else{
                $options5 = '';
            }
            
            $imgoption = '<img  src="' . $clients->img_url . '"width="60px;">';

            $info[] = array(
                $imgoption,
                $clients->name,
                $clients->email,
                $clients->address,
                $clients->phone,
                $options1 . ' ' . $options5 . ' ' . $option3,
                    //  $options2
            );
        }

        if (!empty($data['client'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('client')->num_rows(),
                "recordsFiltered" => $this->db->get('client')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getPurchaseOfClient() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['client'] = $this->client_model->getClientBySearch($search); //done
            } else {
                $data['client'] = $this->client_model->getClient(); //done
            }
        } else {
            if (!empty($search)) {
                $data['client'] = $this->client_model->getClientByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['client'] = $this->client_model->getClientByLimit($limit, $start); //done
            }
        }
        foreach ($data['client'] as $clients) {

            if ($this->ion_auth->in_group(array('admin'))) {
                $options1 = ' <a type="button" class="btn btn-xs editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $clients->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
                $option3 = '<a class="btn btn-xs view_payment_button btn-warning" title="' . lang('view_payment') . '" href="client/purchaseDetailsByClient?id=' . $clients->id . '"><i class="fa fa-money-bill-alt"></i> ' . lang('view_payment') . '</a>';
            }


            if ($this->ion_auth->in_group(array('admin'))) {
                $options5 = '<a class="btn btn-xs delete_button" title="' . lang('delete') . '" href="client/delete?id=' . $clients->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i> ' . lang('delete') . '</a>';
            }
            $imgoption = '<img  src="' . $clients->img_url . '"width="60px;">';

            $info[] = array(
                $imgoption,
                $clients->name,
                $clients->email,
                $clients->address,
                $clients->phone,
                $options1 . ' ' . $options5 . ' ' . $option3,
            );
        }

        if (!empty($data['client'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('client')->num_rows(),
                "recordsFiltered" => $this->db->get('client')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

}

/* End of file client.php */
/* Location: ./application/modules/client/controllers/client.php */
