<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Transaction_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertTransaction($data) {
        $this->db->insert('transaction', $data);
    }

    function getTransaction() {
        $query = $this->db->get('transaction');
        return $query->result();
    }

    function getTransactionById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('transaction');
        return $query->row();
    }
  function getTransactionByBank($bank) {
        $this->db->where('bank', $bank);
        $query = $this->db->get('transaction');
        return $query->result();
    }
    function updateTransaction($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('transaction', $data);
    }

    function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete('transaction');
    }

    function gettransactionBySearch($search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('id', $search);
        $this->db->or_like('bankname', $search);
        $this->db->or_like('tran_type', $search);
        $this->db->or_like('adddate', $search);
        $query = $this->db->get('transaction');
        return $query->result();
    }

    function gettransactionByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('transaction');
        return $query->result();
    }

    function gettransactionByLimitBySearch($limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');

        $this->db->or_like('bankname', $search);
        $this->db->or_like('tran_type', $search);
        $this->db->or_like('adddate', $search);
        $this->db->limit($limit, $start);
        $query = $this->db->get('transaction');
        return $query->result();
    }

}
