<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Transaction extends MX_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('transaction_model');
        $this->load->model('bank/bank_model');
        if (!$this->ion_auth->in_group('admin')) {
            redirect('home/permission');
        }
    }

    public function index() {


        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('transaction', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addNewView() {
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_new_transaction');
        $this->load->view('home/footer'); // just the header file
    }

    public function editTransactionByJason() {
        $id = $this->input->get('id');
        $data['transaction'] = $this->transaction_model->getTransactionById($id);
        echo json_encode($data);
    }

    public function addNew() {

        $title = $this->input->post('title');
        $id = $this->input->post('id');
        $notes = $this->input->post('notes');
        $bank = $this->input->post('bank');
        $tran_type = $this->input->post('transactiontype');
        $amount = $this->input->post('amount');
        $date = $this->input->post('date');
        if (!empty($date)) {
            $dateupdate = $date;
            $datestamp = strtotime($dateupdate);
        } else {
            $dateupdate = date('d-m-Y', time());
            $datestamp = time();
        }
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        $this->form_validation->set_rules('title', 'title', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('amount', 'Amount', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('bank', 'Bank', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        if ($this->form_validation->run() == FALSE) {

            $data['settings'] = $this->settings_model->getSettings();
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('add_new_transaction', $data);
            $this->load->view('home/footer'); // just the header file
        } else {
            $bankname = $this->bank_model->getBankById($bank);
            $data = array();
            $data = array(
                'title' => $title,
                'notes' => $notes,
                'tran_type' => $tran_type,
                'amount' => strval($amount),
                'bank' => $bank,
                'bankname' => $bankname->name,
                'adddate' => $dateupdate,
                'adddatestamp' => $datestamp
            );
            if (!empty($id)) {
                $this->transaction_model->updateTransaction($id, $data);
                $this->session->set_flashdata('feedback', 'Updated');
            } else {
                $this->transaction_model->insertTransaction($data);
                $this->session->set_flashdata('feedback', 'Added');
            }
            redirect('bank/transaction');
        }
    }

    function delete() {
        $id = $this->input->get('id');
        $this->transaction_model->delete($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        redirect('bank/transaction');
    }

    public function getTransactionList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['transaction'] = $this->transaction_model->gettransactionBySearch($search); //done
            } else {
                $data['transaction'] = $this->transaction_model->getTransaction(); //done
            }
        } else {
            if (!empty($search)) {
                $data['transaction'] = $this->transaction_model->gettransactionByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['transaction'] = $this->transaction_model->gettransactionByLimit($limit, $start); //done
            }
        }
        $options1 = '';
        $options5 = '';
        foreach ($data['transaction'] as $transactions) {

            if ($this->ion_auth->in_group(array('admin'))) {
                $options1 = ' <a type="button" class="btn btn-xs editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $transactions->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
            }


            if ($this->ion_auth->in_group(array('admin'))) {
                $options5 = '<a class="btn btn-xs delete_button" title="' . lang('delete') . '" href="bank/transaction/delete?id=' . $transactions->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i> ' . lang('delete') . '</a>';
            }
            if ($transactions->tran_type == 'debit') {
                $type = lang('debit');
            } else {
                $type = lang('credit');
            }

            $info[] = array(
                $transactions->adddate,
                $transactions->title,
                $transactions->bankname,
                $type,
                $transactions->amount,
                $transactions->notes,
                $options1 . ' ' . $options5,
            );
        }

        if (!empty($data['transaction'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('transaction')->num_rows(),
                "recordsFiltered" => $this->db->get('transaction')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function getTransactionByBankList() {
        $id = $this->input->post('id');
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['transaction'] = $this->transaction_model->gettransactionBySearch($search); //done
            } else {
                $data['transaction'] = $this->transaction_model->getTransaction(); //done
            }
        } else {
            if (!empty($search)) {
                $data['transaction'] = $this->transaction_model->gettransactionByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['transaction'] = $this->transaction_model->gettransactionByLimit($limit, $start); //done
            }
        }
        $options1 = '';
        $options5 = '';
        $i = 0;
        foreach ($data['transaction'] as $transactions) {
            if ($id == $transactions->bank) { 
                $i = $i + 1;
                if ($this->ion_auth->in_group(array('admin'))) {
                    $options1 = ' <a type="button" class="btn btn-xs editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $transactions->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
                }


                if ($this->ion_auth->in_group(array('admin'))) {
                    $options5 = '<a class="btn btn-xs delete_button" title="' . lang('delete') . '" href="bank/transaction/delete?id=' . $transactions->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i> ' . lang('delete') . '</a>';
                } 
                if ($transactions->tran_type == 'debit') {
                    $type = lang('debit');
                } else {
                    $type = lang('credit');
                }

                $info[] = array(
                    $transactions->adddate, 
                    $transactions->title,
                    $transactions->bankname,
                    $type,
                    $transactions->amount,
                    $transactions->notes,
                    $options1 . ' ' . $options5,
                );
            }
        }

        if (!empty($data['transaction'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $i,
                "recordsFiltered" => $i,
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

}

/* End of file client.php */
/* Location: ./application/modules/client/controllers/client.php */
