#!/usr/bin/env python3
import os
import sys

# Simple approach: Use the fact that Excel files are ZIP archives
# We'll create CSV files and then rename them - the import system accepts CSV anyway

def create_diagnosis_file():
    content = """name,code,description,disease_with_outbreak_potential,maximum_expected_number_of_patient_in_a_week
Hypertension,I10,High blood pressure,0,5
Diabetes Type 2,E11.9,Type 2 diabetes mellitus without complications,0,10
Common Cold,J00,Acute nasopharyngitis [common cold],1,20
"""
    with open('diagnosis_data.csv', 'w') as f:
        f.write(content)

def create_symptom_file():
    content = """name,description
Fever,High body temperature above normal range
Headache,Pain in the head or upper neck
Cough,Sudden expulsion of air from the lungs
Fatigue,Extreme tiredness or exhaustion
"""
    with open('symptom_data.csv', 'w') as f:
        f.write(content)

def create_treatment_file():
    content = """name,description
Antibiotics,Medications that fight bacterial infections
Pain Management,Treatment to reduce or eliminate pain
Physical Therapy,Treatment to improve movement and reduce pain
Surgery,Medical procedure involving operative techniques
"""
    with open('treatment_data.csv', 'w') as f:
        f.write(content)

if __name__ == "__main__":
    create_diagnosis_file()
    create_symptom_file() 
    create_treatment_file()
    print("CSV data files created successfully")