#!/usr/bin/env python3
import openpyxl
from openpyxl import Workbook
from openpyxl.styles import Font, PatternFill

def create_advice_excel_template():
    """Create advice Excel template with status field"""
    
    # Create a new workbook and select active sheet
    wb = Workbook()
    ws = wb.active
    ws.title = "Advice Template"
    
    # Define headers - including status field that might be required
    headers = ['name', 'description', 'status']
    
    # Style for headers
    header_font = Font(bold=True, color="FFFFFF")
    header_fill = PatternFill(start_color="366092", end_color="366092", fill_type="solid")
    
    # Add headers with styling
    for col, header in enumerate(headers, 1):
        cell = ws.cell(row=1, column=col, value=header)
        cell.font = header_font
        cell.fill = header_fill
    
    # Sample advice data with status field
    sample_data = [
        ["Take medication as prescribed", "Follow the prescribed medication schedule and dosage exactly as directed by your doctor", "active"],
        ["Rest and stay hydrated", "Get adequate rest and maintain proper hydration to help your body recover", "active"],
        ["Follow-up appointment", "Schedule and attend follow-up appointments as recommended by your healthcare provider", "active"],
        ["Dietary modifications", "Make recommended changes to your diet as advised by your doctor or nutritionist", "active"],
        ["Monitor symptoms", "Keep track of your symptoms and report any changes or concerns to your doctor immediately", "active"]
    ]
    
    # Add sample data
    for row_idx, row_data in enumerate(sample_data, 2):
        for col_idx, value in enumerate(row_data, 1):
            ws.cell(row=row_idx, column=col_idx, value=value)
    
    # Adjust column widths
    ws.column_dimensions['A'].width = 35  # name column
    ws.column_dimensions['B'].width = 70  # description column
    ws.column_dimensions['C'].width = 15  # status column
    
    # Save the file
    filename = 'advice_xl_format.xlsx'
    wb.save(filename)
    
    print(f"Advice Excel template created: {filename}")
    print("Headers: name, description, status")
    print(f"Sample data rows: {len(sample_data)}")

if __name__ == "__main__":
    create_advice_excel_template()