#!/usr/bin/env python3
import openpyxl
from openpyxl import Workbook
from openpyxl.styles import Font, PatternFill

def create_advice_excel_template():
    """Create advice Excel template using openpyxl"""
    
    # Create a new workbook and select active sheet
    wb = Workbook()
    ws = wb.active
    ws.title = "Advice Template"
    
    # Define headers
    headers = ['name', 'description']
    
    # Style for headers
    header_font = Font(bold=True, color="FFFFFF")
    header_fill = PatternFill(start_color="366092", end_color="366092", fill_type="solid")
    
    # Add headers with styling
    for col, header in enumerate(headers, 1):
        cell = ws.cell(row=1, column=col, value=header)
        cell.font = header_font
        cell.fill = header_fill
    
    # Sample data
    sample_data = [
        ["Take medication as prescribed", "Follow the prescribed medication schedule and dosage"],
        ["Rest and hydration", "Get adequate rest and maintain proper hydration"],
        ["Follow-up appointment", "Schedule and attend follow-up appointments as recommended"],
        ["Lifestyle modifications", "Make recommended changes to diet and exercise habits"],
        ["Monitor symptoms", "Keep track of symptoms and report any changes"]
    ]
    
    # Add sample data
    for row_idx, row_data in enumerate(sample_data, 2):
        for col_idx, value in enumerate(row_data, 1):
            ws.cell(row=row_idx, column=col_idx, value=value)
    
    # Adjust column widths
    ws.column_dimensions['A'].width = 30  # name column
    ws.column_dimensions['B'].width = 50  # description column
    
    # Save the file
    filename = 'advice_xl_format.xlsx'
    wb.save(filename)
    
    print(f"Advice Excel template created: {filename}")
    print("Headers: name, description")
    print(f"Sample data rows: {len(sample_data)}")

if __name__ == "__main__":
    create_advice_excel_template()