#!/usr/bin/env python3
import csv
import os

def create_advice_excel_template():
    """Create advice Excel template following the same pattern as other templates"""
    
    # Create CSV content with header and sample data
    content = """name,description
Take medication as prescribed,Follow the prescribed medication schedule and dosage
Rest and hydration,Get adequate rest and maintain proper hydration
Follow-up appointment,Schedule and attend follow-up appointments as recommended
Lifestyle modifications,Make recommended changes to diet and exercise habits
Monitor symptoms,Keep track of symptoms and report any changes
"""
    
    # Write to CSV file (Excel import accepts CSV)
    csv_filename = 'advice_xl_format.csv'
    with open(csv_filename, 'w', newline='', encoding='utf-8') as f:
        f.write(content)
    
    print(f"Advice template created: {csv_filename}")
    print("Content preview:")
    print(content)

if __name__ == "__main__":
    create_advice_excel_template()