#!/usr/bin/env python3
import openpyxl
from openpyxl import Workbook
from openpyxl.styles import Font, PatternFill

def create_advice_excel_template():
    """Create advice Excel template with correct field order: description, name"""
    
    # Create a new workbook and select active sheet
    wb = Workbook()
    ws = wb.active
    ws.title = "Advice Template"
    
    # Define headers in the correct database order: description first, then name
    headers = ['description', 'name']
    
    # Style for headers
    header_font = Font(bold=True, color="FFFFFF")
    header_fill = PatternFill(start_color="366092", end_color="366092", fill_type="solid")
    
    # Add headers with styling
    for col, header in enumerate(headers, 1):
        cell = ws.cell(row=1, column=col, value=header)
        cell.font = header_font
        cell.fill = header_fill
    
    # Sample advice data - description first, then name
    sample_data = [
        ["Follow the prescribed medication schedule and dosage exactly as directed by your doctor", "Take medication as prescribed"],
        ["Get adequate rest and maintain proper hydration to help your body recover", "Rest and stay hydrated"],
        ["Schedule and attend follow-up appointments as recommended by your healthcare provider", "Follow-up appointment"],
        ["Make recommended changes to your diet as advised by your doctor or nutritionist", "Dietary modifications"],
        ["Keep track of your symptoms and report any changes or concerns to your doctor immediately", "Monitor symptoms"]
    ]
    
    # Add sample data
    for row_idx, row_data in enumerate(sample_data, 2):
        for col_idx, value in enumerate(row_data, 1):
            ws.cell(row=row_idx, column=col_idx, value=value)
    
    # Adjust column widths
    ws.column_dimensions['A'].width = 70  # description column (wider)
    ws.column_dimensions['B'].width = 35  # name column (narrower)
    
    # Save the file
    filename = 'advice_xl_format.xlsx'
    wb.save(filename)
    
    print(f"Advice Excel template created: {filename}")
    print("Headers: description, name (in database order)")
    print(f"Sample data rows: {len(sample_data)}")

if __name__ == "__main__":
    create_advice_excel_template()