<div class="content-wrapper bg-gradient-light">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-eye text-success mr-3"></i>
                        <?php echo lang('view'); ?> <?php echo lang('payroll'); ?>
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0">
                            <li class="breadcrumb-item"><a href="home"><?php echo lang('home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="staffpayroll"><?php echo lang('staff_payroll'); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo lang('view'); ?> <?php echo lang('payroll'); ?></li>
                        </ol>
                    </nav>
                </div>
                <div class="col-sm-6 text-right">
                    <a href="staffpayroll" class="btn btn-secondary btn-sm px-4 py-3">
                        <i class="fa fa-arrow-left"></i> <?php echo lang('back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-5">
        <div class="container-fluid">
            <!-- Payroll Details Header -->
            <div class="row mb-4">
                <div class="col-md-12">
                    <div class="card shadow-lg border-0">
                        <div class="card-header bg-success text-white">
                            <h3 class="card-title font-weight-bold">
                                <i class="fa fa-calendar"></i> <?php echo lang('payroll'); ?> - <?php echo $month . ' ' . $year; ?>
                            </h3>
                        </div>
                        <div class="card-body bg-light">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-info">
                                            <i class="fa fa-users"></i>
                                        </span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Total Staff</span>
                                            <span class="info-box-number"><?php echo count($payrolls); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-success">
                                            <i class="fa fa-check"></i>
                                        </span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Paid</span>
                                            <span class="info-box-number">
                                                <?php echo count(array_filter($payrolls, function($p) { return $p->status == 'Paid'; })); ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-warning">
                                            <i class="fa fa-clock"></i>
                                        </span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Generated</span>
                                            <span class="info-box-number">
                                                <?php echo count(array_filter($payrolls, function($p) { return $p->status == 'Generated'; })); ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-primary">
                                            <i class="fa fa-dollar-sign"></i>
                                        </span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Total Amount</span>
                                            <span class="info-box-number">
                                                <?php echo $this->currency; ?><?php echo number_format(array_sum(array_column($payrolls, 'net_salary')), 2); ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Payroll Table -->
            <div class="row">
                <div class="col-md-12">
                    <div class="card shadow-lg border-0">
                        <div class="card-header">
                            <h3 class="card-title text-black font-weight-800">
                                <i class="fa fa-list"></i> <?php echo lang('payroll'); ?> <?php echo lang('details'); ?>
                            </h3>
                        </div>

                        <div class="card-body bg-light p-4">
                            <?php if (!empty($payrolls)) { ?>
                                <div class="table-responsive">
                                    <table class="table table-hover datatables" id="payroll-table" width="100%">
                                        <thead>
                                            <tr class="bg-light">
                                                <th class="font-weight-bold text-uppercase"><?php echo lang('employee_id'); ?></th>
                                                <th class="font-weight-bold text-uppercase"><?php echo lang('staff'); ?> <?php echo lang('name'); ?></th>
                                                <th class="font-weight-bold text-uppercase"><?php echo lang('department'); ?></th>
                                                <th class="font-weight-bold text-uppercase"><?php echo lang('designation'); ?></th>
                                                <th class="font-weight-bold text-uppercase"><?php echo lang('basic_salary'); ?></th>
                                                <th class="font-weight-bold text-uppercase"><?php echo lang('allowances'); ?></th>
                                                <th class="font-weight-bold text-uppercase"><?php echo lang('deductions'); ?></th>
                                                <th class="font-weight-bold text-uppercase"><?php echo lang('net_salary'); ?></th>
                                                <th class="font-weight-bold text-uppercase"><?php echo lang('status'); ?></th>
                                                <th class="font-weight-bold text-uppercase no-print"><?php echo lang('actions'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($payrolls as $payroll) { ?>
                                                <tr>
                                                    <td>
                                                        <span class="badge badge-secondary"><?php echo $payroll->employee_id; ?></span>
                                                    </td>
                                                    <td class="font-weight-bold">
                                                        <i class="fa fa-user text-primary"></i> <?php echo $payroll->staff_name; ?>
                                                    </td>
                                                    <td>
                                                        <i class="fa fa-building text-info"></i> <?php echo $payroll->department_name; ?>
                                                    </td>
                                                    <td>
                                                        <i class="fa fa-briefcase text-warning"></i> <?php echo $payroll->designation_name; ?>
                                                    </td>
                                                    <td class="text-right">
                                                        <span class="text-primary font-weight-bold"><?php echo $this->currency; ?><?php echo number_format($payroll->basic_salary, 2); ?></span>
                                                    </td>
                                                    <td class="text-right">
                                                        <span class="text-success">+<?php echo $this->currency; ?><?php echo number_format($payroll->allowances, 2); ?></span>
                                                    </td>
                                                    <td class="text-right">
                                                        <span class="text-danger">-<?php echo $this->currency; ?><?php echo number_format($payroll->deductions, 2); ?></span>
                                                    </td>
                                                    <td class="text-right">
                                                        <span class="badge badge-success badge-lg"><?php echo $this->currency; ?><?php echo number_format($payroll->net_salary, 2); ?></span>
                                                    </td>
                                                    <td>
                                                        <?php if ($payroll->status == 'Paid') { ?>
                                                            <span class="badge badge-success">
                                                                <i class="fa fa-check"></i> <?php echo lang('paid'); ?>
                                                            </span>
                                                        <?php } elseif ($payroll->status == 'Generated') { ?>
                                                            <span class="badge badge-warning">
                                                                <i class="fa fa-clock"></i> <?php echo lang('generated'); ?>
                                                            </span>
                                                        <?php } else { ?>
                                                            <span class="badge badge-secondary">
                                                                <i class="fa fa-question"></i> <?php echo $payroll->status; ?>
                                                            </span>
                                                        <?php } ?>
                                                    </td>
                                                    <td class="no-print">
                                                        <div class="btn-group" role="group">
                                                            <a href="staffpayroll/editPayroll?id=<?php echo $payroll->id; ?>" 
                                                               class="btn btn-primary btn-sm" 
                                                               title="<?php echo lang('edit'); ?>">
                                                                <i class="fa fa-edit"></i>
                                                            </a>
                                                            
                                                            <?php if ($payroll->status != 'Paid') { ?>
                                                                <a href="staffpayroll/markAsPaid?id=<?php echo $payroll->id; ?>" 
                                                                   class="btn btn-success btn-sm" 
                                                                   title="<?php echo lang('mark_as_paid'); ?>"
                                                                   onclick="return confirm('<?php echo lang('are_you_sure'); ?>?')">
                                                                    <i class="fa fa-check"></i>
                                                                </a>
                                                            <?php } ?>
                                                            
                                                            <a href="staffpayroll/deletePayroll?id=<?php echo $payroll->id; ?>" 
                                                               class="btn btn-danger btn-sm" 
                                                               title="<?php echo lang('delete'); ?>"
                                                               onclick="return confirm('<?php echo lang('are_you_sure_you_want_to_delete_this_item'); ?>?')">
                                                                <i class="fa fa-trash"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php } else { ?>
                                <div class="text-center py-5">
                                    <div class="empty-state">
                                        <i class="fa fa-exclamation-triangle fa-5x text-muted mb-4"></i>
                                        <h3 class="text-muted">No Payroll Found</h3>
                                        <p class="text-muted">No payroll records found for <strong><?php echo $month . ' ' . $year; ?></strong></p>
                                        <a href="staffpayroll" class="btn btn-primary btn-lg">
                                            <i class="fa fa-plus"></i> Generate Payroll
                                        </a>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="common/js/codearistos.min.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize DataTables with export options
        $('#payroll-table').DataTable({
            "order": [[ 1, "asc" ]],
            "pageLength": 25,
            "responsive": true,
            "dom": 'Bfrtip',
            "buttons": [
                {
                    extend: 'print',
                    className: 'btn btn-info btn-sm',
                    text: '<i class="fa fa-print"></i> Print',
                    title: 'Staff Payroll - <?php echo $month . " " . $year; ?>',
                    exportOptions: {
                        columns: ':not(.no-print)'
                    }
                },
                {
                    extend: 'excel',
                    className: 'btn btn-success btn-sm',
                    text: '<i class="fa fa-file-excel"></i> Excel',
                    title: 'Staff Payroll - <?php echo $month . " " . $year; ?>',
                    exportOptions: {
                        columns: ':not(.no-print)'
                    }
                },
                {
                    extend: 'pdf',
                    className: 'btn btn-danger btn-sm',
                    text: '<i class="fa fa-file-pdf"></i> PDF',
                    title: 'Staff Payroll - <?php echo $month . " " . $year; ?>',
                    exportOptions: {
                        columns: ':not(.no-print)'
                    }
                }
            ]
        });
    });
</script>

<style>
.info-box {
    display: block;
    min-height: 90px;
    background: #fff;
    width: 100%;
    box-shadow: 0 1px 1px rgba(0,0,0,0.1);
    border-radius: 2px;
    margin-bottom: 15px;
}

.info-box-icon {
    border-top-left-radius: 2px;
    border-top-right-radius: 0;
    border-bottom-right-radius: 0;
    border-bottom-left-radius: 2px;
    display: block;
    float: left;
    height: 90px;
    width: 90px;
    text-align: center;
    font-size: 45px;
    line-height: 90px;
    background: rgba(0,0,0,0.2);
}

.info-box-content {
    padding: 5px 10px;
    margin-left: 90px;
}

.info-box-text {
    text-transform: uppercase;
    font-weight: bold;
    font-size: 13px;
}

.info-box-number {
    display: block;
    font-weight: bold;
    font-size: 18px;
}

.badge-lg {
    font-size: 14px;
    padding: 8px 12px;
}

.empty-state {
    padding: 40px;
}

.btn-group .btn {
    margin-right: 2px;
}

.btn-group .btn:last-child {
    margin-right: 0;
}
</style>