<div class="content-wrapper bg-gradient-light">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-money-check-alt text-primary mr-3"></i>
                        <?php echo lang('staff_payroll_management'); ?>
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0">
                            <li class="breadcrumb-item"><a href="home"><?php echo lang('home'); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo lang('staff_payroll'); ?></li>
                        </ol>
                    </nav>
                </div>
                <div class="col-sm-6 text-right">
                    <a href="staffpayroll/salary" class="btn btn-info btn-sm px-4 py-3">
                        <i class="fa fa-cog"></i> <?php echo lang('manage'); ?> <?php echo lang('salaries'); ?>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-5">
        <div class="container-fluid">
            <!-- Payroll Generation Panel -->
            <div class="row mb-4">
                <div class="col-md-12">
                    <div class="card shadow-lg border-0">
                        <div class="card-header bg-primary text-white">
                            <h3 class="card-title font-weight-bold">Generate Monthly Payroll</h3>
                        </div>
                        <div class="card-body">
                            <form action="staffpayroll/generateStaffPayroll" method="GET" class="row align-items-end">
                                <div class="col-md-3">
                                    <label for="month">Select Month:</label>
                                    <select class="form-control form-control-lg" name="month" id="month" required>
                                        <option value="">Select Month</option>
                                        <?php foreach ($months as $key => $month) { ?>
                                            <option value="<?php echo $month; ?>" <?php echo (date('F') == $month) ? 'selected' : ''; ?>>
                                                <?php echo $month; ?>
                                            </option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label for="year">Select Year:</label>
                                    <select class="form-control form-control-lg" name="year" id="year" required>
                                        <option value="">Select Year</option>
                                        <?php foreach ($years as $year) { ?>
                                            <option value="<?php echo $year; ?>" <?php echo (date('Y') == $year) ? 'selected' : ''; ?>>
                                                <?php echo $year; ?>
                                            </option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <button type="submit" class="btn btn-success btn-lg">
                                        <i class="fa fa-cogs"></i> Generate Payroll
                                    </button>
                                </div>
                                <div class="col-md-3">
                                    <button type="button" class="btn btn-info btn-lg" onclick="viewPayroll()">
                                        <i class="fa fa-eye"></i> View Payroll
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Staff Overview -->
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card shadow-lg border-0">
                        <div class="card-header">
                            <h3 class="card-title text-black font-weight-800">Active Staff Overview (<?php echo $total; ?> Total)</h3>
                        </div>

                        <div class="card-body bg-light p-4">
                            <table class="table table-hover datatables" id="editable-sample" width="100%">
                                <thead>
                                    <tr class="bg-light">
                                        <th class="font-weight-bold text-uppercase">Staff</th>
                                        <th class="font-weight-bold text-uppercase">Department</th>
                                        <th class="font-weight-bold text-uppercase">Designation</th>
                                        <th class="font-weight-bold text-uppercase">Salary</th>
                                        <th class="font-weight-bold text-uppercase no-print">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($staff) && !empty($staff)) { ?>
                                        <?php for ($i = 0; $i < $total; $i++) { ?>
                                            <tr>
                                                <td><?php echo $staff[$i]['staff']; ?></td>
                                                <td><?php echo $staff[$i]['department']; ?></td>
                                                <td><?php echo $staff[$i]['designation']; ?></td>
                                                <td><?php echo $this->currency; ?><?php echo $staff[$i]['salary']; ?></td>
                                                <td><?php echo $staff[$i]['options']; ?></td>
                                            </tr>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr>
                                            <td colspan="5" class="text-center">No active staff found</td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Set Salary Modal -->
<div class="modal fade" id="salaryModal" role="dialog" aria-labelledby="salaryModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title font-weight-bold">Set Staff Salary</h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body">
                <form role="form" action="staffpayroll/addEditStaffSalary" method="post">
                    <input type="hidden" name="staff_id" id="salary_staff_id">
                    
                    <div class="form-group">
                        <label for="staff_name">Staff Member:</label>
                        <input type="text" class="form-control" id="staff_name" readonly>
                    </div>

                    <div class="form-group">
                        <label for="salary">Monthly Salary:</label>
                        <input type="number" step="0.01" class="form-control form-control-lg" name="salary" id="salary" 
                               placeholder="Enter Monthly Salary" required>
                    </div>

                    <div class="form-group text-center">
                        <button type="submit" class="btn btn-primary">Save Salary</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="common/js/codearistos.min.js"></script>

<script type="text/javascript">
    $(document).ready(function() {
        // Initialize DataTables
        $('#editable-sample').DataTable({
            "order": [[ 0, "asc" ]],
            "pageLength": 25
        });
    });

    function setSalary(staffId, staffName, currentSalary) {
        $('#salary_staff_id').val(staffId);
        $('#staff_name').val(staffName);
        $('#salary').val(currentSalary);
        $('#salaryModal').modal('show');
    }

    function viewPayroll() {
        var month = $('#month').val();
        var year = $('#year').val();
        
        if (month && year) {
            window.location.href = 'staffpayroll/viewPayroll?month=' + month + '&year=' + year;
        } else {
            alert('Please select month and year first');
        }
    }
</script>