<div class="content-wrapper bg-gradient-light">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-money-check-alt text-primary mr-3"></i>
                        Staff Salary Management
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0">
                            <li class="breadcrumb-item"><a href="home">Home</a></li>
                            <li class="breadcrumb-item"><a href="staffpayroll">Staff Payroll</a></li>
                            <li class="breadcrumb-item active">Salary Management</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-sm-6 text-right">
                    <a href="staffpayroll" class="btn btn-secondary btn-sm px-4 py-3">
                        <i class="fa fa-arrow-left"></i> Back to Payroll
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-5">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card shadow-lg border-0">
                        <div class="card-header">
                            <h3 class="card-title text-black font-weight-800">All Staff Salary Information (<?php echo $total; ?> Total)</h3>
                        </div>

                        <div class="card-body bg-light p-4">
                            <table class="table table-hover datatables" id="editable-sample" width="100%">
                                <thead>
                                    <tr class="bg-light">
                                        <th class="font-weight-bold text-uppercase">Staff Member</th>
                                        <th class="font-weight-bold text-uppercase">Department</th>
                                        <th class="font-weight-bold text-uppercase">Designation</th>
                                        <th class="font-weight-bold text-uppercase">Monthly Salary</th>
                                        <th class="font-weight-bold text-uppercase no-print">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($staff) && !empty($staff)) { ?>
                                        <?php for ($i = 0; $i < $total; $i++) { ?>
                                            <tr>
                                                <td><?php echo $staff[$i]['staff']; ?></td>
                                                <td><?php echo $staff[$i]['department']; ?></td>
                                                <td><?php echo $staff[$i]['designation']; ?></td>
                                                <td class="font-weight-bold text-success"><?php echo $this->currency; ?><?php echo $staff[$i]['salary']; ?></td>
                                                <td><?php echo $staff[$i]['options']; ?></td>
                                            </tr>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr>
                                            <td colspan="5" class="text-center">No active staff found</td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Edit Salary Modal -->
<div class="modal fade" id="editSalaryModal" role="dialog" aria-labelledby="editSalaryModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title font-weight-bold">Edit Staff Salary</h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body">
                <form role="form" action="staffpayroll/addEditStaffSalary" method="post">
                    <input type="hidden" name="staff_id" id="edit_staff_id">
                    
                    <div class="form-group">
                        <label for="edit_staff_name">Staff Member:</label>
                        <input type="text" class="form-control" id="edit_staff_name" readonly>
                    </div>

                    <div class="form-group">
                        <label for="edit_salary">Monthly Salary:</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><?php echo $this->currency; ?></span>
                            </div>
                            <input type="number" step="0.01" class="form-control form-control-lg" name="salary" id="edit_salary" 
                                   placeholder="Enter Monthly Salary" required>
                        </div>
                        <small class="form-text text-muted">This will be used for payroll generation</small>
                    </div>

                    <div class="form-group text-center">
                        <button type="submit" class="btn btn-primary btn-lg px-4">
                            <i class="fa fa-save"></i> Update Salary
                        </button>
                        <button type="button" class="btn btn-secondary btn-lg px-4" data-dismiss="modal">
                            <i class="fa fa-times"></i> Cancel
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="common/js/codearistos.min.js"></script>

<script type="text/javascript">
    $(document).ready(function() {
        // Initialize DataTables
        $('#editable-sample').DataTable({
            "order": [[ 0, "asc" ]],
            "pageLength": 25,
            "columnDefs": [
                { "orderable": false, "targets": [4] } // Disable sorting on actions column
            ]
        });

        // Edit salary button click
        $('.editSalaryBtn').on('click', function() {
            var staffId = $(this).data('staff-id');
            var staffName = $(this).data('staff-name');
            var currentSalary = $(this).data('current-salary');
            
            $('#edit_staff_id').val(staffId);
            $('#edit_staff_name').val(staffName);
            $('#edit_salary').val(currentSalary);
            $('#editSalaryModal').modal('show');
        });
    });
</script>