<div class="content-wrapper bg-gradient-light">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-edit text-warning mr-3"></i>
                        <?php echo lang('edit'); ?> <?php echo lang('payroll'); ?>
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0">
                            <li class="breadcrumb-item"><a href="home"><?php echo lang('home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="staffpayroll"><?php echo lang('staff_payroll'); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo lang('edit'); ?> <?php echo lang('payroll'); ?></li>
                        </ol>
                    </nav>
                </div>
                <div class="col-sm-6 text-right">
                    <a href="staffpayroll" class="btn btn-secondary btn-sm px-4 py-3">
                        <i class="fa fa-arrow-left"></i> <?php echo lang('back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-5">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card shadow-lg border-0">
                        <div class="card-header bg-warning text-white">
                            <h3 class="card-title font-weight-bold">
                                <i class="fa fa-edit"></i> <?php echo lang('edit'); ?> <?php echo lang('payroll'); ?> <?php echo lang('details'); ?>
                            </h3>
                        </div>
                        
                        <div class="card-body bg-light p-5">
                            <?php if (isset($payroll) && !empty($payroll)) { ?>
                                <!-- Staff Information -->
                                <div class="row mb-4">
                                    <div class="col-md-12">
                                        <div class="card bg-white">
                                            <div class="card-header bg-primary text-white">
                                                <h5 class="mb-0">
                                                    <i class="fa fa-user"></i> <?php echo lang('staff'); ?> <?php echo lang('information'); ?>
                                                </h5>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <table class="table table-borderless">
                                                            <tr>
                                                                <td width="40%"><strong><?php echo lang('employee_id'); ?>:</strong></td>
                                                                <td><span class="badge badge-secondary"><?php echo $payroll->employee_id; ?></span></td>
                                                            </tr>
                                                            <tr>
                                                                <td><strong><?php echo lang('name'); ?>:</strong></td>
                                                                <td><?php echo $payroll->staff_name; ?></td>
                                                            </tr>
                                                            <tr>
                                                                <td><strong><?php echo lang('department'); ?>:</strong></td>
                                                                <td><?php echo $payroll->department_name; ?></td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <table class="table table-borderless">
                                                            <tr>
                                                                <td width="40%"><strong><?php echo lang('designation'); ?>:</strong></td>
                                                                <td><?php echo $payroll->designation_name; ?></td>
                                                            </tr>
                                                            <tr>
                                                                <td><strong><?php echo lang('month'); ?>:</strong></td>
                                                                <td><span class="badge badge-info"><?php echo $payroll->month; ?></span></td>
                                                            </tr>
                                                            <tr>
                                                                <td><strong><?php echo lang('year'); ?>:</strong></td>
                                                                <td><span class="badge badge-info"><?php echo $payroll->year; ?></span></td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Payroll Edit Form -->
                                <form action="staffpayroll/updatePayroll" method="POST" id="payrollForm">
                                    <input type="hidden" name="id" value="<?php echo $payroll->id; ?>">
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="basic_salary" class="font-weight-bold">
                                                    <i class="fa fa-dollar-sign text-primary"></i> <?php echo lang('basic_salary'); ?>
                                                </label>
                                                <div class="input-group input-group-lg">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text"><?php echo $this->currency; ?></span>
                                                    </div>
                                                    <input type="number" 
                                                           class="form-control" 
                                                           id="basic_salary" 
                                                           name="basic_salary" 
                                                           value="<?php echo $payroll->basic_salary; ?>" 
                                                           step="0.01" 
                                                           min="0" 
                                                           required
                                                           onchange="calculateNetSalary()">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="allowances" class="font-weight-bold">
                                                    <i class="fa fa-plus text-success"></i> <?php echo lang('allowances'); ?>
                                                </label>
                                                <div class="input-group input-group-lg">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text"><?php echo $this->currency; ?></span>
                                                    </div>
                                                    <input type="number" 
                                                           class="form-control" 
                                                           id="allowances" 
                                                           name="allowances" 
                                                           value="<?php echo $payroll->allowances; ?>" 
                                                           step="0.01" 
                                                           min="0"
                                                           onchange="calculateNetSalary()">
                                                </div>
                                                <small class="form-text text-muted">
                                                    Overtime, bonuses, commissions, etc.
                                                </small>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="deductions" class="font-weight-bold">
                                                    <i class="fa fa-minus text-danger"></i> <?php echo lang('deductions'); ?>
                                                </label>
                                                <div class="input-group input-group-lg">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text"><?php echo $this->currency; ?></span>
                                                    </div>
                                                    <input type="number" 
                                                           class="form-control" 
                                                           id="deductions" 
                                                           name="deductions" 
                                                           value="<?php echo $payroll->deductions; ?>" 
                                                           step="0.01" 
                                                           min="0"
                                                           onchange="calculateNetSalary()">
                                                </div>
                                                <small class="form-text text-muted">
                                                    Taxes, insurance, loans, etc.
                                                </small>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="font-weight-bold">
                                                    <i class="fa fa-calculator text-info"></i> <?php echo lang('net_salary'); ?>
                                                </label>
                                                <div class="input-group input-group-lg">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text"><?php echo $this->currency; ?></span>
                                                    </div>
                                                    <input type="text" 
                                                           class="form-control bg-light font-weight-bold" 
                                                           id="net_salary_display" 
                                                           value="<?php echo number_format($payroll->net_salary, 2); ?>" 
                                                           readonly>
                                                </div>
                                                <small class="form-text text-muted">
                                                    Calculated automatically
                                                </small>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Action Buttons -->
                                    <div class="row mt-4">
                                        <div class="col-md-12">
                                            <div class="text-center">
                                                <button type="submit" class="btn btn-success btn-lg px-5 mr-3">
                                                    <i class="fa fa-save"></i> <?php echo lang('update'); ?> <?php echo lang('payroll'); ?>
                                                </button>
                                                <a href="staffpayroll" class="btn btn-secondary btn-lg px-5">
                                                    <i class="fa fa-times"></i> <?php echo lang('cancel'); ?>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                                
                            <?php } else { ?>
                                <div class="text-center py-5">
                                    <div class="empty-state">
                                        <i class="fa fa-exclamation-triangle fa-5x text-muted mb-4"></i>
                                        <h3 class="text-muted">Payroll Record Not Found</h3>
                                        <p class="text-muted">The requested payroll record could not be found.</p>
                                        <a href="staffpayroll" class="btn btn-primary btn-lg">
                                            <i class="fa fa-arrow-left"></i> <?php echo lang('back'); ?> to <?php echo lang('staff_payroll'); ?>
                                        </a>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="common/js/codearistos.min.js"></script>
<script type="text/javascript">
    function calculateNetSalary() {
        var basicSalary = parseFloat($('#basic_salary').val()) || 0;
        var allowances = parseFloat($('#allowances').val()) || 0;
        var deductions = parseFloat($('#deductions').val()) || 0;
        
        var netSalary = basicSalary + allowances - deductions;
        
        $('#net_salary_display').val(netSalary.toFixed(2));
        
        // Update styling based on net salary
        if (netSalary > 0) {
            $('#net_salary_display').removeClass('text-danger').addClass('text-success');
        } else {
            $('#net_salary_display').removeClass('text-success').addClass('text-danger');
        }
    }

    $(document).ready(function() {
        // Calculate initial net salary
        calculateNetSalary();
        
        // Form validation
        $('#payrollForm').on('submit', function(e) {
            var basicSalary = parseFloat($('#basic_salary').val()) || 0;
            var allowances = parseFloat($('#allowances').val()) || 0;
            var deductions = parseFloat($('#deductions').val()) || 0;
            var netSalary = basicSalary + allowances - deductions;
            
            if (netSalary < 0) {
                e.preventDefault();
                alert('Net salary cannot be negative. Please adjust allowances or deductions.');
                return false;
            }
            
            if (basicSalary <= 0) {
                e.preventDefault();
                alert('Basic salary must be greater than zero.');
                return false;
            }
        });
        
        // Add animation effects
        $('.form-control').on('focus', function() {
            $(this).addClass('shadow-lg');
        }).on('blur', function() {
            $(this).removeClass('shadow-lg');
        });
    });
</script>

<style>
.empty-state {
    padding: 40px;
}

.form-control:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
}

.input-group-lg .form-control {
    font-size: 1.25rem;
    font-weight: 600;
}

.card {
    transition: all 0.3s ease;
}

.btn {
    transition: all 0.3s ease;
}

.btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}

.table td {
    padding: 12px 8px;
    border: none;
}

.badge {
    font-size: 12px;
    padding: 6px 12px;
}

.text-success {
    color: #28a745 !important;
}

.text-danger {
    color: #dc3545 !important;
}
</style>