<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Staffpayroll_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertStaffSalary($data) {
        $data1 = array('hospital_id' => $this->session->userdata('hospital_id'));
        $data2 = array_merge($data, $data1);
        $this->db->insert('staff_salary', $data2);
        return $this->db->insert_id();
    }

    function updateStaffSalary($id, $data) {
        $this->db->where('id', $id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->update('staff_salary', $data);
    }

    function getStaffSalaryByStaffId($staff_id) {
        $this->db->where('staff_id', $staff_id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        return $this->db->get('staff_salary')->row();
    }

    function createStaffPayroll($data) {
        $data1 = array('hospital_id' => $this->session->userdata('hospital_id'));
        $data2 = array_merge($data, $data1);
        $this->db->insert('staff_payroll', $data2);
        return $this->db->insert_id();
    }

    function updateStaffPayroll($id, $data) {
        $this->db->where('id', $id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->update('staff_payroll', $data);
    }

    function getStaffPayroll($month = null, $year = null) {
        $this->db->select('sp.*, s.name as staff_name, s.employee_id, d.name as department_name, des.name as designation_name');
        $this->db->from('staff_payroll sp');
        $this->db->join('staff s', 'sp.staff_id = s.id', 'left');
        $this->db->join('department d', 's.department_id = d.id', 'left');
        $this->db->join('designation des', 's.designation_id = des.id', 'left');
        $this->db->where('sp.hospital_id', $this->session->userdata('hospital_id'));
        
        if ($month) {
            $this->db->where('sp.month', $month);
        }
        if ($year) {
            $this->db->where('sp.year', $year);
        }
        
        $this->db->order_by('sp.year', 'DESC');
        $this->db->order_by('sp.month', 'DESC');
        $this->db->order_by('s.name', 'ASC');
        
        $query = $this->db->get();
        return $query->result();
    }

    function getStaffPayrollById($id) {
        $this->db->select('sp.*, s.name as staff_name, s.employee_id, d.name as department_name, des.name as designation_name');
        $this->db->from('staff_payroll sp');
        $this->db->join('staff s', 'sp.staff_id = s.id', 'left');
        $this->db->join('department d', 's.department_id = d.id', 'left');
        $this->db->join('designation des', 's.designation_id = des.id', 'left');
        $this->db->where('sp.hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('sp.id', $id);
        
        $query = $this->db->get();
        return $query->row();
    }

    function getStaffPayrollByStaffMonthYear($staff_id, $month, $year) {
        $this->db->where('staff_id', $staff_id);
        $this->db->where('month', $month);
        $this->db->where('year', $year);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $query = $this->db->get('staff_payroll');
        return $query->row();
    }

    function getAllStaffForPayroll() {
        $this->db->select('s.*, d.name as department_name, des.name as designation_name');
        $this->db->from('staff s');
        $this->db->join('department d', 's.department_id = d.id', 'left');
        $this->db->join('designation des', 's.designation_id = des.id', 'left');
        $this->db->where('s.hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('s.status', 'active');
        $this->db->order_by('s.name', 'ASC');
        
        $query = $this->db->get();
        return $query->result();
    }

    function deleteStaffPayroll($id) {
        $this->db->where('id', $id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->delete('staff_payroll');
    }

    function getStaffSalaryList() {
        $this->db->select('ss.*, s.name as staff_name, s.employee_id, d.name as department_name, des.name as designation_name');
        $this->db->from('staff_salary ss');
        $this->db->join('staff s', 'ss.staff_id = s.id', 'left');
        $this->db->join('department d', 's.department_id = d.id', 'left');
        $this->db->join('designation des', 's.designation_id = des.id', 'left');
        $this->db->where('ss.hospital_id', $this->session->userdata('hospital_id'));
        $this->db->order_by('s.name', 'ASC');
        
        $query = $this->db->get();
        return $query->result();
    }

    function getAllActiveStaffWithSalary() {
        $this->db->select('s.*, d.name as department_name, des.name as designation_name, ss.salary as assigned_salary');
        $this->db->from('staff s');
        $this->db->join('department d', 's.department_id = d.id', 'left');
        $this->db->join('designation des', 's.designation_id = des.id', 'left');
        $this->db->join('staff_salary ss', 's.id = ss.staff_id', 'left');
        $this->db->where('s.hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('s.status', 'active');
        $this->db->order_by('s.name', 'ASC');
        
        $query = $this->db->get();
        return $query->result();
    }
}