<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Staffpayroll extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('staffpayroll_model');
        $this->load->model('staff/staff_model');

        if (!$this->ion_auth->in_group('admin')) {
            redirect('home/permission');
        }
    }

    public function index() {
        $year = $this->db->get('staff_payroll')->result();
        if (!empty($year)) {
            $start = $year[0]->year;
        } else {
            $start = date('Y');
        }

        $data['years'] = [];
        $data['months'] = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];

        while ($start <= date('Y')) {
            array_push($data['years'], $start);
            $start += 1;
        }

        // Get all active staff with salary information
        $allStaff = $this->staffpayroll_model->getAllActiveStaffWithSalary();
        $data['total'] = count($allStaff);
        
        $count = 0;
        foreach ($allStaff as $staff) {
            $data['staff'][$count]['staff'] = $staff->name . ' (' . $staff->employee_id . ')';
            $data['staff'][$count]['designation'] = $staff->designation_name;
            $data['staff'][$count]['department'] = $staff->department_name;
            $data['staff'][$count]['salary'] = number_format($staff->assigned_salary ? $staff->assigned_salary : $staff->salary, 2);
            $data['staff'][$count]['options'] = '<button class="btn btn-sm btn-primary" onclick="setSalary(' . $staff->id . ', \'' . $staff->name . '\', ' . ($staff->assigned_salary ? $staff->assigned_salary : $staff->salary) . ')">Set Salary</button>';
            $count++;
        }

        $this->load->view('home/dashboard');
        $this->load->view('staffpayroll', $data);
        $this->load->view('home/footer');
    }

    public function salary() {
        $allStaff = $this->staffpayroll_model->getAllActiveStaffWithSalary();
        $data['total'] = count($allStaff);
        
        $count = 0;
        foreach ($allStaff as $staff) {
            $data['staff'][$count]['staff'] = $staff->name . ' (' . $staff->employee_id . ')';
            $data['staff'][$count]['designation'] = $staff->designation_name;
            $data['staff'][$count]['department'] = $staff->department_name;
            $data['staff'][$count]['salary'] = number_format($staff->assigned_salary ? $staff->assigned_salary : $staff->salary, 2);
            $data['staff'][$count]['options'] = '<button class="btn btn-sm btn-primary editSalaryBtn" data-staff-id="' . $staff->id . '" data-staff-name="' . $staff->name . '" data-current-salary="' . ($staff->assigned_salary ? $staff->assigned_salary : $staff->salary) . '">Edit</button>';
            $count++;
        }

        $this->load->view('home/dashboard');
        $this->load->view('salary', $data);
        $this->load->view('home/footer');
    }

    public function addEditStaffSalary() {
        $salary = $this->input->post('salary');
        $staff_id = $this->input->post('staff_id');

        $result = $this->staffpayroll_model->getStaffSalaryByStaffId($staff_id);

        if (empty($result)) {
            $data = array(
                'salary' => $salary,
                'staff_id' => $staff_id
            );
            $this->staffpayroll_model->insertStaffSalary($data);
            show_swal('Staff salary added successfully', 'success', 'Added');
        } else {
            $data = array(
                'salary' => $salary
            );
            $this->staffpayroll_model->updateStaffSalary($result->id, $data);
            show_swal('Staff salary updated successfully', 'success', 'Updated');
        }

        redirect('staffpayroll/salary');
    }

    public function generateStaffPayroll() {
        $month = $this->input->get('month');
        $year = $this->input->get('year');

        if (empty($month) || empty($year)) {
            show_swal('Please select month and year', 'error', 'Error');
            redirect('staffpayroll');
            return;
        }

        $allStaff = $this->staffpayroll_model->getAllStaffForPayroll();
        $generated_count = 0;
        $updated_count = 0;

        foreach ($allStaff as $staff) {
            // Check if payroll already exists for this staff in this month/year
            $existing_payroll = $this->staffpayroll_model->getStaffPayrollByStaffMonthYear($staff->id, $month, $year);
            
            // Get staff salary
            $staff_salary = $this->staffpayroll_model->getStaffSalaryByStaffId($staff->id);
            $basic_salary = $staff_salary ? $staff_salary->salary : ($staff->salary ? $staff->salary : 0);

            if (empty($existing_payroll)) {
                // Create new payroll record
                $data = array(
                    'staff_id' => $staff->id,
                    'month' => $month,
                    'year' => $year,
                    'basic_salary' => $basic_salary,
                    'allowances' => 0,
                    'deductions' => 0,
                    'net_salary' => $basic_salary,
                    'earning' => 'Basic Salary_' . $basic_salary,
                    'status' => 'Generated'
                );

                $this->staffpayroll_model->createStaffPayroll($data);
                $generated_count++;
            } else if ($existing_payroll->status != 'Paid') {
                // Update existing payroll if not paid
                $data = array(
                    'basic_salary' => $basic_salary,
                    'net_salary' => $basic_salary + $existing_payroll->allowances - $existing_payroll->deductions,
                    'earning' => 'Basic Salary_' . $basic_salary,
                    'status' => 'Generated'
                );

                $this->staffpayroll_model->updateStaffPayroll($existing_payroll->id, $data);
                $updated_count++;
            }
        }

        show_swal("Payroll generated successfully. Generated: $generated_count, Updated: $updated_count", 'success', 'Generated');
        redirect('staffpayroll');
    }

    public function viewPayroll() {
        $month = $this->input->get('month');
        $year = $this->input->get('year');

        $data['month'] = $month;
        $data['year'] = $year;
        $data['payrolls'] = $this->staffpayroll_model->getStaffPayroll($month, $year);

        $this->load->view('home/dashboard');
        $this->load->view('view_payroll', $data);
        $this->load->view('home/footer');
    }

    public function editPayroll() {
        $id = $this->input->get('id');
        $data['payroll'] = $this->staffpayroll_model->getStaffPayrollById($id);

        if (empty($data['payroll'])) {
            show_swal('Payroll record not found', 'error', 'Error');
            redirect('staffpayroll');
            return;
        }

        $this->load->view('home/dashboard');
        $this->load->view('edit_payroll', $data);
        $this->load->view('home/footer');
    }

    public function updatePayroll() {
        $id = $this->input->post('id');
        $allowances = $this->input->post('allowances');
        $deductions = $this->input->post('deductions');
        $basic_salary = $this->input->post('basic_salary');
        
        $net_salary = $basic_salary + $allowances - $deductions;

        $data = array(
            'allowances' => $allowances,
            'deductions' => $deductions,
            'net_salary' => $net_salary
        );

        $this->staffpayroll_model->updateStaffPayroll($id, $data);
        show_swal('Payroll updated successfully', 'success', 'Updated');
        redirect('staffpayroll');
    }

    public function markAsPaid() {
        $id = $this->input->get('id');
        
        $data = array(
            'status' => 'Paid',
            'paid_date' => date('Y-m-d')
        );

        $this->staffpayroll_model->updateStaffPayroll($id, $data);
        show_swal('Payroll marked as paid', 'success', 'Updated');
        redirect('staffpayroll');
    }

    public function deletePayroll() {
        $id = $this->input->get('id');
        $this->staffpayroll_model->deleteStaffPayroll($id);
        show_swal('Payroll deleted successfully', 'success', 'Deleted');
        redirect('staffpayroll');
    }

    // AJAX method to get staff details
    public function getStaffDetails() {
        $staff_id = $this->input->post('staff_id');
        $staff = $this->staff_model->getStaffById($staff_id);
        $salary = $this->staffpayroll_model->getStaffSalaryByStaffId($staff_id);
        
        $response = array(
            'staff' => $staff,
            'current_salary' => $salary ? $salary->salary : ($staff ? $staff->salary : 0)
        );
        
        echo json_encode($response);
    }
}