<div class="content-wrapper bg-gradient-light" style="min-height: 2726.9px;">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-users text-primary mr-3"></i>
                        <?php echo lang('staff_management'); ?>
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0">
                            <li class="breadcrumb-item"><a href="home"><?php echo lang('home'); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo lang('staff'); ?></li>
                        </ol>
                    </nav>
                </div>
                <div class="col-sm-6 text-right">
                    <a data-toggle="modal" href="#addStaffModal" class="btn btn-primary btn-sm px-4 py-3">
                        <i class="fa fa-plus"></i> <?php echo lang('add_new'); ?> <?php echo lang('staff'); ?>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-5">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card shadow-lg border-0">
                        <div class="card-header">
                            <h3 class="card-title text-black font-weight-800"><?php echo lang('all'); ?> <?php echo lang('staff'); ?> <?php echo lang('members'); ?></h3>
                        </div>

                        <div class="card-body bg-light p-4">
                            <table class="table table-hover datatables" id="editable-sample" width="100%">
                                <thead>
                                    <tr class="bg-light">
                                        <th class="font-weight-bold text-uppercase"><?php echo lang('photo'); ?></th>
                                        <th class="font-weight-bold text-uppercase"><?php echo lang('employee_id'); ?></th>
                                        <th class="font-weight-bold text-uppercase"><?php echo lang('name'); ?></th>
                                        <th class="font-weight-bold text-uppercase"><?php echo lang('email'); ?></th>
                                        <th class="font-weight-bold text-uppercase"><?php echo lang('phone'); ?></th>
                                        <th class="font-weight-bold text-uppercase"><?php echo lang('department'); ?></th>
                                        <th class="font-weight-bold text-uppercase"><?php echo lang('designation'); ?></th>
                                        <th class="font-weight-bold text-uppercase"><?php echo lang('salary'); ?></th>
                                        <th class="font-weight-bold text-uppercase"><?php echo lang('status'); ?></th>
                                        <th class="font-weight-bold text-uppercase no-print"><?php echo lang('options'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($staff as $member) { ?>
                                        <tr>
                                            <td>
                                                <?php if (!empty($member->profile_pic) && file_exists($member->profile_pic)) { ?>
                                                    <img src="<?php echo base_url($member->profile_pic); ?>" alt="Profile" class="img-circle" width="40" height="40">
                                                <?php } else { ?>
                                                    <img src="common/uploads/profile.jpg" alt="Profile" class="img-circle" width="40" height="40">
                                                <?php } ?>
                                            </td>
                                            <td><?php echo $member->employee_id; ?></td>
                                            <td><?php echo $member->name; ?></td>
                                            <td><?php echo $member->email; ?></td>
                                            <td><?php echo $member->phone; ?></td>
                                            <td><?php echo $member->department_name; ?></td>
                                            <td><?php echo $member->designation_name; ?></td>
                                            <td><?php echo number_format($member->salary, 2); ?></td>
                                            <td>
                                                <?php if ($member->status == 'active') { ?>
                                                    <span class="badge badge-success"><?php echo lang('active'); ?></span>
                                                <?php } else { ?>
                                                    <span class="badge badge-danger"><?php echo lang('inactive'); ?></span>
                                                <?php } ?>
                                            </td>
                                            <td class="no-print">
                                                <a href="javascript:void(0);" class="btn btn-info btn-sm viewStaffProfile" data-id="<?php echo $member->id; ?>" title="<?php echo lang('view'); ?> <?php echo lang('profile'); ?>"><i class="fa fa-eye"></i></a>
                                                <a href="staff/editStaff?id=<?php echo $member->id; ?>" class="btn btn-primary btn-sm" title="<?php echo lang('edit'); ?>"><i class="fa fa-edit"></i></a>
                                                <a class="btn btn-danger btn-sm" title="<?php echo lang('delete'); ?>" href="staff/delete?id=<?php echo $member->id; ?>" onclick="return confirm('<?php echo lang('are_you_sure_you_want_to_delete_this_item'); ?>');"><i class="fa fa-trash"></i></a>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add New Staff Modal -->
<div class="modal fade" id="addStaffModal" role="dialog" aria-labelledby="addStaffModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title font-weight-bold"><?php echo lang('add_new'); ?> <?php echo lang('staff'); ?> <?php echo lang('member'); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body">
                <form role="form" id="addStaffForm" action="staff/addNew" method="post" enctype="multipart/form-data">
                    <div class="row">
                        <!-- Personal Information -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="employee_id"><?php echo lang('employee_id'); ?> *</label>
                                <input type="text" class="form-control form-control-lg" name="employee_id" id="employee_id" 
                                       placeholder="<?php echo lang('enter'); ?> <?php echo lang('employee_id'); ?>" required readonly>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name"><?php echo lang('full_name'); ?> *</label>
                                <input type="text" class="form-control form-control-lg" name="name" id="name" 
                                       placeholder="<?php echo lang('enter'); ?> <?php echo lang('full_name'); ?>" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="email"><?php echo lang('email'); ?> *</label>
                                <input type="email" class="form-control form-control-lg" name="email" id="email" 
                                       placeholder="<?php echo lang('enter'); ?> <?php echo lang('email'); ?> <?php echo lang('address'); ?>" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="phone"><?php echo lang('phone'); ?></label>
                                <input type="text" class="form-control form-control-lg" name="phone" id="phone" 
                                       placeholder="<?php echo lang('enter'); ?> <?php echo lang('phone'); ?> <?php echo lang('number'); ?>">
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="address"><?php echo lang('address'); ?></label>
                                <textarea class="form-control form-control-lg" name="address" id="address" rows="2" 
                                          placeholder="<?php echo lang('enter'); ?> <?php echo lang('address'); ?>"></textarea>
                            </div>
                        </div>

                        <!-- Work Information -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="department_id"><?php echo lang('department'); ?> *</label>
                                <select class="form-control form-control-lg select2" name="department_id" id="department_id" required>
                                    <option value=""><?php echo lang('select'); ?> <?php echo lang('department'); ?></option>
                                    <?php foreach ($departments as $department) { ?>
                                        <option value="<?php echo $department->id; ?>">
                                            <?php echo $department->name; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="designation_id"><?php echo lang('designation'); ?> *</label>
                                <select class="form-control form-control-lg select2" name="designation_id" id="designation_id" required>
                                    <option value=""><?php echo lang('select'); ?> <?php echo lang('designation'); ?></option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="date_of_joining"><?php echo lang('date_of_joining'); ?></label>
                                <input type="date" class="form-control form-control-lg" name="date_of_joining" id="date_of_joining">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="salary"><?php echo lang('basic_salary'); ?></label>
                                <input type="number" step="0.01" class="form-control form-control-lg" name="salary" id="salary" 
                                       placeholder="<?php echo lang('enter'); ?> <?php echo lang('basic_salary'); ?>">
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="profile_pic"><?php echo lang('profile_picture'); ?></label>
                                <input type="file" class="form-control-file" name="profile_pic" id="profile_pic" accept="image/*">
                                <small class="form-text text-muted"><?php echo lang('maximum_file_size'); ?>: 2MB. <?php echo lang('allowed_formats'); ?>: JPG, PNG, GIF</small>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fa fa-times"></i> <?php echo lang('cancel'); ?>
                </button>
                <button type="submit" form="addStaffForm" class="btn btn-primary">
                    <i class="fa fa-save"></i> <?php echo lang('add'); ?> <?php echo lang('staff'); ?>
                </button>
            </div>
        </div>
    </div>
</div>

<script src="common/js/codearistos.min.js"></script>

<script type="text/javascript">
    $(document).ready(function() {
        // Initialize DataTables
        $('#editable-sample').DataTable({
            "order": [[ 2, "asc" ]], // Sort by name column
            "pageLength": 25
        });

        // Initialize Select2 for modals
        $('.select2').select2({
            dropdownParent: $('#addStaffModal')
        });

        // When modal is opened, generate employee ID
        $('#addStaffModal').on('show.bs.modal', function() {
            // Generate employee ID via AJAX
            $.ajax({
                url: 'staff/generateEmployeeId',
                type: 'GET',
                dataType: 'json',
                success: function(response) {
                    if (response.employee_id) {
                        $('#employee_id').val(response.employee_id);
                    }
                },
                error: function() {
                    // Fallback - generate a simple ID
                    var timestamp = Date.now();
                    $('#employee_id').val('EMP' + timestamp.toString().substr(-4));
                }
            });

            // Clear form when modal opens
            $('#addStaffForm')[0].reset();
            $('#designation_id').empty().append('<option value="">Select Designation</option>');
        });

        // Department change event for modal
        $('#department_id').on('change', function() {
            var departmentId = $(this).val();
            
            if (departmentId) {
                $.ajax({
                    url: 'staff/getDesignationsByDepartment',
                    type: 'POST',
                    data: { department_id: departmentId },
                    dataType: 'json',
                    success: function(response) {
                        $('#designation_id').empty();
                        $('#designation_id').append('<option value="">Select Designation</option>');
                        
                        $.each(response, function(index, designation) {
                            $('#designation_id').append('<option value="' + designation.id + '">' + designation.name + '</option>');
                        });
                    },
                    error: function() {
                        alert('Error loading designations');
                    }
                });
            } else {
                $('#designation_id').empty();
                $('#designation_id').append('<option value="">Select Designation</option>');
            }
        });

        // Preview image on file select
        $('#profile_pic').on('change', function() {
            const file = this.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    // Remove existing preview
                    $('.preview-image').remove();
                    
                    // Add new preview
                    $('#profile_pic').after('<div class="mt-2 preview-image"><img src="' + e.target.result + '" alt="Preview" width="100" height="100" class="img-thumbnail"></div>');
                };
                reader.readAsDataURL(file);
            }
        });

        // Handle form submission
        $('#addStaffForm').on('submit', function(e) {
            e.preventDefault();
            
            var formData = new FormData(this);
            
            $.ajax({
                url: $(this).attr('action'),
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    $('#addStaffModal').modal('hide');
                    // Reload the page to show new staff member
                    location.reload();
                },
                error: function() {
                    alert('Error adding staff member. Please try again.');
                }
            });
        });

        // Handle staff profile view
        $('.viewStaffProfile').on('click', function() {
            var staffId = $(this).data('id');
            
            // Show loading
            $('#staffProfileModal .modal-body').html('<div class="text-center"><i class="fa fa-spinner fa-spin fa-2x"></i><p>Loading...</p></div>');
            $('#staffProfileModal').modal('show');
            
            // Load staff data
            $.ajax({
                url: 'staff/getStaffProfile',
                type: 'GET',
                data: { id: staffId },
                dataType: 'json',
                success: function(response) {
                    if (response.staff) {
                        var staff = response.staff;
                        
                        // Create profile picture or beautiful default avatar
                        var profilePicHtml = '';
                        if (staff.profile_pic && staff.profile_pic !== '') {
                            profilePicHtml = `<img src="<?php echo base_url(); ?>${staff.profile_pic}" alt="Profile Picture" class="img-thumbnail rounded-circle profile-image" style="width: 150px; height: 150px; object-fit: cover;">`;
                        } else {
                            // Create beautiful default avatar with initials
                            var initials = staff.name.split(' ').map(word => word.charAt(0).toUpperCase()).join('');
                            if (initials.length > 2) initials = initials.substring(0, 2);
                            
                            var colors = ['#007bff', '#28a745', '#dc3545', '#ffc107', '#17a2b8', '#6f42c1', '#fd7e14', '#20c997'];
                            var randomColor = colors[Math.floor(Math.random() * colors.length)];
                            
                            profilePicHtml = `
                                <div class="default-avatar rounded-circle d-flex align-items-center justify-content-center" 
                                     style="width: 150px; height: 150px; background: linear-gradient(135deg, ${randomColor}, ${randomColor}aa); 
                                            color: white; font-size: 48px; font-weight: bold; margin: 0 auto;
                                            box-shadow: 0 4px 20px rgba(0,0,0,0.15); border: 4px solid #fff;">
                                    ${initials}
                                </div>`;
                        }
                        
                        var html = `
                            <div class="row">
                                <div class="col-md-4 text-center">
                                    <div class="profile-picture-section mb-3">
                                        ${profilePicHtml}
                                    </div>
                                    <h4 class="mt-3 mb-1" style="color: #2c3e50;">${staff.name}</h4>
                                    <p class="text-muted mb-1" style="font-size: 14px;"><i class="fa fa-briefcase"></i> ${staff.designation_name || 'Not specified'}</p>
                                    <p class="text-info mb-0" style="font-size: 14px;"><i class="fa fa-building"></i> ${staff.department_name || 'Not specified'}</p>
                                </div>
                                <div class="col-md-8">
                                    <table class="table table-borderless">
                                        <tr>
                                            <td width="40%"><strong>Employee ID:</strong></td>
                                            <td><span class="badge badge-primary">${staff.employee_id}</span></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Email:</strong></td>
                                            <td><a href="mailto:${staff.email}">${staff.email}</a></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Phone:</strong></td>
                                            <td><a href="tel:${staff.phone}">${staff.phone}</a></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Address:</strong></td>
                                            <td>${staff.address || 'Not specified'}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Department:</strong></td>
                                            <td><span class="badge badge-info">${staff.department_name || 'Not assigned'}</span></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Designation:</strong></td>
                                            <td><span class="badge badge-secondary">${staff.designation_name || 'Not assigned'}</span></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Date of Joining:</strong></td>
                                            <td>${staff.date_of_joining ? new Date(staff.date_of_joining).toLocaleDateString() : 'Not specified'}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Salary:</strong></td>
                                            <td><span class="badge badge-success">${parseFloat(staff.salary || 0).toLocaleString()}</span></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Status:</strong></td>
                                            <td>${staff.status === 'active' ? '<span class="badge badge-success">Active</span>' : '<span class="badge badge-danger">Inactive</span>'}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        `;
                        
                        $('#staffProfileModal .modal-body').html(html);
                        $('#staffProfileModal .modal-title').html('<i class="fa fa-user"></i> ' + staff.name + ' - Profile');
                    } else {
                        $('#staffProfileModal .modal-body').html('<div class="alert alert-warning">Staff member not found.</div>');
                    }
                },
                error: function() {
                    $('#staffProfileModal .modal-body').html('<div class="alert alert-danger">Error loading staff profile. Please try again.</div>');
                }
            });
        });
    });
</script>

<!-- Staff Profile Modal -->
<div class="modal fade" id="staffProfileModal" tabindex="-1" role="dialog" aria-labelledby="staffProfileModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content" style="border-radius: 15px; border: none; box-shadow: 0 10px 40px rgba(0,0,0,0.2);">
            <div class="modal-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border-radius: 15px 15px 0 0; border: none;">
                <h5 class="modal-title" id="staffProfileModalLabel" style="font-weight: 600;">
                    <i class="fa fa-user"></i> Staff Profile
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close" style="opacity: 0.8;">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" style="padding: 30px; background: #f8f9fa;">
                <!-- Profile content will be loaded here -->
                <div class="text-center">
                    <div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;">
                        <span class="sr-only">Loading...</span>
                    </div>
                    <p class="mt-3 text-muted">Loading staff profile...</p>
                </div>
            </div>
            <div class="modal-footer" style="border: none; background: #f8f9fa; border-radius: 0 0 15px 15px; padding: 20px 30px;">
                <button type="button" class="btn btn-secondary" data-dismiss="modal" style="border-radius: 25px; padding: 8px 25px;">
                    <i class="fa fa-times"></i> Close
                </button>
            </div>
        </div>
    </div>
</div>

<style>
.profile-picture-section {
    background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
    padding: 20px;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}

.default-avatar {
    transition: all 0.3s ease;
}

.default-avatar:hover {
    transform: scale(1.05);
    box-shadow: 0 6px 25px rgba(0,0,0,0.2) !important;
}

.profile-image {
    transition: all 0.3s ease;
    box-shadow: 0 4px 20px rgba(0,0,0,0.15);
}

.profile-image:hover {
    transform: scale(1.05);
    box-shadow: 0 6px 25px rgba(0,0,0,0.2);
}

#staffProfileModal .table td {
    padding: 12px 8px;
    border-bottom: 1px solid #e9ecef;
}

#staffProfileModal .table tr:last-child td {
    border-bottom: none;
}

#staffProfileModal .table td:first-child {
    color: #495057;
    font-weight: 600;
}

#staffProfileModal .badge {
    font-size: 11px;
    padding: 6px 12px;
    border-radius: 20px;
}

.modal-backdrop.show {
    opacity: 0.6;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translate3d(0, 40px, 0);
    }
    to {
        opacity: 1;
        transform: translate3d(0, 0, 0);
    }
}

.modal.fade.show .modal-dialog {
    animation: fadeInUp 0.3s ease-out;
}
</style>