<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <div class="row">
            <div class="col-lg-12">
                <section class="card">
                    <header class="card-header">
                        <h4 class="card-title">
                            <i class="fa fa-user"></i> <?php echo lang('staff'); ?> <?php echo lang('profile'); ?>
                            <?php if (!empty($staff)) { ?>
                                - <?php echo $staff->name; ?>
                            <?php } ?>
                        </h4>
                        <div class="card-tools">
                            <a href="staff" class="btn btn-info btn-sm">
                                <i class="fa fa-arrow-left"></i> <?php echo lang('back_to_staff_list'); ?>
                            </a>
                            <?php if (!empty($staff)) { ?>
                                <a href="staff/editStaff?id=<?php echo $staff->id; ?>" class="btn btn-primary btn-sm">
                                    <i class="fa fa-edit"></i> <?php echo lang('edit'); ?>
                                </a>
                            <?php } ?>
                        </div>
                    </header>
                    
                    <?php if (!empty($staff)) { ?>
                    <div class="card-body">
                        <div class="row">
                            <!-- Profile Picture Section -->
                            <div class="col-md-4 text-center">
                                <div class="profile-picture-section mb-4">
                                    <?php if (!empty($staff->profile_pic) && file_exists($staff->profile_pic)) { ?>
                                        <img src="<?php echo base_url($staff->profile_pic); ?>" alt="Profile Picture" class="img-thumbnail rounded-circle" style="width: 200px; height: 200px; object-fit: cover;">
                                    <?php } else { ?>
                                        <img src="common/uploads/profile.jpg" alt="Profile Picture" class="img-thumbnail rounded-circle" style="width: 200px; height: 200px; object-fit: cover;">
                                    <?php } ?>
                                    <h3 class="mt-3"><?php echo $staff->name; ?></h3>
                                    <p class="text-muted"><?php echo $staff->designation_name; ?></p>
                                    <p class="text-info"><?php echo $staff->department_name; ?></p>
                                </div>
                            </div>
                            
                            <!-- Profile Details Section -->
                            <div class="col-md-8">
                                <div class="profile-details">
                                    <h4 class="mb-4"><?php echo lang('personal_information'); ?></h4>
                                    
                                    <div class="row mb-3">
                                        <div class="col-sm-4">
                                            <label class="font-weight-bold"><?php echo lang('employee_id'); ?>:</label>
                                        </div>
                                        <div class="col-sm-8">
                                            <span class="badge badge-primary"><?php echo $staff->employee_id; ?></span>
                                        </div>
                                    </div>
                                    
                                    <div class="row mb-3">
                                        <div class="col-sm-4">
                                            <label class="font-weight-bold"><?php echo lang('name'); ?>:</label>
                                        </div>
                                        <div class="col-sm-8">
                                            <?php echo $staff->name; ?>
                                        </div>
                                    </div>
                                    
                                    <div class="row mb-3">
                                        <div class="col-sm-4">
                                            <label class="font-weight-bold"><?php echo lang('email'); ?>:</label>
                                        </div>
                                        <div class="col-sm-8">
                                            <a href="mailto:<?php echo $staff->email; ?>"><?php echo $staff->email; ?></a>
                                        </div>
                                    </div>
                                    
                                    <div class="row mb-3">
                                        <div class="col-sm-4">
                                            <label class="font-weight-bold"><?php echo lang('phone'); ?>:</label>
                                        </div>
                                        <div class="col-sm-8">
                                            <a href="tel:<?php echo $staff->phone; ?>"><?php echo $staff->phone; ?></a>
                                        </div>
                                    </div>
                                    
                                    <div class="row mb-3">
                                        <div class="col-sm-4">
                                            <label class="font-weight-bold"><?php echo lang('address'); ?>:</label>
                                        </div>
                                        <div class="col-sm-8">
                                            <?php echo !empty($staff->address) ? $staff->address : '<span class="text-muted">Not specified</span>'; ?>
                                        </div>
                                    </div>
                                    
                                    <div class="row mb-3">
                                        <div class="col-sm-4">
                                            <label class="font-weight-bold"><?php echo lang('department'); ?>:</label>
                                        </div>
                                        <div class="col-sm-8">
                                            <span class="badge badge-info"><?php echo $staff->department_name; ?></span>
                                        </div>
                                    </div>
                                    
                                    <div class="row mb-3">
                                        <div class="col-sm-4">
                                            <label class="font-weight-bold"><?php echo lang('designation'); ?>:</label>
                                        </div>
                                        <div class="col-sm-8">
                                            <span class="badge badge-secondary"><?php echo $staff->designation_name; ?></span>
                                        </div>
                                    </div>
                                    
                                    <?php if (!empty($staff->date_of_joining)) { ?>
                                    <div class="row mb-3">
                                        <div class="col-sm-4">
                                            <label class="font-weight-bold"><?php echo lang('date_of_joining'); ?>:</label>
                                        </div>
                                        <div class="col-sm-8">
                                            <?php echo date('d M Y', strtotime($staff->date_of_joining)); ?>
                                        </div>
                                    </div>
                                    <?php } ?>
                                    
                                    <div class="row mb-3">
                                        <div class="col-sm-4">
                                            <label class="font-weight-bold"><?php echo lang('salary'); ?>:</label>
                                        </div>
                                        <div class="col-sm-8">
                                            <span class="badge badge-success"><?php echo number_format($staff->salary, 2); ?></span>
                                        </div>
                                    </div>
                                    
                                    <div class="row mb-3">
                                        <div class="col-sm-4">
                                            <label class="font-weight-bold"><?php echo lang('status'); ?>:</label>
                                        </div>
                                        <div class="col-sm-8">
                                            <?php if ($staff->status == 'active') { ?>
                                                <span class="badge badge-success"><?php echo lang('active'); ?></span>
                                            <?php } else { ?>
                                                <span class="badge badge-danger"><?php echo lang('inactive'); ?></span>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Additional Information Section -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="card-title">
                                            <i class="fa fa-info-circle"></i> <?php echo lang('additional_information'); ?>
                                        </h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <p><strong><?php echo lang('created_on'); ?>:</strong> 
                                                    <?php echo !empty($staff->created_at) ? date('d M Y, H:i', strtotime($staff->created_at)) : 'Not available'; ?>
                                                </p>
                                            </div>
                                            <div class="col-md-6">
                                                <p><strong><?php echo lang('last_updated'); ?>:</strong> 
                                                    <?php echo !empty($staff->updated_at) ? date('d M Y, H:i', strtotime($staff->updated_at)) : 'Not available'; ?>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <?php } else { ?>
                    <div class="card-body">
                        <div class="alert alert-warning">
                            <i class="fa fa-exclamation-triangle"></i> 
                            <?php echo lang('staff_member_not_found'); ?>
                        </div>
                        <a href="staff" class="btn btn-primary">
                            <i class="fa fa-arrow-left"></i> <?php echo lang('back_to_staff_list'); ?>
                        </a>
                    </div>
                    <?php } ?>
                </section>
            </div>
        </div>
        <!-- page end-->
    </section>
</section>
<!--main content end-->

<style>
.profile-picture-section {
    background: #f8f9fa;
    padding: 20px;
    border-radius: 10px;
    border: 1px solid #e9ecef;
}

.profile-details .row {
    padding: 8px 0;
    border-bottom: 1px solid #f0f0f0;
}

.profile-details .row:last-child {
    border-bottom: none;
}

.card-tools {
    float: right;
}

@media (max-width: 768px) {
    .card-tools {
        float: none;
        margin-top: 10px;
    }
    
    .profile-picture-section {
        margin-bottom: 20px;
    }
}
</style>