<div class="content-wrapper bg-gradient-light">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-user-plus text-primary mr-3"></i>
                        <?php echo isset($staff) ? 'Edit Staff' : 'Add New Staff'; ?>
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0">
                            <li class="breadcrumb-item"><a href="home">Home</a></li>
                            <li class="breadcrumb-item"><a href="staff">Staff</a></li>
                            <li class="breadcrumb-item active"><?php echo isset($staff) ? 'Edit' : 'Add New'; ?></li>
                        </ol>
                    </nav>
                </div>
                <div class="col-sm-6 text-right">
                    <a href="staff" class="btn btn-secondary btn-sm px-4 py-3">
                        <i class="fa fa-arrow-left"></i> Back to Staff List
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-5">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-10">
                    <div class="card shadow-lg border-0">
                        <div class="card-header">
                            <h3 class="card-title text-black font-weight-800">Staff Information</h3>
                        </div>

                        <div class="card-body bg-light p-4">
                            <form role="form" action="staff/addNew" method="post" enctype="multipart/form-data">
                                <?php if (isset($staff)) { ?>
                                    <input type="hidden" name="id" value="<?php echo $staff->id; ?>">
                                <?php } ?>
                                
                                <div class="row">
                                    <!-- Personal Information -->
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="employee_id">Employee ID *</label>
                                            <input type="text" class="form-control form-control-lg" name="employee_id" id="employee_id" 
                                                   value="<?php echo isset($staff) ? $staff->employee_id : (isset($employee_id) ? $employee_id : ''); ?>" 
                                                   placeholder="Enter Employee ID" required>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="name">Full Name *</label>
                                            <input type="text" class="form-control form-control-lg" name="name" id="name" 
                                                   value="<?php echo isset($staff) ? $staff->name : ''; ?>" 
                                                   placeholder="Enter Full Name" required>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="email">Email *</label>
                                            <input type="email" class="form-control form-control-lg" name="email" id="email" 
                                                   value="<?php echo isset($staff) ? $staff->email : ''; ?>" 
                                                   placeholder="Enter Email Address" required>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="phone">Phone</label>
                                            <input type="text" class="form-control form-control-lg" name="phone" id="phone" 
                                                   value="<?php echo isset($staff) ? $staff->phone : ''; ?>" 
                                                   placeholder="Enter Phone Number">
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label for="address">Address</label>
                                            <textarea class="form-control form-control-lg" name="address" id="address" rows="3" 
                                                      placeholder="Enter Address"><?php echo isset($staff) ? $staff->address : ''; ?></textarea>
                                        </div>
                                    </div>

                                    <!-- Work Information -->
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="department_id">Department *</label>
                                            <select class="form-control form-control-lg select2" name="department_id" id="department_id" required>
                                                <option value="">Select Department</option>
                                                <?php foreach ($departments as $department) { ?>
                                                    <option value="<?php echo $department->id; ?>" 
                                                            <?php echo (isset($staff) && $staff->department_id == $department->id) ? 'selected' : ''; ?>>
                                                        <?php echo $department->name; ?>
                                                    </option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="designation_id">Designation *</label>
                                            <select class="form-control form-control-lg select2" name="designation_id" id="designation_id" required>
                                                <option value="">Select Designation</option>
                                                <?php if (isset($designations)) { ?>
                                                    <?php foreach ($designations as $designation) { ?>
                                                        <option value="<?php echo $designation->id; ?>" 
                                                                <?php echo (isset($staff) && $staff->designation_id == $designation->id) ? 'selected' : ''; ?>>
                                                            <?php echo $designation->name; ?>
                                                        </option>
                                                    <?php } ?>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="date_of_joining">Date of Joining</label>
                                            <input type="date" class="form-control form-control-lg" name="date_of_joining" id="date_of_joining" 
                                                   value="<?php echo isset($staff) ? $staff->date_of_joining : ''; ?>">
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="salary">Basic Salary</label>
                                            <input type="number" step="0.01" class="form-control form-control-lg" name="salary" id="salary" 
                                                   value="<?php echo isset($staff) ? $staff->salary : ''; ?>" 
                                                   placeholder="Enter Basic Salary">
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="profile_pic">Profile Picture</label>
                                            <input type="file" class="form-control-file" name="profile_pic" id="profile_pic" accept="image/*">
                                            <small class="form-text text-muted">Maximum file size: 2MB. Allowed formats: JPG, PNG, GIF</small>
                                            <?php if (isset($staff) && !empty($staff->profile_pic) && file_exists($staff->profile_pic)) { ?>
                                                <div class="mt-2">
                                                    <img src="<?php echo base_url($staff->profile_pic); ?>" alt="Current Profile" width="100" height="100" class="img-thumbnail">
                                                </div>
                                            <?php } ?>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group text-center">
                                            <button type="submit" class="btn btn-primary btn-lg px-5">
                                                <?php echo isset($staff) ? 'Update Staff' : 'Add Staff'; ?>
                                            </button>
                                            <a href="staff" class="btn btn-secondary btn-lg px-5 ml-3">Cancel</a>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="common/js/codearistos.min.js"></script>

<script type="text/javascript">
    $(document).ready(function() {
        // Initialize Select2
        $('.select2').select2();

        // Department change event
        $('#department_id').on('change', function() {
            var departmentId = $(this).val();
            
            if (departmentId) {
                $.ajax({
                    url: 'staff/getDesignationsByDepartment',
                    type: 'POST',
                    data: { department_id: departmentId },
                    dataType: 'json',
                    success: function(response) {
                        $('#designation_id').empty();
                        $('#designation_id').append('<option value="">Select Designation</option>');
                        
                        $.each(response, function(index, designation) {
                            $('#designation_id').append('<option value="' + designation.id + '">' + designation.name + '</option>');
                        });
                    },
                    error: function() {
                        alert('Error loading designations');
                    }
                });
            } else {
                $('#designation_id').empty();
                $('#designation_id').append('<option value="">Select Designation</option>');
            }
        });

        // Preview image on file select
        $('#profile_pic').on('change', function() {
            const file = this.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    // Remove existing preview
                    $('.preview-image').remove();
                    
                    // Add new preview
                    $('#profile_pic').after('<div class="mt-2 preview-image"><img src="' + e.target.result + '" alt="Preview" width="100" height="100" class="img-thumbnail"></div>');
                };
                reader.readAsDataURL(file);
            }
        });
    });
</script>