<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Staff_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertStaff($data) {
        $data1 = array('hospital_id' => $this->session->userdata('hospital_id'));
        $data2 = array_merge($data, $data1);
        $this->db->insert('staff', $data2);
        return $this->db->insert_id();
    }

    function getStaff() {
        $this->db->select('s.*, d.name as department_name, des.name as designation_name');
        $this->db->from('staff s');
        $this->db->join('department d', 's.department_id = d.id', 'left');
        $this->db->join('designation des', 's.designation_id = des.id', 'left');
        $this->db->where('s.hospital_id', $this->session->userdata('hospital_id'));
        $this->db->order_by('s.name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    function getStaffById($id) {
        $this->db->select('s.*, d.name as department_name, des.name as designation_name');
        $this->db->from('staff s');
        $this->db->join('department d', 's.department_id = d.id', 'left');
        $this->db->join('designation des', 's.designation_id = des.id', 'left');
        $this->db->where('s.hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('s.id', $id);
        $query = $this->db->get();
        return $query->row();
    }

    function updateStaff($id, $data) {
        $this->db->where('id', $id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->update('staff', $data);
    }

    function delete($id) {
        // Check if staff has payroll records
        $this->db->where('staff_id', $id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $payroll_count = $this->db->count_all_results('staff_payroll');
        
        if ($payroll_count > 0) {
            // Soft delete - set status to inactive
            $this->updateStaff($id, array('status' => 'inactive'));
            return 'soft_deleted';
        }
        
        // Hard delete if no payroll records
        $this->db->where('id', $id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->delete('staff');
        return 'deleted';
    }

    function getStaffByEmail($email, $id = null) {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('email', $email);
        if ($id) {
            $this->db->where('id !=', $id);
        }
        $query = $this->db->get('staff');
        return $query->row();
    }

    function getStaffByEmployeeId($employee_id, $id = null) {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('employee_id', $employee_id);
        if ($id) {
            $this->db->where('id !=', $id);
        }
        $query = $this->db->get('staff');
        return $query->row();
    }

    function getStaffByDepartment($department_id) {
        $this->db->select('s.*, des.name as designation_name');
        $this->db->from('staff s');
        $this->db->join('designation des', 's.designation_id = des.id', 'left');
        $this->db->where('s.hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('s.department_id', $department_id);
        $this->db->where('s.status', 'active');
        $this->db->order_by('s.name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    function getActiveStaff() {
        $this->db->select('s.*, d.name as department_name, des.name as designation_name');
        $this->db->from('staff s');
        $this->db->join('department d', 's.department_id = d.id', 'left');
        $this->db->join('designation des', 's.designation_id = des.id', 'left');
        $this->db->where('s.hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('s.status', 'active');
        $this->db->order_by('s.name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    function generateEmployeeId() {
        $hospital_id = $this->session->userdata('hospital_id');
        $prefix = 'EMP';
        
        // Get the latest employee ID for this hospital
        $this->db->select('employee_id');
        $this->db->where('hospital_id', $hospital_id);
        $this->db->where('employee_id LIKE', $prefix . '%');
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);
        $query = $this->db->get('staff');
        
        if ($query->num_rows() > 0) {
            $last_emp_id = $query->row()->employee_id;
            $number = (int) substr($last_emp_id, strlen($prefix));
            $new_number = $number + 1;
        } else {
            $new_number = 1;
        }
        
        return $prefix . str_pad($new_number, 4, '0', STR_PAD_LEFT);
    }
}