<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Staff extends MX_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('staff_model');
        $this->load->model('department/department_model');
        $this->load->model('designation/designation_model');

        if (!$this->ion_auth->in_group('admin')) {
            redirect('home/permission');
        }
    }

    public function index() {
        $data['staff'] = $this->staff_model->getStaff();
        $data['departments'] = $this->department_model->getDepartment();
        $this->load->view('home/dashboard'); 
        $this->load->view('staff', $data);
        $this->load->view('home/footer'); 
    }

    public function addNewView() {
        $data['departments'] = $this->department_model->getDepartment();
        $data['employee_id'] = $this->staff_model->generateEmployeeId();
        $this->load->view('home/dashboard'); 
        $this->load->view('add_new', $data);
        $this->load->view('home/footer'); 
    }

    public function addNew() {
        $id = $this->input->post('id');
        $name = $this->input->post('name');
        $email = $this->input->post('email');
        $phone = $this->input->post('phone');
        $address = $this->input->post('address');
        $department_id = $this->input->post('department_id');
        $designation_id = $this->input->post('designation_id');
        $employee_id = $this->input->post('employee_id');
        $date_of_joining = $this->input->post('date_of_joining');
        $salary = $this->input->post('salary');

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        // Validation rules
        $this->form_validation->set_rules('name', 'Staff Name', 'trim|required|min_length[2]|max_length[255]|xss_clean');
        $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|max_length[255]|xss_clean');
        $this->form_validation->set_rules('phone', 'Phone', 'trim|max_length[20]|xss_clean');
        $this->form_validation->set_rules('address', 'Address', 'trim|max_length[1000]|xss_clean');
        $this->form_validation->set_rules('department_id', 'Department', 'trim|required|numeric|xss_clean');
        $this->form_validation->set_rules('designation_id', 'Designation', 'trim|required|numeric|xss_clean');
        $this->form_validation->set_rules('employee_id', 'Employee ID', 'trim|required|max_length[50]|xss_clean');
        $this->form_validation->set_rules('date_of_joining', 'Date of Joining', 'trim|xss_clean');
        $this->form_validation->set_rules('salary', 'Salary', 'trim|numeric|xss_clean');
        
        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $data['departments'] = $this->department_model->getDepartment();
            if (!empty($id)) {
                $data['staff'] = $this->staff_model->getStaffById($id);
                $data['designations'] = $this->designation_model->getDesignationByDepartment($data['staff']->department_id);
            } else {
                $data['employee_id'] = $this->staff_model->generateEmployeeId();
            }
            $this->load->view('home/dashboard'); 
            $this->load->view('add_new', $data);
            $this->load->view('home/footer'); 
        } else {
            // Check for duplicate email
            $existing_email = $this->staff_model->getStaffByEmail($email, $id);
            if (!empty($existing_email)) {
                show_swal('Email already exists', 'error', 'Error');
                redirect('staff');
                return;
            }

            // Check for duplicate employee ID
            $existing_emp_id = $this->staff_model->getStaffByEmployeeId($employee_id, $id);
            if (!empty($existing_emp_id)) {
                show_swal('Employee ID already exists', 'error', 'Error');
                redirect('staff');
                return;
            }

            // Handle file upload for profile picture
            $profile_pic = '';
            if (!empty($_FILES['profile_pic']['name'])) {
                $config['upload_path'] = './uploads/staff/';
                $config['allowed_types'] = 'gif|jpg|png|jpeg';
                $config['max_size'] = 2048; // 2MB
                $config['file_name'] = 'staff_' . time() . '_' . rand(1000, 9999);
                
                // Create directory if it doesn't exist
                if (!file_exists($config['upload_path'])) {
                    mkdir($config['upload_path'], 0777, true);
                }
                
                $this->load->library('upload', $config);
                
                if ($this->upload->do_upload('profile_pic')) {
                    $upload_data = $this->upload->data();
                    $profile_pic = 'uploads/staff/' . $upload_data['file_name'];
                }
            }

            $data = array(
                'name' => $name,
                'email' => $email,
                'phone' => $phone,
                'address' => $address,
                'department_id' => $department_id,
                'designation_id' => $designation_id,
                'employee_id' => $employee_id,
                'date_of_joining' => !empty($date_of_joining) ? $date_of_joining : null,
                'salary' => !empty($salary) ? $salary : 0
            );

            if (!empty($profile_pic)) {
                $data['profile_pic'] = $profile_pic;
            }
            
            if (empty($id)) {     // Adding New staff
                $this->staff_model->insertStaff($data);
                show_swal('New staff member added successfully', 'success', 'Added');
            } else { // Updating staff
                $this->staff_model->updateStaff($id, $data);
                show_swal('Staff details updated successfully', 'success', 'Updated');
            }
            // Loading View
            redirect('staff');
        }
    }

    function getStaff() {
        $data['staff'] = $this->staff_model->getStaff();
        $this->load->view('staff', $data);
    }

    function editStaff() {
        $data = array();
        $id = $this->input->get('id');
        $data['staff'] = $this->staff_model->getStaffById($id);
        $data['departments'] = $this->department_model->getDepartment();
        $data['designations'] = $this->designation_model->getDesignationByDepartment($data['staff']->department_id);
        $this->load->view('home/dashboard'); 
        $this->load->view('add_new', $data);
        $this->load->view('home/footer'); 
    }

    function editStaffByJason() {
        $id = $this->input->get('id');
        $data['staff'] = $this->staff_model->getStaffById($id);
        $data['designations'] = $this->designation_model->getDesignationByDepartment($data['staff']->department_id);
        echo json_encode($data);
    }

    function delete() {
        $id = $this->input->get('id');
        $result = $this->staff_model->delete($id);
        
        if ($result == 'deleted') {
            show_swal('Staff member deleted successfully', 'success', 'Deleted');
        } elseif ($result == 'soft_deleted') {
            show_swal('Staff member deactivated (has payroll records)', 'info', 'Deactivated');
        } else {
            show_swal('Error deleting staff member', 'error', 'Error');
        }
        redirect('staff');
    }

    // AJAX method to get designations by department
    function getDesignationsByDepartment() {
        $department_id = $this->input->post('department_id');
        $designations = $this->designation_model->getDesignationByDepartment($department_id);
        echo json_encode($designations);
    }

    function profile() {
        $id = $this->input->get('id');
        $data['staff'] = $this->staff_model->getStaffById($id);
        $this->load->view('home/dashboard'); 
        $this->load->view('profile', $data);
        $this->load->view('home/footer'); 
    }

    function getStaffProfile() {
        $id = $this->input->get('id');
        $data['staff'] = $this->staff_model->getStaffById($id);
        echo json_encode($data);
    }

    // AJAX method to generate employee ID
    function generateEmployeeId() {
        $employee_id = $this->staff_model->generateEmployeeId();
        echo json_encode(array('employee_id' => $employee_id));
    }
}