<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <link rel="shortcut icon" type="image/x-icon" href="uploads/favicon.ico">
    <title><?php echo $this->router->fetch_class(); ?> | <?php echo $settings->system_vendor; ?></title>
    <meta name="description" content="MyLab">
    <meta name="author" content="Rizvi">
    <meta name="keyword" content="Lab, Diagnostic, Hospital, Blood">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700&family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="common/assets/css/bootstrap4.1.3.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/custom.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/custom2.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/custom3.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/custom4.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/dataTables.bootstrap4.1.1.min.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/bootstrap-clockpicker.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/jquery.timepicker.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/daterangepicker.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/select2.min.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/select2-bootstrap4.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/bootstrap-editable.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/theme.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/theme-custom.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/custom-modal.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/custom-panel.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/custom-table.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/custom-form.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/custom-button.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/custom-alert.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/custom-card.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/custom-navbar.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/custom-sidebar.css">
    <link rel="stylesheet" type="text/css" href="common/assets/css/custom-footer.css">
    <style>
        .content-panel {
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .page-header {
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }
        .btn-group-sm>.btn, .btn-sm {
            padding: 5px 10px;
            font-size: 12px;
        }
        .table th, .table td {
            vertical-align: middle;
        }
    </style>
</head>
<body>
    <section id="container" class="">
        <header class="header white-bg">
            <div class="sidebar-toggle-box">
                <div data-original-title="Toggle Navigation" data-placement="right" class="fa fa-bars tooltips"></div>
            </div>
            <a href="index.php" class="logo">
                <strong><?php echo $settings->system_vendor; ?></strong>
            </a>
            <div class="nav notify-row" id="top_menu">
                <!--  notification start -->
                <ul class="nav top-menu">
                    <!-- settings start -->
                    <!-- settings end -->
                    <!-- inbox dropdown start-->
                    <!-- inbox dropdown end -->
                </ul>
                <!--  notification end -->
            </div>
            <div class="top-nav ">
                <ul class="nav pull-right top-menu">
                    <!-- user login dropdown start-->
                    <li class="dropdown">
                        <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                            <img alt="" src="uploads/favicon.ico" height="30" width="30">
                            <span class="username">
                                <?php
                                $username = $this->ion_auth->user()->row()->username;
                                $usergroup = $this->ion_auth->get_users_groups()->row()->name;
                                echo $username . ' (' . $usergroup . ')';
                                ?>
                            </span>
                            <b class="caret"></b>
                        </a>
                        <ul class="dropdown-menu extended logout">
                            <div class="log-arrow-up"></div>
                            <?php if ($this->ion_auth->in_group('admin')) { ?>
                                <li><a href="settings"><i class="fa fa-cog"></i> <?php echo lang('settings'); ?></a></li>
                            <?php } ?>
                            <li><a href="profile"><i class="fa fa-user"></i> <?php echo lang('profile'); ?></a></li>
                            <li><a href="auth/logout"><i class="fa fa-key"></i> <?php echo lang('log_out'); ?></a></li>
                        </ul>
                    </li>
                    <!-- user login dropdown end -->
                </ul>
            </div>
        </header>
        <!--header end-->
        <!--sidebar start-->
        <?php include 'application/views/home/sidebar.php'; ?>
        <!--sidebar end-->
        <!--main content start-->
        <section id="main-content">
            <section class="wrapper site-min-height">
                <!-- page start-->
                <section class="content-panel">
                    <div class="page-header">
                        <h1 class="font-weight-bold text-primary">
                            <i class="fa fa-google"></i> <?php echo lang('google_api_clients'); ?>
                            <small class="text-muted"><?php echo lang('manage_doctor_google_calendar_integration'); ?></small>
                        </h1>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <header class="panel-heading clearfix">
                                <div class="pull-left">
                                    <i class="fa fa-list"></i> <?php echo lang('google_api_clients_list'); ?>
                                </div>
                                <div class="pull-right">
                                    <a href="settings/google_api_clients/add" class="btn btn-success btn-sm">
                                        <i class="fa fa-plus"></i> <?php echo lang('add_new_client'); ?>
                                    </a>
                                </div>
                            </header>
                            <div class="panel-body">
                                <?php if ($this->session->flashdata('success')): ?>
                                    <div class="alert alert-success">
                                        <button type="button" class="close" data-dismiss="alert">&times;</button>
                                        <?php echo $this->session->flashdata('success'); ?>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if ($this->session->flashdata('error')): ?>
                                    <div class="alert alert-danger">
                                        <button type="button" class="close" data-dismiss="alert">&times;</button>
                                        <?php echo $this->session->flashdata('error'); ?>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="adv-table editable-table">
                                    <table class="table table-striped table-hover table-bordered" id="editable-sample">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th><?php echo lang('doctor'); ?></th>
                                                <th><?php echo lang('client_name'); ?></th>
                                                <th><?php echo lang('project_id'); ?></th>
                                                <th><?php echo lang('status'); ?></th>
                                                <th><?php echo lang('created_at'); ?></th>
                                                <th><?php echo lang('options'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($google_api_clients as $client): ?>
                                                <tr>
                                                    <td><?php echo $client->id; ?></td>
                                                    <td>
                                                        <?php 
                                                        $doctor = null;
                                                        foreach ($doctors as $d) {
                                                            if ($d->id == $client->doctor_id) {
                                                                $doctor = $d;
                                                                break;
                                                            }
                                                        }
                                                        echo $doctor ? $doctor->name : lang('unknown_doctor');
                                                        ?>
                                                    </td>
                                                    <td><?php echo $client->client_name; ?></td>
                                                    <td><?php echo $client->project_id; ?></td>
                                                    <td>
                                                        <?php if ($client->is_active): ?>
                                                            <span class="badge badge-success"><?php echo lang('active'); ?></span>
                                                        <?php else: ?>
                                                            <span class="badge badge-danger"><?php echo lang('inactive'); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td><?php echo date('Y-m-d H:i', strtotime($client->created_at)); ?></td>
                                                    <td>
                                                        <a href="settings/google_api_clients/view?id=<?php echo $client->id; ?>" class="btn btn-info btn-sm" title="<?php echo lang('view'); ?>">
                                                            <i class="fa fa-eye"></i>
                                                        </a>
                                                        <a href="settings/google_api_clients/edit?id=<?php echo $client->id; ?>" class="btn btn-primary btn-sm" title="<?php echo lang('edit'); ?>">
                                                            <i class="fa fa-edit"></i>
                                                        </a>
                                                        <a href="settings/google_api_clients/delete?id=<?php echo $client->id; ?>" class="btn btn-danger btn-sm" title="<?php echo lang('delete'); ?>" 
                                                           onclick="return confirm('<?php echo lang('are_you_sure_you_want_to_delete_this_client'); ?>')">
                                                            <i class="fa fa-trash"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- page end-->
            </section>
        </section>
        <!--main content end-->
        <!--footer start-->
        <footer class="site-footer">
            <div class="text-center">
                <?php echo date('Y'); ?> &copy; <?php echo $settings->system_vendor; ?>. All Rights Reserved.
                <a href="#" class="go-top">
                    <i class="fa fa-angle-up"></i>
                </a>
            </div>
        </footer>
        <!--footer end-->
    </section>

    <!-- js placed at the end of the document so the pages load faster -->
    <script src="common/assets/js/jquery.js"></script>
    <script src="common/assets/js/bootstrap.min.js"></script>
    <script src="common/assets/js/jquery.scrollTo.min.js"></script>
    <script src="common/assets/js/jquery.nicescroll.js" type="text/javascript"></script>
    <script src="common/assets/js/jquery.sparkline.js" type="text/javascript"></script>
    <script src="common/assets/jquery.validate.min.js"></script>
    <script src="common/assets/js/jquery.dataTables.min.js"></script>
    <script src="common/assets/js/dataTables.bootstrap4.1.1.min.js"></script>
    <script src="common/assets/js/jquery.cookie.js"></script>
    <script src="common/assets/js/common-scripts.js"></script>
    <script src="common/assets/js/jquery-ui-1.9.2.custom.min.js"></script>
    <script src="common/assets/js/bootstrap-datepicker.js"></script>
    <script src="common/assets/js/bootstrap-fileupload.js"></script>
    <script src="common/assets/js/bootstrap-clockpicker.js"></script>
    <script src="common/assets/js/jquery.timepicker.js"></script>
    <script src="common/assets/js/daterangepicker.js"></script>
    <script src="common/assets/js/select2.full.min.js"></script>
    <script src="common/assets/js/bootstrap-editable.js"></script>
    <script>
        $(document).ready(function() {
            $('#editable-sample').DataTable({
                "order": [[ 0, "desc" ]],
                "pageLength": 25,
                "responsive": true
            });
        });
    </script>
</body>
</html>