<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Prescription_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertPrescription($data) {
        $data1 = array('hospital_id' => $this->session->userdata('hospital_id'));
        $data2 = array_merge($data, $data1);
        $this->db->insert('prescription', $data2);
    }

    function getPrescription() {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('prescription');
        return $query->result();
    }

    function getPrescriptionById($id) {
        $hospital_id = $this->session->userdata('hospital_id');
        
        // Check if hospital groups tables exist before using sharing
        if ($this->db->table_exists('hospital_groups') && $this->db->table_exists('hospital_group_members')) {
            // Get prescription from own hospital or shared hospitals in the same group, with hospital name
            $this->db->select('p.*, h.name as hospital_name, 
                               (CASE 
                                   WHEN p.hospital_id = ' . $hospital_id . ' THEN "own"
                                   ELSE "shared"
                               END) as record_type', FALSE);
            $this->db->from('prescription p');
            $this->db->join('hospital h', 'p.hospital_id = h.id');
            $this->db->where('p.id', $id);
            
            // Allow access to own prescriptions or prescriptions from group hospitals
            $this->db->group_start();
            $this->db->where('p.hospital_id', $hospital_id);
            $this->db->or_where('p.hospital_id IN (
                SELECT DISTINCT hgm2.hospital_id 
                FROM hospital_group_members hgm1 
                JOIN hospital_group_members hgm2 ON hgm1.group_id = hgm2.group_id 
                JOIN hospital_groups hg ON hgm1.group_id = hg.id
                WHERE hgm1.hospital_id = ' . $hospital_id . ' 
                AND hgm2.hospital_id != ' . $hospital_id . '
                AND hgm1.status = "active" 
                AND hgm2.status = "active" 
                AND hg.status = "active"
            )', NULL, FALSE);
            $this->db->group_end();
            
            $query = $this->db->get();
            return $query->row();
        } else {
            // Fallback to simple implementation if tables don't exist
            $this->db->where('hospital_id', $hospital_id);
            $this->db->where('id', $id);
            $query = $this->db->get('prescription');
            return $query->row();
        }
    }

    function getPrescriptionByPatientId($patient_id) {
        $hospital_id = $this->session->userdata('hospital_id');
        
        // Check if hospital groups tables exist before using sharing
        if ($this->db->table_exists('hospital_groups') && $this->db->table_exists('hospital_group_members')) {
            // Get prescriptions from all hospitals in the same group, with hospital name
            $this->db->select('p.*, h.name as hospital_name, 
                               (CASE 
                                   WHEN p.hospital_id = ' . $hospital_id . ' THEN "own"
                                   ELSE "shared"
                               END) as record_type', FALSE);
            $this->db->from('prescription p');
            $this->db->join('hospital h', 'p.hospital_id = h.id');
            $this->db->where('p.patient', $patient_id);
            
            // Get records from own hospital and shared hospitals in the same group
            $this->db->group_start();
            $this->db->where('p.hospital_id', $hospital_id);
            $this->db->or_where('p.hospital_id IN (
                SELECT DISTINCT hgm2.hospital_id 
                FROM hospital_group_members hgm1 
                JOIN hospital_group_members hgm2 ON hgm1.group_id = hgm2.group_id 
                JOIN hospital_groups hg ON hgm1.group_id = hg.id
                WHERE hgm1.hospital_id = ' . $hospital_id . ' 
                AND hgm2.hospital_id != ' . $hospital_id . '
                AND hgm1.status = "active" 
                AND hgm2.status = "active" 
                AND hg.status = "active"
            )', NULL, FALSE);
            $this->db->group_end();
            
            $this->db->order_by('p.id', 'desc');
            $query = $this->db->get();
            return $query->result();
        } else {
            // Fallback to simple implementation if tables don't exist
            $this->db->where('hospital_id', $hospital_id);
            $this->db->order_by('id', 'desc');
            $this->db->where('patient', $patient_id);
            $query = $this->db->get('prescription');
            return $query->result();
        }
    }

    function getPrescriptionByDoctorId($doctor_id) {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->order_by('id', 'desc');
        $this->db->where('doctor', $doctor_id);
        $query = $this->db->get('prescription');
        return $query->result();
    }

    function updatePrescription($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('prescription', $data);
    }

    function deletePrescription($id) {
        $this->db->where('id', $id);
        $this->db->delete('prescription');
    }
    
    function getPrescriptionWithoutSearch($order, $dir) {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $query = $this->db->get('prescription');
        return $query->result();
    }

    function getPrescriptionBySearch($search, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $query = $this->db->select('*')
                ->from('prescription')
                ->where('hospital_id', $this->session->userdata('hospital_id'))
                ->where("(id LIKE '%" . $search . "%' OR patientname LIKE '%" . $search . "%' OR doctorname LIKE '%" . $search . "%')", NULL, FALSE)
                ->get();
        ;
        return $query->result();
    }

    function getPrescriptionByLimit($limit, $start, $order, $dir) {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->limit($limit, $start);
        $query = $this->db->get('prescription');
        return $query->result();
    }

    function getPrescriptionByLimitBySearch($limit, $start, $search, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->limit($limit, $start);
        $query = $this->db->select('*')
                ->from('prescription')
                ->where('hospital_id', $this->session->userdata('hospital_id'))
                ->where("(id LIKE '%" . $search . "%' OR patientname LIKE '%" . $search . "%' OR doctorname LIKE '%" . $search . "%')", NULL, FALSE)
                ->get();
        ;
        return $query->result();
    }

    function getPrescriptionByDoctor($doctor_id) {
        $this->db->order_by('id', 'desc');
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('doctor', $doctor_id);
        $query = $this->db->get('prescription');
        return $query->result();
    }
    
    function getPrescriptionByDoctorWithoutSearch($doctor_id, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('doctor', $doctor_id);
        $query = $this->db->get('prescription');
        return $query->result();
    }

    function getPrescriptionBySearchByDoctor($doctor, $search, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $query = $this->db->select('*')
                ->from('prescription')
                ->where('hospital_id', $this->session->userdata('hospital_id'))
                ->where('doctor', $doctor)
                ->where("(id LIKE '%" . $search . "%' OR patientname LIKE '%" . $search . "%' OR doctorname LIKE '%" . $search . "%')", NULL, FALSE)
                ->get();
        ;
        return $query->result();
    }

    function getPrescriptionByLimitByDoctor($doctor, $limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('doctor', $doctor);
        $this->db->limit($limit, $start);
        $query = $this->db->get('prescription');
        return $query->result();
    }

    function getPrescriptionByLimitBySearchByDoctor($doctor, $limit, $start, $search, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->limit($limit, $start);
        $query = $this->db->select('*')
                ->from('prescription')
                ->where('hospital_id', $this->session->userdata('hospital_id'))
                ->where('doctor', $doctor)
                ->where("(id LIKE '%" . $search . "%' OR patientname LIKE '%" . $search . "%' OR doctorname LIKE '%" . $search . "%')", NULL, FALSE)
                ->get();
        ;
        return $query->result();
    }

}
