<div class="content-wrapper">
    <!-- Content Header -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark"><i class="fas fa-eye mr-2"></i><?php echo lang('view_hospital_group'); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="home"><?php echo lang('home'); ?></a></li>
                        <li class="breadcrumb-item"><a href="hospital/groups"><?php echo lang('hospital_groups'); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo $group->name; ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <!-- Group Overview -->
            <div class="row">
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-info-circle mr-2"></i><?php echo lang('group_information'); ?>
                            </h3>
                            <div class="card-tools">
                                <a href="hospital/editGroup/<?php echo $group->id; ?>" class="btn btn-primary btn-sm">
                                    <i class="fas fa-edit mr-1"></i><?php echo lang('edit_group'); ?>
                                </a>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="200"><strong><?php echo lang('group_name'); ?>:</strong></td>
                                    <td><?php echo $group->name; ?></td>
                                </tr>
                                <tr>
                                    <td><strong><?php echo lang('description'); ?>:</strong></td>
                                    <td><?php echo !empty($group->description) ? $group->description : lang('no_description'); ?></td>
                                </tr>
                                <tr>
                                    <td><strong><?php echo lang('created_by'); ?>:</strong></td>
                                    <td><?php echo $group->created_by_name; ?></td>
                                </tr>
                                <tr>
                                    <td><strong><?php echo lang('created_date'); ?>:</strong></td>
                                    <td><?php echo date('d M Y, h:i A', strtotime($group->created_date)); ?></td>
                                </tr>
                                <tr>
                                    <td><strong><?php echo lang('status'); ?>:</strong></td>
                                    <td>
                                        <span class="badge badge-<?php echo $group->status == 'active' ? 'success' : 'danger'; ?>">
                                            <?php echo ucfirst($group->status); ?>
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Statistics -->
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-chart-bar mr-2"></i><?php echo lang('sharing_statistics'); ?>
                            </h3>
                        </div>
                        <div class="card-body">
                            <div class="info-box bg-info">
                                <span class="info-box-icon"><i class="fas fa-hospital"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text"><?php echo lang('hospitals_in_group'); ?></span>
                                    <span class="info-box-number"><?php echo count($group_hospitals); ?></span>
                                </div>
                            </div>

                            <?php if (isset($sharing_stats)): ?>
                                <div class="info-box bg-success">
                                    <span class="info-box-icon"><i class="fas fa-users"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text"><?php echo lang('shared_patients'); ?></span>
                                        <span class="info-box-number"><?php echo $sharing_stats['total_shared_patients']; ?></span>
                                    </div>
                                </div>

                                <div class="info-box bg-warning">
                                    <span class="info-box-icon"><i class="fas fa-eye"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text"><?php echo lang('recent_access'); ?></span>
                                        <span class="info-box-number"><?php echo $sharing_stats['recent_access_count']; ?></span>
                                        <span class="progress-description"><?php echo lang('last_30_days'); ?></span>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Hospitals in Group -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-hospital-user mr-2"></i><?php echo lang('hospitals_in_group'); ?>
                            </h3>
                        </div>
                        <div class="card-body">
                            <?php if (!empty($group_hospitals)): ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th><?php echo lang('hospital_name'); ?></th>
                                                <th><?php echo lang('email'); ?></th>
                                                <th><?php echo lang('phone'); ?></th>
                                                <th><?php echo lang('address'); ?></th>
                                                <th><?php echo lang('sharing_status'); ?></th>
                                                <th><?php echo lang('added_date'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($group_hospitals as $hospital): ?>
                                                <tr>
                                                    <td>
                                                        <strong><?php echo $hospital->name; ?></strong>
                                                    </td>
                                                    <td>
                                                        <i class="fas fa-envelope mr-1"></i><?php echo $hospital->email; ?>
                                                    </td>
                                                    <td>
                                                        <i class="fas fa-phone mr-1"></i><?php echo $hospital->phone; ?>
                                                    </td>
                                                    <td>
                                                        <i class="fas fa-map-marker-alt mr-1"></i><?php echo $hospital->address; ?>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-<?php echo $hospital->allow_group_sharing == 'yes' ? 'success' : 'warning'; ?>">
                                                            <i class="fas fa-<?php echo $hospital->allow_group_sharing == 'yes' ? 'check' : 'exclamation-triangle'; ?> mr-1"></i>
                                                            <?php echo $hospital->allow_group_sharing == 'yes' ? lang('enabled') : lang('disabled'); ?>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <?php echo date('d M Y', strtotime($hospital->added_date)); ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle mr-2"></i><?php echo lang('no_hospitals_in_group'); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Activity -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-history mr-2"></i><?php echo lang('recent_sharing_activity'); ?>
                            </h3>
                        </div>
                        <div class="card-body">
                            <div id="activityLog">
                                <div class="text-center">
                                    <i class="fas fa-spinner fa-spin fa-2x"></i>
                                    <p class="mt-2"><?php echo lang('loading_activity'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    // Load sharing activity log
    loadSharingActivity();
    
    function loadSharingActivity() {
        $.ajax({
            url: 'hospital/getSharingLog/<?php echo $group->id; ?>',
            method: 'GET',
            dataType: 'json',
            success: function(data) {
                var html = '';
                
                if (data && data.length > 0) {
                    html += '<div class="table-responsive">';
                    html += '<table class="table table-sm table-striped">';
                    html += '<thead>';
                    html += '<tr>';
                    html += '<th><?php echo lang("accessing_hospital"); ?></th>';
                    html += '<th><?php echo lang("patient"); ?></th>';
                    html += '<th><?php echo lang("owner_hospital"); ?></th>';
                    html += '<th><?php echo lang("action"); ?></th>';
                    html += '<th><?php echo lang("user"); ?></th>';
                    html += '<th><?php echo lang("access_date"); ?></th>';
                    html += '</tr>';
                    html += '</thead>';
                    html += '<tbody>';
                    
                    $.each(data, function(index, log) {
                        var actionBadge = '';
                        switch(log.action) {
                            case 'view':
                                actionBadge = '<span class="badge badge-info"><i class="fas fa-eye mr-1"></i>View</span>';
                                break;
                            case 'edit':
                                actionBadge = '<span class="badge badge-warning"><i class="fas fa-edit mr-1"></i>Edit</span>';
                                break;
                            case 'delete':
                                actionBadge = '<span class="badge badge-danger"><i class="fas fa-trash mr-1"></i>Delete</span>';
                                break;
                        }
                        
                        html += '<tr>';
                        html += '<td>' + log.accessing_hospital + '</td>';
                        html += '<td>' + log.patient_name + '</td>';
                        html += '<td>' + log.owner_hospital + '</td>';
                        html += '<td>' + actionBadge + '</td>';
                        html += '<td>' + log.username + '</td>';
                        html += '<td>' + new Date(log.access_date).toLocaleString() + '</td>';
                        html += '</tr>';
                    });
                    
                    html += '</tbody>';
                    html += '</table>';
                    html += '</div>';
                } else {
                    html = '<div class="alert alert-info"><i class="fas fa-info-circle mr-2"></i><?php echo lang("no_recent_activity"); ?></div>';
                }
                
                $('#activityLog').html(html);
            },
            error: function() {
                $('#activityLog').html('<div class="alert alert-danger"><i class="fas fa-exclamation-triangle mr-2"></i><?php echo lang("error_loading_activity"); ?></div>');
            }
        });
    }
    
    // Refresh activity every 30 seconds
    setInterval(loadSharingActivity, 30000);
});
</script>