<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark"><i class="fas fa-hospital-user mr-2"></i><?php echo lang('hospital_groups'); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="home"><?php echo lang('home'); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo lang('hospital_groups'); ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <!-- Info boxes -->
            <div class="row mb-3">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title"><?php echo lang('hospital_groups_management'); ?></h3>
                            <div class="card-tools">
                                <a href="hospital/createGroup" class="btn btn-primary btn-sm">
                                    <i class="fas fa-plus mr-1"></i><?php echo lang('create_new_group'); ?>
                                </a>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle mr-2"></i>
                                <?php echo lang('hospital_groups_description'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Groups List -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title"><?php echo lang('existing_hospital_groups'); ?></h3>
                        </div>
                        <div class="card-body">
                            <?php if (!empty($groups)): ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="groupsTable">
                                        <thead>
                                            <tr>
                                                <th><?php echo lang('group_name'); ?></th>
                                                <th><?php echo lang('description'); ?></th>
                                                <th><?php echo lang('hospitals_count'); ?></th>
                                                <th><?php echo lang('created_by'); ?></th>
                                                <th><?php echo lang('created_date'); ?></th>
                                                <th><?php echo lang('status'); ?></th>
                                                <th><?php echo lang('actions'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($groups as $group): ?>
                                                <tr>
                                                    <td>
                                                        <strong><?php echo htmlspecialchars($group->name); ?></strong>
                                                    </td>
                                                    <td>
                                                        <?php echo htmlspecialchars(substr($group->description, 0, 100)); ?>
                                                        <?php if (strlen($group->description) > 100): ?>...<?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-info"><?php echo $group->hospital_count; ?> <?php echo lang('hospitals'); ?></span>
                                                    </td>
                                                    <td><?php echo htmlspecialchars($group->created_by_name); ?></td>
                                                    <td><?php echo date('M d, Y', strtotime($group->created_date)); ?></td>
                                                    <td>
                                                        <?php if ($group->status == 'active'): ?>
                                                            <span class="badge badge-success"><?php echo lang('active'); ?></span>
                                                        <?php else: ?>
                                                            <span class="badge badge-secondary"><?php echo lang('inactive'); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <div class="btn-group" role="group">
                                                            <a href="hospital/viewGroup/<?php echo $group->id; ?>" 
                                                               class="btn btn-info btn-sm" title="<?php echo lang('view_details'); ?>">
                                                                <i class="fas fa-eye"></i>
                                                            </a>
                                                            <a href="hospital/editGroup/<?php echo $group->id; ?>" 
                                                               class="btn btn-warning btn-sm" title="<?php echo lang('edit'); ?>">
                                                                <i class="fas fa-edit"></i>
                                                            </a>
                                                            <a href="hospital/toggleGroupStatus/<?php echo $group->id; ?>" 
                                                               class="btn btn-<?php echo ($group->status == 'active') ? 'secondary' : 'success'; ?> btn-sm" 
                                                               title="<?php echo ($group->status == 'active') ? lang('deactivate') : lang('activate'); ?>"
                                                               onclick="return confirm('<?php echo lang('are_you_sure'); ?>')">
                                                                <i class="fas fa-<?php echo ($group->status == 'active') ? 'pause' : 'play'; ?>"></i>
                                                            </a>
                                                            <a href="hospital/deleteGroup/<?php echo $group->id; ?>" 
                                                               class="btn btn-danger btn-sm" title="<?php echo lang('delete'); ?>"
                                                               onclick="return confirm('<?php echo lang('are_you_sure_delete'); ?>')">
                                                                <i class="fas fa-trash"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-4">
                                    <i class="fas fa-hospital-user fa-3x text-muted mb-3"></i>
                                    <h5 class="text-muted"><?php echo lang('no_hospital_groups_found'); ?></h5>
                                    <p class="text-muted"><?php echo lang('create_first_hospital_group'); ?></p>
                                    <a href="hospital/createGroup" class="btn btn-primary">
                                        <i class="fas fa-plus mr-1"></i><?php echo lang('create_new_group'); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    <?php if (!empty($groups)): ?>
    $('#groupsTable').DataTable({
        "responsive": true,
        "autoWidth": false,
        "order": [[4, "desc"]], // Sort by created date
        "columnDefs": [
            { "orderable": false, "targets": 6 } // Disable sorting for actions column
        ]
    });
    <?php endif; ?>
});
</script>