<!-- Group Overview -->
<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-info-circle mr-2"></i><?php echo lang('group_information'); ?>
                </h3>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <td width="200"><strong><?php echo lang('group_name'); ?>:</strong></td>
                        <td><?php echo htmlspecialchars($group->name); ?></td>
                    </tr>
                    <tr>
                        <td><strong><?php echo lang('description'); ?>:</strong></td>
                        <td><?php echo !empty($group->description) ? htmlspecialchars($group->description) : lang('no_description'); ?></td>
                    </tr>
                    <tr>
                        <td><strong><?php echo lang('created_by'); ?>:</strong></td>
                        <td><?php echo htmlspecialchars($group->created_by_name); ?></td>
                    </tr>
                    <tr>
                        <td><strong><?php echo lang('created_date'); ?>:</strong></td>
                        <td><?php echo date('M d, Y H:i A', strtotime($group->created_date)); ?></td>
                    </tr>
                    <tr>
                        <td><strong><?php echo lang('status'); ?>:</strong></td>
                        <td>
                            <?php if ($group->status == 'active'): ?>
                                <span class="badge badge-success"><?php echo lang('active'); ?></span>
                            <?php else: ?>
                                <span class="badge badge-secondary"><?php echo lang('inactive'); ?></span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td><strong><?php echo lang('total_hospitals'); ?>:</strong></td>
                        <td><span class="badge badge-primary"><?php echo count($group_hospitals); ?></span></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-chart-bar mr-2"></i><?php echo lang('sharing_statistics'); ?>
                </h3>
            </div>
            <div class="card-body">
                <div class="info-box">
                    <span class="info-box-icon bg-info"><i class="fas fa-users"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo lang('shared_patients'); ?></span>
                        <span class="info-box-number"><?php echo $sharing_stats['total_shared_patients']; ?></span>
                    </div>
                </div>
                
                <div class="info-box">
                    <span class="info-box-icon bg-success"><i class="fas fa-eye"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo lang('recent_access'); ?></span>
                        <span class="info-box-number"><?php echo $sharing_stats['recent_access_count']; ?></span>
                        <span class="progress-description"><?php echo lang('last_30_days'); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Hospitals in Group -->
<div class="row mt-3">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-hospital mr-2"></i><?php echo lang('hospitals_in_group'); ?>
                </h3>
            </div>
            <div class="card-body">
                <?php if (!empty($group_hospitals)): ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th><?php echo lang('hospital_name'); ?></th>
                                    <th><?php echo lang('email'); ?></th>
                                    <th><?php echo lang('phone'); ?></th>
                                    <th><?php echo lang('address'); ?></th>
                                    <th><?php echo lang('added_date'); ?></th>
                                    <th><?php echo lang('sharing_status'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count = 1; ?>
                                <?php foreach ($group_hospitals as $hospital): ?>
                                    <tr>
                                        <td><?php echo $count++; ?></td>
                                        <td>
                                            <strong><?php echo htmlspecialchars($hospital->name); ?></strong>
                                            <?php if (isset($hospital->allow_group_sharing) && $hospital->allow_group_sharing == 'no'): ?>
                                                <br><span class="badge badge-warning badge-sm"><?php echo lang('sharing_disabled'); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if (!empty($hospital->email)): ?>
                                                <i class="fas fa-envelope mr-1"></i><?php echo htmlspecialchars($hospital->email); ?>
                                            <?php else: ?>
                                                <span class="text-muted"><?php echo lang('not_provided'); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if (!empty($hospital->phone)): ?>
                                                <i class="fas fa-phone mr-1"></i><?php echo htmlspecialchars($hospital->phone); ?>
                                            <?php else: ?>
                                                <span class="text-muted"><?php echo lang('not_provided'); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if (!empty($hospital->address)): ?>
                                                <i class="fas fa-map-marker-alt mr-1"></i><?php echo htmlspecialchars($hospital->address); ?>
                                            <?php else: ?>
                                                <span class="text-muted"><?php echo lang('not_provided'); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if (!empty($hospital->added_date)): ?>
                                                <?php echo date('M d, Y', strtotime($hospital->added_date)); ?>
                                            <?php else: ?>
                                                <span class="text-muted"><?php echo lang('unknown'); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if (isset($hospital->allow_group_sharing) && $hospital->allow_group_sharing == 'yes'): ?>
                                                <span class="badge badge-success"><?php echo lang('enabled'); ?></span>
                                            <?php elseif (isset($hospital->allow_group_sharing) && $hospital->allow_group_sharing == 'no'): ?>
                                                <span class="badge badge-warning"><?php echo lang('disabled'); ?></span>
                                            <?php else: ?>
                                                <span class="badge badge-info"><?php echo lang('default'); ?></span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="text-center py-4">
                        <i class="fas fa-hospital fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted"><?php echo lang('no_hospitals_in_group'); ?></h5>
                        <p class="text-muted"><?php echo lang('hospitals_needed_for_sharing'); ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Group Sharing Activity (if any) -->
<?php if ($sharing_stats['recent_access_count'] > 0): ?>
<div class="row mt-3">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-history mr-2"></i><?php echo lang('recent_sharing_activity'); ?>
                </h3>
            </div>
            <div class="card-body">
                <div class="alert alert-info">
                    <i class="fas fa-info-circle mr-2"></i>
                    <?php echo lang('recent_activity_description'); ?>
                </div>
                <div id="sharing-activity" class="timeline">
                    <!-- Sharing activity will be loaded via AJAX if needed -->
                    <div class="text-center">
                        <button type="button" class="btn btn-outline-primary" onclick="loadSharingActivity(<?php echo $group->id; ?>)">
                            <i class="fas fa-sync mr-1"></i><?php echo lang('load_activity'); ?>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<script>
function loadSharingActivity(groupId) {
    $.ajax({
        url: 'hospital/getSharingLog/' + groupId,
        type: 'GET',
        dataType: 'json',
        beforeSend: function() {
            $('#sharing-activity').html('<div class="text-center"><i class="fas fa-spinner fa-spin"></i> <?php echo lang("loading"); ?>...</div>');
        },
        success: function(logs) {
            if (logs && logs.length > 0) {
                var html = '';
                logs.forEach(function(log) {
                    html += '<div class="time-label">';
                    html += '<span class="bg-primary">' + log.access_date + '</span>';
                    html += '</div>';
                    html += '<div>';
                    html += '<i class="fas fa-user bg-info"></i>';
                    html += '<div class="timeline-item">';
                    html += '<span class="time"><i class="fas fa-clock"></i> ' + log.access_date + '</span>';
                    html += '<h3 class="timeline-header">' + log.accessing_hospital + '</h3>';
                    html += '<div class="timeline-body">';
                    html += 'Accessed patient <strong>' + log.patient_name + '</strong> from ' + log.owner_hospital;
                    html += '<br><small class="text-muted">User: ' + log.username + ' | Action: ' + log.action + '</small>';
                    html += '</div>';
                    html += '</div>';
                    html += '</div>';
                });
                html += '<div><i class="fas fa-clock bg-gray"></i></div>';
                $('#sharing-activity').html(html);
            } else {
                $('#sharing-activity').html('<div class="alert alert-info"><?php echo lang("no_recent_activity"); ?></div>');
            }
        },
        error: function() {
            $('#sharing-activity').html('<div class="alert alert-danger"><?php echo lang("error_loading_activity"); ?></div>');
        }
    });
}
</script>