<div class="content-wrapper">
    <!-- Content Header -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark"><i class="fas fa-edit mr-2"></i><?php echo lang('edit_hospital_group'); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="home"><?php echo lang('home'); ?></a></li>
                        <li class="breadcrumb-item"><a href="hospital/groups"><?php echo lang('hospital_groups'); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo lang('edit_group'); ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-8 offset-lg-2">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-hospital-user mr-2"></i><?php echo lang('edit_hospital_group'); ?>: <?php echo $group->name; ?>
                            </h3>
                        </div>
                        <div class="card-body">
                            <?php echo validation_errors('<div class="alert alert-danger">', '</div>'); ?>
                            
                            <form action="hospital/updateGroup" method="post" id="groupForm">
                                <input type="hidden" name="group_id" value="<?php echo $group->id; ?>">
                                
                                <!-- Group Basic Information -->
                                <div class="form-group">
                                    <label for="group_name"><?php echo lang('group_name'); ?> <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="group_name" name="group_name" 
                                           value="<?php echo $group->name; ?>" 
                                           placeholder="<?php echo lang('enter_group_name'); ?>" required>
                                </div>

                                <div class="form-group">
                                    <label for="description"><?php echo lang('description'); ?></label>
                                    <textarea class="form-control" id="description" name="description" rows="3" 
                                              placeholder="<?php echo lang('enter_group_description'); ?>"><?php echo $group->description; ?></textarea>
                                </div>

                                <!-- Hospital Selection -->
                                <div class="form-group">
                                    <label><?php echo lang('select_hospitals'); ?> <span class="text-danger">*</span></label>
                                    <div class="card">
                                        <div class="card-body" style="max-height: 300px; overflow-y: auto;">
                                            <?php if (!empty($hospitals)): ?>
                                                <?php 
                                                $selected_hospital_ids = array();
                                                if (!empty($group_hospitals)) {
                                                    foreach ($group_hospitals as $gh) {
                                                        $selected_hospital_ids[] = $gh->hospital_id;
                                                    }
                                                }
                                                ?>
                                                <?php foreach ($hospitals as $hospital): ?>
                                                    <div class="form-check mb-2">
                                                        <input class="form-check-input" type="checkbox" 
                                                               name="hospitals[]" value="<?php echo $hospital->id; ?>" 
                                                               id="hospital_<?php echo $hospital->id; ?>"
                                                               <?php echo in_array($hospital->id, $selected_hospital_ids) ? 'checked' : ''; ?>>
                                                        <label class="form-check-label d-flex justify-content-between align-items-center w-100" 
                                                               for="hospital_<?php echo $hospital->id; ?>">
                                                            <div>
                                                                <strong><?php echo $hospital->name; ?></strong>
                                                                <br>
                                                                <small class="text-muted">
                                                                    <i class="fas fa-envelope mr-1"></i><?php echo $hospital->email; ?>
                                                                    <i class="fas fa-phone ml-3 mr-1"></i><?php echo $hospital->phone; ?>
                                                                </small>
                                                            </div>
                                                            <span class="badge badge-<?php echo $hospital->allow_group_sharing == 'yes' ? 'success' : 'warning'; ?>">
                                                                <?php echo $hospital->allow_group_sharing == 'yes' ? lang('sharing_enabled') : lang('sharing_disabled'); ?>
                                                            </span>
                                                        </label>
                                                    </div>
                                                <?php endforeach; ?>
                                            <?php else: ?>
                                                <div class="alert alert-info">
                                                    <i class="fas fa-info-circle mr-2"></i><?php echo lang('no_hospitals_available'); ?>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <small class="form-text text-muted">
                                        <i class="fas fa-info-circle mr-1"></i><?php echo lang('select_hospitals_help'); ?>
                                    </small>
                                </div>

                                <!-- Form Actions -->
                                <div class="form-group text-right">
                                    <a href="hospital/groups" class="btn btn-secondary mr-2">
                                        <i class="fas fa-arrow-left mr-1"></i><?php echo lang('cancel'); ?>
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save mr-1"></i><?php echo lang('update_group'); ?>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    // Form validation
    $('#groupForm').validate({
        rules: {
            group_name: {
                required: true,
                minlength: 3,
                maxlength: 255
            },
            'hospitals[]': {
                required: true,
                minlength: 2
            }
        },
        messages: {
            group_name: {
                required: "<?php echo lang('group_name_required'); ?>",
                minlength: "<?php echo lang('group_name_minlength'); ?>",
                maxlength: "<?php echo lang('group_name_maxlength'); ?>"
            },
            'hospitals[]': {
                required: "<?php echo lang('select_hospitals_required'); ?>",
                minlength: "<?php echo lang('select_min_hospitals'); ?>"
            }
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
});
</script>