<div class="content-wrapper">
    <!-- Content Header -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark"><i class="fas fa-plus-circle mr-2"></i><?php echo lang('create_hospital_group'); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="home"><?php echo lang('home'); ?></a></li>
                        <li class="breadcrumb-item"><a href="hospital/groups"><?php echo lang('hospital_groups'); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo lang('create_group'); ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-8 offset-lg-2">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-hospital-user mr-2"></i><?php echo lang('new_hospital_group'); ?>
                            </h3>
                        </div>
                        <div class="card-body">
                            <?php echo validation_errors('<div class="alert alert-danger">', '</div>'); ?>
                            
                            <form action="hospital/addNewGroup" method="post" id="groupForm">
                                <!-- Group Basic Information -->
                                <div class="form-group">
                                    <label for="group_name"><?php echo lang('group_name'); ?> <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="group_name" name="group_name" 
                                           value="<?php echo set_value('group_name'); ?>" 
                                           placeholder="<?php echo lang('enter_group_name'); ?>" required>
                                    <small class="form-text text-muted"><?php echo lang('group_name_help'); ?></small>
                                </div>

                                <div class="form-group">
                                    <label for="description"><?php echo lang('description'); ?></label>
                                    <textarea class="form-control" id="description" name="description" rows="3" 
                                              placeholder="<?php echo lang('enter_group_description'); ?>"><?php echo set_value('description'); ?></textarea>
                                    <small class="form-text text-muted"><?php echo lang('group_description_help'); ?></small>
                                </div>

                                <!-- Hospital Selection -->
                                <div class="form-group">
                                    <label><?php echo lang('select_hospitals'); ?> <span class="text-danger">*</span></label>
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle mr-2"></i>
                                        <?php echo lang('hospital_selection_help'); ?>
                                    </div>
                                    
                                    <?php if (!empty($hospitals)): ?>
                                        <div class="row">
                                            <?php foreach ($hospitals as $hospital): ?>
                                                <div class="col-md-6 mb-2">
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" 
                                                               id="hospital_<?php echo $hospital->id; ?>" 
                                                               name="hospitals[]" value="<?php echo $hospital->id; ?>"
                                                               <?php echo (in_array($hospital->id, (array)set_value('hospitals', array()))) ? 'checked' : ''; ?>>
                                                        <label class="custom-control-label" for="hospital_<?php echo $hospital->id; ?>">
                                                            <strong><?php echo htmlspecialchars($hospital->name); ?></strong>
                                                            <br>
                                                            <small class="text-muted">
                                                                <?php if (!empty($hospital->email)): ?>
                                                                    <i class="fas fa-envelope mr-1"></i><?php echo htmlspecialchars($hospital->email); ?>
                                                                <?php endif; ?>
                                                                <?php if (!empty($hospital->phone)): ?>
                                                                    <br><i class="fas fa-phone mr-1"></i><?php echo htmlspecialchars($hospital->phone); ?>
                                                                <?php endif; ?>
                                                                <?php if ($hospital->allow_group_sharing == 'no'): ?>
                                                                    <br><span class="badge badge-warning"><?php echo lang('sharing_disabled'); ?></span>
                                                                <?php endif; ?>
                                                            </small>
                                                        </label>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                        
                                        <div class="mt-3">
                                            <button type="button" class="btn btn-outline-primary btn-sm" id="selectAllHospitals">
                                                <i class="fas fa-check-double mr-1"></i><?php echo lang('select_all'); ?>
                                            </button>
                                            <button type="button" class="btn btn-outline-secondary btn-sm ml-2" id="deselectAllHospitals">
                                                <i class="fas fa-times mr-1"></i><?php echo lang('deselect_all'); ?>
                                            </button>
                                        </div>
                                    <?php else: ?>
                                        <div class="alert alert-warning">
                                            <i class="fas fa-exclamation-triangle mr-2"></i>
                                            <?php echo lang('no_hospitals_available'); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <!-- Action Buttons -->
                                <div class="form-group mt-4">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save mr-2"></i><?php echo lang('create_group'); ?>
                                    </button>
                                    <a href="hospital/groups" class="btn btn-secondary ml-2">
                                        <i class="fas fa-arrow-left mr-2"></i><?php echo lang('back_to_groups'); ?>
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    // Select/Deselect all hospitals
    $('#selectAllHospitals').click(function() {
        $('input[name="hospitals[]"]').prop('checked', true);
    });
    
    $('#deselectAllHospitals').click(function() {
        $('input[name="hospitals[]"]').prop('checked', false);
    });
    
    // Form validation
    $('#groupForm').on('submit', function(e) {
        var selectedHospitals = $('input[name="hospitals[]"]:checked').length;
        if (selectedHospitals < 2) {
            e.preventDefault();
            Swal.fire({
                icon: 'warning',
                title: '<?php echo lang("validation_error"); ?>',
                text: '<?php echo lang("select_at_least_two_hospitals"); ?>',
                confirmButtonText: '<?php echo lang("ok"); ?>'
            });
            return false;
        }
    });
});
</script>