<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Hospital_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function hospitalId() {
        if (!$this->ion_auth->in_group(array('superadmin'))) {
            if ($this->ion_auth->in_group(array('admin'))) {
                $current_user_id = $this->ion_auth->user()->row()->id;
                $hospital_id = $this->db->get_where('hospital', array('ion_user_id' => $current_user_id))->row()->id;
                return $hospital_id;
            } else {
                $current_user_id = $this->ion_auth->user()->row()->id;
                $group_id = $this->db->get_where('users_groups', array('user_id' => $current_user_id))->row()->group_id;
                $group_name = $this->db->get_where('groups', array('id' => $group_id))->row()->name;
                $group_name = strtolower($group_name);
                $hospital_id = $this->db->get_where($group_name, array('ion_user_id' => $current_user_id))->row()->hospital_id;
                return $hospital_id;
            }
        }
    }

    function modules() {
        if (!$this->ion_auth->in_group(array('superadmin'))) {
            if ($this->ion_auth->in_group(array('admin'))) {
                $current_user_id = $this->ion_auth->user()->row()->id;
                $modules = $this->db->get_where('hospital', array('ion_user_id' => $current_user_id))->row()->module;
                $module = explode(',', $modules);
                return $module;
            } else {
                $current_user_id = $this->ion_auth->user()->row()->id;
                $group_id = $this->db->get_where('users_groups', array('user_id' => $current_user_id))->row()->group_id;
                $group_name = $this->db->get_where('groups', array('id' => $group_id))->row()->name;
                $group_name = strtolower($group_name);
                $hospital_id = $this->db->get_where($group_name, array('ion_user_id' => $current_user_id))->row()->hospital_id;
                $modules = $this->db->get_where('hospital', array('id' => $hospital_id))->row()->module;
                $module = explode(',', $modules);
                return $module;
            }
        }
    }

    function addHospitalIdToIonUser($ion_user_id, $hospital_id) {
        $hospital_ion_id = $this->db->get_where('hospital', array('id' => $hospital_id))->row()->ion_user_id;
        $uptade_ion_user = array(
            'hospital_ion_id' => $hospital_ion_id,
        );
        $this->db->where('id', $ion_user_id);
        $this->db->update('users', $uptade_ion_user);
    }

    function insertHospital($data) {
        $this->db->insert('hospital', $data);
    }

    function getHospital() {
        $query = $this->db->get('hospital');
        return $query->result();
    }

    function getHospitalById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('hospital');
        return $query->row();
    }

    function updateHospital($id, $data) {

        $this->db->where('id', $id);
        $this->db->update('hospital', $data);
    }

    function updateHospitalByIonId($id, $data) {
        $this->db->where('ion_user_id', $id);
        $this->db->update('hospital', $data);
    }

    function activate($id, $data) {
        $this->db->where('id', $id);
        $this->db->or_where('hospital_ion_id', $id);
        $this->db->update('users', $data);
    }

    function deactivate($id, $data) {
        $this->db->where('hospital_ion_id', $id);
        $this->db->or_where('id', $id);
        $this->db->update('users', $data);
    }

    function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete('hospital');
    }

    function updateIonUser($username, $email, $password, $ion_user_id) {
        $uptade_ion_user = array(
            'username' => $username,
            'email' => $email,
            'password' => $password
        );
        $this->db->where('id', $ion_user_id);
        $this->db->update('users', $uptade_ion_user);
    }

    function getHospitalId($current_user_id) {
        $group_id = $this->db->get_where('users_groups', array('user_id' => $current_user_id))->row()->group_id;
        $group_name = $this->db->get_where('groups', array('id' => $group_id))->row()->name;
        $group_name = strtolower($group_name);
        $hospital_id = $this->db->get_where($group_name, array('ion_user_id' => $current_user_id))->row()->hospital_id;
        return $hospital_id;
    }

    function createAutoSmsTemplate($hospital_id) {
        $data = array();
        $data = array('0' => array(
                'name' => 'Payment successful sms to patient',
                'message' => 'Dear {name}, Your paying amount - Tk {amount} was successful. Thank You Please contact our support for further queries.',
                'type' => 'payment',
                'status' => 'Active',
            ),
            '1' => array(
                'name' => 'Appointment Confirmation sms to patient',
                'message' => 'Dear {name}, Your appointment with {doctorname} on {appoinmentdate} at {time_slot} is confirmed. For more information contact with {hospital_name} Regards',
                'type' => 'appoinment_confirmation',
                'status' => 'Active',
            ),
            '2' => array(
                'name' => 'Appointment creation sms to patient',
                'message' => 'Dear {name}, You have an appointment with {doctorname} on {appoinmentdate} at {time_slot} .Please confirm your appointment. For more information contact with {hospital_name} Regards',
                'type' => 'appoinment_creation',
                'status' => 'Active',
            ),
            '3' => array(
                'name' => 'Meeting Schedule Notification To Patient',
                'message' => 'Dear {patient_name}, You have a Live Video Meeting with {doctor_name} on {start_time}. For more information contact with {hospital_name} . Regards',
                'type' => 'meeting_creation',
                'status' => 'Active',
            ),
            '4' => array(
                'name' => 'send appoint confirmation to Doctor',
                'message' => 'Dear {name}, You are appointed as a doctor in {department} . Thank You {company}',
                'type' => 'doctor',
                'status' => 'Active',
            ),
            '5' => array(
                'name' => 'Patient Registration Confirmation',
                'message' => 'Dear {name}, You are registred to {company} as a patient to {doctor}. Regards',
                'type' => 'patient',
                'status' => 'Active',
        ),'6' => array(
                'name' => 'Appointment Remainder sms to patient',
                'message' => 'Dear {name}, REMAINDER!!<br> You have an appointment with {doctorname} on {appoinmentdate} at {time_slot} . For more information contact with {hospital_name} Regards',
                'type' => 'appoinment_remainder',
                'status' => 'Active',
            )
            );

        foreach ($data as $row) {
            $data1 = array();
            $data1 = array(
                'name' => $row['name'],
                'message' => $row['message'],
                'type' => $row['type'],
                'status' => $row['status'],
                'hospital_id' => $hospital_id
            );
            $this->db->insert('autosmstemplate', $data1);
        }
    }

    function createAutoEmailTemplate($hospital_id) {
        $data = array();
        $data = array('0' => array(
                'name' => 'Payment successful email to patient',
                'message' => 'Dear {name}, Your paying amount - Tk {amount} was successful. Thank You Please contact our support for further queries.',
                'type' => 'payment',
                'status' => 'Active',
            ),
            '1' => array(
                'name' => 'Appointment Confirmation email to patient',
                'message' => 'Dear {name}, Your appointment with {doctorname} on {appoinmentdate} at {time_slot} is confirmed. For more information contact with {hospital_name} Regards',
                'type' => 'appoinment_confirmation',
                'status' => 'Active',
            ),
            '2' => array(
                'name' => 'Appointment creation email to patient',
                'message' => 'Dear {name}, You have an appointment with {doctorname} on {appoinmentdate} at {time_slot} .Please confirm your appointment. For more information contact with {hospital_name} Regards',
                'type' => 'appoinment_creation',
                'status' => 'Active',
            ),
            '3' => array(
                'name' => 'Meeting Schedule Notification To Patient',
                'message' => 'Dear {patient_name}, You have a Live Video Meeting with {doctor_name} on {start_time}. For more information contact with {hospital_name} . Regards',
                'type' => 'meeting_creation',
                'status' => 'Active',
            ),
            '4' => array(
                'name' => 'Send Appointment confirmation to Doctor',
                'message' => 'Dear {name},<br> You are registered to {company} as a New Doctor in {department}.<br><br> Your Details:<br> Url Link: {base_url}<br> Username : {email}<br> Password: {password}<br><br> Thank You for registration.<br> Regards',
                'type' => 'doctor',
                'status' => 'Active',
            ),
            '5' => array(
                'name' => 'Patient Registration Confirmation',
                'message' => 'Dear {name},<br> You are registered to {company} as a New Patient to {doctor}.<br><br> Your Details:<br> Url Link: {base_url}<br> Username : {email}<br> Password: {password}<br><br> Thank You for registration.<br> Regards',
                'type' => 'patient',
                'status' => 'Active',
            ),
            '6' => array(
                'name' => 'Nurse Registration Confirmation',
                'message' => 'Dear {name},<br> You are registered to {company} as a New Nurse.<br><br> Your Details:<br> Url Link: {base_url}<br> Username : {email}<br> Password: {password}<br><br> Thank You for registration.<br> Regards',
                'type' => 'nurse',
                'status' => 'Active',
            ),
            '7' => array(
                'name' => 'Pharmacist Registration Confirmation',
                'message' => 'Dear {name},<br> You are registered to {company} as a New Pharmacist.<br><br> Your Details:<br> Url Link: {base_url}<br> Username : {email}<br> Password: {password}<br><br> Thank You for registration.<br> Regards',
                'type' => 'pharmacist',
                'status' => 'Active',
            ),
            '8' => array(
                'name' => 'Laboratorist Registration Confirmation',
                'message' => 'Dear {name},<br> You are registered to {company} as a New Laboratorist.<br><br> Your Details:<br> Url Link: {base_url}<br> Username : {email}<br> Password: {password}<br><br> Thank You for registration.<br> Regards',
                'type' => 'laboratorist',
                'status' => 'Active',
            ),
            '9' => array(
                'name' => 'Accountant Registration Confirmation',
                'message' => 'Dear {name},<br> You are registered to {company} as a New Accountant.<br><br> Your Details:<br> Url Link: {base_url}<br> Username : {email}<br> Password: {password}<br><br> Thank You for registration.<br> Regards',
                'type' => 'accountant',
                'status' => 'Active',
            ),
            '10' => array(
                'name' => 'Receptionist Registration Confirmation',
                'message' => 'Dear {name},<br> You are registered to {company} as a New Receptionist.<br><br> Your Details:<br> Url Link: {base_url}<br> Username : {email}<br> Password: {password}<br><br> Thank You for registration.<br> Regards',
                'type' => 'receptionist',
                'status' => 'Active',
            ),
            '11' => array(
                'name' => 'Appointment Remainder email to patient',
                'message' => 'Dear {name}, REMAINDER!!<br> You have an appointment with {doctorname} on {appoinmentdate} at {time_slot} . For more information contact with {hospital_name} Regards',
                'type' => 'appoinment_remainder',
                'status' => 'Active',
            ),
            '12' => array(
                'name' => 'Send Patient Appointment confirmation to Doctor',
                'message' => 'Dear {name}, <br> {patientname} creates a appointment  with you on {appoinmentdate} at {time_slot} . Please See details on your login panel. <br> Regards',
                'type' => 'appoinment_creation_to_doctor',
                'status' => 'Active',
            ),
            '13' => array(
                'name' => 'Appointment Cancellation',
                'message' => '<p>Dear {name}, Your appointment with {doctorname} on {appoinmentdate} at {time_slot} has been cancelled. For more information contact with {hospital_name} Regards</p>',
                'type' => 'appointment_cancel',
                'status' => 'Active',
            ),
            '14' => array(
                'name' => 'Appointment Update',
                'message' => '<p>Dear {name}, Your appointment with {doctorname} on {appoinmentdate} at {time_slot} has been updated. For more information contact with {hospital_name} Regards</p>',
                'type' => 'appointment_update',
                'status' => 'Active',
            ),
            '15' => array(
                'name' => 'Doctor Appointment Update',
                'message' => '<p>Dear {name}, Your appointment with {patientname} on {appoinmentdate} at {time_slot} has been updated. For more information contact with {hospital_name} Regards</p>',
                'type' => 'doctor_appointment_update',
                'status' => 'Active',
            )
            ,
            '16' => array(
                'name' => 'Doctor Appointment Cancellation',
                'message' => '<p>Dear {name}, Your appointment with {patientname} on {appoinmentdate} at {time_slot} has been cancelled. For more information contact with {hospital_name} Regards</p>',
                'type' => 'doctor_appointment_cancel',
                'status' => 'Active',
            )
        );

        foreach ($data as $row) {
            $data1 = array();
            $data1 = array(
                'name' => $row['name'],
                'message' => $row['message'],
                'type' => $row['type'],
                'status' => $row['status'],
                'hospital_id' => $hospital_id
            );
            $this->db->insert('autoemailtemplate', $data1);
        }
    }

    function getHospitalByIonId($id) {
        $this->db->where('ion_user_id', $id);
        $query = $this->db->get('hospital');
        return $query->row();
    }

    function getHospitalInfo($searchTerm) {
        if (!empty($searchTerm)) {
            $this->db->select('*');

            $this->db->where("name like '%" . $searchTerm . "%' OR id like '%" . $searchTerm . "%'");
            $fetched_records = $this->db->get('hospital');
            $users = $fetched_records->result_array();
        } else {
            $this->db->select('*');

            $this->db->limit(10);
            $fetched_records = $this->db->get('hospital');
            $users = $fetched_records->result_array();
        }

        $data = array();
        foreach ($users as $user) {
            $data[] = array("id" => $user['id'], "text" => $user['name'] . ' (' . lang('id') . ': ' . $user['id'] . ')');
        }
        return $data;
    }

    function addHospitalPayment($data) {
        $this->db->insert('hospital_payment', $data);
    }

    function addHospitalDeposit($data) {
        return $this->db->insert('hospital_deposit', $data);
    }

    function updateHospitalPayment($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('hospital_payment', $data);
    }

    function updateHospitalPaymentByHospitalId($id, $data) {
        $this->db->where('hospital_user_id', $id);
        $this->db->update('hospital_payment', $data);
    }

    function getHospitalPaymentByHospitalId($id) {
        $this->db->where('hospital_user_id', $id);
        return $this->db->get('hospital_payment')->row();
    }

    function getHospitalPaymentById($id) {
        $this->db->where('id', $id);
        return $this->db->get('hospital_payment')->row();
    }

    function thisMonthlyDepositCount() {

        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('m/Y', time()) == date('m/Y', $q->add_date_stamp)) {
                $hospital_payment = $this->db->get_where('hospital_payment', array('id' => $q->payment_id))->row();
                if ($hospital_payment->package_duration == 'monthly') {
                    $total[] = 1;
                }
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisYearlyDepositCount() {

        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('m/Y', time()) == date('m/Y', $q->add_date_stamp)) {
                $hospital_payment = $this->db->get_where('hospital_payment', array('id' => $q->payment_id))->row();
                if ($hospital_payment->package_duration == 'yearly') {
                    $total[] = 1;
                }
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function getPaymentPerMonthThisYear() {


        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('Y', time()) == date('Y', $q->add_date_stamp)) {

                if (date('m', $q->add_date_stamp) == '01') {
                    $total['january'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '02') {
                    $total['february'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '03') {
                    $total['march'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '04') {
                    $total['april'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '05') {
                    $total['may'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '06') {
                    $total['june'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '07') {
                    $total['july'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '08') {
                    $total['august'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '09') {
                    $total['september'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '10') {
                    $total['october'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '11') {
                    $total['november'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '12') {
                    $total['december'][] = $q->deposited_amount;
                }
            }
        }


        if (!empty($total['january'])) {
            $total['january'] = array_sum($total['january']);
        } else {
            $total['january'] = 0;
        }
        if (!empty($total['february'])) {
            $total['february'] = array_sum($total['february']);
        } else {
            $total['february'] = 0;
        }
        if (!empty($total['march'])) {
            $total['march'] = array_sum($total['march']);
        } else {
            $total['march'] = 0;
        }
        if (!empty($total['april'])) {
            $total['april'] = array_sum($total['april']);
        } else {
            $total['april'] = 0;
        }
        if (!empty($total['may'])) {
            $total['may'] = array_sum($total['may']);
        } else {
            $total['may'] = 0;
        }
        if (!empty($total['june'])) {
            $total['june'] = array_sum($total['june']);
        } else {
            $total['june'] = 0;
        }
        if (!empty($total['july'])) {
            $total['july'] = array_sum($total['july']);
        } else {
            $total['july'] = 0;
        }
        if (!empty($total['august'])) {
            $total['august'] = array_sum($total['august']);
        } else {
            $total['august'] = 0;
        }
        if (!empty($total['september'])) {
            $total['september'] = array_sum($total['september']);
        } else {
            $total['september'] = 0;
        }
        if (!empty($total['october'])) {
            $total['october'] = array_sum($total['october']);
        } else {
            $total['october'] = 0;
        }
        if (!empty($total['november'])) {
            $total['november'] = array_sum($total['november']);
        } else {
            $total['november'] = 0;
        }
        if (!empty($total['december'])) {
            $total['december'] = array_sum($total['december']);
        } else {
            $total['december'] = 0;
        }

        return $total;
    }

    function thisMonthlyDeposit() {

        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('m/Y', time()) == date('m/Y', $q->add_date_stamp)) {
                $hospital_payment = $this->db->get_where('hospital_payment', array('id' => $q->payment_id))->row();
                if ($hospital_payment->package_duration == 'monthly') {
                    $total[] = $q->deposited_amount;
                }
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisYearlyDeposit() {

        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('m/Y', time()) == date('m/Y', $q->add_date_stamp)) {
                $hospital_payment = $this->db->get_where('hospital_payment', array('id' => $q->payment_id))->row();
                if ($hospital_payment->package_duration == 'yearly') {
                    $total[] = $q->deposited_amount;
                }
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisDayMonthlyPayment() {

        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('d/m/Y', time()) == date('d/m/Y', $q->add_date_stamp)) {
                $hospital_payment = $this->db->get_where('hospital_payment', array('id' => $q->payment_id))->row();
                if ($hospital_payment->package_duration == 'monthly') {
                    $total[] = $q->deposited_amount;
                }
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisDayYearlyPayment() {

        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('d/m/Y', time()) == date('d/m/Y', $q->add_date_stamp)) {
                $hospital_payment = $this->db->get_where('hospital_payment', array('id' => $q->payment_id))->row();
                if ($hospital_payment->package_duration == 'yearly') {
                    $total[] = $q->deposited_amount;
                }
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisYearYearlyPayment() {

        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('Y', time()) == date('Y', $q->add_date_stamp)) {
                $hospital_payment = $this->db->get_where('hospital_payment', array('id' => $q->payment_id))->row();
                if (!empty($hospital_payment)) {
                    if ($hospital_payment->package_duration == 'yearly') {
                        $total[] = $q->deposited_amount;
                    }
                }
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisYearMonthlyPayment() {

        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('Y', time()) == date('Y', $q->add_date_stamp)) {
                $hospital_payment = $this->db->get_where('hospital_payment', array('id' => $q->payment_id))->row();
                if (!empty($hospital_payment)) {
                    if ($hospital_payment->package_duration == 'monthly') {
                        $total[] = $q->deposited_amount;
                    }
                }
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function getHospitalDepositById($id) {
        return $this->db->where('id', $id)->get('hospital_deposit')->row();
    }

    function getHospitalPaymentDeposits() {
        return $this->db->order_by('date', 'desc')->get('hospital_deposit')->result();
    }
    function getHospitalPaymentDepositsReportBySubscription($subscription) {
        if($subscription=='new'){
            return $this->db->order_by('date', 'desc')->where('deposited_amount_id')->get('hospital_deposit')->result();
        }else{
            return $this->db->order_by('date', 'desc')->where('deposited_amount_id IS NOT NULL')->get('hospital_deposit')->result();
        }
        
    }
    function getHospitalPaymentDepositsReport() {
        return $this->db->order_by('date', 'desc')->get('hospital_deposit')->result();
    }
    function getHospitalDepositByDate($date_from, $date_to) {
        return $this->db->order_by('date', 'desc')->where('add_date_stamp >=', $date_from)
                        ->where('add_date_stamp <=', $date_to)
                        ->get('hospital_deposit')->result();
    }
    function getHospitalDepositByDateBySubscription($date_from, $date_to,$subscription) {
        if($subscription=='new'){
            return $this->db->order_by('date', 'desc')
                            ->where('add_date_stamp >=', $date_from) 
                            ->where('add_date_stamp <=', $date_to)
                            ->where('deposited_amount_id')
                            ->get('hospital_deposit')->result();
           
        }else{
            return $this->db->order_by('date', 'desc')
                            ->where('add_date_stamp >=', $date_from) 
                            ->where('add_date_stamp <=', $date_to)
                            ->where('deposited_amount_id IS NOT NULL')
                            ->get('hospital_deposit')->result();
           
        } 
       
    }
 
    function getHospitalDepositByDateByCountry($date_from, $date_to, $country) {

        return $this->db->select("*")
                        ->order_by('date', 'desc')
                        ->where('add_date_stamp >=', $date_from)
                        ->where('add_date_stamp <=', $date_to)
                        ->from('hospital_deposit')
                        ->where('country', $country)
                        ->join('hospital', 'hospital_deposit.hospital_user_id = hospital.id')->get()->result();
    }
    function getHospitalDepositByDateByCountryBySubscription($date_from, $date_to, $country,$subscription) {

        if($subscription=='new'){
            return $this->db->select("*")
                        ->order_by('date', 'desc')
                        ->where('add_date_stamp >=', $date_from)
                        ->where('add_date_stamp <=', $date_to)
                        ->where('deposited_amount_id')
                        ->from('hospital_deposit')
                        ->where('country', $country)
                        ->join('hospital', 'hospital_deposit.hospital_user_id = hospital.id')->get()->result();
           
        }else{
            return $this->db->select("*")
            ->order_by('date', 'desc')
            ->where('add_date_stamp >=', $date_from)
            ->where('add_date_stamp <=', $date_to)
            ->where('deposited_amount_id IS NOT NULL')
            ->from('hospital_deposit')
            ->where('country', $country)
            ->join('hospital', 'hospital_deposit.hospital_user_id = hospital.id')->get()->result();
           
        } 
       
        
    }

    function getHospitalDepositByCountry($country) {
        return $this->db->select("*")
                        ->order_by('date', 'desc')
                        ->from('hospital_deposit')
                        ->where('country', $country)
                        ->join('hospital', 'hospital_deposit.hospital_user_id = hospital.id')->get()->result();
    }
    
    function getHospitalDepositByCountryBySubscription($country,$subscription) {
        if($subscription=='new'){
            return $this->db->select("*")
                        ->order_by('date', 'desc')
                        ->where('deposited_amount_id')
                        ->from('hospital_deposit')
                        ->where('country', $country)
                        ->join('hospital', 'hospital_deposit.hospital_user_id = hospital.id')->get()->result();
        }else{
            return $this->db->select("*")
                        ->order_by('date', 'desc')
                        ->where('deposited_amount_id IS NOT NULL')
                        ->from('hospital_deposit')
                        ->where('country', $country)
                        ->join('hospital', 'hospital_deposit.hospital_user_id = hospital.id')->get()->result();
        }
        
    }
    
    
    function getHospitalFromWebsite() {
        $this->db->where('from_where', 'Website');
        $query = $this->db->get('hospital');
        return $query->result();
    }
    
    function updateUsers($id, $data) {

        $this->db->where('id', $id);
        $this->db->update('users', $data);
    }
    
    // Hospital Groups Management Functions - All functionality moved from hospitalgroups module
    function createHospitalGroup($group_data, $hospital_ids = array())
    {
        $this->db->trans_start();
        
        // Insert group
        $this->db->insert('hospital_groups', $group_data);
        $group_id = $this->db->insert_id();
        
        // Add hospitals to group
        if (!empty($hospital_ids) && $group_id) {
            foreach ($hospital_ids as $hospital_id) {
                $member_data = array(
                    'group_id' => $group_id,
                    'hospital_id' => $hospital_id,
                    'added_by' => $this->session->userdata('user_id')
                );
                $this->db->insert('hospital_group_members', $member_data);
            }
        }
        
        $this->db->trans_complete();
        
        if ($this->db->trans_status() === FALSE) {
            return false;
        }
        
        return $group_id;
    }

    function getHospitalGroups()
    {
        $this->db->select('hg.*, u.username as created_by_name, COUNT(hgm.hospital_id) as hospital_count');
        $this->db->from('hospital_groups hg');
        $this->db->join('users u', 'hg.created_by = u.id', 'left');
        $this->db->join('hospital_group_members hgm', 'hg.id = hgm.group_id AND hgm.status = "active"', 'left');
        $this->db->group_by('hg.id');
        $this->db->order_by('hg.created_date', 'desc');
        $query = $this->db->get();
        return $query->result();
    }

    function getHospitalGroupById($group_id)
    {
        $this->db->select('hg.*, u.username as created_by_name');
        $this->db->from('hospital_groups hg');
        $this->db->join('users u', 'hg.created_by = u.id', 'left');
        $this->db->where('hg.id', $group_id);
        $query = $this->db->get();
        return $query->row();
    }

    function getAllActiveHospitals()
    {
        $this->db->select('id, name, email, phone, address, allow_group_sharing');
        $this->db->from('hospital');
        // Check if status column exists before filtering by it
        if ($this->db->field_exists('status', 'hospital')) {
            $this->db->where('status', 'active');
        }
        $this->db->order_by('name', 'asc');
        $query = $this->db->get();
        return $query->result();
    }

    function getGroupHospitals($group_id)
    {
        $this->db->select('hgm.*, h.name, h.email, h.phone');
        $this->db->from('hospital_group_members hgm');
        $this->db->join('hospital h', 'hgm.hospital_id = h.id');
        $this->db->where('hgm.group_id', $group_id);
        $this->db->where('hgm.status', 'active');
        $query = $this->db->get();
        return $query->result();
    }

    function getGroupHospitalsWithDetails($group_id)
    {
        $this->db->select('h.*, hgm.added_date, hgm.status as membership_status');
        $this->db->from('hospital h');
        $this->db->join('hospital_group_members hgm', 'h.id = hgm.hospital_id');
        $this->db->where('hgm.group_id', $group_id);
        $this->db->where('hgm.status', 'active');
        $this->db->order_by('h.name', 'asc');
        $query = $this->db->get();
        return $query->result();
    }

    function updateHospitalGroup($group_id, $group_data, $hospital_ids = array())
    {
        $this->db->trans_start();
        
        // Update group data
        $this->db->where('id', $group_id);
        $this->db->update('hospital_groups', $group_data);
        
        // Remove existing hospital associations
        $this->db->where('group_id', $group_id);
        $this->db->delete('hospital_group_members');
        
        // Add new hospital associations
        if (!empty($hospital_ids)) {
            foreach ($hospital_ids as $hospital_id) {
                $member_data = array(
                    'group_id' => $group_id,
                    'hospital_id' => $hospital_id,
                    'added_by' => $this->session->userdata('user_id')
                );
                $this->db->insert('hospital_group_members', $member_data);
            }
        }
        
        $this->db->trans_complete();
        
        return $this->db->trans_status() !== FALSE;
    }

    function deleteHospitalGroup($group_id)
    {
        $this->db->trans_start();
        
        // Delete group members first (due to foreign key)
        $this->db->where('group_id', $group_id);
        $this->db->delete('hospital_group_members');
        
        // Delete sharing permissions
        $this->db->where('group_id', $group_id);
        $this->db->delete('patient_sharing_permissions');
        
        // Delete sharing logs
        $this->db->where('group_id', $group_id);
        $this->db->delete('hospital_sharing_log');
        
        // Delete the group
        $this->db->where('id', $group_id);
        $this->db->delete('hospital_groups');
        
        $this->db->trans_complete();
        
        return $this->db->trans_status() !== FALSE;
    }

    function updateGroupStatus($group_id, $status)
    {
        $this->db->where('id', $group_id);
        $this->db->update('hospital_groups', array('status' => $status));
        return $this->db->affected_rows() > 0;
    }

    function getGroupSharingStats($group_id)
    {
        // Get total shared patients in this group
        $this->db->select('COUNT(DISTINCT patient_id) as total_shared_patients');
        $this->db->from('patient_sharing_permissions');
        $this->db->where('group_id', $group_id);
        $this->db->where('status', 'active');
        $query1 = $this->db->get();
        $shared_patients = $query1->row()->total_shared_patients;

        // Get recent access count
        $this->db->select('COUNT(*) as recent_access_count');
        $this->db->from('hospital_sharing_log');
        $this->db->where('group_id', $group_id);
        $this->db->where('access_date >', date('Y-m-d H:i:s', strtotime('-30 days')));
        $query2 = $this->db->get();
        $recent_access = $query2->row()->recent_access_count;

        return array(
            'total_shared_patients' => $shared_patients,
            'recent_access_count' => $recent_access
        );
    }

    function getGroupSharingLogs($group_id, $limit = 50)
    {
        $this->db->select('hsl.*, h1.name as accessing_hospital, h2.name as owner_hospital, p.name as patient_name, u.username');
        $this->db->from('hospital_sharing_log hsl');
        $this->db->join('hospital h1', 'hsl.hospital_id = h1.id');
        $this->db->join('hospital h2', 'hsl.owner_hospital_id = h2.id');
        $this->db->join('patient p', 'hsl.patient_id = p.id');
        $this->db->join('users u', 'hsl.user_id = u.id');
        $this->db->where('hsl.group_id', $group_id);
        $this->db->order_by('hsl.access_date', 'desc');
        $this->db->limit($limit);
        $query = $this->db->get();
        return $query->result();
    }

    function createAutomaticSharingPermissions($group_id)
    {
        // Get all hospitals in this group
        $hospitals = $this->getGroupHospitals($group_id);
        
        // Get all patients from all hospitals in group
        foreach ($hospitals as $owner_hospital) {
            $this->db->select('id');
            $this->db->from('patient');
            $this->db->where('hospital_id', $owner_hospital->hospital_id);
            $patients_query = $this->db->get();
            $patients = $patients_query->result();
            
            // Share with all other hospitals in group
            foreach ($hospitals as $shared_hospital) {
                if ($owner_hospital->hospital_id != $shared_hospital->hospital_id) {
                    foreach ($patients as $patient) {
                        // Check if permission already exists
                        $this->db->where('patient_id', $patient->id);
                        $this->db->where('shared_with_hospital_id', $shared_hospital->hospital_id);
                        $existing = $this->db->get('patient_sharing_permissions');
                        
                        if ($existing->num_rows() == 0) {
                            $permission_data = array(
                                'patient_id' => $patient->id,
                                'owner_hospital_id' => $owner_hospital->hospital_id,
                                'shared_with_hospital_id' => $shared_hospital->hospital_id,
                                'group_id' => $group_id,
                                'permission_level' => 'read_write'
                            );
                            $this->db->insert('patient_sharing_permissions', $permission_data);
                        }
                    }
                }
            }
        }
    }

    // Additional hospital group sharing functions
    function getSharedHospitals($hospital_id)
    {
        $this->db->select('DISTINCT h.id, h.name');
        $this->db->from('hospital h');
        $this->db->join('hospital_group_members hgm1', 'h.id = hgm1.hospital_id');
        $this->db->join('hospital_group_members hgm2', 'hgm1.group_id = hgm2.group_id');
        $this->db->join('hospital_groups hg', 'hgm1.group_id = hg.id');
        $this->db->where('hgm2.hospital_id', $hospital_id);
        $this->db->where('h.id !=', $hospital_id);
        $this->db->where('hgm1.status', 'active');
        $this->db->where('hgm2.status', 'active');
        $this->db->where('hg.status', 'active');
        // Check if allow_group_sharing column exists before filtering by it
        if ($this->db->field_exists('allow_group_sharing', 'hospital')) {
            $this->db->where('h.allow_group_sharing', 'yes');
        }
        $query = $this->db->get();
        return $query->result();
    }

    function areHospitalsInSameGroup($hospital1_id, $hospital2_id)
    {
        $this->db->select('COUNT(*) as count');
        $this->db->from('hospital_group_members hgm1');
        $this->db->join('hospital_group_members hgm2', 'hgm1.group_id = hgm2.group_id');
        $this->db->join('hospital_groups hg', 'hgm1.group_id = hg.id');
        $this->db->where('hgm1.hospital_id', $hospital1_id);
        $this->db->where('hgm2.hospital_id', $hospital2_id);
        $this->db->where('hgm1.status', 'active');
        $this->db->where('hgm2.status', 'active');
        $this->db->where('hg.status', 'active');
        $query = $this->db->get();
        return $query->row()->count > 0;
    }

    function logSharingActivity($hospital_id, $patient_id, $owner_hospital_id, $group_id, $action = 'view')
    {
        $log_data = array(
            'hospital_id' => $hospital_id,
            'patient_id' => $patient_id,
            'owner_hospital_id' => $owner_hospital_id,
            'group_id' => $group_id,
            'user_id' => $this->session->userdata('user_id'),
            'action' => $action,
            'ip_address' => $this->input->ip_address(),
            'user_agent' => substr($this->input->user_agent(), 0, 500)
        );
        
        $this->db->insert('hospital_sharing_log', $log_data);
        return $this->db->affected_rows() > 0;
    }

    function canAccessPatient($hospital_id, $patient_id)
    {
        // Get patient's hospital
        $this->db->select('hospital_id');
        $this->db->from('patient');
        $this->db->where('id', $patient_id);
        $query = $this->db->get();
        
        if ($query->num_rows() == 0) {
            return false;
        }
        
        $patient_hospital_id = $query->row()->hospital_id;
        
        // If same hospital, allow access
        if ($hospital_id == $patient_hospital_id) {
            return true;
        }
        
        // Check if hospitals are in same group
        return $this->areHospitalsInSameGroup($hospital_id, $patient_hospital_id);
    }

    function getAccessiblePatients($hospital_id)
    {
        // Get all hospitals in same groups as current hospital
        $shared_hospitals = $this->getSharedHospitals($hospital_id);
        $hospital_ids = array($hospital_id); // Include own hospital
        
        foreach ($shared_hospitals as $hospital) {
            $hospital_ids[] = $hospital->id;
        }
        
        // Get patients from all accessible hospitals
        $this->db->select('p.*, h.name as hospital_name, 
                          CASE WHEN p.hospital_id = ' . $hospital_id . ' THEN "own" ELSE "shared" END as access_type');
        $this->db->from('patient p');
        $this->db->join('hospital h', 'p.hospital_id = h.id');
        $this->db->where_in('p.hospital_id', $hospital_ids);
        // Check if allow_group_sharing column exists before filtering by it
        if ($this->db->field_exists('allow_group_sharing', 'hospital')) {
            $this->db->where('h.allow_group_sharing', 'yes');
        }
        $this->db->order_by('p.name', 'asc');
        $query = $this->db->get();
        
        return $query->result();
    }

    function getGroupForHospitals($hospital1_id, $hospital2_id)
    {
        $this->db->select('hg.id, hg.name');
        $this->db->from('hospital_groups hg');
        $this->db->join('hospital_group_members hgm1', 'hg.id = hgm1.group_id');
        $this->db->join('hospital_group_members hgm2', 'hg.id = hgm2.group_id');
        $this->db->where('hgm1.hospital_id', $hospital1_id);
        $this->db->where('hgm2.hospital_id', $hospital2_id);
        $this->db->where('hgm1.status', 'active');
        $this->db->where('hgm2.status', 'active');
        $this->db->where('hg.status', 'active');
        $this->db->limit(1);
        $query = $this->db->get();
        
        return $query->row();
    }

    function getTotalSharedPatients()
    {
        $this->db->select('COUNT(DISTINCT patient_id) as total');
        $this->db->from('patient_sharing_permissions');
        $this->db->where('status', 'active');
        $query = $this->db->get();
        return $query->row()->total;
    }

    function getRecentSharingActivities($limit = 20)
    {
        $this->db->select('hsl.*, h1.name as accessing_hospital, h2.name as owner_hospital, p.name as patient_name, u.username, hg.name as group_name');
        $this->db->from('hospital_sharing_log hsl');
        $this->db->join('hospital h1', 'hsl.hospital_id = h1.id');
        $this->db->join('hospital h2', 'hsl.owner_hospital_id = h2.id');
        $this->db->join('patient p', 'hsl.patient_id = p.id');
        $this->db->join('users u', 'hsl.user_id = u.id');
        $this->db->join('hospital_groups hg', 'hsl.group_id = hg.id');
        $this->db->order_by('hsl.access_date', 'desc');
        $this->db->limit($limit);
        $query = $this->db->get();
        return $query->result();
    }
        function insertAdmin($data) {
        $this->db->insert('admin', $data);
    }
        function deleteAdminByHospitalId($id)
    {
        $this->db->where('hospital_id', $id);
        $this->db->delete('admin');
    }
}
