<!DOCTYPE html>
<html>
<head>
    <title>Google Calendar Integration Test</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f8f9fa;
        }
        .container {
            background-color: #fff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-top: 20px;
        }
        .btn {
            background-color: #4285f4;
            color: white;
            padding: 12px 24px;
            text-decoration: none;
            border-radius: 4px;
            display: inline-block;
            margin: 10px 5px;
            border: none;
            cursor: pointer;
            font-size: 16px;
        }
        .btn:hover {
            background-color: #3367d6;
        }
        .btn-disconnect {
            background-color: #dc3545;
        }
        .btn-disconnect:hover {
            background-color: #c82333;
        }
        .btn-secondary {
            background-color: #6c757d;
        }
        .btn-secondary:hover {
            background-color: #545b62;
        }
        .status {
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
            text-align: center;
        }
        .connected {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .disconnected {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .success-message {
            background-color: #d4edda;
            color: #155724;
            padding: 15px;
            border-radius: 5px;
            border: 1px solid #c3e6cb;
            margin: 15px 0;
        }
        .info-box {
            background-color: #e2e3e5;
            border-left: 4px solid #6c757d;
            padding: 15px;
            margin: 20px 0;
        }
        h1, h2, h3 {
            color: #333;
        }
        code {
            background-color: #f8f9fa;
            padding: 2px 4px;
            border-radius: 3px;
            font-family: monospace;
        }
    </style>
</head>
<body>
    <h1>📅 Google Calendar Integration</h1>
    
    <div class="container">
        <?php if (!empty($success_message)): ?>
            <div class="success-message">
                <?php echo htmlspecialchars($success_message); ?>
            </div>
        <?php endif; ?>
        
        <h2>🔗 Connection Status</h2>
        <?php if ($is_connected): ?>
            <div class="status connected">
                <h3>✅ Connected to Google Calendar</h3>
                <p>Your appointments will automatically appear in your Google Calendar.</p>
            </div>
        <?php else: ?>
            <div class="status disconnected">
                <h3>❌ Not connected to Google Calendar</h3>
                <p>You need to connect your Google Calendar to automatically sync appointments.</p>
            </div>
        <?php endif; ?>
        
        <div style="text-align: center; margin: 20px 0;">
            <?php if ($is_connected): ?>
                <a href="<?php echo base_url('google_auth/disconnect'); ?>" class="btn btn-disconnect" 
                   onclick="return confirm('Are you sure you want to disconnect from Google Calendar?')">
                    🔌 Disconnect Google Calendar
                </a>
            <?php else: ?>
                <a href="<?php echo base_url('google_auth'); ?>" class="btn">
                    🔗 Connect Google Calendar
                </a>
            <?php endif; ?>
            <a href="<?php echo base_url(); ?>" class="btn btn-secondary">🏠 Home</a>
        </div>
        
        <div class="info-box">
            <h3>ℹ️ How It Works</h3>
            <ul>
                <li>When you create a new appointment, it will automatically appear in your Google Calendar</li>
                <li>Appointments will show as events with details about the patient and doctor</li>
                <li>You can view these events on any device where you're logged into Google Calendar</li>
                <li>Events are added to your primary Google Calendar</li>
            </ul>
        </div>
        
        <h3>🧪 Test Appointment Creation</h3>
        <p>To test the integration:</p>
        <ol>
            <li>Create a new appointment through the system</li>
            <li>Check your Google Calendar for the new event</li>
            <li>Events should appear with title "Appointment with [Doctor Name]"</li>
        </ol>
        
        <div class="info-box">
            <h3>⚙️ Technical Details</h3>
            <p><strong>Library:</strong> Google Calendar API v3</p>
            <p><strong>Authentication:</strong> OAuth 2.0</p>
            <p><strong>Scope:</strong> https://www.googleapis.com/auth/calendar</p>
            <p><strong>Timezone:</strong> Asia/Dhaka (default)</p>
        </div>
    </div>
</body>
</html>