<!DOCTYPE html>
<html>
<head>
    <title>Google Calendar Authentication Error</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 50px auto;
            padding: 20px;
            background-color: #f8f9fa;
        }
        .error-container {
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            padding: 30px;
            text-align: center;
        }
        .error-header {
            color: #dc3545;
            margin-bottom: 20px;
        }
        .error-details {
            background-color: #f8d7da;
            color: #721c24;
            padding: 20px;
            border-radius: 5px;
            border: 1px solid #f5c6cb;
            text-align: left;
            margin: 20px 0;
        }
        .btn {
            background-color: #007bff;
            color: white;
            padding: 12px 24px;
            text-decoration: none;
            border-radius: 4px;
            display: inline-block;
            margin: 10px 5px;
            border: none;
            cursor: pointer;
            font-size: 16px;
        }
        .btn:hover {
            background-color: #0056b3;
        }
        .btn-secondary {
            background-color: #6c757d;
        }
        .btn-secondary:hover {
            background-color: #545b62;
        }
        .troubleshooting {
            background-color: #e2e3e5;
            border-left: 4px solid #6c757d;
            padding: 15px;
            margin: 20px 0;
            text-align: left;
        }
        .step-list {
            text-align: left;
            margin: 15px 0;
        }
        .step-list li {
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <div class="error-container">
        <h1 class="error-header">❌ Google Calendar Authentication Failed</h1>
        
        <?php if (isset($error_message)): ?>
            <div class="error-details">
                <strong>Specific Error:</strong> <?php echo htmlspecialchars($error_message); ?>
            </div>
        <?php endif; ?>
        
        <p>There was an error connecting to Google Calendar. This could be due to several reasons:</p>
        
        <div class="troubleshooting">
            <h3>🔍 Troubleshooting Steps</h3>
            <ol class="step-list">
                <li><strong>Check Credentials File</strong> - Ensure <code>application/credentials/client_secret.json</code> exists and is valid</li>
                <li><strong>Verify Google API Setup</strong> - Make sure you've enabled the Calendar API in Google Cloud Console</li>
                <li><strong>Check Redirect URI</strong> - Ensure your redirect URI in Google Cloud Console matches: <code><?php echo base_url('google_auth/callback'); ?></code></li>
                <li><strong>Clear Browser Cache</strong> - Try clearing your browser cache and cookies</li>
                <li><strong>Try Incognito Mode</strong> - Test in an incognito/private browsing window</li>
            </ol>
        </div>
        
        <h3>🔧 Setup Checklist</h3>
        <ul class="step-list">
            <li>✅ Google API Project Created</li>
            <li>✅ Calendar API Enabled</li>
            <li>✅ OAuth 2.0 Credentials Created</li>
            <li>✅ <code>client_secret.json</code> File in Place</li>
            <li>✅ Redirect URI Configured</li>
        </ul>
        
        <div style="margin: 30px 0;">
            <a href="<?php echo base_url('google_auth'); ?>" class="btn">🔄 Try Again</a>
            <a href="<?php echo base_url('google_auth/test'); ?>" class="btn btn-secondary">📋 Test Page</a>
            <a href="<?php echo base_url(); ?>" class="btn btn-secondary">🏠 Home</a>
        </div>
        
        <p>For detailed setup instructions, see <code>GOOGLE_CALENDAR_INTEGRATION.md</code></p>
    </div>
</body>
</html>