<!DOCTYPE html>
<html>
<head>
    <title>Google Calendar Authentication Error</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 600px;
            margin: 50px auto;
            padding: 20px;
            text-align: center;
        }
        .error {
            background-color: #f8d7da;
            color: #721c24;
            padding: 20px;
            border-radius: 5px;
            border: 1px solid #f5c6cb;
        }
        .btn {
            background-color: #4285f4;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 3px;
            display: inline-block;
            margin: 20px 0;
        }
        .btn:hover {
            background-color: #3367d6;
        }
    </style>
</head>
<body>
    <div class="error">
        <h1>❌ Authentication Error</h1>
        <p>There was an error connecting to Google Calendar.</p>
        <p>Possible causes:</p>
        <ul style="text-align: left;">
            <li>Missing or invalid Google API credentials</li>
            <li>Google API client library not installed</li>
            <li>Network connectivity issues</li>
        </ul>
    </div>
    
    <a href="<?php echo base_url('google_auth'); ?>" class="btn">Try Again</a>
    <br>
    <a href="<?php echo base_url('google_auth/test'); ?>">Back to Test Page</a>
    
    <p>For setup instructions, see GOOGLE_CALENDAR_INTEGRATION.md</p>
</body>
</html>