<html lang="en"><head><meta http-equiv="origin-trial" content="A7vZI3v+Gz7JfuRolKNM4Aff6zaGuT7X0mf3wtoZTnKv6497cVMnhy03KDqX7kBz/q/iidW7srW31oQbBt4VhgoAAACUeyJvcmlnaW4iOiJodHRwczovL3d3dy5nb29nbGUuY29tOjQ0MyIsImZlYXR1cmUiOiJEaXNhYmxlVGhpcmRQYXJ0eVN0b3JhZ2VQYXJ0aXRpb25pbmczIiwiZXhwaXJ5IjoxNzU3OTgwODAwLCJpc1N1YmRvbWFpbiI6dHJ1ZSwiaXNUaGlyZFBhcnR5Ijp0cnVlfQ==">
  <base href="<?php echo base_url(); ?>">
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Medi Soft</title>

    <!-- SEO Meta Tags -->
    <meta name="description" content="">
    <meta name="keywords" content="software development, HMS software, hospital management system, custom software development">
    <meta name="author" content="Medi Soft">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="Medi Soft">
    <meta property="og:description" content="">
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://medecinesoft.com/">
    <meta property="og:site_name" content="Medi Soft">
    
    <!-- Stylesheets -->
  <link rel="stylesheet" href="new-fnt/index.css">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&amp;display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/country-select-js@2.1.0/build/css/countrySelect.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.5.0/css/flag-icon.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css">

    <script type="text/javascript" async="" charset="utf-8" src="https://www.gstatic.com/recaptcha/releases/3jpV4E_UA9gZWYy11LtggjoU/recaptcha__en_gb.js" crossorigin="anonymous" integrity="sha384-M3cPg3YUZQkN7aNKV/mBGNXW41IfHv1HbeVvE7eqGFnjzdhS8e/Wt7qC7dDXdpSQ"></script><script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f0f9ff',
                            100: '#e0f2fe',
                            200: '#bae6fd',
                            300: '#7dd3fc',
                            400: '#38bdf8',
                            500: '#0ea5e9',
                            600: '#0284c7',
                            700: '#0369a1',
                            800: '#075985',
                            900: '#0c4a6e',
                        },
                        secondary: {
                            50: '#f8fafc',
                            900: '#0f172a',
                        }
                    },
                    boxShadow: {
                        'custom': '0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06)',
                        'custom-lg': '0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1)',
                        'custom-2xl': '0 25px 50px -12px rgba(0, 0, 0, 0.25)',
                    },
                    animation: {
                        'float': 'float 6s ease-in-out infinite',
                    },
                    keyframes: {
                        float: {
                            '0%, 100%': { transform: 'translateY(0)' },
                            '50%': { transform: 'translateY(-20px)' },
                        }
                    }
                }
            }
        }
    </script>
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        
        .gradient-text {
            background: linear-gradient(135deg, #0ea5e9 0%, #3b82f6 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .hero-gradient {
            background: radial-gradient(circle at 30% 107%, rgba(14, 165, 233, 0.05) 0%, rgba(255, 255, 255, 0) 50%),
                        radial-gradient(circle at 70% 40%, rgba(59, 130, 246, 0.05) 0%, rgba(255, 255, 255, 0) 50%);
        }
        
        .service-card {
            background: rgba(255, 255, 255, 0.7);
            backdrop-filter: blur(10px);
        }
        
        @keyframes blob {
            0% { transform: translate(0px, 0px) scale(1); }
            33% { transform: translate(30px, -50px) scale(1.1); }
            66% { transform: translate(-20px, 20px) scale(0.9); }
            100% { transform: translate(0px, 0px) scale(1); }
        }
        
        .animate-blob {
            animation: blob 7s infinite;
        }
        
        .animation-delay-2000 {
            animation-delay: 2s;
        }
        
        .animation-delay-4000 {
            animation-delay: 4s;
        }

        body{
            overflow-x: hidden;
        }

        @media (max-width: 640px) {
            body {
                overflow-x: hidden;
            }
        }

        /* Hide horizontal scrollbar on mobile */
        html, body {
            max-width: 100%;
            overflow-x: hidden;
            position: relative;
        }

        /* Ensure content stays within viewport width */
        .container {
            width: 100%;
            max-width: 100vw;
            margin: 0 auto;
            padding-left: 1rem;
            padding-right: 1rem;
            box-sizing: border-box;
        }

        /* Handle overflow on grid layouts */
        .grid {
            width: 100%;
            margin: 0;
            padding: 0;
        }

        @media (max-width: 640px) {
            .grid {
                margin-left: 0;
                margin-right: 0;
            }
        }


    </style>


<body class="font-sans antialiased text-secondary-900 selection:bg-primary-200 selection:text-primary-900" cz-shortcut-listen="true">
    <!-- Navbar -->
    <nav  class="bg-white/80 backdrop-blur-md shadow-custom fixed w-full z-50 border-b border-gray-200/50">
        <div class="max-w-7xl mx-auto px-6">
            <div class="flex justify-between items-center h-20">
                <div class="flex-shrink-0">
                    <a href="#" class="flex items-center space-x-3">
                        <div class="relative w-10 h-10">
                            <div class="absolute inset-0 bg-gradient-to-r from-primary-600 to-primary-500 rounded-lg transform rotate-6 transition-transform group-hover:rotate-12"></div>
                            <div class="absolute inset-0 bg-white rounded-lg shadow-sm flex items-center justify-center">
                                <span class="text-xl font-bold text-primary-600">
                                    M                                </span>
                            </div>
                        </div>
                        <div>
                            <span class="text-2xl font-extrabold">
                                <span class="text-secondary-900">Medi</span><span class="text-primary-600">Soft</span>
                            </span>
                            <span class="hidden lg:block text-xs text-gray-500 -mt-1" data-en="Hospital Management Software" data-fr="Logiciel de gestion d'hôpital">Logiciel de gestion d'hôpital</span>
                        </div>
                    </a>
                </div>
                
                <!-- Desktop Menu -->
                <div class="hidden md:flex items-center space-x-8">
                    <a href="#home" class="text-gray-700 hover:text-primary-600 transition-colors duration-200 font-medium nav-item" data-en="Home" data-fr="Acceuil">Acceuil</a>
                    <a href="#features" class="text-gray-700 hover:text-primary-600 transition-colors duration-200 font-medium nav-item" data-en="Service" data-fr="Service">Service</a>
                    <a href="#package" class="text-gray-700 hover:text-primary-600 transition-colors duration-200 font-medium nav-item" data-en="Packages" data-fr="Nos Tarifs">Nos Tarifs</a>
                    <a href="#review" class="text-gray-700 hover:text-primary-600 transition-colors duration-200 font-medium nav-item" data-en="Reviews" data-fr="Avis">Avis</a>
                    <a href="#contact" class="text-gray-700 hover:text-primary-600 transition-colors duration-200 font-medium nav-item" data-en="Contact" data-fr="Contact">Contact</a>

                                            <a href="auth/login" target="_blank" class="inline-flex items-center px-4 py-2 bg-green-600 text-white font-medium rounded-lg hover:bg-green-700 transition duration-300 login-btn" data-en="Login" data-fr="Se Connecter">
                            <i class="fas fa-sign-in-alt mr-2"></i>
                            Se Connecter                        </a>
                    
                    <a href="#register" class="inline-flex items-center px-6 py-2.5 bg-primary-600 text-white font-medium rounded-lg hover:bg-primary-700 transition duration-300 shadow-sm register-btn" data-en="Try Free" data-fr="Essayez gratuitement">
                       Essayez gratuitement                    </a>
                    <!-- Language Switcher -->
                    <div class="relative inline-block text-left ml-4">
                        <button id="language-toggle" class="inline-flex items-center px-3 py-2 bg-gray-100 text-gray-700 rounded-lg hover:bg-gray-200 transition duration-300">
                            <span id="current-lang" class="mr-2">FR</span>
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                        <div id="language-dropdown" class="hidden absolute right-0 mt-2 w-32 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5 z-50">
                            <div class="py-1" role="menu">
                                <button class="language-option block w-full text-left px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 hover:text-gray-900" data-lang="fr" role="menuitem">
                                    🇫🇷 Français
                                </button>
                                <button class="language-option block w-full text-left px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 hover:text-gray-900" data-lang="en" role="menuitem">
                                    🇬🇧 English
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Mobile Menu Button -->
                <div class="md:hidden flex items-center space-x-2">
                    <!-- Language Switcher Mobile -->
                    <div class="relative">
                        <button id="mobile-language-toggle" class="w-10 h-10 flex items-center justify-center text-gray-700 hover:bg-gray-100 rounded-lg transition-colors">
                            <span id="mobile-current-lang" class="text-sm font-medium">FR</span>
                        </button>
                        <div id="mobile-language-dropdown" class="hidden absolute right-0 mt-2 w-32 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5 z-50">
                            <div class="py-1" role="menu">
                                <button class="language-option block w-full text-left px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 hover:text-gray-900" data-lang="fr" role="menuitem">
                                    🇫🇷 Français
                                </button>
                                <button class="language-option block w-full text-left px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 hover:text-gray-900" data-lang="en" role="menuitem">
                                    🇬🇧 English
                                </button>
                            </div>
                        </div>
                    </div>
                    <button id="mobile-menu-button" class="w-10 h-10 flex items-center justify-center text-gray-700 hover:bg-gray-100 rounded-lg transition-colors">
                        <svg class="w-6 h-6 text-gray-900" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                        </svg>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile Menu -->
        <div id="mobile-menu" class="hidden md:hidden bg-white border-b border-gray-200 py-4">
            <div class="px-4 space-y-3">
                <a href="#home" class="block px-4 py-2 text-gray-700 hover:bg-primary-50 rounded-lg transition-colors mobile-nav-item" data-en="Home" data-fr="Home">Home</a>
                <a href="#features" class="block px-4 py-2 text-gray-700 hover:bg-primary-50 rounded-lg transition-colors mobile-nav-item" data-en="Service" data-fr="Service">Service</a>
                <a href="#package" class="block px-4 py-2 text-gray-700 hover:bg-primary-50 rounded-lg transition-colors mobile-nav-item" data-en="Package" data-fr="Package">Package</a>
                <a href="#review" class="block px-4 py-2 text-gray-700 hover:bg-primary-50 rounded-lg transition-colors mobile-nav-item" data-en="Review" data-fr="Review">Review</a>
                <a href="#contact" class="block px-4 py-2 text-gray-700 hover:bg-primary-50 rounded-lg transition-colors mobile-nav-item" data-en="Contact Us" data-fr="Contactez-nous">Contact Us</a>
                
                                    <a href="auth/login" target="_blank" class="block px-4 py-2 text-white bg-green-600 hover:bg-green-700 rounded-lg transition-colors mobile-login-btn" data-en="Login" data-fr="Se connecter">
                        <i class="fas fa-sign-in-alt mr-2"></i>
                        Login                    </a>
                
                <a href="#register" class="block px-4 py-2 text-white bg-primary-600 hover:bg-primary-700 rounded-lg transition-colors font-medium mobile-register-btn" data-en="Register Hospital" data-fr="Enregistrer l'hôpital">
                    Register Hospital                </a>
            </div>
        </div>
    </nav>

    <!-- Language Switcher Script -->
    <script>
    // Immediate execution - no DOM ready event needed
    (function() {
        console.log('Language switcher initializing...');
        
        // Wait a bit for DOM to be ready
        setTimeout(function() {
            // Comprehensive language translations dictionary
            const translations = {
                'en': {
                    // Navigation
                    'Acceuil': 'Home',
                    'Service': 'Service',
                    'Nos Tarifs': 'Packages',
                    'Review': 'Reviews',
                    'Contact': 'Contact',
                    'Se Connecter': 'Login',
                    'Essayez gratuitement': 'Try Free',
                    'Contactez-nous': 'Contact Us',
                    'Enregistrer l\'hôpital': 'Register Hospital',
                    
                    // Hero Section
                    'Découvrez le meilleur Logiciel de Gestion des hôpitaux': 'Discover the Best Hospital Management Software',
                    'Informatisez': 'Digitalize',
                    'vos processus': 'your processes',
                    'de gestion hospitalière': 'of hospital management',
                    'Le logiciel de gestion hospitalière MEDI SOFT vous permet de centraliser et d\'organiser toutes les informations relatives aux patients a travers un Dossier Patient Informatisé (DPI)': 'The MEDI SOFT hospital management software allows you to centralize and organize all patient-related information through an Electronic Patient Record (EPR)',
                    'Centralisation de toutes les informations médicales du patient, y compris les antécédents, les traitements, les résultats d\'examens, facilitant ainsi la gestion des soins et la facturation.': 'Centralization of all patient medical information, including medical history, treatments, and test results, thus facilitating care management and billing.',
                    'MEDI SOFT vous offre des fonctionnalités variées telles que la gestion automatisée des rendez-vous (les patients peuvent prendre RDV en ligne depuis leur smartphone), la Prescriptions et suivi des traitements : Gestion informatisée des prescriptions, suivi des médicaments, et rappels pour les médicaments périmées': 'MEDI SOFT offers various features such as automated appointment management (patients can book appointments online from their smartphones), Prescriptions and treatment monitoring: Computerized prescription management, medication tracking, and expired medication reminders',
                    'MEDI SOFT est Logiciel conçu pour les hôpitaux modernes soucieux d\'améliorer la qualité des soins :Accès rapide et facile aux informations médicales, suivi précis des patients, et amélioration de la communication entre les professionnels de santé.': 'MEDI SOFT is software designed for modern hospitals concerned with improving care quality: Quick and easy access to medical information, precise patient tracking, and improved communication between healthcare professionals.',
                    
                    // Stats
                    'Active Hospitals': 'Active Hospitals',
                    'Patients Served': 'Patients Served',
                    'Support Available': 'Support Available',
                    
                    // Features Section
                    'Features': 'Features',
                    'Grand principe de fonctionnement de MEDI SOFT': 'Main operating principle of MEDI SOFT',
                    'Dans un hôpital utilisant MEDI SOFT, le parcours typique d\'un patient en temps réel est le suivant :': 'In a hospital using MEDI SOFT, the typical real-time patient journey is as follows:',
                    '1. Arrivée du patient dans la structure de santé': '1. Patient arrival at the healthcare facility',
                    'L\'accueil reçoit le patient qui se présente. Si le patient est déjà venu dans la structure de santé, son dossier est facilement retrouvé sur PC ou tablette ; les informations administratives sont déjà existant dans la machine et ne doivent pas être saisie. Si c\'est un nouveau patient, ses informations sont entrées en machine.': 'Reception receives the patient who presents themselves. If the patient has already visited the healthcare facility, their file is easily retrieved on PC or tablet; administrative information already exists in the system and does not need to be entered. If it\'s a new patient, their information is entered into the system.',
                    '2. Prise des paramètres (signe vitaux) du patient': '2. Taking patient parameters (vital signs)',
                    'Après la prise de ses paramètres tels que la température, la fréquence cardiaque, la fréquence respiratoire, et la pression artérielle, le patient est dirigé vers l\'unité de destination tel que le médecin traitant pour consultation': 'After taking parameters such as temperature, heart rate, respiratory rate, and blood pressure, the patient is directed to the destination unit such as the attending physician for consultation',
                    '3. Les paramètres sont disponible instantanément sur le PC du Médecin': '3. Parameters are instantly available on the Physician\'s PC',
                    'Le médecin dispose sur son PC ou sa tablette de la liste des patients en attente. Il sélectionne le patient qu\'il reçoit et consulte ses paramètres, son historique médical, ainsi que le détail de visites précédentes. Après avoir examiné le patient, il peut demander des examens de laboratoire ou d\'imagerie médicale, ce qu\'il indique sur son PC ou tablette': 'The physician has access on their PC or tablet to the list of waiting patients. They select the patient they receive and review their parameters, medical history, as well as details of previous visits. After examining the patient, they can request laboratory or medical imaging tests, which they indicate on their PC or tablet',
                    '4. Les demande d\'examens d\'analyses médicale sont envoyé au PC du labo en temps réel': '4. Medical analysis examination requests are sent to the lab PC in real-time',
                    'La commande est envoyée au niveau de la caisse pour règlement (si l\'hôpital dispose d\'un laboratoire médical) après règlement de cette facture, la demande d\'examen apparaitra chez le laborantin, qui pourra procéder à la prise d\'échantillons et à leurs analyses. Le laborantin saisi ensuite sur son PC (ou tablette) les résultats des examens.': 'The order is sent to the cashier for payment (if the hospital has a medical laboratory). After payment of this bill, the examination request will appear at the lab technician\'s station, who can then proceed with sample collection and analysis. The lab technician then enters the test results on their PC (or tablet).',
                    '5. Après l\'analyse des prélèvements et la saisie des resultats, les résultants sont disponibles dans le PC du médecin': '5. After analysis of samples and entry of results, the results are available on the physician\'s PC',
                    'Les résultats du laboratoire apparaissent automatiquement chez le médecin, qui peut indiquer un diagnostic et prescrire éventuellement des médicaments, ce qu\'il indique sur son PC (ou tablette).': 'Laboratory results automatically appear at the physician\'s station, who can indicate a diagnosis and potentially prescribe medications, which they indicate on their PC (or tablet).',
                    '6. Les médicaments prescrits par le médecin son immédiatement disponible sur le PC de la pharmacie': '6. Medications prescribed by the physician are immediately available on the pharmacy PC',
                    'Les prescriptions apparaissent sur le PC ou tablette de la pharmacie, qui peut préparer la commande pour le patient. À l\'issue du passage du patient, le dossier est clôturé (après d\'éventuelles formalités de facturation). Le dossier est archivé et son contenu sera disponible en machine lors d\'un prochain passage.': 'Prescriptions appear on the pharmacy PC or tablet, which can prepare the order for the patient. At the end of the patient\'s visit, the file is closed (after any billing procedures). The file is archived and its contents will be available digitally for future visits.'
                },
                'fr': {
                    // Navigation (keeping French as default)
                    'Home': 'Acceuil',
                    'Service': 'Service',
                    'Packages': 'Nos Tarifs',
                    'Reviews': 'Review',
                    'Contact': 'Contact',
                    'Login': 'Se Connecter',
                    'Try Free': 'Essayez gratuitement',
                    'Contact Us': 'Contactez-nous',
                    'Register Hospital': 'Enregistrer l\'hôpital',
                    
                    // Hero Section (keeping French as default)
                    'Discover the Best Hospital Management Software': 'Découvrez le meilleur Logiciel de Gestion des hôpitaux',
                    'Digitalize': 'Informatisez',
                    'your processes': 'vos processus',
                    'of hospital management': 'de gestion hospitalière',
                    'The MEDI SOFT hospital management software allows you to centralize and organize all patient-related information through an Electronic Patient Record (EPR)': 'Le logiciel de gestion hospitalière MEDI SOFT vous permet de centraliser et d\'organiser toutes les informations relatives aux patients a travers un Dossier Patient Informatisé (DPI)',
                    'Centralization of all patient medical information, including medical history, treatments, and test results, thus facilitating care management and billing.': 'Centralisation de toutes les informations médicales du patient, y compris les antécédents, les traitements, les résultats d\'examens, facilitant ainsi la gestion des soins et la facturation.',
                    'MEDI SOFT offers various features such as automated appointment management (patients can book appointments online from their smartphones), Prescriptions and treatment monitoring: Computerized prescription management, medication tracking, and expired medication reminders': 'MEDI SOFT vous offre des fonctionnalités variées telles que la gestion automatisée des rendez-vous (les patients peuvent prendre RDV en ligne depuis leur smartphone), la Prescriptions et suivi des traitements : Gestion informatisée des prescriptions, suivi des médicaments, et rappels pour les médicaments périmées',
                    'MEDI SOFT is software designed for modern hospitals concerned with improving care quality: Quick and easy access to medical information, precise patient tracking, and improved communication between healthcare professionals.': 'MEDI SOFT est Logiciel conçu pour les hôpitaux modernes soucieux d\'améliorer la qualité des soins :Accès rapide et facile aux informations médicales, suivi précis des patients, et amélioration de la communication entre les professionnels de santé.',
                    
                    // Stats (keeping French as default)
                    'Active Hospitals': 'Active Hospitals',
                    'Patients Served': 'Patients Served',
                    'Support Available': 'Support Available',
                    
                    // Features Section (keeping French as default)
                    'Features': 'Features',
                    'Main operating principle of MEDI SOFT': 'Grand principe de fonctionnement de MEDI SOFT',
                    'In a hospital using MEDI SOFT, the typical real-time patient journey is as follows:': 'Dans un hôpital utilisant MEDI SOFT, le parcours typique d\'un patient en temps réel est le suivant :',
                    '1. Patient arrival at the healthcare facility': '1. Arrivée du patient dans la structure de santé',
                    'Reception receives the patient who presents themselves. If the patient has already visited the healthcare facility, their file is easily retrieved on PC or tablet; administrative information already exists in the system and does not need to be entered. If it\'s a new patient, their information is entered into the system.': 'L\'accueil reçoit le patient qui se présente. Si le patient est déjà venu dans la structure de santé, son dossier est facilement retrouvé sur PC ou tablette ; les informations administratives sont déjà existant dans la machine et ne doivent pas être saisie. Si c\'est un nouveau patient, ses informations sont entrées en machine.',
                    '2. Taking patient parameters (vital signs)': '2. Prise des paramètres (signe vitaux) du patient',
                    'After taking parameters such as temperature, heart rate, respiratory rate, and blood pressure, the patient is directed to the destination unit such as the attending physician for consultation': 'Après la prise de ses paramètres tels que la température, la fréquence cardiaque, la fréquence respiratoire, et la pression artérielle, le patient est dirigé vers l\'unité de destination tel que le médecin traitant pour consultation',
                    '3. Parameters are instantly available on the Physician\'s PC': '3. Les paramètres sont disponible instantanément sur le PC du Médecin',
                    'The physician has access on their PC or tablet to the list of waiting patients. They select the patient they receive and review their parameters, medical history, as well as details of previous visits. After examining the patient, they can request laboratory or medical imaging tests, which they indicate on their PC or tablet': 'Le médecin dispose sur son PC ou sa tablette de la liste des patients en attente. Il sélectionne le patient qu\'il reçoit et consulte ses paramètres, son historique médical, ainsi que le détail de visites précédentes. Après avoir examiné le patient, il peut demander des examens de laboratoire ou d\'imagerie médicale, ce qu\'il indique sur son PC ou tablette',
                    '4. Medical analysis examination requests are sent to the lab PC in real-time': '4. Les demande d\'examens d\'analyses médicale sont envoyé au PC du labo en temps réel',
                    'The order is sent to the cashier for payment (if the hospital has a medical laboratory). After payment of this bill, the examination request will appear at the lab technician\'s station, who can then proceed with sample collection and analysis. The lab technician then enters the test results on their PC (or tablet).': 'La commande est envoyée au niveau de la caisse pour règlement (si l\'hôpital dispose d\'un laboratoire médical) après règlement de cette facture, la demande d\'examen apparaitra chez le laborantin, qui pourra procéder à la prise d\'échantillons et à leurs analyses. Le laborantin saisi ensuite sur son PC (ou tablette) les résultats des examens.',
                    '5. After analysis of samples and entry of results, the results are available on the physician\'s PC': '5. Après l\'analyse des prélèvements et la saisie des resultats, les résultants sont disponibles dans le PC du médecin',
                    'Laboratory results automatically appear at the physician\'s station, who can indicate a diagnosis and potentially prescribe medications, which they indicate on their PC (or tablet).': 'Les résultats du laboratoire apparaissent automatiquement chez le médecin, qui peut indiquer un diagnostic et prescrire éventuellement des médicaments, ce qu\'il indique sur son PC (ou tablette).',
                    '6. Medications prescribed by the physician are immediately available on the pharmacy PC': '6. Les médicaments prescrits par le médecin son immédiatement disponible sur le PC de la pharmacie',
                    'Prescriptions appear on the pharmacy PC or tablet, which can prepare the order for the patient. At the end of the patient\'s visit, the file is closed (after any billing procedures). The file is archived and its contents will be available digitally for future visits.': 'Les prescriptions apparaissent sur le PC ou tablette de la pharmacie, qui peut préparer la commande pour le patient. À l\'issue du passage du patient, le dossier est clôturé (après d\'éventuelles formalités de facturation). Le dossier est archivé et son contenu sera disponible en machine lors d\'un prochain passage.'
                }
            };

            // Add data attributes to all translatable content

            // Get DOM elements
            const languageToggle = document.getElementById('language-toggle');
            const languageDropdown = document.getElementById('language-dropdown');
            const mobileLanguageToggle = document.getElementById('mobile-language-toggle');
            const mobileLanguageDropdown = document.getElementById('mobile-language-dropdown');
            const languageOptions = document.querySelectorAll('.language-option');
            const currentLangSpan = document.getElementById('current-lang');
            const mobileCurrentLangSpan = document.getElementById('mobile-current-lang');
            
            console.log('Elements found:', {
                languageToggle: !!languageToggle,
                languageDropdown: !!languageDropdown,
                mobileLanguageToggle: !!mobileLanguageToggle,
                mobileLanguageDropdown: !!mobileLanguageDropdown,
                languageOptions: languageOptions.length,
                currentLangSpan: !!currentLangSpan,
                mobileCurrentLangSpan: !!mobileCurrentLangSpan
            });

            if (!languageToggle || !languageOptions.length) {
                console.error('Required elements not found!');
                return;
            }

            // Check for saved language preference or default to French
            let currentLang = localStorage.getItem('preferredLanguage') || 'fr';
            console.log('Current language:', currentLang);
            
            // Set initial language display
            updateLanguageDisplay(currentLang);
            
            // Apply initial translation
            translatePage(currentLang);
            
            console.log('Initial translation applied');

            // Toggle desktop language dropdown
            languageToggle.addEventListener('click', function(e) {
                console.log('Language toggle clicked!');
                e.stopPropagation();
                languageDropdown.classList.toggle('hidden');
            });

            // Toggle mobile language dropdown
            if (mobileLanguageToggle) {
                mobileLanguageToggle.addEventListener('click', function(e) {
                    console.log('Mobile language toggle clicked!');
                    e.stopPropagation();
                    mobileLanguageDropdown.classList.toggle('hidden');
                });
            }

            // Handle language selection
            languageOptions.forEach((option, index) => {
                console.log(`Adding listener to option ${index}:`, option.getAttribute('data-lang'));
                option.addEventListener('click', function() {
                    console.log('Language option clicked:', this.getAttribute('data-lang'));
                    const selectedLang = this.getAttribute('data-lang');
                    changeLanguage(selectedLang);
                    
                    // Hide dropdowns
                    languageDropdown.classList.add('hidden');
                    if (mobileLanguageDropdown) {
                        mobileLanguageDropdown.classList.add('hidden');
                    }
                });
            });

            // Close dropdowns when clicking outside
            document.addEventListener('click', function(e) {
                if (!languageToggle.contains(e.target) && !languageDropdown.contains(e.target)) {
                    languageDropdown.classList.add('hidden');
                }
                if (mobileLanguageToggle && !mobileLanguageToggle.contains(e.target) && !mobileLanguageDropdown.contains(e.target)) {
                    mobileLanguageDropdown.classList.add('hidden');
                }
            });

            // Function to change language
            function changeLanguage(lang) {
                console.log('Changing language to:', lang);
                currentLang = lang;
                localStorage.setItem('preferredLanguage', lang);
                updateLanguageDisplay(lang);
                translatePage(lang);
                console.log('Language changed successfully');
            }

            // Function to update language display
            function updateLanguageDisplay(lang) {
                const displayText = lang === 'en' ? 'EN' : 'FR';
                if (currentLangSpan) currentLangSpan.textContent = displayText;
                if (mobileCurrentLangSpan) mobileCurrentLangSpan.textContent = displayText;
            }

            // Function to translate the page
            function translatePage(lang) {
                // Translate navigation items
                document.querySelectorAll('.nav-item').forEach(item => {
                    const frenchText = item.getAttribute('data-fr');
                    const englishText = item.getAttribute('data-en');
                    if (frenchText && englishText) {
                        item.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                // Translate mobile navigation items
                document.querySelectorAll('.mobile-nav-item').forEach(item => {
                    const frenchText = item.getAttribute('data-fr');
                    const englishText = item.getAttribute('data-en');
                    if (frenchText && englishText) {
                        item.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                // Translate buttons
                document.querySelectorAll('.login-btn, .mobile-login-btn').forEach(btn => {
                    const frenchText = btn.getAttribute('data-fr');
                    const englishText = btn.getAttribute('data-en');
                    if (frenchText && englishText) {
                        const icon = btn.querySelector('i');
                        btn.innerHTML = '';
                        if (icon) btn.appendChild(icon);
                        const textNode = document.createTextNode(lang === 'en' ? englishText : frenchText);
                        btn.appendChild(textNode);
                    }
                });

                document.querySelectorAll('.register-btn, .mobile-register-btn').forEach(btn => {
                    const frenchText = btn.getAttribute('data-fr');
                    const englishText = btn.getAttribute('data-en');
                    if (frenchText && englishText) {
                        btn.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                // Translate hero section content
                document.querySelectorAll('[data-en][data-fr]').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                // Translate stats labels
                document.querySelectorAll('.stats-label').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                // Translate features section
                document.querySelectorAll('.features-header').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.features-title').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.features-description').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                // Translate feature cards
                document.querySelectorAll('.feature-title').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.feature-desc').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                // Translate why choose us section
                document.querySelectorAll('.why-choose-header').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.why-choose-title').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.why-choose-desc').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.why-choose-reasons').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                // Translate why choose cards
                document.querySelectorAll('.why-card-title').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.why-card-desc').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                // Translate registration section
                document.querySelectorAll('.register-header').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.register-title').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.register-desc').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.register-form-title').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.register-form-desc').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                // Translate form placeholders
                document.querySelectorAll('[data-en-placeholder][data-fr-placeholder]').forEach(input => {
                    const frenchPlaceholder = input.getAttribute('data-fr-placeholder');
                    const englishPlaceholder = input.getAttribute('data-en-placeholder');
                    if (frenchPlaceholder && englishPlaceholder) {
                        input.placeholder = lang === 'en' ? englishPlaceholder : frenchPlaceholder;
                    }
                });

                // Translate select options
                document.querySelectorAll('option[data-en][data-fr]').forEach(option => {
                    const frenchText = option.getAttribute('data-fr');
                    const englishText = option.getAttribute('data-en');
                    if (frenchText && englishText) {
                        option.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                // Translate reviews section
                document.querySelectorAll('.reviews-header').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.reviews-title').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.reviews-description').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                // Translate review cards
                document.querySelectorAll('.review-title').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.review-content').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                // Translate FAQ section
                document.querySelectorAll('.faq-title').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.faq-module-title').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.faq-prompt').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.faq-contact-link').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                // Translate Contact section
                document.querySelectorAll('.contact-title').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.contact-subtitle').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.contact-info-title').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.contact-proceed-title').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.contact-proceed-desc').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.contact-consultation-btn').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                // Translate Footer section
                document.querySelectorAll('.footer-quick-links').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.footer-language').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.footer-newsletter').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.footer-newsletter-desc').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                document.querySelectorAll('.footer-copyright').forEach(element => {
                    const frenchText = element.getAttribute('data-fr');
                    const englishText = element.getAttribute('data-en');
                    if (frenchText && englishText) {
                        element.textContent = lang === 'en' ? englishText : frenchText;
                    }
                });

                // Translate form placeholders
                document.querySelectorAll('.footer-email-input').forEach(input => {
                    const frenchPlaceholder = input.getAttribute('data-fr-placeholder');
                    const englishPlaceholder = input.getAttribute('data-en-placeholder');
                    if (frenchPlaceholder && englishPlaceholder) {
                        input.placeholder = lang === 'en' ? englishPlaceholder : frenchPlaceholder;
                    }
                });
            }
        }, 100); // Small delay to ensure DOM is ready
    })();
    </script>

    <!-- Hero Section -->
    <section  id="home" class="relative min-h-screen bg-gradient-to-b from-gray-50 to-white pt-32">
        <!-- Animated Background Elements -->
        <div class="absolute inset-0 z-0">
            <div class="absolute top-0 left-0 w-full h-full bg-grid-pattern opacity-[0.02]"></div>
            <div class="absolute top-1/4 right-1/3 w-96 h-96 bg-primary-600/30 rounded-full mix-blend-multiply filter blur-3xl animate-blob"></div>
            <div class="absolute top-1/3 right-1/2 w-96 h-96 bg-purple-300/30 rounded-full mix-blend-multiply filter blur-3xl animate-blob animation-delay-2000"></div>
            <div class="absolute top-1/2 left-1/4 w-96 h-96 bg-pink-300/30 rounded-full mix-blend-multiply filter blur-3xl animate-blob animation-delay-4000"></div>
        </div>

        <div style= "margin-top: -7em;" class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-2 items-center py-20">
                <!-- Left Column - Content -->
                <div class="text-center lg:text-left">
                    <!-- Announcement Badge -->
                    <a href="#features" class="inline-flex items-center px-4 py-2 bg-primary-50 rounded-full mb-8 group cursor-pointer hover:bg-primary-100 transition-all duration-300">
                        <span class="animate-pulse w-2 h-2 bg-primary-600 rounded-full mr-2"></span>
                        <span class="text-primary-800 font-medium hero-badge" data-en="Discover the Best Hospital Management Software" data-fr="Découvrez le meilleur Logiciel de Gestion des hôpitaux">Découvrez le meilleur Logiciel de Gestion des hôpitaux</span>
                        <svg class="w-4 h-4 ml-2 text-primary-600 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                        </svg>
                    </a>

                    <h1 class="text-5xl lg:text-4xl font-extrabold mb-8">
                        <span class="block mb-2 text-secondary-900 hero-title" data-en="Digitalize" data-fr="Informatisez">Informatisez</span>
                        <span class="relative inline-block">
                            <span class="relative z-10 gradient-text hero-subtitle" data-en="your processes" data-fr="vos processus">vos processus</span>
                            <div class="absolute -bottom-2 left-0 w-full h-3 bg-primary-200/60 -rotate-1"></div>
                        </span>
                        <span class="block mt-2 text-secondary-900 hero-description" data-en="of hospital management" data-fr="de gestion hospitalière">de gestion hospitalière</span>
                    </h1>
              <p class="text-xl text-gray-600 mb-10 max-w-2xl mx-auto lg:mx-0 leading-relaxed hero-content" data-en="The MEDI SOFT hospital management software allows you to centralize and organize all patient-related information through an Electronic Patient Record (EPR): Centralization of all patient medical information, including medical history, treatments, and test results, thus facilitating care management and billing." data-fr="Le logiciel de gestion hospitalière MEDI SOFT vous permet de centraliser et d'organiser toutes les informations relatives aux patients a travers un Dossier Patient Informatisé (DPI): Centralisation de toutes les informations médicales du patient, y compris les antécédents, les traitements, les résultats d'examens, facilitant ainsi la gestion des soins et la facturation.">
                     Le logiciel de gestion hospitalière MEDI SOFT vous permet de centraliser et d'organiser toutes les informations relatives aux patients a travers un Dossier Patient Informatisé (DPI):
Centralisation de toutes les informations médicales du patient, y compris les antécédents, les traitements, les résultats d'examens, facilitant ainsi la gestion des soins et la facturation. 
</p>
<p class="text-xl text-gray-600 mb-10 max-w-2xl mx-auto lg:mx-0 leading-relaxed hero-content2" data-en="MEDI SOFT offers various features such as automated appointment management (patients can book appointments online from their smartphones), Prescriptions and treatment monitoring: Computerized prescription management, medication tracking, and expired medication reminders" data-fr="MEDI SOFT vous offre des fonctionnalités variées telles que la gestion automatisée des rendez-vous (les patients peuvent prendre RDV en ligne depuis leur smartphone), la Prescriptions et suivi des traitements : Gestion informatisée des prescriptions, suivi des médicaments, et rappels pour les médicaments périmées">
MEDI SOFT vous offre des fonctionnalités variées telles que la gestion automatisée des rendez-vous (les patients peuvent prendre RDV en ligne depuis leur smartphone), la Prescriptions et suivi des traitements : Gestion informatisée des prescriptions, suivi des médicaments, et rappels pour les médicaments périmées 
</p>
<p class="text-xl text-gray-600 mb-10 max-w-2xl mx-auto lg:mx-0 leading-relaxed hero-content3" data-en="MEDI SOFT is software designed for modern hospitals concerned with improving care quality: Quick and easy access to medical information, precise patient tracking, and improved communication between healthcare professionals." data-fr="MEDI SOFT est Logiciel conçu pour les hôpitaux modernes soucieux d'améliorer la qualité des soins :Accès rapide et facile aux informations médicales, suivi précis des patients, et amélioration de la communication entre les professionnels de santé.">
MEDI SOFT est Logiciel conçu pour les hôpitaux modernes soucieux d'améliorer la qualité des soins :Accès rapide et facile aux informations médicales, suivi précis des patients, et amélioration de la communication entre les professionnels de santé.

                    </p>
                    <!-- Stats Section -->
                    <div class="grid grid-cols-3 gap-8">
                        <div class="text-center">
                            <div class="text-4xl font-bold text-primary-600 mb-2">50+</div>
                            <div class="text-sm text-gray-600 stats-label" data-en="Active Hospitals" data-fr="Hôpitaux Actifs">Active Hospitals</div>
                        </div>
                        <div class="text-center">
                            <div class="text-4xl font-bold text-primary-600 mb-2">5M+</div>
                            <div class="text-sm text-gray-600 stats-label" data-en="Patients Served" data-fr="Patients Servis">Patients Served</div>
                        </div>
                        <div class="text-center">
                            <div class="text-4xl font-bold text-primary-600 mb-2">24/7</div>
                            <div class="text-sm text-gray-600 stats-label" data-en="Support Available" data-fr="Support Disponible">Support Available</div>
                        </div>
                    </div>
                </div>

                <!-- Right Column - Visual Elements -->
                <div class="relative hidden lg:block">
                    <!-- Main Image Grid -->
                    <div class="grid grid-cols-2 gap-10">
                        <!-- Large Feature Image -->
                        <div class="col-span-2">
                            <div class="relative rounded-2xl overflow-hidden shadow-2xl transform hover:scale-[1.02] transition-transform duration-500">
                                <img src="uploads/frontend/reception.jpg" alt="Modern Hospital" class="w-full h-64 object-cover">
                                <div class="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent"></div>
                                
                                <!--<div class="absolute bottom-4 left-4 text-white">
                                    <div class="text-sm font-medium">Featured</div>
                                    <div class="text-lg font-bold">Une gestion hospitaliere moderne</div>
                                </div>
                                -->
                            </div>
                        </div>

                        <!-- Smaller Images -->
                        <div class="relative rounded-2xl overflow-hidden shadow-xl transform hover:scale-[1.02] transition-transform duration-500">
                            <img src="uploads/frontend/hospitalization.jpg" alt="Medical Technology" class="w-full h-48 object-cover">
                            <div class="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent"></div>
                        </div>
                        <div class="relative rounded-2xl overflow-hidden shadow-xl transform hover:scale-[1.02] transition-transform duration-500">
                            <img src="uploads/frontend/pharmacie.jpg" alt="Patient Care" class="w-full h-48 object-cover">
                            <div class="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent"></div>
                        </div>
                    </div>

                    <!-- Floating Tech Cards -->
                    <!--<div class="absolute -top-6 -right-6 bg-white p-4 rounded-xl shadow-xl animate-float">
                        <div class="flex items-center gap-3">
                            <div class="w-12 h-12 bg-blue-100 rounded-xl flex items-center justify-center">
                                <i class="fas fa-user-md text-2xl text-blue-600"></i>
                            </div>
                            <div>
                                <div class="text-sm font-medium text-gray-500">Latest Tech</div>
                                <div class="text-lg font-bold text-blue-600">HMS Pro</div>
                            </div>
                        </div>
                    </div>-->

                    <!--<div class="absolute -bottom-6 -left-6 bg-white p-4 rounded-xl shadow-xl animate-float animation-delay-2000">
                        <div class="flex items-center gap-3">
                            <div class="w-12 h-12 bg-green-100 rounded-xl flex items-center justify-center">
                                <i class="fas fa-heartbeat text-2xl text-green-600"></i>
                            </div>
                            <div>
                                <div class="text-sm font-medium text-gray-500">Powered by</div>
                                <div class="text-lg font-bold text-green-600">AI Care</div>
                            </div>
                        </div>
                    </div>-->
                    
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="relative py-24 bg-gradient-to-b from-white to-gray-50" id="features">
        <!-- Background Elements -->
        <div class="absolute inset-0 z-0">
            <div class="absolute top-0 -left-64 w-96 h-96 bg-indigo-100 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob"></div>
            <div class="absolute top-0 -right-64 w-96 h-96 bg-purple-100 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob animation-delay-2000"></div>
            <div class="absolute -bottom-64 left-64 w-96 h-96 bg-pink-100 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob animation-delay-4000"></div>
        </div>
    
        <div style= "margin-top: -5em;" class="container mx-auto px-4 relative z-10">
            <!-- Section Header -->
            <div class="max-w-3xl mx-auto text-center mb-20">
                <span class="text-sm font-bold tracking-wider text-indigo-600 uppercase mb-4 block features-header" data-en="Features" data-fr="Fonctionnalités">
          Features                </span>
                <h2 class="text-4xl md:text-5xl font-extrabold mb-6 text-gray-900 features-title" data-en="Main Operating Principle of MEDI SOFT" data-fr="Grand principe de fonctionnement de MEDI SOFT">
           Grand principe de fonctionnement de MEDI SOFT</h2>
                <div class="w-24 h-1 bg-gradient-to-r from-indigo-500 to-purple-500 mx-auto rounded-full mb-6"></div>
                <p class="text-xl text-gray-600 leading-relaxed features-description" data-en="In a hospital using MEDI SOFT, the typical real-time patient journey is as follows:" data-fr="Dans un hôpital utilisant MEDI SOFT, le parcours typique d’un patient en temps réel est le suivant : ">
          Dans un hôpital utilisant MEDI SOFT, le parcours typique d’un patient en temps réel est le suivant : </p>
            </div>

            <!-- Features Grid -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Feature 1 -->
                <div class="group relative bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl transform hover:-translate-y-1 transition-all duration-300">
                    <div class="absolute top-0 left-0 w-full h-1 bg-gradient-to-r from-indigo-500 to-purple-500 rounded-t-2xl"></div>
                    <div class="mb-6 inline-block">
                        <div class="w-16 h-16 bg-indigo-100 rounded-2xl flex items-center justify-center group-hover:bg-indigo-200 transition-colors duration-300">
                            <img src="new-fnt/assets/images/1.svg" class="w-8 h-8 transform group-hover:scale-110 transition-transform duration-300" alt="">
                        </div>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-4 group-hover:text-indigo-600 transition-colors duration-300 feature-title" data-en="1. Patient arrival at the health facility" data-fr="1. Arrivée du patient dans la structure de santé">
             1.	Arrivée du patient dans la structure de santé            </h3>
                    <p class="text-gray-600 leading-relaxed group-hover:text-gray-700 transition-colors duration-300 feature-desc" data-en="Reception receives the patient who presents themselves. If the patient has already visited the health facility, their file is easily retrieved on PC or tablet; administrative information already exists in the system and does not need to be entered. If it's a new patient, their information is entered into the system." data-fr="L'accueil reçoit le patient qui se présente. Si le patient est déjà venu dans la structure de santé, son dossier est facilement retrouvé sur PC ou tablette ; les informations administratives sont déjà existant dans la machine et ne doivent pas être saisie. Si c’est un nouveau patient, ses informations sont entrées en machine.             ">
             L'accueil reçoit le patient qui se présente. Si le patient est déjà venu dans la structure de santé, son dossier est facilement retrouvé sur PC ou tablette ; les informations administratives sont déjà existant dans la machine et ne doivent pas être saisie. Si c’est un nouveau patient, ses informations sont entrées en machine.             </p>
          </div>
          
          
          
          <!-- Feature 2 -->
                <div class="group relative bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl transform hover:-translate-y-1 transition-all duration-300">
                    <div class="absolute top-0 left-0 w-full h-1 bg-gradient-to-r from-indigo-500 to-purple-500 rounded-t-2xl"></div>
                    <div class="mb-6 inline-block">
                        <div class="w-16 h-16 bg-indigo-100 rounded-2xl flex items-center justify-center group-hover:bg-indigo-200 transition-colors duration-300">
                            <img src="new-fnt/assets/images/1.svg" class="w-8 h-8 transform group-hover:scale-110 transition-transform duration-300" alt="">
                        </div>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-4 group-hover:text-indigo-600 transition-colors duration-300 feature-title" data-en="2. Taking patient parameters (vital signs)" data-fr="2. Prise des paramètres (signe vitaux) du patient">
             2.	Prise des paramètres (signe vitaux) du patient           </h3>
                    <p class="text-gray-600 leading-relaxed group-hover:text-gray-700 transition-colors duration-300 feature-desc" data-en="After taking parameters such as temperature, heart rate, respiratory rate, and blood pressure, the patient is directed to the destination unit such as the attending physician for consultation" data-fr="Après la prise de ses paramètres tels que la température, la fréquence cardiaque, la fréquence respiratoire, et la pression artérielle, le patient est dirigé vers l’unité de destination tel que le médecin traitant pour consultation            ">
             Après la prise de ses paramètres tels que la température, la fréquence cardiaque, la fréquence respiratoire, et la pression artérielle, le patient est dirigé vers l’unité de destination tel que le médecin traitant pour consultation            </p>
          </div>
          
          <!-- Feature 3 -->
                <div class="group relative bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl transform hover:-translate-y-1 transition-all duration-300">
                    <div class="absolute top-0 left-0 w-full h-1 bg-gradient-to-r from-indigo-500 to-purple-500 rounded-t-2xl"></div>
                    <div class="mb-6 inline-block">
                        <div class="w-16 h-16 bg-indigo-100 rounded-2xl flex items-center justify-center group-hover:bg-indigo-200 transition-colors duration-300">
                            <img src="new-fnt/assets/images/1.svg" class="w-8 h-8 transform group-hover:scale-110 transition-transform duration-300" alt="">
                        </div>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-4 group-hover:text-indigo-600 transition-colors duration-300 feature-title" data-en="3. Parameters are instantly available on the Doctor's PC" data-fr="3. Les paramètres sont disponible instantanément sur le PC du Médecin">
              3.	Les paramètres sont disponible instantanément sur le PC du Médecin        </h3>
                    <p class="text-gray-600 leading-relaxed group-hover:text-gray-700 transition-colors duration-300 feature-desc" data-en="The doctor has access on their PC or tablet to the list of waiting patients. They select the patient they receive and review their parameters, medical history, as well as details of previous visits. After examining the patient, they can request laboratory or medical imaging exams, which they indicate on their PC or tablet" data-fr="Le médecin dispose sur son PC ou sa tablette de la liste des patients en attente. Il sélectionne le patient qu’il reçoit et consulte ses paramètres, son historique médical, ainsi que le détail de visites précédentes. Après avoir examiné le patient, il peut demander des examens de laboratoire ou d’imagerie médicale, ce qu’il indique sur son PC ou tablette           ">
              Le médecin dispose sur son PC ou sa tablette de la liste des patients en attente. Il sélectionne le patient qu’il reçoit et consulte ses paramètres, son historique médical, ainsi que le détail de visites précédentes. Après avoir examiné le patient, il peut demander des examens de laboratoire ou d’imagerie médicale, ce qu’il indique sur son PC ou tablette           </p>
          </div>
          
          
          
          
          <!-- Feature 4 -->
                <div class="group relative bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl transform hover:-translate-y-1 transition-all duration-300">
                    <div class="absolute top-0 left-0 w-full h-1 bg-gradient-to-r from-indigo-500 to-purple-500 rounded-t-2xl"></div>
                    <div class="mb-6 inline-block">
                        <div class="w-16 h-16 bg-indigo-100 rounded-2xl flex items-center justify-center group-hover:bg-indigo-200 transition-colors duration-300">
                            <img src="new-fnt/assets/images/1.svg" class="w-8 h-8 transform group-hover:scale-110 transition-transform duration-300" alt="">
                        </div>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-4 group-hover:text-indigo-600 transition-colors duration-300 feature-title" data-en="4. Medical analysis examination requests are sent to the lab PC in real-time" data-fr="4. Les demande d’examens d’analyses médicale sont envoyé au PC du labo en temps réel">
            4.	Les demande d’examens d’analyses médicale sont envoyé au PC du labo en temps réel          </h3>
                    <p class="text-gray-600 leading-relaxed group-hover:text-gray-700 transition-colors duration-300 feature-desc" data-en="The order is sent to the cashier for payment (if the hospital has a medical laboratory). After payment of this bill, the examination request will appear at the lab technician's station, who can then proceed with sample collection and analysis. The lab technician then enters the test results on their PC (or tablet)." data-fr="La commande est envoyée au niveau de la caisse pour règlement (si l’hôpital dispose d’un laboratoire médical) après règlement de cette facture, la demande d’examen apparaitra chez le laborantin, qui pourra procéder à la prise d’échantillons et à leurs analyses. Le laborantin saisi ensuite sur son PC (ou tablette) les résultats des examens.           ">
              La commande est envoyée au niveau de la caisse pour règlement (si l’hôpital dispose d’un laboratoire médical) après règlement de cette facture, la demande d’examen apparaitra chez le laborantin, qui pourra procéder à la prise d’échantillons et à leurs analyses. Le laborantin saisi ensuite sur son PC (ou tablette) les résultats des examens.           </p>
          </div>

                <!-- Feature 5 -->
                <div class="group relative bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl transform hover:-translate-y-1 transition-all duration-300">
                    <div class="absolute top-0 left-0 w-full h-1 bg-gradient-to-r from-green-500 to-emerald-500 rounded-t-2xl"></div>
                    <div class="mb-6 inline-block">
                        <div class="w-16 h-16 bg-green-100 rounded-2xl flex items-center justify-center group-hover:bg-green-200 transition-colors duration-300">
                            <img src="new-fnt/assets/images/support.svg" class="w-8 h-8 transform group-hover:scale-110 transition-transform duration-300" alt="">
            </div>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-4 group-hover:text-green-600 transition-colors duration-300 feature-title" data-en="5. After analysis of samples and entry of results, the results are available on the physician's PC" data-fr="5. Après l’analyse des prélèvements et la saisie des resultats, les résultants sont disponibles dans le PC du médecin">
              5.	Après l’analyse des prélèvements et la saisie des resultats, les résultants sont disponibles dans le PC du médecin           </h3>
                    <p class="text-gray-600 leading-relaxed group-hover:text-gray-700 transition-colors duration-300 feature-desc" data-en="Laboratory results automatically appear at the physician's station, who can indicate a diagnosis and potentially prescribe medications, which they indicate on their PC (or tablet)." data-fr="Les résultats du laboratoire apparaissent automatiquement chez le médecin, qui peut indiquer un diagnostic et prescrire éventuellement des médicaments, ce qu’il indique sur son PC (ou tablette).            ">
              Les résultats du laboratoire apparaissent automatiquement chez le médecin, qui peut indiquer un diagnostic et prescrire éventuellement des médicaments, ce qu’il indique sur son PC (ou tablette).            </p>
          </div>

                <!-- Feature 6 -->
                <div class="group relative bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl transform hover:-translate-y-1 transition-all duration-300">
                    <div class="absolute top-0 left-0 w-full h-1 bg-gradient-to-r from-purple-500 to-pink-500 rounded-t-2xl"></div>
                    <div class="mb-6 inline-block">
                        <div class="w-16 h-16 bg-purple-100 rounded-2xl flex items-center justify-center group-hover:bg-purple-200 transition-colors duration-300">
                            <img src="new-fnt/assets/images/health.svg" class="w-8 h-8 transform group-hover:scale-110 transition-transform duration-300" alt="">
            </div>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-4 group-hover:text-purple-600 transition-colors duration-300 feature-title" data-en="6. Medications prescribed by the physician are immediately available on the pharmacy PC" data-fr="6. Les médicaments prescrits par le médecin son immédiatement disponible sur le PC de la pharmacie">
            6.	Les médicaments prescrits par le médecin son immédiatement disponible sur le PC de la pharmacie        </h3>
                    <p class="text-gray-600 leading-relaxed group-hover:text-gray-700 transition-colors duration-300 feature-desc" data-en="Prescriptions appear on the pharmacy PC or tablet, which can prepare the order for the patient. At the end of the patient's visit, the file is closed (after any billing procedures). The file is archived and its contents will be available digitally for future visits." data-fr="Les prescriptions apparaissent sur le PC ou tablette de la pharmacie, qui peut préparer la commande pour le patient. À l’issue du passage du patient, le dossier est clôturé (après d’éventuelles formalités de facturation). Le dossier est archivé et son contenu sera disponible en machine lors d’un prochain passage.          ">
              Les prescriptions apparaissent sur le PC ou tablette de la pharmacie, qui peut préparer la commande pour le patient. À l’issue du passage du patient, le dossier est clôturé (après d’éventuelles formalités de facturation). Le dossier est archivé et son contenu sera disponible en machine lors d’un prochain passage.          </p>
          </div>
        </div>

            <!-- Stats Section -->
            <div class="mt-24 grid grid-cols-1 md:grid-cols-3 gap-8">
                <div class="bg-white rounded-2xl p-8 text-center shadow-lg hover:shadow-xl transition-shadow duration-300">
                    <div class="text-4xl font-bold text-indigo-600 mb-2 flex items-center justify-center gap-2">
                        <span class="counter">50</span>
                        <span>+</span>
                    </div>
                    <p class="text-gray-600 font-medium">Active Hospitals</p>
                </div>
                <div class="bg-white rounded-2xl p-8 text-center shadow-lg hover:shadow-xl transition-shadow duration-300">
                    <div class="text-4xl font-bold text-green-600 mb-2 flex items-center justify-center gap-2">
                        <span class="counter">5</span>
                        <span>M+</span>
                    </div>
                    <p class="text-gray-600 font-medium">Patients Served</p>
                </div>
                <div class="bg-white rounded-2xl p-8 text-center shadow-lg hover:shadow-xl transition-shadow duration-300">
                    <div class="text-4xl font-bold text-purple-600 mb-2">24/7</div>
                    <p class="text-gray-600 font-medium">Support Available</p>
                </div>
            </div>
      </div>
    </section>

    <!-- Why Choose Us Section -->
    <section class="relative py-32 bg-gradient-to-br from-gray-900 via-indigo-950 to-purple-950">
        <!-- Background Elements -->
        <div class="absolute inset-0 z-0">
            <div class="absolute top-0 -left-64 w-96 h-96 bg-indigo-500/20 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob"></div>
            <div class="absolute top-0 -right-64 w-96 h-96 bg-purple-500/20 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob animation-delay-2000"></div>
            <div class="absolute -bottom-64 left-64 w-96 h-96 bg-pink-500/20 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob animation-delay-4000"></div>
        </div>
    
        <div class="container mx-auto px-4 relative z-10">
            <!-- Section Header -->
            <div class="max-w-3xl mx-auto text-center mb-20">
                <span class="text-sm font-bold tracking-wider text-yellow-400 uppercase mb-4 block why-choose-header" data-en="Main Factors" data-fr="Facteurs Principaux">
            Main Factors                </span>
                <h2 class="text-4xl md:text-5xl font-extrabold mb-6 text-white why-choose-title" data-en="Why choose Medi Soft?" data-fr="Pourquoi choisir Medi Soft ?">
            Pourquoi choisir Medi Soft ?          </h2>
                <div class="w-24 h-1 bg-gradient-to-r from-yellow-400 to-yellow-300 mx-auto rounded-full mb-6"></div>
                <p class="text-xl text-gray-300 leading-relaxed why-choose-desc" data-en="Hospital management software is essential to optimize hospital operations by improving efficiency, quality of care, patient satisfaction, and reducing costs. It enables centralized management of information, processes and resources, resulting in better patient care and reduced errors." data-fr="Un logiciel de gestion hospitalière est essentiel pour optimiser le fonctionnement d'un hôpital en améliorant l'efficacité, la qualité des soins, la satisfaction des patients, et en réduisant les coûts. Il permet une gestion centralisée des informations, des processus et des ressources, ce qui se traduit par une meilleure prise en charge des patients et une réduction des erreurs.">
            Un logiciel de gestion hospitalière est essentiel pour optimiser le fonctionnement d'un hôpital en améliorant l'efficacité, la qualité des soins, la satisfaction des patients, et en réduisant les coûts. Il permet une gestion centralisée des informations, des processus et des ressources, ce qui se traduit par une meilleure prise en charge des patients et une réduction des erreurs. 
            
                <p class="text-xl text-gray-300 leading-relaxed why-choose-reasons" data-en="Here are some key reasons why a hospital should use management software:" data-fr="Voici quelques raisons clés pour lesquelles un hôpital devrait utiliser un logiciel de gestion :">
            Voici quelques raisons clés pour lesquelles un hôpital devrait utiliser un logiciel de gestion :  </p>
        </div>

            <!-- Features Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 lg:gap-12">
                <!-- Left Column -->
                <div class="space-y-8">
                    <!-- Card 1 -->
                    <div class="group bg-white/10 backdrop-blur-lg rounded-2xl p-8 border border-white/10 hover:bg-white/20 transition-all duration-300 transform hover:-translate-y-1">
                        <div class="flex items-center gap-4 mb-4">
                            <div class="w-12 h-12 bg-gradient-to-br from-yellow-400 to-yellow-300 rounded-xl flex items-center justify-center">
                                <i class="fas fa-star text-gray-900 text-xl"></i>
                            </div>
                            <h4 class="text-2xl font-bold text-white why-card-title" data-en="1. Electronic medical records" data-fr="1. Dossiers médicaux électroniques">
                              1. Dossiers médicaux électroniques               </h4>
                        </div>
                        <p class="text-gray-300 text-lg leading-relaxed why-card-desc" data-en="With MEDI SOFT, the patient file is computerized (EPR). It offers several advantages over paper medical records, particularly in terms of time savings. For doctors, it provides quick and easy access to patient medical history, previous diagnoses and treatments. For patients, it provides instant access to their health history and previous treatments. Patients can share their information with different healthcare professionals if they change city or doctor." data-fr="Avec MEDI SOFT, Le dossier patient est informatisé (DPI). Il présente plusieurs avantages par rapport au carnet médical papier, notamment en termes de gain de temps. Pour le médecin, il procure un accès rapide et facile aux antécédent médicaux du patient, aux anciens diagnostics et traitements. Pour le patient, il procure un accès instantané a son historique de santé et précédents traitements. Possibilité pour le patient s’il change de ville ou de médecin de partager ses informations avec différents professionnels de santé.  ">
     Avec MEDI SOFT, Le dossier patient est informatisé (DPI). Il présente plusieurs avantages par rapport au carnet médical papier, notamment en termes de gain de temps. Pour le médecin, il procure un accès rapide et facile aux antécédent médicaux du patient, aux anciens diagnostics et traitements. Pour le patient, il procure un accès instantané a son historique de santé et précédents traitements. Possibilité pour le patient s’il change de ville ou de médecin de partager ses informations avec différents professionnels de santé.  </p>
            </div>

                    <!-- Card 2 -->
                    <div class="group bg-white/10 backdrop-blur-lg rounded-2xl p-8 border border-white/10 hover:bg-white/20 transition-all duration-300 transform hover:-translate-y-1">
                        <div class="flex items-center gap-4 mb-4">
                            <div class="w-12 h-12 bg-gradient-to-br from-blue-400 to-blue-300 rounded-xl flex items-center justify-center">
                                <i class="fas fa-shield-alt text-gray-900 text-xl"></i>
                            </div>
                            <h4 class="text-2xl font-bold text-white why-card-title" data-en="2. Your online appointment scheduling software" data-fr="2. Votre logiciel de prise de rendez-vous en ligne">
                2. Votre logiciel de prise de rendez-vous en ligne             </h4>
                        </div>
                        <p class="text-gray-300 text-lg leading-relaxed why-card-desc" data-en="MEDI SOFT offers hospitals an online appointment scheduling solution perfectly adapted to their daily routine. Whether you work alone, in a multidisciplinary practice, or within a clinic or hospital group, MEDI SOFT is the essential tool for improving your secretarial operations. Your patients book appointments 24/7 on their smartphones, everything is synchronized in real-time at the reception desk and on your phone." data-fr="MEDI SOFT offre aux hôpitaux une solution de prise de rendez-vous en ligne parfaitement adaptée à leur quotidien. Que vous soyez seul(e), en cabinet pluridisciplinaire ou au sein d'une clinique ou d'un groupe hospitalier, MEDI SOFT est l'outil essentiel à l'amélioration du fonctionnement de votre secrétariat. Vos patients prennent RDV 24h/24 et 7j/7 sur leur smartphone, le tout est synchronisé en temps réel au secrétariat et sur votre téléphone.">
               MEDI SOFT offre aux hôpitaux une solution de prise de rendez-vous en ligne parfaitement adaptée à leur quotidien. Que vous soyez seul(e), en cabinet pluridisciplinaire ou au sein d'une clinique ou d'un groupe hospitalier, MEDI SOFT est l'outil essentiel à l'amélioration du fonctionnement de votre secrétariat. Vos patients prennent RDV 24h/24 et 7j/7 sur leur smartphone, le tout est synchronisé en temps réel au secrétariat et sur votre téléphone.</p>
            </div>

                    <!-- Card 3 -->
                    <div class="group bg-white/10 backdrop-blur-lg rounded-2xl p-8 border border-white/10 hover:bg-white/20 transition-all duration-300 transform hover:-translate-y-1">
                        <div class="flex items-center gap-4 mb-4">
                            <div class="w-12 h-12 bg-gradient-to-br from-green-400 to-green-300 rounded-xl flex items-center justify-center">
                                <i class="fas fa-check-circle text-gray-900 text-xl"></i>
                            </div>
                            <h4 class="text-2xl font-bold text-white why-card-title" data-en="3. Cost reduction and inventory management optimization" data-fr="3. Réduction des coûts et Optimisation de la gestion des stocks">
                3. Réduction des coûts et Optimisation de la gestion des stocks   </h4>
                        </div>
                        <p class="text-gray-300 text-lg leading-relaxed why-card-desc" data-en="MEDI SOFT enables real-time inventory tracking, prevents stockouts, and reduces costs related to medication and supply management. Similarly, automation of administrative processes reduces billing errors and losses." data-fr="MEDI SOFT permet de suivre les stocks en temps réel, d'éviter les ruptures de stock et de réduire les coûts liés à la gestion des médicaments et des fournitures. De même, l'automatisation des processus administratifs réduit les erreurs de facturation et les pertes.">
               MEDI SOFT permet de suivre les stocks en temps réel, d'éviter les ruptures de stock et de réduire les coûts liés à la gestion des médicaments et des fournitures. De même, l'automatisation des processus administratifs réduit les erreurs de facturation et les pertes.</p>
            </div>
          </div>

                <!-- Right Column -->
                <div class="space-y-8 mt-8 md:mt-16">
                    <!-- Card 4 -->
                    <div class="group bg-white/10 backdrop-blur-lg rounded-2xl p-8 border border-white/10 hover:bg-white/20 transition-all duration-300 transform hover:-translate-y-1">
                        <div class="flex items-center gap-4 mb-4">
                            <div class="w-12 h-12 bg-gradient-to-br from-purple-400 to-purple-300 rounded-xl flex items-center justify-center">
                                <i class="fas fa-rocket text-gray-900 text-xl"></i>
                            </div>
                            <h4 class="text-2xl font-bold text-white why-card-title" data-en="4. Improvement of care quality" data-fr="4. Amélioration de la qualité des soins">
                4. Amélioration de la qualité des soins              </h4>
                        </div>
                        <p class="text-gray-300 text-lg leading-relaxed why-card-desc" data-en="Personalized care: By centralizing patient information, the software enables better understanding of their needs and medical history, facilitating more personalized care while reducing medication errors, diagnostic errors and administrative errors" data-fr="Prise en charge personnalisée : En centralisant les informations sur les patients, le logiciel permet une meilleure compréhension de leurs besoins et de leurs antécédents médicaux, ce qui facilite une prise en charge plus personnalisée, tout en réduisant les erreurs de médication, les erreurs de diagnostic et les erreurs administratives ">
                 Prise en charge personnalisée : En centralisant les informations sur les patients, le logiciel permet une meilleure compréhension de leurs besoins et de leurs antécédents médicaux, ce qui facilite une prise en charge plus personnalisée, tout en réduisant les erreurs de médication, les erreurs de diagnostic et les erreurs administratives </p>
            </div>

                    <!-- Card 5 -->
                    <div class="group bg-white/10 backdrop-blur-lg rounded-2xl p-8 border border-white/10 hover:bg-white/20 transition-all duration-300 transform hover:-translate-y-1">
                        <div class="flex items-center gap-4 mb-4">
                            <div class="w-12 h-12 bg-gradient-to-br from-pink-400 to-pink-300 rounded-xl flex items-center justify-center">
                                <i class="fas fa-heart text-gray-900 text-xl"></i>
                            </div>
                            <h4 class="text-2xl font-bold text-white why-card-title" data-en="5. Increased patient satisfaction" data-fr="5. Satisfaction accrue des patients">
                5. Satisfaction accrue des patients  </h4>
                        </div>
                        <p class="text-gray-300 text-lg leading-relaxed why-card-desc" data-en="Less waiting: Reducing wait times and improving care delivery contributes to a better patient experience. Patients can access their medical information, such as test results and prescriptions, which promotes their autonomy and involvement in their care." data-fr="Moins d’attente : La réduction des temps d'attente et l'amélioration de la prise en charge contribuent à une meilleure expérience patient. Les patients peuvent accéder à leurs informations médicales, telles que les résultats d'examens et les ordonnances, ce qui favorise leur autonomie et leur implication dans leurs soins.">
                Moins d’attente : La réduction des temps d'attente et l'amélioration de la prise en charge contribuent à une meilleure expérience patient. Les patients peuvent accéder à leurs informations médicales, telles que les résultats d'examens et les ordonnances, ce qui favorise leur autonomie et leur implication dans leurs soins.</p>
            </div>

                    <!-- Testimonial Card -->
                    <div class="group bg-gradient-to-br from-indigo-600 to-purple-600 rounded-2xl p-8 shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-1">
                        <div class="flex items-center gap-4 mb-4">
                            <div class="w-16 h-16 bg-white rounded-xl flex items-center justify-center">
                                <i class="fas fa-quote-right text-indigo-600 text-2xl"></i>
                            </div>
                            <div>
                                <h4 class="text-2xl font-bold text-white why-card-title" data-en="6. Improvement of efficiency and productivity" data-fr="6. Amélioration de l'efficacité et de la productivité">
                6. Amélioration de l'efficacité et de la productivité </h4>
                                <p class="text-indigo-200 text-lg why-card-desc" data-en="Task automation: The software automates many administrative and clinical tasks, such as appointment scheduling, billing, inventory management and report generation, freeing up staff for more important tasks." data-fr="Automatisation des tâches: Le logiciel automatise de nombreuses tâches administratives et cliniques, telles que la planification des rendez-vous, la facturation, la gestion des stocks et la production de rapports, libérant ainsi le personnel pour des tâches plus importantes. ">
               Automatisation des tâches: Le logiciel automatise de nombreuses tâches administratives et cliniques, telles que la planification des rendez-vous, la facturation, la gestion des stocks et la production de rapports, libérant ainsi le personnel pour des tâches plus importantes. </p>
                            </div>
                        </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <style>
    .text1 {
        display: none;
    }
</style>



    

    <!-- Registration Section -->
    <section class="relative py-32 bg-gradient-to-br from-indigo-900 via-purple-900 to-indigo-900" id="register">
        <!-- Background Elements -->
        <div class="absolute inset-0 z-0">
            <div class="absolute top-0 -left-64 w-96 h-96 bg-indigo-500/20 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob"></div>
            <div class="absolute top-0 -right-64 w-96 h-96 bg-purple-500/20 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob animation-delay-2000"></div>
            <div class="absolute -bottom-64 left-64 w-96 h-96 bg-pink-500/20 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob animation-delay-4000"></div>
        </div>
    
        <div class="container mx-auto px-4 relative z-10">
            <!-- Section Header -->
            <div class="max-w-3xl mx-auto text-center mb-16">
                <span class="text-sm font-bold tracking-wider text-indigo-300 uppercase mb-4 block register-header" data-en="Join Us" data-fr="Rejoignez-nous">
                    Join Us                </span>
                <h2 class="text-4xl md:text-5xl font-extrabold mb-6 text-white register-title" data-en="Request your Free Demo" data-fr="Demandez votre démo Gratuite">
          Demandez votre démo Gratuite       </h2>
                <div class="w-24 h-1 bg-gradient-to-r from-indigo-400 to-purple-400 mx-auto rounded-full mb-6"></div>
                <p class="text-xl text-indigo-200 leading-relaxed register-desc" data-en="Get started with MEDI SOFT today" data-fr="">
                      </p>
        </div>

            <!-- Registration Form -->
            <div class="max-w-4xl mx-auto">
                <div class="bg-white/10 backdrop-blur-lg rounded-2xl overflow-hidden shadow-2xl">
                    <div class="p-8 bg-gradient-to-r from-indigo-600/20 to-purple-600/20 border-b border-white/10">
                        <h3 class="text-2xl font-bold text-white mb-2 register-form-title" data-en="Free Demo Request" data-fr="Demande de démo Gratuite">
              Demande de démo Gratuite          </h3>
                        <p class="text-indigo-200 register-form-desc" data-en="Fill out the form below to request your free demonstration" data-fr="">
                          </p>
          </div>

                    <form action="frontend/addNewHospitalPayment" method="post" id="addNewHospital" enctype="multipart/form-data" class="p-8 space-y-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <input type="text" name="name" placeholder="Hospital Name*" data-en-placeholder="Hospital Name*" data-fr-placeholder="Nom de l'Hôpital*" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-white placeholder-gray-400 focus:border-indigo-500">
                            
                            <input type="text" name="address" placeholder="Hospital Address*" data-en-placeholder="Hospital Address*" data-fr-placeholder="Adresse de l'Hôpital*" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-white placeholder-gray-400 focus:border-indigo-500 focus:ring-1 focus:ring-indigo-500">
                            
                            <input type="email" name="email" placeholder="Hospital Email*" data-en-placeholder="Hospital Email*" data-fr-placeholder="Email de l'Hôpital*" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-white placeholder-gray-400 focus:border-indigo-500 focus:ring-1 focus:ring-indigo-500">
                            
                            <input type="text" name="phone" placeholder="Hospital Phone*" data-en-placeholder="Hospital Phone*" data-fr-placeholder="Téléphone de l'Hôpital*" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-white placeholder-gray-400 focus:border-indigo-500 focus:ring-1 focus:ring-indigo-500">

              <div class="package_select_div">
                                <select name="package" id="package_select" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-white focus:border-indigo-500 focus:ring-1 focus:ring-indigo-500">
                                    <option class="bg-gray-900 text-white" data-en="Select Package" data-fr="Sélectionner un Pack">Select Package</option>
                                                              <option class="bg-gray-900 text-white" value="1" data-en="Premium" data-fr="Premium">Premium </option>
                                                              <option class="bg-gray-900 text-white" value="2" data-en="Standard" data-fr="Standard">Standard</option>
                                                              <option class="bg-gray-900 text-white" value="3" data-en="Starter" data-fr="Démarrage">Starter</option>
                                  </select>
              </div>

              <div class="package_duration_div">
                                <select name="package_duration" id="package_duration" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-white focus:border-indigo-500 focus:ring-1 focus:ring-indigo-500">
                                    <option class="bg-gray-900 text-white" value="monthly">Monthly</option>
                                    <option class="bg-gray-900 text-white" value="yearly">Yearly</option>
                </select>
              </div>

                            <select name="language" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-white focus:border-indigo-500 focus:ring-1 focus:ring-indigo-500">
                                <option class="bg-gray-900 text-white" data-en="Select Language" data-fr="Sélectionner la Langue">Select Language</option>
                                <option class="bg-gray-900 text-white" value="arabic">Ø¹Ø±Ø¨ÙÂÂÂÂÂÂÂÂÂÂÂ</option>
                                <option class="bg-gray-900 text-white" value="english">English</option>
                                <option class="bg-gray-900 text-white" value="spanish">Español</option>
                                <option class="bg-gray-900 text-white" value="french">Français</option>
                                <option class="bg-gray-900 text-white" value="italian">Italiano</option>
                                <option class="bg-gray-900 text-white" value="portuguese">Português</option>
                                <option class="bg-gray-900 text-white" value="turkish">Türkçe</option>
              </select>

                            <input type="text" name="price" placeholder="Price*" class="price-input w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-white placeholder-gray-400 focus:border-indigo-500 focus:ring-1 focus:ring-indigo-500">
                                   <input type="text" name="username" id="username" placeholder="Frontend Website Link*" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-white placeholder-gray-400 focus:border-indigo-500 focus:ring-1 focus:ring-indigo-500">
                                   
                            <input type="text" name="country" placeholder="Country*" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-white placeholder-gray-400 focus:border-indigo-500 focus:ring-1 focus:ring-indigo-500">
                                   <p id="web_link"><a style="color:#0cb8b6;" target="_blank" href="https://medecinesoft.com/site/">https://medecinesoft.com/site/</a></p>
                                </div>

                        <textarea name="remarks" placeholder="Remarks*" rows="4" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-white placeholder-gray-400 focus:border-indigo-500 focus:ring-1 focus:ring-indigo-500"></textarea>

                        <div class="payment_div space-y-6">
                                              <select name="card_type" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-white focus:border-indigo-500 focus:ring-1 focus:ring-indigo-500">
                  <option value="Mastercard">Master Card</option>
                  <option value="Visa">Visa</option>
                  <option value="American Express">American Express</option>
                </select>
                                <input type="text" name="cardholder" placeholder="Card Holder Name" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-white placeholder-gray-400 focus:border-indigo-500 focus:ring-1 focus:ring-indigo-500">
              
                                                            <input type="text" name="card_number" id="card" placeholder="Card Number*" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-white placeholder-gray-400 focus:border-indigo-500 focus:ring-1 focus:ring-indigo-500">
                                
                                <div class="grid grid-cols-2 gap-6">
                                    <input type="text" name="expire_date" id="expire" placeholder="Expire Date" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-white placeholder-gray-400 focus:border-indigo-500 focus:ring-1 focus:ring-indigo-500">
                                    
                                    <input type="text" name="cvv_number" id="cvv" placeholder="CVV" maxlength="3" class="w-full px-4 py-3 bg-white/5 border border-white/10 rounded-xl text-white placeholder-gray-400 focus:border-indigo-500 focus:ring-1 focus:ring-indigo-500">
                </div>
                          </div>

                        <div class="flex items-center gap-3 trial_version_div_div">
                            <input type="checkbox" name="trial_version" value="1" class="trial_version w-5 h-5 bg-white/5 border border-white/10 rounded text-indigo-500 focus:ring-indigo-500">
                            <span class="text-white">Do You Want Trial Version??</span>
            </div>

            <input type="hidden" name="request" value="">
            <input type="hidden" name="recaptcha_response" id="recaptchaResponse">

                        <button type="submit" id="submit-btn" class="w-full py-4 bg-gradient-to-r from-indigo-500 to-purple-500 text-white text-xl font-bold rounded-xl hover:from-indigo-600 hover:to-purple-600 transition-all duration-300 transform hover:scale-105">
              Register Hospital            </button>
          </form>
                </div>
        </div>
      </div>
    </section>

    <!-- Reviews Section -->
    <section class="relative py-32 bg-gradient-to-b from-white to-gray-50" id="review">
        <!-- Background Elements -->
        <div class="absolute inset-0 z-0">
            <div class="absolute top-0 -left-64 w-96 h-96 bg-indigo-100 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob"></div>
            <div class="absolute top-0 -right-64 w-96 h-96 bg-purple-100 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob animation-delay-2000"></div>
            <div class="absolute -bottom-64 left-64 w-96 h-96 bg-pink-100 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob animation-delay-4000"></div>
        </div>

        <div class="container mx-auto px-4 relative z-10">
            <!-- Section Header -->
            <div class="max-w-3xl mx-auto text-center mb-20">
                <span class="text-sm font-bold tracking-wider text-indigo-600 uppercase mb-4 block reviews-header" data-en="Review" data-fr="Avis">
            Review                </span>
                <h2 class="text-4xl md:text-5xl font-extrabold mb-6 text-gray-900 reviews-title" data-en="What did our customers say?" data-fr="Que disent nos clients ?">
            What did our customer say?          </h2>
                <div class="w-24 h-1 bg-gradient-to-r from-indigo-500 to-purple-500 mx-auto rounded-full mb-6"></div>
                <p class="text-xl text-gray-600 leading-relaxed reviews-description" data-en="In a hospital using Medi Soft, the typical patient journey from arrival to discharge is as follows:" data-fr="Dans un hôpital utilisant Medi Soft, le parcours typique d’un patient de son arrivée a l’hôpital a sa sortie est le suivant :">
            Dans un hôpital utilisant Medi Soft, le parcours typique d’un patient de son arrivée a l’hôpital a sa sortie est le suivant :          </p>
        </div>

            <!-- Reviews Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 lg:gap-16">
                              <div class="group relative bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-1">
                        <div class="absolute top-0 left-0 w-full h-1 bg-gradient-to-r from-indigo-500 to-purple-500 rounded-t-2xl"></div>
                        
                        <!-- Review Header -->
                        <div class="flex items-center gap-6 mb-8">
                            <img src="uploads/Sans_titre_-_31.png" class="w-20 h-20 rounded-2xl object-cover border-4 border-white shadow-xl group-hover:scale-110 transition-transform duration-300" alt="Reviewer">
                            <div>
                                <h3 class="text-2xl font-bold text-gray-900 group-hover:text-indigo-600 transition-colors duration-300 review-title" data-en="Patient arrival and hospital admission" data-fr="Arrivée et accueil du patient qui se présente a l'hopital">
                                    Arrivée et accueil du patient qui se présente a l'hopital                                </h3>
                                <div class="flex items-center gap-1 mt-2">
                                                            <svg class="w-6 h-6 text-yellow-400 transition-colors duration-300" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                      </svg>
                                                            <svg class="w-6 h-6 text-yellow-400 transition-colors duration-300" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                      </svg>
                                                            <svg class="w-6 h-6 text-yellow-400 transition-colors duration-300" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                      </svg>
                                                            <svg class="w-6 h-6 text-yellow-400 transition-colors duration-300" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                      </svg>
                                                            <svg class="w-6 h-6 text-yellow-400 transition-colors duration-300" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                      </svg>
                                      </div>
                </div>
              </div>

                        <!-- Review Content -->
                        <p class="text-gray-600 text-lg leading-relaxed review-content" data-en="The nurse at reception identifies the patient who presents themselves. If the patient has already visited the health facility, their file is easily retrieved on PC or tablet; administrative information is already available and will not be entered again. If it's a new patient, their administrative information is recorded. The nurse will take and enter into Medi Soft the patient's parameters such as: 1) Blood pressure 2) Temperature 3) Respiratory rate 4) Weight and height. A visit is then opened, either for consultation or hospitalization (by the admissions department)." data-fr="L’infirmière a l’accueil identifie le patient qui se présente. Si le patient est déjà venu dans la structure de santé, son dossier est facilement retrouvé sur PC ou tablette ; les informations administratives sont déjà disponibles et ne serons pas saisies à nouveau. Si c’est un nouveau patient, ses informations administratives sont consignées. L’infirmière prendra et saisira dans Medi Soft les paramètres du patient tel que : 1) Sa pression artérielle 2) La température 3) La fréquence respiratoire 4) Son poids et sa taille Un passage est ensuite ouvert, soit en consultation, soit en hospitalisation (par le service d’admission).">
                            L’infirmière a l’accueil identifie le patient qui se présente. Si le patient est déjà venu dans la structure de santé, son dossier est facilement retrouvé sur PC ou tablette ; les informations administratives sont déjà disponibles et ne serons pas saisies à nouveau. Si c’est un nouveau patient, ses informations administratives sont consignées. L’infirmière prendra et saisira dans Medi Soft les paramètres du patient tel que : 1) Sa pression artérielle 2) La température 3) La fréquence respiratoire 4) Son poids et sa taille Un passage est ensuite ouvert, soit en consultation, soit en hospitalisation (par le service d’admission).                        </p>
            </div>
                              <div class="group relative bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-1">
                        <div class="absolute top-0 left-0 w-full h-1 bg-gradient-to-r from-indigo-500 to-purple-500 rounded-t-2xl"></div>
                        
                        <!-- Review Header -->
                        <div class="flex items-center gap-6 mb-8">
                            <img src="uploads/Sans_titre_-_2.png" class="w-20 h-20 rounded-2xl object-cover border-4 border-white shadow-xl group-hover:scale-110 transition-transform duration-300" alt="Reviewer">
                            <div>
                                <h3 class="text-2xl font-bold text-gray-900 group-hover:text-indigo-600 transition-colors duration-300 review-title" data-en="The patient is directed to the destination department" data-fr="Le patient est dirigé vers le service de destination">
                                    Le patient est dirigé vers le service de destination                                </h3>
                                <div class="flex items-center gap-1 mt-2">
                                                            <svg class="w-6 h-6 text-yellow-400 transition-colors duration-300" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                      </svg>
                                                            <svg class="w-6 h-6 text-yellow-400 transition-colors duration-300" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                      </svg>
                                                            <svg class="w-6 h-6 text-yellow-400 transition-colors duration-300" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                      </svg>
                                                            <svg class="w-6 h-6 text-yellow-400 transition-colors duration-300" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                      </svg>
                                                            <svg class="w-6 h-6 text-yellow-400 transition-colors duration-300" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                      </svg>
                                      </div>
                </div>
              </div>

                        <!-- Review Content -->
                        <p class="text-gray-600 text-lg leading-relaxed review-content" data-en="The doctor who receives him has access on his PC or tablet to the list of waiting patients. He selects the patient he receives and reviews the parameters taken at reception and his medical history, as well as the details of previous visits if any. After examining the patient, the doctor can request laboratory tests, which he indicates on his PC or tablet." data-fr="Le médecin qui le recoit dispose sur son PC ou sa tablette de la liste des patients en attente. Il sélectionne le patient qu’il reçoit et consulte ses paramètres pris à l'accueil et son historique médical, ainsi que le détail éventuel de visites précédentes. Après avoir examiné le patient, le médecin peut demander des examens de laboratoire, ce qu’il indique sur son PC ou tablette.">
                            Le médecin qui le recoit dispose sur son PC ou sa tablette de la liste des patients en attente. Il sélectionne le patient qu’il reçoit et consulte ses paramètres pris à l'accueil et son historique médical, ainsi que le détail éventuel de visites précédentes. Après avoir examiné le patient, le médecin peut demander des examens de laboratoire, ce qu’il indique sur son PC ou tablette.                        </p>
            </div>
                              <div class="group relative bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-1">
                        <div class="absolute top-0 left-0 w-full h-1 bg-gradient-to-r from-indigo-500 to-purple-500 rounded-t-2xl"></div>
                        
                        <!-- Review Header -->
                        <div class="flex items-center gap-6 mb-8">
                            <img src="uploads/Sans_titre_-_4.png" class="w-20 h-20 rounded-2xl object-cover border-4 border-white shadow-xl group-hover:scale-110 transition-transform duration-300" alt="Reviewer">
                            <div>
                                <h3 class="text-2xl font-bold text-gray-900 group-hover:text-indigo-600 transition-colors duration-300 review-title" data-en="Examination request transmitted to the laboratory" data-fr="Demande d'examens transmise au laboratoire">
                                    Demande d'examens transmise au laboratoire                                </h3>
                                <div class="flex items-center gap-1 mt-2">
                                                            <svg class="w-6 h-6 text-yellow-400 transition-colors duration-300" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                      </svg>
                                                            <svg class="w-6 h-6 text-yellow-400 transition-colors duration-300" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                      </svg>
                                                            <svg class="w-6 h-6 text-yellow-400 transition-colors duration-300" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                      </svg>
                                                            <svg class="w-6 h-6 text-yellow-400 transition-colors duration-300" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                      </svg>
                                                            <svg class="w-6 h-6 text-yellow-400 transition-colors duration-300" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                      </svg>
                                      </div>
                </div>
              </div>

                        <!-- Review Content -->
                        <p class="text-gray-600 text-lg leading-relaxed review-content" data-en="The examination request will appear at the lab technician's station, who can proceed with sample collection and analysis. The lab technician then enters the test results on their PC (or tablet). These results automatically appear at the doctor's station, who can indicate a diagnosis and potentially prescribe medications," data-fr="La demande d’examen apparaitra chez le laborantin, qui pourra procéder à la prise d’échantillons et à leurs analyses. Le laborantin saisie ensuite sur son PC (ou tablette) les résultats des examens. Ces résultats apparaissent automatiquement chez le médecin, qui peut indiquer un diagnostic et prescrire éventuellement des médicaments,">
                            La demande d’examen apparaitra chez le laborantin, qui pourra procéder à la prise d’échantillons et à leurs analyses. Le laborantin saisie ensuite sur son PC (ou tablette) les résultats des examens. Ces résultats apparaissent automatiquement chez le médecin, qui peut indiquer un diagnostic et prescrire éventuellement des médicaments,                         </p>
            </div>
                  </div>
      </div>
    </section>

    <!-- FAQ Section -->
    <section class="relative py-32 bg-gradient-to-br from-indigo-50 to-purple-100" id="faq">
        <!-- Background Elements -->
        <div class="absolute inset-0 z-0">
            <div class="absolute top-0 -left-64 w-96 h-96 bg-indigo-200 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob"></div>
            <div class="absolute top-0 -right-64 w-96 h-96 bg-purple-200 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob animation-delay-2000"></div>
            <div class="absolute -bottom-64 left-64 w-96 h-96 bg-pink-200 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob animation-delay-4000"></div>
        </div>

        <div class="container mx-auto px-4 relative z-10">
            <!-- Section Header -->
            <div class="max-w-3xl mx-auto text-center mb-20">
                <!--<span class="text-sm font-bold tracking-wider text-indigo-600 uppercase mb-4 block">
            Unravel Your Queries          </span>-->
                <h2 class="text-4xl md:text-5xl font-extrabold mb-6 text-gray-900 faq-title" data-en="Frequently Asked Questions" data-fr="Questions fréquemment posées">
            Questions fréquemment posées         </h2>
                <div class="w-24 h-1 bg-gradient-to-r from-indigo-500 to-purple-500 mx-auto rounded-full mb-6"></div>
        </div>

            <div class="flex flex-col lg:flex-row items-start justify-between gap-16">
                <!-- FAQ List -->
                <div class="w-full lg:w-2/3 space-y-6">
                                    <div class="group bg-white rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300">
    <div class="parent cursor-pointer p-6" onclick="toggleChild(this)">
                                <div class="flex justify-between items-center">
                                    <h3 class="text-xl font-bold text-gray-900 group-hover:text-indigo-600 transition-colors duration-300 faq-module-title" data-en="Administrative Module" data-fr="Module Administratif">
                                        Administrative Module                                    </h3>
                                    <div class="toggle-icon transform transition-transform duration-300">
                                        <svg class="w-6 h-6 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                  </div>
                                </div>
        <div class="cc hidden mt-4">
                                    <p class="text-gray-600 text-lg leading-relaxed">
                                        We have designed the administrative module for a hospital owner or the person who is accountable to operate the entire hospital smoothly. Using this module, you can manage the entire system easily and efficiently. Because this module includes every important feature like doctors portal, patient portal, appointment scheduling, prescription management, human resource management, bed management, employee, accounts, software settings, role assigning, etc.                                    </p>
                  </div>
                </div>
              </div>
                                    <div class="group bg-white rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300">
    <div class="parent cursor-pointer p-6" onclick="toggleChild(this)">
                                <div class="flex justify-between items-center">
                                    <h3 class="text-xl font-bold text-gray-900 group-hover:text-indigo-600 transition-colors duration-300 faq-module-title" data-en="Doctor Module" data-fr="Module Médecin">
                                        Doctor Module                                    </h3>
                                    <div class="toggle-icon transform transition-transform duration-300">
                                        <svg class="w-6 h-6 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                  </div>
                                </div>
        <div class="cc hidden mt-4">
                                    <p class="text-gray-600 text-lg leading-relaxed">
                                        A doctor is the most important person to ensure the health condition of any patient. For this purpose, this software has a doctor module. Using this module, doctors can access all important functions that belong to them. As a result, they can maintain patient portals, appointment scheduling &amp; maintaining, prescription making, and any other things that are related to hospital activities.                                    </p>
                  </div>
                </div>
              </div>
                                    <div class="group bg-white rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300">
    <div class="parent cursor-pointer p-6" onclick="toggleChild(this)">
                                <div class="flex justify-between items-center">
                                    <h3 class="text-xl font-bold text-gray-900 group-hover:text-indigo-600 transition-colors duration-300 faq-module-title" data-en="Accountants Module" data-fr="Module Comptable">
                                        Accountants Module                                    </h3>
                                    <div class="toggle-icon transform transition-transform duration-300">
                                        <svg class="w-6 h-6 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                  </div>
                                </div>
        <div class="cc hidden mt-4">
                                    <p class="text-gray-600 text-lg leading-relaxed">
                                        Accountants are responsible to control monetary flow, profit-and- loss calculation. Patients are considered the main factor of this software. Moreover, they are the key earning source of this system. So this module allows access to the patient portal. Besides, the Accountant module also has the access account creation option, like debit or credit account based on expense and earning, employee name, and billing. With this software, you can get a complete clinic management system that helps to understand both technical or non-technical people.                                    </p>
                  </div>
                </div>
              </div>
                      </div>

                <!-- FAQ Illustration -->
                <div class="w-full lg:w-1/3">
                    <div class="relative">
                        <div class="absolute -top-8 -left-8 w-32 h-32 bg-purple-300/50 rounded-full"></div>
                        <img src="new-fnt/assets/images/Vector (1).svg" alt="FAQ Illustration" class="relative z-10 w-full max-w-md mx-auto transform -rotate-6 hover:rotate-0 transition-transform duration-500">
                        <div class="mt-12 text-center">
                            <p class="text-xl font-semibold text-indigo-900 mb-6 faq-prompt" data-en="Still Puzzled?" data-fr="Encore perplexe ?">
                                Still Puzzled?                            </p>
                            <a href="#contact" class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-indigo-600 to-purple-600 text-white rounded-xl font-bold hover:from-indigo-700 hover:to-purple-700 transition-all duration-300 transform hover:scale-105 shadow-lg faq-contact-link" data-en="Reach Out To Us" data-fr="Contactez-nous">
                                Reach Out To Us                                <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                                </svg>
                            </a>
                        </div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Contact Section -->
    <section id="contact" class="bg-gradient-to-br from-indigo-950 to-purple-900 py-24 sm:py-24 md:py-32">
      <div class="container mx-auto px-4 sm:px-6 md:px-8">
        <div class="text-center mb-12 sm:mb-16 md:mb-20">
          <span class="text-xs sm:text-sm uppercase tracking-widest text-indigo-300 mb-2 sm:mb-3 block font-bold contact-subtitle" data-en="Get in Touch" data-fr="Contactez-nous">
            Get in Touch          </span>
          <h2 class="text-3xl sm:text-5xl md:text-6xl font-black text-white mb-4 sm:mb-6 leading-tight contact-title" data-en="Contact Us" data-fr="Contactez-nous">
            Contact Us          </h2>
          <div class="w-24 sm:w-32 h-1 sm:h-2 bg-gradient-to-r from-white to-purple-300 mx-auto rounded-full"></div>
          <p class="text-lg sm:text-xl md:text-2xl text-indigo-200 max-w-2xl mx-auto mt-4 sm:mt-6 leading-relaxed">
                      </p>
        </div>

        <div class="flex flex-col lg:flex-row items-stretch justify-between space-y-8 lg:space-y-0 lg:space-x-8 xl:space-x-12">
          <div class="w-full lg:w-1/2 bg-white rounded-2xl shadow-xl p-6 sm:p-8 md:p-10">
            <h3 class="text-2xl sm:text-3xl md:text-4xl font-extrabold text-indigo-900 mb-4 sm:mb-6 md:mb-8 contact-info-title" data-en="Contact Information" data-fr="Informations de Contact">
              Contact Information            </h3>

            <p class="text-base sm:text-lg md:text-xl text-gray-700 mb-6 sm:mb-8 md:mb-10 leading-relaxed">
                            <span class="font-bold text-indigo-600 block mt-2 text-lg sm:text-xl md:text-2xl">
                              </span>
            </p>

            <div class="space-y-4 sm:space-y-6">
              <div class="flex items-center bg-indigo-100 p-4 rounded-xl">
                <svg class="w-8 h-8 sm:w-10 sm:h-10 text-indigo-600 mr-4 sm:mr-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                </svg>
                <span class="text-base sm:text-lg md:text-xl font-bold text-indigo-800">info@barcles.com</span>
              </div>
              <div class="flex items-center bg-purple-100 p-4 rounded-xl">
                <svg class="w-8 h-8 sm:w-10 sm:h-10 text-purple-600 mr-4 sm:mr-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                </svg>
                <span class="text-base sm:text-lg md:text-xl font-bold text-purple-800">237695043576</span>
              </div>
              <div class="flex items-center bg-blue-100 p-4 rounded-xl">
                <svg class="w-8 h-8 sm:w-10 sm:h-10 text-blue-600 mr-4 sm:mr-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8h2a2 2 0 012 2v6a2 2 0 01-2 2h-2v4l-4-4H9a1.994 1.994 0 01-1.414-.586m0 0L11 14h4a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2v4l.586-.586z"></path>
                </svg>
                <span class="text-base sm:text-lg md:text-xl font-bold text-blue-800">Address: Douala, Bonamoussadi, Rond Point Maetur Cameroon</span>
              </div>
            </div>
          </div>

          <div class="w-full lg:w-1/2 flex flex-col justify-center">
            <div class="bg-indigo-800 rounded-2xl p-6 sm:p-8 md:p-10 shadow-xl">
              <h4 class="text-2xl sm:text-3xl font-black text-white mb-4 sm:mb-6 contact-proceed-title" data-en="Ready to Proceed?" data-fr="Prêt à continuer ?">
                Ready to Proceed?              </h4>
              <p class="text-base sm:text-lg md:text-xl text-indigo-200 mb-6 sm:mb-8 contact-proceed-desc" data-en="Let's discuss your project requirements and explore how we can assist you in achieving your objectives." data-fr="Discutons de vos exigences de projet et explorons comment nous pouvons vous aider à atteindre vos objectifs.">
                Let's discuss your project requirements and explore how we can assist you in achieving your objectives.              </p>
              <a href="mailto:info@barcles.com" class="inline-block bg-white text-indigo-900 py-3 px-6 rounded-full text-base sm:text-lg md:text-xl font-bold hover:bg-indigo-100 transition-all duration-300 contact-consultation-btn" data-en="Request a Consultation" data-fr="Demander une consultation">
                Request a Consultation              </a>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Footer -->
    <footer class="bg-secondary-900 text-white py-16">
        <div class="max-w-7xl mx-auto px-6">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-12">
                <div>
                    <div class="flex items-center space-x-3 mb-6">
                        <div class="relative w-10 h-10">
                            <div class="absolute inset-0 bg-gradient-to-r from-primary-600 to-primary-500 rounded-lg transform rotate-6">
                            </div>
                            <div class="absolute inset-0 bg-white rounded-lg shadow-sm flex items-center justify-center">
                                <span class="text-xl font-bold text-primary-600">
                                    M                                </span>
                            </div>
                        </div>
                        <div>
                            <span class="text-2xl font-extrabold">
                                <span class="text-white">Medi</span>
                                <span class="text-primary-600">Soft</span>
                            </span>
                        </div>
                    </div>
                    <p class="text-gray-400 leading-relaxed">
                        Transforming healthcare through innovative management solutions.
                    </p>
                </div>

                <div>
                    <h4 class="text-xl font-bold mb-6 footer-quick-links" data-en="Quick Links" data-fr="Liens rapides">
                      Quick Links                    </h4>
                    <ul class="space-y-4">
                        <li><a href="#features" class="text-gray-400 hover:text-white transition-colors duration-200">Service</a></li>
                        <li><a href="#package" class="text-gray-400 hover:text-white transition-colors duration-200">Package</a></li>
                        <li><a href="#review" class="text-gray-400 hover:text-white transition-colors duration-200">Review</a></li>
                        <li><a href="#contact" class="text-gray-400 hover:text-white transition-colors duration-200">Contact Us</a></li>
                    </ul>
                </div>

                <div>
                    <h4 class="text-xl font-bold mb-6 footer-language" data-en="Language" data-fr="Langue">
                      Language                    </h4>
                    <div class="space-y-4">
                                                    <a href="frontend/chooseLanguage?lang=arabic" class="flex items-center text-gray-400 hover:text-white transition-colors duration-200 ">
                                <i class="flag-icon flag-icon-sa mr-2 shadow-sm"></i>
                                arabic                            </a>
                                                    <a href="frontend/chooseLanguage?lang=english" class="flex items-center text-gray-400 hover:text-white transition-colors duration-200 text-white">
                                <i class="flag-icon flag-icon-us mr-2 shadow-sm"></i>
                                english                            </a>
                                                    <a href="frontend/chooseLanguage?lang=french" class="flex items-center text-gray-400 hover:text-white transition-colors duration-200 ">
                                <i class="flag-icon flag-icon-fr mr-2 shadow-sm"></i>
                                french                            </a>
                                                    <a href="frontend/chooseLanguage?lang=italian" class="flex items-center text-gray-400 hover:text-white transition-colors duration-200 ">
                                <i class="flag-icon flag-icon-it mr-2 shadow-sm"></i>
                                italian                            </a>
                                                    <a href="frontend/chooseLanguage?lang=portuguese" class="flex items-center text-gray-400 hover:text-white transition-colors duration-200 ">
                                <i class="flag-icon flag-icon-pt mr-2 shadow-sm"></i>
                                portuguese                            </a>
                                                    <a href="frontend/chooseLanguage?lang=turkish" class="flex items-center text-gray-400 hover:text-white transition-colors duration-200 ">
                                <i class="flag-icon flag-icon-tr mr-2 shadow-sm"></i>
                                turkish                            </a>
                                                    <a href="frontend/chooseLanguage?lang=spanish" class="flex items-center text-gray-400 hover:text-white transition-colors duration-200 ">
                                <i class="flag-icon flag-icon-es mr-2 shadow-sm"></i>
                                spanish                            </a>
                                            </div>
                </div>

                <div>
                    <h4 class="text-xl font-bold mb-6 footer-newsletter" data-en="Newsletter" data-fr="Newsletter">
                      Newsletter                    </h4>
                    <p class="text-gray-400 mb-6 footer-newsletter-desc" data-en="Subscribe to our newsletter for updates" data-fr="Abonnez-vous à notre newsletter pour les mises à jour">
                      Subscribe to our newsletter for updates                    </p>
                    <form class="flex">
                        <input type="email" placeholder="Enter your email" data-en-placeholder="Enter your email" data-fr-placeholder="Entrez votre email" class="px-4 py-3 rounded-l-lg w-full focus:outline-none text-gray-900 footer-email-input">
                        <button class="bg-primary-600 px-6 py-3 rounded-r-lg hover:bg-primary-700 transition-colors duration-200">
                            <i class="fas fa-paper-plane"></i>
                        </button>
                    </form>
                </div>
            </div>

            <div class="border-t border-gray-800 mt-12 pt-8 text-center">
                <p class="text-gray-400 footer-copyright" data-en="© 2025 Medi Soft. All Rights Reserved" data-fr="© 2025 Medi Soft. Tous droits réservés">
                  © 2025 Medi Soft. All Rights Reserved                </p>
            </div>
        </div>
    </footer>
<?php
            $googleReCaptchaSiteKey =  $this->settings_model->getGoogleReCaptchaSettings()->site_key;
            ?>
    <!-- Scroll to Top Button -->
    <button id="scrollToTopBtn" style="margin-right:50px;" class="fixed bottom-8 right-8 bg-primary-600 text-white p-3 rounded-full shadow-lg transition-opacity duration-300 opacity-0 hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-primary-500 focus:ring-offset-2" style="opacity: 0,">
      <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18"></path>
      </svg>
    </button>

    <!-- Scripts -->
    <script src="https://kit.fontawesome.com/0257e3c208.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.js"></script>
    <script type="text/javascript" src="new-fnt/index.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/country-select-js@2.1.0/build/js/countrySelect.min.js"></script>
    <script type="text/javascript" src="common/assets/ckeditor/ckeditor.js"></script>
    <script src="common/js/codearistos.min.js"></script>
    <script type="text/javascript" src="https://js.stripe.com/v2/"></script>
    
 
<script src="common/extranal/js/frontend/front_end.js"></script>
    <script type="text/javascript">
        // Initialize Swiper
        const swiper = new Swiper('.hero-slider', {
            // Optional parameters
            loop: true,
            effect: 'fade',
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
            
            // Navigation arrows
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            
            // Pagination
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
        });

        var payment_gateway = "PayPal";
        var publish = "";

      // Scroll to Top functionality
      const scrollToTopBtn = document.getElementById('scrollToTopBtn');

      window.addEventListener('scroll', () => {
        if (window.pageYOffset > 300) {
          scrollToTopBtn.style.opacity = '1';
        } else {
          scrollToTopBtn.style.opacity = '0';
        }
      });

      scrollToTopBtn.addEventListener('click', () => {
        window.scrollTo({
          top: 0,
          behavior: 'smooth'
        });
      });

        // Mobile Menu Toggle
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const mobileMenu = document.getElementById('mobile-menu');

        mobileMenuButton.addEventListener('click', () => {
            mobileMenu.classList.toggle('hidden');
        });

        // Close mobile menu when clicking menu items
        const mobileMenuItems = mobileMenu.querySelectorAll('a');
        mobileMenuItems.forEach(item => {
            item.addEventListener('click', () => {
                mobileMenu.classList.add('hidden');
            });
        });

        // Close mobile menu when clicking outside
        document.addEventListener('click', (event) => {
            if (!mobileMenu.contains(event.target) && !mobileMenuButton.contains(event.target)) {
                mobileMenu.classList.add('hidden');
            }
        });

        // Language Dropdown
  document.getElementById('dropdownButton').addEventListener('click', function() {
    var dropdownMenu = document.getElementById('dropdownMenu');
    dropdownMenu.classList.toggle('hidden');
  });

  document.addEventListener('click', function(event) {
    var isClickInside = document.getElementById('dropdownButton').contains(event.target);
    if (!isClickInside) {
      var dropdownMenu = document.getElementById('dropdownMenu');
      if (!dropdownMenu.classList.contains('hidden')) {
        dropdownMenu.classList.add('hidden');
      }
    }
  });

        // Country Select
  $("#country").countrySelect();

        // Package Toggle
        // $(document).ready(function() {
           
        //     $("#yearly").click(function() {
                
        //     });
        //     $("#monthly").click(function() {
                
        //     });
        // });

        // Add this to your existing JavaScript
        document.addEventListener('DOMContentLoaded', function() {
            // FAQ Toggle functionality
            // const faqItems = document.querySelectorAll('.parent');
            // faqItems.forEach(item => {
            //     item.addEventListener('click', function() {
            //         const content = this.querySelector('.child');
            //         const icon = this.querySelector('.toggle-icon svg');
                    
            //         // Toggle content
            //         content.classList.toggle('hidden');
                    
            //         // Rotate icon
            //         if (content.classList.contains('hidden')) {
            //             icon.style.transform = 'rotate(0deg)';
            //         } else {
            //             icon.style.transform = 'rotate(45deg)';
            //         }
            //     });
            // });

            // // Pricing Toggle functionality
            // const yearlyBtn = document.getElementById('yearly');
            // const monthlyBtn = document.getElementById('monthly');
            // const yearlyPrices = document.querySelectorAll('.text2');
            // const monthlyPrices = document.querySelectorAll('.text1');

            // function togglePricing(showmonthly) {
            //     if (showmonthly) {
            //        monthlyBtn.classList.add('bg-indigo-600', 'text-white');
            //         yearlyBtn.classList.remove('bg-indigo-600', 'text-white');
            //         monthlyPrices.forEach(price => price.style.display = 'block');
            //         yearlyPrices.forEach(price => price.style.display = 'none');
                  
            //      
            //     } else {
            //         yearlyBtn.classList.add('bg-indigo-600', 'text-white');
            //         monthlyBtn.classList.remove('bg-indigo-600', 'text-white');
            //         yearlyPrices.forEach(price => price.style.display = 'block');
            //         monthlyPrices.forEach(price => price.style.display = 'none');
            //     }
            // }

            // yearlyBtn.addEventListener('click', () => togglePricing(true));
            // monthlyBtn.addEventListener('click', () => togglePricing(false));

            // // Initialize with yearly prices
            // togglePricing(true);
        });

        // Style all select dropdowns
        document.querySelectorAll('select').forEach(select => {
            select.addEventListener('mousedown', (e) => {
                e.preventDefault();
                const select = e.target;
                const scroll = select.scrollTop;
                e.target.blur();
                setTimeout(() => {
                    select.focus();
                    select.scrollTop = scroll;
                }, 0);
            });
        });

        // Language Switcher Functionality
        document.addEventListener('DOMContentLoaded', function() {
            console.log('Language switcher initializing...');
            
            // Language translations dictionary
            const translations = {
                'en': {
                    'Acceuil': 'Home',
                    'Service': 'Service',
                    'Nos Tarifs': 'Packages',
                    'Review': 'Reviews',
                    'Contact': 'Contact',
                    'Se Connecter': 'Login',
                    'Essayez gratuitement': 'Try Free',
                    'Contactez-nous': 'Contact Us',
                    'Enregistrer l\'hôpital': 'Register Hospital'
                },
                'fr': {
                    'Home': 'Acceuil',
                    'Service': 'Service',
                    'Packages': 'Nos Tarifs',
                    'Reviews': 'Review',
                    'Contact': 'Contact',
                    'Login': 'Se Connecter',
                    'Try Free': 'Essayez gratuitement',
                    'Contact Us': 'Contactez-nous',
                    'Register Hospital': 'Enregistrer l\'hôpital'
                }
            };

            // Get DOM elements
            const languageToggle = document.getElementById('language-toggle');
            const languageDropdown = document.getElementById('language-dropdown');
            const mobileLanguageToggle = document.getElementById('mobile-language-toggle');
            const mobileLanguageDropdown = document.getElementById('mobile-language-dropdown');
            const languageOptions = document.querySelectorAll('.language-option');
            const currentLangSpan = document.getElementById('current-lang');
            const mobileCurrentLangSpan = document.getElementById('mobile-current-lang');
            
            console.log('Elements found:', {
                languageToggle: !!languageToggle,
                languageDropdown: !!languageDropdown,
                mobileLanguageToggle: !!mobileLanguageToggle,
                mobileLanguageDropdown: !!mobileLanguageDropdown,
                languageOptions: languageOptions.length,
                currentLangSpan: !!currentLangSpan,
                mobileCurrentLangSpan: !!mobileCurrentLangSpan
            });

            // Check for saved language preference or default to French
            let currentLang = localStorage.getItem('preferredLanguage') || 'fr';
            console.log('Current language:', currentLang);
            
            // Set initial language display
            updateLanguageDisplay(currentLang);
            
            // Apply initial translation
            translatePage(currentLang);
            
            console.log('Initial translation applied');

            // Toggle desktop language dropdown
            if (languageToggle) {
                console.log('Adding click listener to language toggle');
                languageToggle.addEventListener('click', function(e) {
                    console.log('Language toggle clicked!');
                    e.stopPropagation();
                    languageDropdown.classList.toggle('hidden');
                });
            } else {
                console.error('Language toggle element not found!');
            }

            // Toggle mobile language dropdown
            if (mobileLanguageToggle) {
                console.log('Adding click listener to mobile language toggle');
                mobileLanguageToggle.addEventListener('click', function(e) {
                    console.log('Mobile language toggle clicked!');
                    e.stopPropagation();
                    mobileLanguageDropdown.classList.toggle('hidden');
                });
            } else {
                console.error('Mobile language toggle element not found!');
            }

            // Handle language selection
            console.log('Setting up language options listeners, count:', languageOptions.length);
            languageOptions.forEach((option, index) => {
                console.log(`Adding listener to option ${index}:`, option.getAttribute('data-lang'));
                option.addEventListener('click', function() {
                    console.log('Language option clicked:', this.getAttribute('data-lang'));
                    const selectedLang = this.getAttribute('data-lang');
                    changeLanguage(selectedLang);
                    
                    // Hide dropdowns
                    languageDropdown.classList.add('hidden');
                    mobileLanguageDropdown.classList.add('hidden');
                });
            });

            // Close dropdowns when clicking outside
            document.addEventListener('click', function(e) {
                if (!languageToggle?.contains(e.target) && !languageDropdown?.contains(e.target)) {
                    languageDropdown?.classList.add('hidden');
                }
                if (!mobileLanguageToggle?.contains(e.target) && !mobileLanguageDropdown?.contains(e.target)) {
                    mobileLanguageDropdown?.classList.add('hidden');
                }
            });

            // Function to change language
            function changeLanguage(lang) {
                console.log('Changing language to:', lang);
                currentLang = lang;
                localStorage.setItem('preferredLanguage', lang);
                updateLanguageDisplay(lang);
                translatePage(lang);
                console.log('Language changed successfully');
            }

            // Function to update language display
            function updateLanguageDisplay(lang) {
                const displayText = lang === 'en' ? 'EN' : 'FR';
                if (currentLangSpan) currentLangSpan.textContent = displayText;
                if (mobileCurrentLangSpan) mobileCurrentLangSpan.textContent = displayText;
            }

            // Function to translate the page
            function translatePage(lang) {
                // Translate navigation items
                document.querySelectorAll('.nav-item').forEach(item => {
                    const frenchText = item.getAttribute('data-fr');
                    const englishText = item.getAttribute('data-en');
                    item.textContent = lang === 'en' ? englishText : frenchText;
                });

                // Translate mobile navigation items
                document.querySelectorAll('.mobile-nav-item').forEach(item => {
                    const frenchText = item.getAttribute('data-fr');
                    const englishText = item.getAttribute('data-en');
                    item.textContent = lang === 'en' ? englishText : frenchText;
                });

                // Translate buttons
                document.querySelectorAll('.login-btn, .mobile-login-btn').forEach(btn => {
                    const frenchText = btn.getAttribute('data-fr');
                    const englishText = btn.getAttribute('data-en');
                    const icon = btn.querySelector('i');
                    btn.innerHTML = '';
                    if (icon) btn.appendChild(icon);
                    const textNode = document.createTextNode(lang === 'en' ? englishText : frenchText);
                    btn.appendChild(textNode);
                });

                document.querySelectorAll('.register-btn, .mobile-register-btn').forEach(btn => {
                    const frenchText = btn.getAttribute('data-fr');
                    const englishText = btn.getAttribute('data-en');
                    btn.textContent = lang === 'en' ? englishText : frenchText;
                });
            }
        });
</script>
   <script>
function toggleChild(element) {
    const child = element.querySelector('.cc');
    child.classList.toggle('hidden');
}
</script>
    <script>
function switchPlan(plan) {
    $(".text1").hide();
     const yearlyButton = document.getElementById('yearly');
     const monthlyButton = document.getElementById('monthly');
   
   
   
   if (plan === 'yearly') {
        $(".text1").hide();
                $(".text2").show();
            
               yearlyButton.classList.add('bg-indigo-600', 'text-white');
        yearlyButton.classList.remove('text-gray-700', 'hover:bg-indigo-50');
        monthlyButton.classList.add('text-gray-700', 'hover:bg-indigo-50');
        monthlyButton.classList.remove('bg-indigo-600', 'text-white'); 
       
    } else {
        $(".text1").show();
                $(".text2").hide();
                
                   
                monthlyButton.classList.add('bg-indigo-600', 'text-white');
        monthlyButton.classList.remove('text-gray-700', 'hover:bg-indigo-50');
        yearlyButton.classList.add('text-gray-700', 'hover:bg-indigo-50');
        yearlyButton.classList.remove('bg-indigo-600', 'text-white'); 
                
         
    }


}
</script>

     
<script src="https://www.google.com/recaptcha/api.js?render=<?php echo $googleReCaptchaSiteKey; ?>"></script>
        <script>
            grecaptcha.ready(function() {
                // document.getElementById('addNewHospital').addEventListener('submit', function(event) {
                document.getElementById('recap').addEventListener('input', function(event) {
                    event.preventDefault();
                    var form = this;
                    grecaptcha.execute('<?php echo $googleReCaptchaSiteKey; ?>', {
                        action: 'submit'
                    }).then(function(token) {
                        document.getElementById('recaptchaResponse').value = token;
                        // form.submit(); // Submit the form after setting the token
                    });
                });
            });
            grecaptcha.ready(function() {
                document.getElementById('sendEmail').addEventListener('submit', function(event) {
                    event.preventDefault();
                    var form = this;
                    grecaptcha.execute('<?php echo $googleReCaptchaSiteKey; ?>', {
                        action: 'submit'
                    }).then(function(token) {
                        document.getElementById('recaptchaResponse1').value = token;
                        form.submit();
                    });
                });
            });
        </script>
            <script>
  $(document).ready(function() {
    // Ensure base_url is defined
    const base_url  = "https://medecinesoft.com/";

    // Function to update the web link
    function updateWebLink() {
        const val = $("#username").val();
       
            const url = base_url + 'site/' + val;
            const final_url = '<a style="color:#0cb8b6;" target="_blank" href="' + url + '">' + url + '</a>';
            $("#web_link").html(final_url);
      
    }

    // Initial update on page load
    updateWebLink();

    // Update on keyup event
    $("#username").on("keyup", function() {
        updateWebLink();
    });
});
    </script>
    <script>
         $("#username").keyup(function() {
        $("#web_link").html("");
        var val = $("#username").val();
        $.ajax({
            url: "frontend/checkIfUsernameAvailable?username=" + val,
            method: "GET",
            data: "",
            dataType: "json"

        }).done(function(response) {
            if (response.check == 1) {
                var url = base_url + 'site/' + val;
                var final_url = '<a style="color:#0cb8b6;" target="_blank" href="' + url + '">' + url + '</a>';
                $("#web_link").html(final_url);
            } else {
                $("#web_link").html("<span style='color: #0cb8b6;'>This link is not available!</span>");
            }
        });
    });
    

    </script>

<iframe name="stripeXDM_default865249_provider" id="stripeXDM_default865249_provider" aria-hidden="true" src="https://js.stripe.com/v2/channel.html?stripe_xdm_e=https%3A%2F%2Fhopital.barcles.com&amp;stripe_xdm_c=default865249&amp;stripe_xdm_p=1#__stripe_transport__" frameborder="0" style="position: absolute; top: -2000px; left: 0px;"></iframe><iframe src="https://js.stripe.com/v2/m/outer.html#referrer=&amp;title=Medi%20Soft&amp;url=https%3A%2F%2Fhopital.barcles.com%2F&amp;muid=24916897-d2c2-449a-8e39-8161ba6121e2dec6c3&amp;sid=7abd7633-63a2-4207-be98-c9d9b1b2b03e362011&amp;version=6&amp;preview=false&amp;" frameborder="0" allowtransparency="true" scrolling="no" tabindex="-1" aria-hidden="true" style="width: 1px !important; height: 1px !important; position: fixed !important; visibility: hidden !important; pointer-events: none !important;"></iframe></body></html>
