<div class="content-wrapper bg-gradient-light">
    <!-- Content Header -->
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fa fa-google fa-lg mr-3"></i>
                        <?php echo lang('google_calendar_settings'); ?>
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0">
                            <li class="breadcrumb-item"><a href="home"><?php echo lang('home'); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo lang('google_calendar_settings'); ?></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </section>

    <!-- Main content -->
    <section class="content py-5">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card shadow-lg border-0">
                        <div class="card-body bg-white p-5">


                            <?php if ($this->session->flashdata('success')): ?>
                                <div class="alert alert-success">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    <?php echo $this->session->flashdata('success'); ?>
                                </div>
                            <?php endif; ?>

                            <form role="form" action="<?php echo base_url('doctor/google_calendar_settings/save'); ?>" method="post" enctype="multipart/form-data">
                                <!-- Google API Client Settings Card -->
                                <div class="card shadow-sm border-0 mb-5">
                                    <div class="card-header bg-info text-white py-3">
                                        <h3 class="card-title font-weight-bold mb-0">
                                            <i class="fas fa-cog mr-2"></i>
                                            <?php echo lang('google_api_client_settings'); ?>
                                        </h3>
                                    </div>

                                    <div class="card-body bg-light p-4">
                                        <div class="row">
                                            <?php if ($this->ion_auth->in_group(array('Doctor'))) { ?>
                                                <!-- Doctor Info -->
                                                <div class="col-md-12 mb-4">
                                                    <div class="form-group">
                                                        <label class="text-uppercase font-weight-bold text-dark">
                                                            <i class="fas fa-user-md mr-2 text-muted"></i>
                                                            <?php echo lang('doctor'); ?>
                                                        </label>
                                                        <input type="text" class="form-control form-control-lg shadow-sm"
                                                            value="<?php echo !empty($doctor) ? $doctor->name : ''; ?>" readonly>
                                                        <input type="hidden" name="doctor_id" value="<?php echo !empty($doctor) ? $doctor->id : ''; ?>">
                                                    </div>
                                                </div>
                                            <?php } ?>
                                            <?php if ($this->ion_auth->in_group(array('Doctor'))) {
                                                $value = "Doctor";
                                            } else {
                                                $value = "Admin";
                                            } ?>
                                            <!-- Client Name -->
                                            <div class="col-md-6 mb-4">
                                                <div class="form-group">
                                                    <label class="text-uppercase font-weight-bold text-dark">
                                                        <i class="fas fa-signature mr-2 text-muted"></i>
                                                        <?php echo lang('client_name'); ?>
                                                        <span class="text-danger"></span>
                                                    </label>
                                                    <input type="text" class="form-control form-control-lg shadow-sm"
                                                        name="client_name" id="client_name"
                                                        value="<?php echo $value; ?>" readonly>
                                                    <?php echo form_error('client_name'); ?>
                                                </div>
                                            </div>

                                            <!-- Client ID -->
                                            <div class="col-md-6 mb-4">
                                                <div class="form-group">
                                                    <label class="text-uppercase font-weight-bold text-dark">
                                                        <i class="fas fa-id-card mr-2 text-muted"></i>
                                                        <?php echo lang('client_id'); ?>
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <input type="text" class="form-control form-control-lg shadow-sm"
                                                        name="client_id" id="client_id"
                                                        value="<?php echo !empty($google_api_client) ? $google_api_client->client_id : set_value('client_id'); ?>" required>
                                                    <?php echo form_error('client_id'); ?>
                                                </div>
                                            </div>

                                            <!-- Client Secret -->
                                            <div class="col-md-6 mb-4">
                                                <div class="form-group">
                                                    <label class="text-uppercase font-weight-bold text-dark">
                                                        <i class="fas fa-key mr-2 text-muted"></i>
                                                        <?php echo lang('client_secret'); ?>
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <input type="password" class="form-control form-control-lg shadow-sm"
                                                        name="client_secret" id="client_secret"
                                                        value="<?php echo !empty($google_api_client) ? $google_api_client->client_secret : set_value('client_secret'); ?>" required>
                                                    <?php echo form_error('client_secret'); ?>
                                                </div>
                                            </div>

                                            <!-- Project ID -->
                                            <div class="col-md-6 mb-4">
                                                <div class="form-group">
                                                    <label class="text-uppercase font-weight-bold text-dark">
                                                        <i class="fas fa-project-diagram mr-2 text-muted"></i>
                                                        <?php echo lang('project_id'); ?>
                                                    </label>
                                                    <input type="text" class="form-control form-control-lg shadow-sm"
                                                        name="project_id" id="project_id"
                                                        value="<?php echo !empty($google_api_client) ? $google_api_client->project_id : set_value('project_id'); ?>">
                                                    <?php echo form_error('project_id'); ?>
                                                </div>
                                            </div>

                                            <!-- Auth URI -->
                                            <div class="col-md-6 mb-4">
                                                <div class="form-group">
                                                    <label class="text-uppercase font-weight-bold text-dark">
                                                        <i class="fas fa-link mr-2 text-muted"></i>
                                                        <?php echo lang('auth_uri'); ?>
                                                    </label>
                                                    <input type="text" class="form-control form-control-lg shadow-sm"
                                                        name="auth_uri" id="auth_uri"
                                                        value="<?php echo !empty($google_api_client) ? $google_api_client->auth_uri : set_value('auth_uri', 'https://accounts.google.com/o/oauth2/auth'); ?>">
                                                    <?php echo form_error('auth_uri'); ?>
                                                </div>
                                            </div>

                                            <!-- Token URI -->
                                            <div class="col-md-6 mb-4">
                                                <div class="form-group">
                                                    <label class="text-uppercase font-weight-bold text-dark">
                                                        <i class="fas fa-link mr-2 text-muted"></i>
                                                        <?php echo lang('token_uri'); ?>
                                                    </label>
                                                    <input type="text" class="form-control form-control-lg shadow-sm"
                                                        name="token_uri" id="token_uri"
                                                        value="<?php echo !empty($google_api_client) ? $google_api_client->token_uri : set_value('token_uri', 'https://oauth2.googleapis.com/token'); ?>">
                                                    <?php echo form_error('token_uri'); ?>
                                                </div>
                                            </div>

                                            <!-- Redirect URIs -->
                                            <div class="col-md-6 mb-4">
                                                <div class="form-group">
                                                    <label class="text-uppercase font-weight-bold text-dark">
                                                        <i class="fas fa-external-link-alt mr-2 text-muted"></i>
                                                        <?php echo lang('redirect_uris'); ?>
                                                    </label>
                                                    <textarea class="form-control form-control-lg shadow-sm"
                                                        name="redirect_uris" id="redirect_uris" rows="3"><?php echo !empty($google_api_client) ? $google_api_client->redirect_uris : set_value('redirect_uris', '["' . base_url('google_auth/callback') . '"]'); ?></textarea>
                                                    <small class="form-text text-muted"><?php echo lang('enter_json_array_of_redirect_uris'); ?></small>
                                                    <?php echo form_error('redirect_uris'); ?>
                                                </div>
                                            </div>

                                            <!-- Auth Provider X509 Cert URL -->
                                            <div class="col-md-6 mb-4">
                                                <div class="form-group">
                                                    <label class="text-uppercase font-weight-bold text-dark">
                                                        <i class="fas fa-certificate mr-2 text-muted"></i>
                                                        <?php echo lang('auth_provider_x509_cert_url'); ?>
                                                    </label>
                                                    <input type="text" class="form-control form-control-lg shadow-sm"
                                                        name="auth_provider_x509_cert_url" id="auth_provider_x509_cert_url"
                                                        value="<?php echo !empty($google_api_client) ? $google_api_client->auth_provider_x509_cert_url : set_value('auth_provider_x509_cert_url', 'https://www.googleapis.com/oauth2/v1/certs'); ?>">
                                                    <?php echo form_error('auth_provider_x509_cert_url'); ?>
                                                </div>
                                            </div>

                                            <!-- Client X509 Cert URL -->


                                            <!-- Test Connection Button -->
                                            <?php if (!empty($google_api_client)): ?>


                                                <!-- Authentication Button -->
                                                <div class="col-md-12 mb-4">
                                                    <div class="form-group">
                                                        <label class="text-uppercase font-weight-bold text-dark">
                                                            <i class="fas fa-key mr-2 text-muted"></i>
                                                            <?php echo lang('google_calendar_authentication'); ?>
                                                        </label>
                                                        <div class="d-flex align-items-center">
                                                            <a href="<?php echo base_url('doctor/google_calendar_settings/authenticate'); ?>" class="btn btn-info btn-lg">
                                                                <i class="fas fa-sign-in-alt mr-2"></i>
                                                                <?php echo lang('authentication'); ?>
                                                            </a>
                                                            <span class="ml-3 text-muted"><?php echo lang('manage_google_calendar_authentication'); ?> first</span>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-md-12 mb-4">
                                                    <div class="form-group">
                                                        <label class="text-uppercase font-weight-bold text-dark">
                                                            <i class="fas fa-plug mr-2 text-muted"></i>
                                                            <?php echo lang('test_google_api_connection'); ?>
                                                        </label>
                                                        <div class="d-flex align-items-center">
                                                            <a href="<?php echo base_url('doctor/google_calendar_settings/test_connection'); ?>" class="btn btn-primary btn-lg">
                                                                <i class="fas fa-bolt mr-2"></i>
                                                                <?php echo lang('test_connection'); ?>
                                                            </a>
                                                            <span class="ml-3 text-muted"><?php echo lang('test_connection_help'); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="text-right">
                                    <button type="submit" class="btn btn-success btn-lg px-5">
                                        <i class="fa fa-save mr-2"></i>
                                        <?php echo lang('save'); ?>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!--main content end-->
<!--footer start-->

<link href="common/extranal/css/settings/google_api_client.css" rel="stylesheet">
<script src="common/js/codearistos.min.js"></script>
<script src="common/extranal/js/settings/settings.js"></script>
<script src="common/extranal/js/settings/google_api_client.js"></script>