<div class="content-wrapper bg-gradient-light">
    <!-- Content Header -->
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fa fa-google fa-lg mr-3"></i>
                        <?php echo lang('google_calendar_authentication'); ?>
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0">
                            <li class="breadcrumb-item"><a href="home"><?php echo lang('home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="doctor/google_calendar_settings"><?php echo lang('google_calendar_settings'); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo lang('authentication'); ?></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </section>

    <!-- Main content -->
    <section class="content py-5">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card shadow-lg border-0">
                        <div class="card-body bg-white p-5">
                            <?php if ($this->session->flashdata('error')): ?>
                                <div class="alert alert-danger">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    <?php echo $this->session->flashdata('error'); ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($this->session->flashdata('success')): ?>
                                <div class="alert alert-success">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    <?php echo $this->session->flashdata('success'); ?>
                                </div>
                            <?php endif; ?>
                            
                            <div class="card shadow-sm border-0 mb-5">
                                <div class="card-header bg-info text-white py-3">
                                    <h3 class="card-title font-weight-bold mb-0">
                                        <i class="fas fa-key mr-2"></i>
                                        <?php echo lang('google_calendar_authentication'); ?>
                                    </h3>
                                </div>

                                <div class="card-body bg-light p-4">
                                    <?php if (!empty($google_api_client)): ?>
                                        <?php if ($is_authenticated): ?>
                                            <div class="alert alert-success">
                                                <h4><i class="fas fa-check-circle"></i> <?php echo lang('authentication_successful'); ?></h4>
                                                <p><?php echo lang('google_calendar_authenticated_message'); ?></p>
                                                <p><strong><?php echo lang('calendar_name'); ?>:</strong> <?php echo !empty($calendar_name) ? $calendar_name : lang('primary_calendar'); ?></p>
                                            </div>
                                            <?php if ($this->ion_auth->in_group(array('Doctor'))) { ?>
                                            <a href="<?php echo base_url('google_auth/disconnect?doctor_id=' . $doctor->id); ?>" class="btn btn-danger btn-lg">
                                                <i class="fas fa-unlink mr-2"></i>
                                                <?php echo lang('disconnect_google_calendar'); ?>
                                            </a>
                                            <?php }else{ ?>
                                               <a href="<?php echo base_url('google_auth/disconnect'); ?>" class="btn btn-danger btn-lg">
                                                <i class="fas fa-unlink mr-2"></i>
                                                <?php echo lang('disconnect_google_calendar'); ?>
                                            </a> 
                                                <?php } ?>
                                        <?php else: ?>
                                            <div class="alert alert-warning">
                                                <h4><i class="fas fa-exclamation-triangle"></i> <?php echo lang('authentication_required'); ?></h4>
                                                <p><?php echo lang('google_calendar_auth_required_message'); ?></p>
                                            </div>
                                            <?php if ($this->ion_auth->in_group(array('Doctor'))) { ?>
                                            <a href="<?php echo base_url('google_auth?doctor_id=' . $doctor->id); ?>" class="btn btn-primary btn-lg">
                                                <i class="fab fa-google mr-2"></i>
                                                <?php echo lang('authenticate_with_google'); ?>
                                            </a>
                                            <?php }else{ ?>
                                               <a href="<?php echo base_url('google_auth'); ?>" class="btn btn-primary btn-lg">
                                                <i class="fab fa-google mr-2"></i>
                                                <?php echo lang('authenticate_with_google'); ?>
                                            </a>
                                                <?php } ?>
                                        <?php endif; ?>
                                        <a href="doctor/google_calendar_settings" class="btn btn-primary btn-lg">
                                                <i class="fab fa-google mr-2"></i>
                                                <?php echo lang('settings'); ?>
                                            </a>

                                            <a href="home" class="btn btn-primary btn-lg">
                                                <i class="fab fa-google mr-2"></i>
                                                <?php echo lang('home'); ?>
                                            </a>
                                        <div class="mt-4">
                                            <h5><?php echo lang('doctor_info'); ?></h5>
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th><?php echo lang('doctor'); ?></th>
                                                    <td><?php echo $doctor->name; ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('client_name'); ?></th>
                                                    <td><?php echo $google_api_client->client_name; ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('client_id'); ?></th>
                                                    <td><?php echo $google_api_client->client_id; ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('project_id'); ?></th>
                                                    <td><?php echo !empty($google_api_client->project_id) ? $google_api_client->project_id : lang('not_set'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('callback_url'); ?></th>
                                                    <td><?php echo $callback_url; ?></td>
                                                </tr>
                                            </table>
                                            
                                            <div class="alert alert-info mt-3">
                                                <h6><i class="fas fa-info-circle"></i> <?php echo lang('important'); ?></h6>
                                                <p><?php echo lang('ensure_callback_url_matches'); ?></p>
                                                <p><strong><?php echo lang('redirect_uris_in_google_console'); ?>:</strong></p>
                                                <ul>
                                                    <li><?php echo $callback_url; ?></li>
                                                    <li>http://localhost/google_auth/callback</li>
                                                    <li>http://127.0.0.1/google_auth/callback</li>
                                                </ul>
                                                
                                                <h6 class="mt-3"><i class="fas fa-tools"></i> <?php echo lang('troubleshooting_steps'); ?></h6>
                                                <ol>
                                                    <li><?php echo lang('verify_google_api_credentials'); ?></li>
                                                    <li><?php echo lang('check_redirect_uri_match'); ?></li>
                                                    <li><?php echo lang('ensure_calendar_api_enabled'); ?></li>
                                                    <li><?php echo lang('test_with_incognito_mode'); ?></li>
                                                </ol>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <div class="alert alert-danger">
                                            <h4><i class="fas fa-exclamation-circle"></i> <?php echo lang('no_google_api_client_configured'); ?></h4>
                                            <p><?php echo lang('configure_google_api_client_first'); ?></p>
                                            <a href="doctor/google_calendar_settings" class="btn btn-primary">
                                                <i class="fas fa-cog mr-2"></i>
                                                <?php echo lang('configure_google_api_client'); ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!--main content end-->
<!--footer start-->

<link href="common/extranal/css/settings/google_api_client.css" rel="stylesheet">
<script src="common/js/codearistos.min.js"></script>
<script src="common/extranal/js/settings/settings.js"></script>
<script src="common/extranal/js/settings/google_api_client.js"></script>