<div class="content-wrapper bg-gradient-light" style="min-height: 2726.9px;">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-user-tag text-primary mr-3"></i>
                        <?php echo lang('designations'); ?>
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0">
                            <li class="breadcrumb-item"><a href="home"><?php echo lang('home'); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo lang('designation'); ?></li>
                        </ol>
                    </nav>
                </div>
                <div class="col-sm-6 text-right">
                    <a data-toggle="modal" href="#myModal" class="btn btn-primary btn-sm px-4 py-3">
                        <i class="fa fa-plus"></i> <?php echo lang('add_new'); ?> <?php echo lang('designation'); ?>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-5">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card shadow-lg border-0">
                        <div class="card-header">
                            <h3 class="card-title text-black font-weight-800"><?php echo lang('all'); ?> <?php echo lang('designations'); ?></h3>
                        </div>

                        <div class="card-body bg-light p-4">
                            <table class="table table-hover datatables" id="editable-sample" width="100%">
                                <thead>
                                    <tr class="bg-light">
                                        <th class="font-weight-bold text-uppercase"><?php echo lang('designation'); ?> <?php echo lang('name'); ?></th>
                                        <th class="font-weight-bold text-uppercase"><?php echo lang('department'); ?></th>
                                        <th class="font-weight-bold text-uppercase"><?php echo lang('description'); ?></th>
                                        <th class="font-weight-bold text-uppercase no-print"><?php echo lang('options'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($designations as $designation) { ?>
                                        <tr>
                                            <td><?php echo $designation->name; ?></td>
                                            <td><?php echo $designation->department_name; ?></td>
                                            <td><?php echo $designation->description; ?></td>
                                            <td class="no-print">
                                                <a type="button" class="btn btn-primary btn-sm editbutton" data-toggle="modal" title="<?php echo lang('edit'); ?>" data-id="<?php echo $designation->id; ?>"><i class="fa fa-edit"></i></a>
                                                <a class="btn btn-danger btn-sm" title="<?php echo lang('delete'); ?>" href="designation/delete?id=<?php echo $designation->id; ?>" onclick="return confirm('<?php echo lang('are_you_sure_you_want_to_delete_this_item'); ?>');"><i class="fa fa-trash"></i></a>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Designation Modal-->
<div class="modal fade" id="myModal" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title font-weight-bold"><?php echo lang('add_new'); ?> <?php echo lang('designation'); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body row">
                <form role="form" action="designation/addNew" class="clearfix" method="post" enctype="multipart/form-data">
                    <div class="form-group col-md-12">
                        <label for="name"><?php echo lang('designation'); ?> <?php echo lang('name'); ?> *</label>
                        <input type="text" class="form-control form-control-lg" name="name" id="name" value='' placeholder="<?php echo lang('enter'); ?> <?php echo lang('designation'); ?> <?php echo lang('name'); ?>" required>
                    </div>

                    <div class="form-group col-md-12">
                        <label for="department_id"><?php echo lang('department'); ?> *</label>
                        <select class="form-control form-control-lg select2" name="department_id" id="department_id" required>
                            <option value=""><?php echo lang('select'); ?> <?php echo lang('department'); ?></option>
                            <?php foreach ($departments as $department) { ?>
                                <option value="<?php echo $department->id; ?>"><?php echo $department->name; ?></option>
                            <?php } ?>
                        </select>
                    </div>

                    <div class="form-group col-md-12">
                        <label for="description"><?php echo lang('description'); ?></label>
                        <textarea class="form-control form-control-lg" name="description" id="description" rows="3" placeholder="<?php echo lang('enter'); ?> <?php echo lang('description'); ?> (<?php echo lang('optional'); ?>)"></textarea>
                    </div>

                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info float-right"><?php echo lang('submit'); ?></button>
                    </div>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

<!-- Edit Designation Modal-->
<div class="modal fade" id="editModal" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title font-weight-bold"><?php echo lang('edit'); ?> <?php echo lang('designation'); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body row">
                <form role="form" action="designation/addNew" class="clearfix" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="id" id="edit_id">
                    
                    <div class="form-group col-md-12">
                        <label for="edit_name"><?php echo lang('designation'); ?> <?php echo lang('name'); ?> *</label>
                        <input type="text" class="form-control form-control-lg" name="name" id="edit_name" required>
                    </div>

                    <div class="form-group col-md-12">
                        <label for="edit_department_id"><?php echo lang('department'); ?> *</label>
                        <select class="form-control form-control-lg select2" name="department_id" id="edit_department_id" required>
                            <option value=""><?php echo lang('select'); ?> <?php echo lang('department'); ?></option>
                            <?php foreach ($departments as $department) { ?>
                                <option value="<?php echo $department->id; ?>"><?php echo $department->name; ?></option>
                            <?php } ?>
                        </select>
                    </div>

                    <div class="form-group col-md-12">
                        <label for="edit_description"><?php echo lang('description'); ?></label>
                        <textarea class="form-control form-control-lg" name="description" id="edit_description" rows="3"></textarea>
                    </div>

                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info float-right"><?php echo lang('update'); ?></button>
                    </div>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

<script src="common/js/codearistos.min.js"></script>

<script type="text/javascript">
    $(document).ready(function() {
        // Edit designation button click
        $('.editbutton').on('click', function() {
            var designationId = $(this).data('id');
            
            $.ajax({
                url: 'designation/editDesignationByJason',
                type: 'GET',
                data: { id: designationId },
                dataType: 'json',
                success: function(response) {
                    if (response.designation) {
                        $('#edit_id').val(response.designation.id);
                        $('#edit_name').val(response.designation.name);
                        $('#edit_department_id').val(response.designation.department_id);
                        $('#edit_description').val(response.designation.description);
                        $('#editModal').modal('show');
                    }
                },
                error: function() {
                    alert('Error loading designation data');
                }
            });
        });

        // Initialize DataTables
        $('#editable-sample').DataTable();

        // Initialize Select2
        $('.select2').select2();
    });
</script>