<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Designation_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertDesignation($data) {
        $data1 = array('hospital_id' => $this->session->userdata('hospital_id'));
        $data2 = array_merge($data, $data1);
        $this->db->insert('designation', $data2);
        return $this->db->insert_id();
    }

    function getDesignation() {
        $this->db->select('d.*, dept.name as department_name');
        $this->db->from('designation d');
        $this->db->join('department dept', 'd.department_id = dept.id', 'left');
        $this->db->where('d.hospital_id', $this->session->userdata('hospital_id'));
        $this->db->order_by('d.name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    function getDesignationByDepartment($department_id) {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('department_id', $department_id);
        $this->db->order_by('name', 'ASC');
        $query = $this->db->get('designation');
        return $query->result();
    }

    function getDesignationById($id) {
        $this->db->select('d.*, dept.name as department_name');
        $this->db->from('designation d');
        $this->db->join('department dept', 'd.department_id = dept.id', 'left');
        $this->db->where('d.hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('d.id', $id);
        $query = $this->db->get();
        return $query->row();
    }

    function updateDesignation($id, $data) {
        $this->db->where('id', $id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->update('designation', $data);
    }

    function delete($id) {
        // Check if designation is used by any staff
        $this->db->where('designation_id', $id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $staff_count = $this->db->count_all_results('staff');
        
        if ($staff_count > 0) {
            return false; // Cannot delete, designation is in use
        }
        
        $this->db->where('id', $id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->delete('designation');
        return true;
    }

    function getDesignationByName($name, $department_id) {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('name', $name);
        $this->db->where('department_id', $department_id);
        $query = $this->db->get('designation');
        return $query->row();
    }
}