<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Designation extends MX_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('designation_model');
        $this->load->model('department/department_model');

        if (!$this->ion_auth->in_group('admin')) {
            redirect('home/permission');
        }
    }

    public function index() {
        $data['designations'] = $this->designation_model->getDesignation();
        $data['departments'] = $this->department_model->getDepartment();
        $this->load->view('home/dashboard'); 
        $this->load->view('designation', $data);
        $this->load->view('home/footer'); 
    }

    public function addNewView() {
        $data['departments'] = $this->department_model->getDepartment();
        $this->load->view('home/dashboard'); 
        $this->load->view('add_new', $data);
        $this->load->view('home/footer'); 
    }

    public function addNew() {
        $id = $this->input->post('id');
        $name = $this->input->post('name');
        $description = $this->input->post('description');
        $department_id = $this->input->post('department_id');

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        // Validating Name Field
        $this->form_validation->set_rules('name', 'Designation Name', 'trim|required|min_length[2]|max_length[100]|xss_clean');
        // Validating Description Field    
        $this->form_validation->set_rules('description', 'Description', 'trim|max_length[1000]|xss_clean');
        // Validating Department Field   
        $this->form_validation->set_rules('department_id', 'Department', 'trim|required|numeric|xss_clean');
        
        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $data['departments'] = $this->department_model->getDepartment();
            if (!empty($id)) {
                $data['designation'] = $this->designation_model->getDesignationById($id);
            }
            $this->load->view('home/dashboard'); 
            $this->load->view('add_new', $data);
            $this->load->view('home/footer'); 
        } else {
            // Check for duplicate designation name in same department
            if (empty($id)) {
                $existing = $this->designation_model->getDesignationByName($name, $department_id);
                if (!empty($existing)) {
                    show_swal('Designation name already exists in this department', 'error', 'Error');
                    redirect('designation');
                    return;
                }
            }

            $data = array(
                'name' => $name,
                'description' => $description,
                'department_id' => $department_id
            );
            
            if (empty($id)) {     // Adding New designation
                $this->designation_model->insertDesignation($data);
                show_swal('New designation added successfully', 'success', 'Added');
            } else { // Updating designation
                $this->designation_model->updateDesignation($id, $data);
                show_swal('Designation details updated successfully', 'success', 'Updated');
            }
            // Loading View
            redirect('designation');
        }
    }

    function getDesignation() {
        $data['designations'] = $this->designation_model->getDesignation();
        $this->load->view('designation', $data);
    }

    function editDesignation() {
        $data = array();
        $id = $this->input->get('id');
        $data['designation'] = $this->designation_model->getDesignationById($id);
        $data['departments'] = $this->department_model->getDepartment();
        $this->load->view('home/dashboard'); 
        $this->load->view('add_new', $data);
        $this->load->view('home/footer'); 
    }

    function editDesignationByJason() {
        $id = $this->input->get('id');
        $data['designation'] = $this->designation_model->getDesignationById($id);
        echo json_encode($data);
    }

    function delete() {
        $id = $this->input->get('id');
        $result = $this->designation_model->delete($id);
        
        if ($result) {
            show_swal('Designation deleted successfully', 'success', 'Deleted');
        } else {
            show_swal('Cannot delete designation. It is assigned to staff members.', 'error', 'Error');
        }
        redirect('designation');
    }

    // AJAX method to get designations by department
    function getDesignationsByDepartment() {
        $department_id = $this->input->post('department_id');
        $designations = $this->designation_model->getDesignationByDepartment($department_id);
        echo json_encode($designations);
    }
}