<?php
defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('send_google_calendar_invitation')) {
    /**
     * Send Google Calendar invitation email to doctor
     * 
     * @param array $appointment_data Appointment data
     * @param string $doctor_email Doctor's email address
     * @return bool True on success, false on failure
     */
    function send_google_calendar_invitation($appointment_data, $doctor_email) {
        // Get CI instance
        $CI =& get_instance();
        
        // Load email library
        $CI->load->library('email');
        
        // Get settings
        $CI->load->model('settings/settings_model');
        $settings = $CI->settings_model->getSettings();
        
        // Configure email
        $config = array(
            'protocol' => $settings->email_protocol,
            'smtp_host' => $settings->smtp_host,
            'smtp_port' => $settings->smtp_port,
            'smtp_user' => $settings->smtp_user,
            'smtp_pass' => $settings->smtp_pass,
            'smtp_crypto' => $settings->smtp_crypto,
            'mailtype' => 'html',
            'charset' => 'utf-8',
            'newline' => "\r\n"
        );
        
        $CI->email->initialize($config);
        $CI->email->set_newline("\r\n");
        
        // Set email content
        $CI->email->from($settings->admin_email, $settings->system_title);
        $CI->email->to($doctor_email);
        $CI->email->subject('New Appointment Invitation - ' . $appointment_data['title']);
        
        // Create email message
        $message = '<!DOCTYPE html>
<html>
<head>
    <title>New Appointment Invitation</title>
</head>
<body>
    <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;">
        <h2 style="color: #333;">New Appointment Invitation</h2>
        <p>Hello Doctor,</p>
        <p>You have been invited to a new appointment:</p>
        
        <div style="background-color: #f5f5f5; padding: 15px; border-radius: 5px; margin: 20px 0;">
            <h3 style="margin-top: 0;">' . $appointment_data['title'] . '</h3>
            <p><strong>Description:</strong> ' . $appointment_data['description'] . '</p>
            <p><strong>Date & Time:</strong> ' . date('F j, Y \a\t g:i A', strtotime($appointment_data['start_datetime'])) . ' - ' . date('g:i A', strtotime($appointment_data['end_datetime'])) . '</p>
        </div>
        
        <p>You will receive a Google Calendar invitation for this appointment. Please accept the invitation to add it to your calendar.</p>
        
        <p>Best regards,<br>' . $settings->system_title . ' Team</p>
    </div>
</body>
</html>';
        
        $CI->email->message($message);
        
        // Send email
        if ($CI->email->send()) {
            log_message('info', 'Google Calendar invitation email sent successfully to: ' . $doctor_email);
            return true;
        } else {
            log_message('error', 'Failed to send Google Calendar invitation email to: ' . $doctor_email . '. Error: ' . $CI->email->print_debugger());
            return false;
        }
    }
}

if (!function_exists('create_google_calendar_invitation_link')) {
    /**
     * Create a Google Calendar invitation link
     * 
     * @param array $event_data Event data
     * @return string Google Calendar invitation link
     */
    function create_google_calendar_invitation_link($event_data) {
        // Format dates for Google Calendar
        $start_date = str_replace(['-', ':', ' '], ['', '', 'T'], $event_data['start_datetime']) . 'Z';
        $end_date = str_replace(['-', ':', ' '], ['', '', 'T'], $event_data['end_datetime']) . 'Z';
        
        // Create Google Calendar link
        $link = 'https://calendar.google.com/calendar/render?action=TEMPLATE';
        $link .= '&text=' . urlencode($event_data['title']);
        $link .= '&details=' . urlencode($event_data['description']);
        $link .= '&dates=' . $start_date . '/' . $end_date;
        
        if (!empty($event_data['location'])) {
            $link .= '&location=' . urlencode($event_data['location']);
        }
        
        return $link;
    }
}