<?php
defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('add_appointment_to_google_calendar')) {
    /**
     * Add appointment to Google Calendar
     * 
     * @param array $appointment_data Appointment data
     * @param array $attendees Optional list of attendee email addresses
     * @return bool|string Event ID on success, false on failure
     */
    function add_appointment_to_google_calendar($appointment_data, $attendees = array()) {
        // Try to load the Google Calendar library
        $CI =& get_instance();
        
        // Check if the library is already loaded
        if (!isset($CI->google_calendar)) {
            // Try to load the library
            $CI->load->library('google_calendar');
        }
        
        // Check if we have the library and it's authenticated
        if (isset($CI->google_calendar) && $CI->google_calendar->is_authenticated()) {
            // Use the actual Google Calendar library
            $event_id = $CI->google_calendar->add_event(
                $appointment_data['title'],
                $appointment_data['description'],
                $appointment_data['start_datetime'],
                $appointment_data['end_datetime'],
                'Asia/Dhaka', // Default timezone
                $attendees
            );
            
            return $event_id;
        } else {
            // Fallback to logging if not authenticated or library not available
            log_message('info', 'Google Calendar Event (Mock/Logged): ' . json_encode($appointment_data));
            return 'mock_event_' . time();
        }
    }
}