<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Test_google_calendar_invitations extends MX_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('google_calendar');
        $this->load->helper('google_calendar_invitation');
    }

    public function index() {
        echo "<h1>Google Calendar Invitations Test</h1>";
        
        // Test if the library is loaded
        echo "<p>✅ Google Calendar library loaded successfully.</p>";
        
        // Test authentication status
        $is_authenticated = $this->google_calendar->is_authenticated();
        echo "<p>Authentication Status: " . ($is_authenticated ? "✅ Authenticated" : "❌ Not Authenticated") . "</p>";
        
        if ($is_authenticated) {
            // Test creating an event with attendees
            $attendees = array('doctor@example.com', 'patient@example.com');
            
            $event_id = $this->google_calendar->add_event(
                'Test Appointment with Attendees',
                'This is a test appointment with attendees from the clinic system',
                date('c'),
                date('c', time() + 3600), // 1 hour from now
                'Asia/Dhaka',
                $attendees
            );
            
            if ($event_id) {
                echo "<p>✅ Event with attendees created successfully with ID: " . htmlspecialchars($event_id) . "</p>";
            } else {
                echo "<p>❌ Failed to create event with attendees</p>";
            }
            
            // Test invitation helper
            $appointment_data = array(
                'title' => 'Test Appointment',
                'description' => 'This is a test appointment',
                'start_datetime' => date('c'),
                'end_datetime' => date('c', time() + 3600)
            );
            
            $invitation_link = create_google_calendar_invitation_link($appointment_data);
            echo "<p>✅ Google Calendar Invitation Link Generated:</p>";
            echo "<p><a href='" . $invitation_link . "' target='_blank'>Add to Google Calendar</a></p>";
        } else {
            echo "<p>Please authenticate with Google first:</p>";
            echo "<a href='" . base_url('google_auth') . "'>Authenticate with Google</a>";
        }
        
        echo "<h2>Next Steps</h2>";
        echo "<ol>";
        echo "<li>Create a new appointment to test the invitation workflow</li>";
        echo "<li>Check the doctor's email for the invitation</li>";
        echo "<li>Verify the appointment appears in both calendars</li>";
        echo "</ol>";
    }
}